/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.activiti.service.impl;

import com.yqbsoft.laser.service.activiti.dao.ActHiProcdefMapper;
import com.yqbsoft.laser.service.activiti.dao.ActRuProcdefMapper;
import com.yqbsoft.laser.service.activiti.domain.ActChannelsendApiDomain;
import com.yqbsoft.laser.service.activiti.domain.ActChannelsendDomain;
import com.yqbsoft.laser.service.activiti.engine.SendPutThread;
import com.yqbsoft.laser.service.activiti.model.ActChannelsend;
import com.yqbsoft.laser.service.activiti.service.ActChannelsendApiService;
import com.yqbsoft.laser.service.activiti.service.ActChannelsendService;
import com.yqbsoft.laser.service.activiti.service.ActCommonService;
import com.yqbsoft.laser.service.activiti.service.impl.ActChannelsendServiceImpl;
import com.yqbsoft.laser.service.activiti.util.BpmsActivityTypeEnum;
import com.yqbsoft.laser.service.activiti.util.DelAllFile;
import com.yqbsoft.laser.service.activiti.util.FileUpload;
import com.yqbsoft.laser.service.activiti.util.ImageAnd64Binary;
import com.yqbsoft.laser.service.activiti.util.PageData;
import com.yqbsoft.laser.service.activiti.util.PathUtil;
import com.yqbsoft.laser.service.activiti.util.UtilMisc;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.activiti.image.ProcessDiagramGenerator;
import org.springframework.beans.factory.annotation.Autowired;

public class ActCommonServiceImpl
extends BaseServiceImpl
implements ActCommonService {
    public static final String SYS_CODE = "act.activiti.ActCommonServiceImpl";
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ActRuProcdefMapper actRuProcdefMapper;
    @Autowired
    private ActHiProcdefMapper actHiProcdefMapper;
    @Autowired
    private ActChannelsendApiService actChannelsendApiService;
    @Autowired
    private ActChannelsendService actChannelsendService;

    @Override
    public String activateProcess(Map<String, Object> map) {
        String interfaceType = map.get("interfaceType").toString();
        String tenantCode = map.get("tenantCode").toString();
        if (StringUtils.isBlank((String)interfaceType) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("act.activiti.ActCommonServiceImplactivateProcess", "\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5tenantCode/interfaceType\uff01");
        }
        map.remove("interfaceType");
        map.remove("tenantCode");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKeyAndTenantId(interfaceType, map, tenantCode);
        return "success";
    }

    @Override
    public QueryResult<PageData> queryTask(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        String candidateUser = (String)map.get("candidateUser");
        String assignee = (String)map.get("assignee");
        String tenantCode = (String)map.get("tenantCode");
        String processDefinitionKey = (String)map.get("processDefinitionKey");
        int startRow = 0;
        int rows = 0;
        if (map.get("startRow") != null) {
            startRow = Integer.parseInt(map.get("startRow").toString());
        }
        if (map.get("rows") != null) {
            rows = Integer.parseInt(map.get("rows").toString());
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        if (startRow == 0) {
            startRow = 1;
        }
        if (rows == 0) {
            rows = 5;
        }
        int firstResult = (startRow - 1) * rows;
        int maxResults = firstResult + rows;
        TaskQuery taskQuery = (TaskQuery)this.taskService.createTaskQuery().taskTenantId(tenantCode);
        if (StringUtils.isNotBlank((String)assignee)) {
            taskQuery.taskAssignee(assignee);
        }
        if (StringUtils.isNotBlank((String)candidateUser)) {
            taskQuery.taskCandidateUser(candidateUser);
        }
        if (StringUtils.isNotBlank((String)processDefinitionKey)) {
            taskQuery.processDefinitionKey(processDefinitionKey);
        }
        taskQuery.includeProcessVariables();
        long count = taskQuery.count();
        List tasks = ((TaskQuery)((TaskQuery)taskQuery.orderByTaskCreateTime()).desc()).listPage(firstResult, maxResults);
        ArrayList<PageData> resultLists = new ArrayList<PageData>();
        for (Task task : tasks) {
            PageData result = new PageData();
            result.put("taskId", task.getId());
            result.put("name", task.getName());
            result.put("assignee", task.getAssignee());
            result.put("processInstanceId", task.getProcessInstanceId());
            result.put("processDefinitionId", task.getProcessDefinitionId());
            result.put("createTime", task.getCreateTime());
            result.put("processVariables", task.getProcessVariables());
            resultLists.add(result);
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount((int)count);
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setTotal((long)((int)count));
        queryResult.setList(resultLists);
        return queryResult;
    }

    @Override
    public QueryResult<PageData> queryHiTaskInst(Map<String, Object> map) {
        if (null == map) {
            throw new ApiException("act.activiti.ActCommonServiceImplqueryHiTaskInst", "map\u4e3a\u7a7a");
        }
        String tenantCode = (String)map.get("tenantCode");
        if (StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("act.activiti.ActCommonServiceImplqueryHiTaskInst", "tenantCode\u4e3a\u7a7a");
        }
        String lastStart = (String)map.get("lastStart");
        String lastEnd = (String)map.get("lastEnd");
        if (StringUtils.isNotBlank((String)lastStart)) {
            map.put("lastStart", lastStart + " 00:00:00");
        }
        if (StringUtils.isNotBlank((String)lastEnd)) {
            map.put("lastEnd", lastEnd + " 00:00:00");
        }
        int startRow = (Integer)map.get("page");
        int rows = (Integer)map.get("rows");
        if (startRow == 0) {
            startRow = 1;
            map.put("startRow", 1);
        }
        if (rows == 0) {
            rows = 5;
        }
        int firstResult = (startRow - 1) * rows;
        map.put("startRow", firstResult);
        map.put("rows", rows);
        List<PageData> list = this.actHiProcdefMapper.queryHiTaskInst(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        queryResult.setPageTools((SupPageTools)pageTools);
        pageTools.setRecordCount(this.count(map));
        queryResult.setList(list);
        return queryResult;
    }

    private int count(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.actHiProcdefMapper.countHiTaskInst(map);
        }
        catch (Exception e) {
            this.logger.error("act.activiti.ActCommonServiceImpl.count", (Throwable)e);
        }
        return i;
    }

    @Override
    public void claimTask(String taskId, String userId, String tenantCode) {
        this.taskService.claim(taskId, userId);
    }

    @Override
    public void saveTask(Map<String, Object> map) {
        String taskId = map.get("taskId").toString();
        String assignee = map.get("assignee").toString();
        String tenantCode = map.get("tenantCode").toString();
        if (StringUtils.isBlank((String)taskId) || StringUtils.isBlank((String)assignee)) {
            throw new ApiException("act.activiti.ActCommonServiceImpl.completTask", "\u53c2\u6570\u4e3a\u7a7a");
        }
        map.remove("taskId");
        map.remove("assignee");
        map.remove("tenantCode");
        Task task = (Task)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().includeProcessVariables()).taskId(taskId)).taskAssignee(assignee)).taskTenantId(tenantCode)).singleResult();
        if (null != task) {
            this.taskService.addComment(taskId, null, map.get("auditStatus").toString());
            this.taskService.addComment(taskId, null, map.get("auditRemark").toString());
            this.taskService.complete(taskId, map);
            if (this.checkEnd(task.getProcessInstanceId()).booleanValue()) {
                this.callBack(task, map);
            }
        } else {
            throw new ApiException("act.activiti.ActCommonServiceImpl.completTask", "\u8be5\u7528\u6237\u6ca1\u6709\u5b8c\u6210\u8be5\u4efb\u52a1\u7684\u6743\u9650");
        }
    }

    private void callBack(Task task, Map<String, Object> map) {
        Object callUrl = task.getProcessVariables().get("callUrl");
        if (callUrl == null) {
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelsendApiApicode", callUrl);
        param.put("tenantCode", task.getTenantId());
        List list = this.actChannelsendApiService.queryChannelsendApiPage(param).getList();
        if (ListUtil.isEmpty((Collection)list)) {
            ActChannelsendApiDomain actChannelsendApi = new ActChannelsendApiDomain();
            actChannelsendApi.setChannelsendApiApicode(callUrl.toString());
            actChannelsendApi.setChannelsendApiType("audit");
            actChannelsendApi.setTenantCode(task.getTenantId());
            this.actChannelsendApiService.saveChannelsendApi(actChannelsendApi);
        }
        task.getProcessVariables().putAll(map);
        ActChannelsendDomain ctChannelsendDomain = new ActChannelsendDomain();
        ctChannelsendDomain.setChannelsendDir("audit");
        ctChannelsendDomain.setChannelsendOpcode(task.getId());
        ctChannelsendDomain.setChannelsendOpcode1(task.getProcessInstanceId());
        ctChannelsendDomain.setChannelsendType("audit");
        ctChannelsendDomain.setTenantCode(task.getTenantId());
        ctChannelsendDomain.setChannelsendOpremark(map.get("auditRemark") + "");
        ctChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)task.getProcessVariables()));
        ActChannelsend actChannelsend = this.actChannelsendService.saveChannelsend(ctChannelsendDomain);
        if (null != actChannelsend) {
            ArrayList<ActChannelsend> actChannelsends = new ArrayList<ActChannelsend>();
            actChannelsends.add(actChannelsend);
            ActChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(ActChannelsendServiceImpl.getSendService(), actChannelsends));
        }
    }

    private Boolean checkEnd(String processInstanceId) {
        ProcessInstance rpi = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (rpi == null) {
            return true;
        }
        return false;
    }

    @Override
    public PageData getTask(Map<String, Object> map) {
        this.logger.error("act.activiti.ActCommonServiceImpl.getTask", (Object)JsonUtil.buildNormalBinder().toJson(map));
        PageData pd = new PageData();
        String processId = (String)map.get("processId");
        String taskId = (String)map.get("taskId");
        String fileName = (String)map.get("fileName");
        String tenantCode = (String)map.get("tenantCode");
        if (StringUtils.isBlank((String)processId) || StringUtils.isBlank((String)taskId) || StringUtils.isBlank((String)fileName) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("act.activiti.ActCommonServiceImpl.getTask", "\u53c2\u6570\u4e3a\u7a7a");
        }
        List<PageData> varList = this.actRuProcdefMapper.queryvarList(map);
        List<PageData> hitaskList = this.actRuProcdefMapper.queryHiTaskList(map);
        for (PageData pageData : hitaskList) {
            if (null == pageData.get("DURATION_")) continue;
            Long ztime = Long.parseLong(pageData.get("DURATION_").toString());
            Long tian = ztime / 86400000L;
            Long shi = ztime % 86400000L / 3600000L;
            Long fen = ztime % 86400000L % 3600000L / 60000L;
            Long miao = ztime % 86400000L % 3600000L % 60000L / 1000L;
            pageData.put("ZTIME", tian + "\u5929" + shi + "\u65f6" + fen + "\u5206" + miao + "\u79d2");
        }
        pd.put("varList", varList);
        pd.put("hitaskList", hitaskList);
        try {
            String FILENAME = URLDecoder.decode(fileName, "UTF-8");
            pd.put("FILENAME", FILENAME);
            pd.put("imgSrc", this.getBase64Image(FILENAME, processId));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return pd;
    }

    @Override
    public String getPng(Map<String, Object> map) {
        Object deploymentId = map.get("deploymentId");
        Object fileName = map.get("fileName");
        if (deploymentId == null || fileName == null) {
            throw new ApiException("act.activiti.ActCommonServiceImpl.getPng", "\u53c2\u6570\u4e3a\u7a7a");
        }
        this.createXmlAndPng(deploymentId.toString());
        try {
            String imgName = URLDecoder.decode(fileName.toString(), "UTF-8");
            imgName = imgName.replace("\"", "");
            String imgSrcPath = PathUtil.getClasspath() + "uploadFiles/activitiFile/" + imgName;
            String base = ImageAnd64Binary.getImageStr(imgSrcPath);
            base = "data:image/jpeg;base64," + base;
            return base;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<PageData> getProcdefList(Map<String, Object> map) {
        List list = ((ProcessDefinitionQuery)this.processEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionTenantId(map.get("tenantCode").toString()).orderByProcessDefinitionVersion().asc()).list();
        ArrayList<PageData> resultList = new ArrayList<PageData>();
        for (ProcessDefinition processDefinition : list) {
            PageData pageData = new PageData();
            pageData.put("id", processDefinition.getId());
            pageData.put("name", processDefinition.getName());
            pageData.put("key", processDefinition.getKey());
            pageData.put("version", (Object)processDefinition.getVersion());
            pageData.put("resourceName", processDefinition.getResourceName());
            pageData.put("diagramResourceName", processDefinition.getDiagramResourceName());
            pageData.put("deploymentId", processDefinition.getDeploymentId());
            resultList.add(pageData);
        }
        return resultList;
    }

    public ProcessDefinition getProcessDefinition(String processDefinitionKey) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.processEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).singleResult();
        return processDefinition;
    }

    public void createXmlAndPng(String deploymentId) throws ApiException {
        if (StringUtils.isBlank((String)deploymentId)) {
            throw new ApiException("act.activiti.ActCommonServiceImplcreateXmlAndPng", "deploymentId\u4e3a\u7a7a");
        }
        try {
            List names = this.repositoryService.getDeploymentResourceNames(deploymentId);
            for (String name : names) {
                if (name.indexOf("zip") != -1) continue;
                InputStream in = this.repositoryService.getResourceAsStream(deploymentId, name);
                FileUpload.copyFile(in, PathUtil.getClasspath() + "uploadFiles/activitiFile/", name);
                in.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getBase64Image(String fileName, String processId) {
        try {
            String FILENAME = URLDecoder.decode(fileName, "UTF-8");
            FILENAME = FILENAME.replace("\"", "");
            this.createXmlAndPngAtNowTask(processId, FILENAME);
            String imgSrcPath = PathUtil.getClasspath() + "uploadFiles/activitiFile/" + FILENAME;
            return "data:image/jpeg;base64," + ImageAnd64Binary.getImageStr(imgSrcPath);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public Boolean nextTaskIsEnd(String taskId) {
        Task task = (Task)((TaskQuery)((TaskQuery)ProcessEngines.getDefaultProcessEngine().getTaskService().createTaskQuery().includeProcessVariables()).taskId(taskId)).singleResult();
        ExecutionEntity ee = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(task.getExecutionId()).singleResult();
        String crruentActivityId = ee.getActivityId();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        FlowNode flowNode = (FlowNode)bpmnModel.getFlowElement(crruentActivityId);
        List outFlows = flowNode.getOutgoingFlows();
        Iterator iterator = outFlows.iterator();
        if (iterator.hasNext()) {
            SequenceFlow sequenceFlow = (SequenceFlow)iterator.next();
            FlowElement targetFlow = sequenceFlow.getTargetFlowElement();
            if (targetFlow instanceof EndEvent) {
                return true;
            }
            return false;
        }
        return false;
    }

    private void createXmlAndPngAtNowTask(String processId, String fileName) throws ApiException {
        DelAllFile.delFolder(PathUtil.getClasspath() + "uploadFiles/activitiFile");
        InputStream in = this.getResourceDiagramInputStream(processId);
        try {
            FileUpload.copyFile(in, PathUtil.getClasspath() + "uploadFiles/activitiFile/", fileName);
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private InputStream getResourceDiagramInputStream(String PROC_INST_ID_) {
        try {
            HistoricProcessInstance hip = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(PROC_INST_ID_).singleResult();
            List hai = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(PROC_INST_ID_).orderByHistoricActivityInstanceId().asc()).list();
            ArrayList<String> executedActivityIdList = new ArrayList<String>();
            for (HistoricActivityInstance activityInstance : hai) {
                executedActivityIdList.add(activityInstance.getActivityId());
            }
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(hip.getProcessDefinitionId());
            List<String> flowIds = this.getExecutedFlows(bpmnModel, hai);
            ProcessDiagramGenerator processDiagramGenerator = this.processEngine.getProcessEngineConfiguration().getProcessDiagramGenerator();
            InputStream imageStream = processDiagramGenerator.generateDiagram(bpmnModel, "png", executedActivityIdList, flowIds, "\u5b8b\u4f53", "\u5fae\u8f6f\u96c5\u9ed1", "\u9ed1\u4f53", null, 2.0);
            return imageStream;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<String> getExecutedFlows(BpmnModel bpmnModel, List<HistoricActivityInstance> historicActivityInstances) {
        ArrayList<String> flowIdList = new ArrayList<String>();
        LinkedList<FlowNode> historicFlowNodeList = new LinkedList<FlowNode>();
        LinkedList<HistoricActivityInstance> finishedActivityInstanceList = new LinkedList<HistoricActivityInstance>();
        for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
            historicFlowNodeList.add((FlowNode)bpmnModel.getMainProcess().getFlowElement(historicActivityInstance.getActivityId(), true));
            if (historicActivityInstance.getEndTime() == null) continue;
            finishedActivityInstanceList.add(historicActivityInstance);
        }
        FlowNode currentFlowNode = null;
        for (HistoricActivityInstance currentActivityInstance : finishedActivityInstanceList) {
            Object sequenceFlow22;
            currentFlowNode = (FlowNode)bpmnModel.getMainProcess().getFlowElement(currentActivityInstance.getActivityId(), true);
            List sequenceFlowList = currentFlowNode.getOutgoingFlows();
            FlowNode targetFlowNode = null;
            if (BpmsActivityTypeEnum.PARALLEL_GATEWAY.getType().equals(currentActivityInstance.getActivityType()) || BpmsActivityTypeEnum.INCLUSIVE_GATEWAY.getType().equals(currentActivityInstance.getActivityType())) {
                for (Object sequenceFlow22 : sequenceFlowList) {
                    targetFlowNode = (FlowNode)bpmnModel.getMainProcess().getFlowElement(sequenceFlow22.getTargetRef(), true);
                    if (!historicFlowNodeList.contains(targetFlowNode)) continue;
                    flowIdList.add(sequenceFlow22.getId());
                }
                continue;
            }
            LinkedList<Map<String, String>> tempMapList = new LinkedList<Map<String, String>>();
            sequenceFlow22 = sequenceFlowList.iterator();
            while (sequenceFlow22.hasNext()) {
                SequenceFlow sequenceFlow3 = (SequenceFlow)sequenceFlow22.next();
                for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
                    if (!historicActivityInstance.getActivityId().equals(sequenceFlow3.getTargetRef())) continue;
                    tempMapList.add(UtilMisc.toMap("flowId", sequenceFlow3.getId(), "activityStartTime", String.valueOf(historicActivityInstance.getStartTime().getTime())));
                }
            }
            String flowId = null;
            for (Map map : tempMapList) {
                flowId = (String)map.get("flowId");
                flowIdList.add(flowId);
            }
        }
        return flowIdList;
    }
}

