/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.activiti.service.impl;

import com.yqbsoft.laser.service.activiti.dao.ActHiProcdefMapper;
import com.yqbsoft.laser.service.activiti.dao.ActRuProcdefMapper;
import com.yqbsoft.laser.service.activiti.domain.ActChannelsendApiDomain;
import com.yqbsoft.laser.service.activiti.domain.ActChannelsendDomain;
import com.yqbsoft.laser.service.activiti.domain.ActCommonDomain;
import com.yqbsoft.laser.service.activiti.engine.SendPutThread;
import com.yqbsoft.laser.service.activiti.model.ActChannelsend;
import com.yqbsoft.laser.service.activiti.service.ActChannelsendApiService;
import com.yqbsoft.laser.service.activiti.service.ActChannelsendService;
import com.yqbsoft.laser.service.activiti.service.ActCommonService;
import com.yqbsoft.laser.service.activiti.service.impl.ActChannelsendServiceImpl;
import com.yqbsoft.laser.service.activiti.util.BpmsActivityTypeEnum;
import com.yqbsoft.laser.service.activiti.util.DelAllFile;
import com.yqbsoft.laser.service.activiti.util.FileUpload;
import com.yqbsoft.laser.service.activiti.util.ImageAnd64Binary;
import com.yqbsoft.laser.service.activiti.util.PageData;
import com.yqbsoft.laser.service.activiti.util.PathUtil;
import com.yqbsoft.laser.service.activiti.util.UtilMisc;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.json.JSONArray;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.activiti.image.ProcessDiagramGenerator;
import org.springframework.beans.factory.annotation.Autowired;

public class ActCommonServiceImpl
extends BaseServiceImpl
implements ActCommonService {
    public static final String SYS_CODE = "act.activiti.ActCommonServiceImpl";
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ActRuProcdefMapper actRuProcdefMapper;
    @Autowired
    private ActHiProcdefMapper actHiProcdefMapper;
    @Autowired
    private ActChannelsendApiService actChannelsendApiService;
    @Autowired
    private ActChannelsendService actChannelsendService;

    @Override
    public void saveDefinitionProcess(String fileName, String processName, String tenantCode) {
        if (StringUtils.isBlank((String)fileName) || StringUtils.isBlank((String)processName) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("act.activiti.ActCommonServiceImpl.definitionProcess.ex", "\u53c2\u6570\u4e3a\u7a7a");
        }
        Deployment deploy = null;
        try {
            deploy = this.repositoryService.createDeployment().addClasspathResource("com/yqbsoft/laser/service/activiti/processes/" + fileName).name(processName).tenantId(tenantCode).deploy();
        }
        catch (Exception e) {
            throw new ApiException("act.activiti.ActCommonServiceImpl.definitionProcess.ex");
        }
        if (null == deploy) {
            throw new ApiException("act.activiti.ActCommonServiceImpl.definitionProcess.ex");
        }
    }

    @Override
    public String activateProcess(ActCommonDomain actCommonDomain) {
        this.logger.error("act.activiti.ActCommonServiceImpl.activateProcess:\u6d41\u7a0b\u6fc0\u6d3b\u53c2\u6570:", (Object)JsonUtil.buildNormalBinder().toJson((Object)actCommonDomain));
        Map<String, Object> paramMap = actCommonDomain.getParamMap();
        if (paramMap == null) {
            paramMap = new HashMap<String, Object>();
        }
        if (actCommonDomain == null || StringUtils.isBlank((String)actCommonDomain.getInterfaceType()) || StringUtils.isBlank((String)actCommonDomain.getTenantCode()) || StringUtils.isBlank((String)actCommonDomain.getBusinessKey()) || StringUtils.isBlank((String)actCommonDomain.getStartUser()) || StringUtils.isBlank((String)actCommonDomain.getStartUserType())) {
            throw new ApiException("act.activiti.ActCommonServiceImpl.activateProcess", "\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\uff01");
        }
        String unknownCode = "";
        HashMap<String, String> map = new HashMap<String, String>();
        switch (actCommonDomain.getStartUserType()) {
            case "1": {
                unknownCode = this.getDepartCode(actCommonDomain.getUserCode(), actCommonDomain.getTenantCode());
                break;
            }
            case "2": {
                map.put("employeeCode", actCommonDomain.getEmployeeCode());
                map.put("tenantCode", actCommonDomain.getTenantCode());
                String empResult = this.internalInvoke("org.depart.getDepartCodeByEmployeeCode", map);
                if (empResult == null) break;
                unknownCode = empResult.toString();
                break;
            }
            case "3": {
                break;
            }
            case "4": {
                unknownCode = actCommonDomain.getDepartCode();
            }
        }
        this.setDepartNameArr(unknownCode, actCommonDomain.getTenantCode(), paramMap);
        paramMap.put("unknownCode", unknownCode);
        paramMap.put("callUrl", actCommonDomain.getCallUrl());
        actCommonDomain.setParamMap(null);
        paramMap.put("actCommonDomain", actCommonDomain);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKeyAndTenantId(actCommonDomain.getInterfaceType(), actCommonDomain.getBusinessKey(), paramMap, actCommonDomain.getTenantCode());
        return processInstance.getId();
    }

    private void setDepartNameArr(String unknownCode, String tenantCode, Map<String, Object> paramMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        String departCode = unknownCode;
        try {
            if (paramMap.get("customerCode") != null) {
                departCode = this.getDepartCode(paramMap.get("customerCode") + "", tenantCode);
            }
            if (StringUtils.isNotBlank((String)unknownCode)) {
                map.put("tenantCode", tenantCode);
                map.put("departPcode", departCode);
                String object = this.internalInvoke("org.depart.queryDepartByPcode", map);
                if (object != null) {
                    StringBuffer sb = new StringBuffer();
                    JSONArray jsonArray = JSONArray.json2array((String)object);
                    HashMap<String, JSONObject> smap = new HashMap<String, JSONObject>();
                    for (JSONObject jsonObject : jsonArray) {
                        smap.put(jsonObject.getString("departCode"), jsonObject);
                    }
                    this.getDepartNameArrToStr(sb, unknownCode, smap);
                    if (sb.length() != 0) {
                        paramMap.put("departNameArr", sb.toString());
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("act.activiti.ActCommonServiceImpl.activateProcess:\u67e5\u8be2\u90e8\u95e8\u6811\u5f02\u5e38", (Object)e.getMessage());
        }
    }

    private String getDepartCode(String userInfoCode, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userinfoCode", userInfoCode);
        map.put("tenantCode", tenantCode);
        String userResult = this.internalInvoke("um.user.getUserinfoByUserCode", map);
        if (userResult != null) {
            Map jsonMap = (Map)JsonUtil.buildNormalBinder().getJsonToObject(userResult.toString(), Map.class);
            return jsonMap.get("departCode") + "";
        }
        return null;
    }

    private void getDepartNameArrToStr(StringBuffer sb, String departCode, Map<String, JSONObject> smap) {
        if (smap.containsKey(departCode)) {
            JSONObject jsonObject = smap.get(departCode);
            sb.append(jsonObject.getString("departName") + "-");
            this.getDepartNameArrToStr(sb, jsonObject.getString("departPcode"), smap);
        }
    }

    @Override
    public QueryResult<PageData> queryTask(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        String candidateUser = (String)map.get("candidateUser");
        String assignee = (String)map.get("assignee");
        String tenantCode = (String)map.get("tenantCode");
        String processDefinitionKey = (String)map.get("processDefinitionKey");
        int startRow = 0;
        int rows = 0;
        if (map.get("startRow") != null) {
            startRow = Integer.parseInt(map.get("startRow").toString());
        }
        if (map.get("rows") != null) {
            rows = Integer.parseInt(map.get("rows").toString());
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        if (startRow == 0) {
            startRow = 1;
        }
        if (rows == 0) {
            rows = 5;
        }
        int firstResult = (startRow - 1) * rows;
        int maxResults = firstResult + rows;
        TaskQuery taskQuery = (TaskQuery)this.taskService.createTaskQuery().taskTenantId(tenantCode);
        if (StringUtils.isNotBlank((String)assignee)) {
            taskQuery.taskAssignee(assignee);
        }
        if (StringUtils.isNotBlank((String)candidateUser)) {
            taskQuery.taskCandidateUser(candidateUser);
        }
        if (StringUtils.isNotBlank((String)processDefinitionKey)) {
            taskQuery.processDefinitionKey(processDefinitionKey);
        }
        taskQuery.includeProcessVariables();
        long count = taskQuery.count();
        List tasks = ((TaskQuery)((TaskQuery)taskQuery.orderByTaskCreateTime()).desc()).listPage(firstResult, maxResults);
        ArrayList<PageData> resultLists = new ArrayList<PageData>();
        for (Task task : tasks) {
            PageData result = new PageData();
            result.put("taskId", task.getId());
            result.put("name", task.getName());
            result.put("assignee", task.getAssignee());
            result.put("processInstanceId", task.getProcessInstanceId());
            result.put("processDefinitionId", task.getProcessDefinitionId());
            result.put("createTime", task.getCreateTime());
            result.put("processVariables", task.getProcessVariables());
            resultLists.add(result);
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount((int)count);
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setTotal((long)((int)count));
        queryResult.setList(resultLists);
        return queryResult;
    }

    @Override
    public QueryResult<PageData> queryHiTaskInst(Map<String, Object> map) {
        if (null == map) {
            throw new ApiException("act.activiti.ActCommonServiceImplqueryHiTaskInst", "map\u4e3a\u7a7a");
        }
        String tenantCode = (String)map.get("tenantCode");
        if (StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("act.activiti.ActCommonServiceImplqueryHiTaskInst", "tenantCode\u4e3a\u7a7a");
        }
        String lastStart = (String)map.get("lastStart");
        String lastEnd = (String)map.get("lastEnd");
        if (StringUtils.isNotBlank((String)lastStart)) {
            map.put("lastStart", lastStart + " 00:00:00");
        }
        if (StringUtils.isNotBlank((String)lastEnd)) {
            map.put("lastEnd", lastEnd + " 00:00:00");
        }
        int startRow = (Integer)map.get("page");
        int rows = (Integer)map.get("rows");
        if (startRow == 0) {
            startRow = 1;
            map.put("startRow", 1);
        }
        if (rows == 0) {
            rows = 5;
        }
        int firstResult = (startRow - 1) * rows;
        map.put("startRow", firstResult);
        map.put("rows", rows);
        QueryResult queryResult = new QueryResult();
        if (map.get("businessKey") == null) {
            List<PageData> list = this.actHiProcdefMapper.queryHiTaskInst(map);
            PageTools pageTools = new PageTools();
            queryResult.setPageTools((SupPageTools)pageTools);
            pageTools.setRecordCount(this.count(map));
            queryResult.setList(list);
        } else {
            List<PageData> list = this.actHiProcdefMapper.queryTaskInstByBusinessKey(map);
            PageTools pageTools = new PageTools();
            queryResult.setPageTools((SupPageTools)pageTools);
            pageTools.setRecordCount(this.actHiProcdefMapper.countTaskInstByBusinessKey(map));
            queryResult.setList(list);
        }
        return queryResult;
    }

    public QueryResult<PageData> queryHiTaskInstPage(Map<String, Object> map) {
        if (null == map) {
            throw new ApiException("act.activiti.ActCommonServiceImplqueryHiTaskInst", "map\u4e3a\u7a7a");
        }
        String tenantCode = (String)map.get("tenantCode");
        if (StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("act.activiti.ActCommonServiceImplqueryHiTaskInst", "tenantCode\u4e3a\u7a7a");
        }
        String lastStart = (String)map.get("lastStart");
        String lastEnd = (String)map.get("lastEnd");
        if (StringUtils.isNotBlank((String)lastStart)) {
            map.put("lastStart", lastStart + " 00:00:00");
        }
        if (StringUtils.isNotBlank((String)lastEnd)) {
            map.put("lastEnd", lastEnd + " 00:00:00");
        }
        int startRow = (Integer)map.get("page");
        int rows = (Integer)map.get("rows");
        if (startRow == 0) {
            startRow = 1;
            map.put("startRow", 1);
        }
        if (rows == 0) {
            rows = 5;
        }
        int firstResult = (startRow - 1) * rows;
        map.put("startRow", firstResult);
        map.put("rows", rows);
        HistoricTaskInstanceQuery historicTaskInstanceQuery = (HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().includeProcessVariables();
        List historicTaskInstanceList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)historicTaskInstanceQuery.orderByTaskCreateTime()).desc()).listPage(startRow, rows);
        long count = historicTaskInstanceQuery.count();
        ArrayList<PageData> resultLists = new ArrayList<PageData>();
        for (HistoricTaskInstance task : historicTaskInstanceList) {
            PageData result = new PageData();
            result.put("taskId", task.getId());
            result.put("name", task.getName());
            result.put("assignee", task.getAssignee());
            result.put("processInstanceId", task.getProcessInstanceId());
            result.put("processDefinitionId", task.getProcessDefinitionId());
            result.put("createTime", task.getCreateTime());
            result.put("processVariables", task.getProcessVariables());
            resultLists.add(result);
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount((int)count);
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setTotal((long)((int)count));
        queryResult.setList(resultLists);
        return queryResult;
    }

    private int count(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.actHiProcdefMapper.countHiTaskInst(map);
        }
        catch (Exception e) {
            this.logger.error("act.activiti.ActCommonServiceImpl.count", (Throwable)e);
        }
        return i;
    }

    @Override
    public void claimTask(String taskId, String userId, String tenantCode) {
        this.logger.error("act.activiti.ActCommonServiceImpl.claimTask", (Object)("taskId:" + taskId + ",userId" + userId));
        Task task = (Task)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().includeProcessVariables()).taskId(taskId)).taskTenantId(tenantCode)).singleResult();
        if (task == null) {
            throw new ApiException("act.activiti.ActCommonServiceImpl.claimTask", "\u4efb\u52a1\u5df2\u88ab\u8ba4\u9886/\u8ba4\u9886\u4efb\u52a1\u4e0d\u5b58\u5728!");
        }
        this.taskService.claim(taskId, userId);
    }

    @Override
    public void saveTask(Map<String, Object> map) {
        this.logger.error("act.activiti.ActCommonServiceImpl.saveTask", (Object)JsonUtil.buildNormalBinder().toJson(map));
        String taskId = map.get("taskId").toString();
        String assignee = map.get("assignee").toString();
        String tenantCode = map.get("tenantCode").toString();
        if (StringUtils.isBlank((String)taskId) || StringUtils.isBlank((String)assignee)) {
            throw new ApiException("act.activiti.ActCommonServiceImpl.completTask", "\u53c2\u6570\u4e3a\u7a7a");
        }
        map.remove("taskId");
        map.remove("assignee");
        map.remove("tenantCode");
        Task task = (Task)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().includeProcessVariables()).taskId(taskId)).taskAssignee(assignee)).taskTenantId(tenantCode)).singleResult();
        if (null != task) {
            this.setUnknownCode(map, task);
            Authentication.setAuthenticatedUserId((String)assignee);
            this.taskService.addComment(taskId, task.getProcessInstanceId(), map.get("auditStatus").toString() + "," + map.get("auditRemark").toString());
            this.taskService.setVariableLocal(taskId, "oldUnknownCode", task.getProcessVariables().get("unknownCode"));
            this.taskService.complete(taskId, map);
            if (this.checkEnd(task.getProcessInstanceId()).booleanValue()) {
                this.callBack(task, map);
            }
        } else {
            throw new ApiException("act.activiti.ActCommonServiceImpl.completTask", "\u8be5\u7528\u6237\u6ca1\u6709\u5b8c\u6210\u8be5\u4efb\u52a1\u7684\u6743\u9650");
        }
    }

    private void setUnknownCode(Map<String, Object> map, Task task) {
        if (map.get("departCode") != null) {
            map.put("unknownCode", map.get("departCode"));
        } else if (task.getDescription() != null) {
            map.put("unknownCode", task.getDescription());
        } else {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("tenantCode", task.getTenantId());
            paramMap.put("departCode", (String)task.getProcessVariables().get("unknownCode"));
            String result = this.internalInvoke("org.depart.getDepartByCode", paramMap);
            if (result != null) {
                JSONObject jsonObject = JSONObject.json2object((String)result.toString());
                map.put("unknownCode", jsonObject.get((Object)"departPcode"));
            }
        }
    }

    private void callBack(Task task, Map<String, Object> map) {
        Map varMap;
        ActCommonDomain actCommonDomain;
        Object callUrl = task.getProcessVariables().get("callUrl");
        this.logger.error("act.activiti.ActCommonServiceImpl.callBack", (Object)("callBack:" + callUrl));
        if (callUrl == null) {
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelsendApiApicode", callUrl);
        param.put("tenantCode", task.getTenantId());
        List list = this.actChannelsendApiService.queryChannelsendApiPage(param).getList();
        if (ListUtil.isEmpty((Collection)list)) {
            ActChannelsendApiDomain actChannelsendApi = new ActChannelsendApiDomain();
            actChannelsendApi.setChannelsendApiApicode(callUrl.toString());
            actChannelsendApi.setChannelsendApiType("audit");
            actChannelsendApi.setTenantCode(task.getTenantId());
            this.actChannelsendApiService.saveChannelsendApi(actChannelsendApi);
        }
        if ((actCommonDomain = (ActCommonDomain)(varMap = task.getProcessVariables()).get("actCommonDomain")).getParamMap() != null) {
            actCommonDomain.setParamMap(null);
            varMap.put("actCommonDomain", actCommonDomain);
        }
        varMap.putAll(map);
        varMap.put("auditUserName", task.getAssignee());
        ActChannelsendDomain ctChannelsendDomain = new ActChannelsendDomain();
        ctChannelsendDomain.setChannelsendDir("audit");
        ctChannelsendDomain.setChannelsendOpcode(task.getId());
        ctChannelsendDomain.setChannelsendOpcode1(task.getProcessInstanceId());
        ctChannelsendDomain.setChannelsendType(task.getProcessDefinitionId().split(":")[0] + "-audit");
        ctChannelsendDomain.setTenantCode(task.getTenantId());
        ctChannelsendDomain.setChannelsendOpremark(map.get("auditRemark") + "");
        ctChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)varMap));
        ActChannelsend actChannelsend = this.actChannelsendService.saveChannelsend(ctChannelsendDomain);
        if (null != actChannelsend) {
            ArrayList<ActChannelsend> actChannelsends = new ArrayList<ActChannelsend>();
            actChannelsends.add(actChannelsend);
            ActChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(ActChannelsendServiceImpl.getSendService(), actChannelsends));
        }
    }

    private Boolean checkEnd(String processInstanceId) {
        ProcessInstance rpi = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        return rpi == null;
    }

    @Override
    public PageData getTask(Map<String, Object> map) {
        this.logger.error("act.activiti.ActCommonServiceImpl.getTask", (Object)JsonUtil.buildNormalBinder().toJson(map));
        PageData pd = new PageData();
        String processId = (String)map.get("processId");
        String taskId = (String)map.get("taskId");
        String fileName = (String)map.get("fileName");
        String tenantCode = (String)map.get("tenantCode");
        if (StringUtils.isBlank((String)processId) || StringUtils.isBlank((String)taskId) || StringUtils.isBlank((String)fileName) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("act.activiti.ActCommonServiceImpl.getTask", "\u53c2\u6570\u4e3a\u7a7a");
        }
        List<PageData> hitaskList = this.actRuProcdefMapper.queryHiTaskList(map);
        for (PageData pageData : hitaskList) {
            if (null != pageData.get("DURATION_")) {
                Long ztime = Long.parseLong(pageData.get("DURATION_").toString());
                Long tian = ztime / 86400000L;
                Long shi = ztime % 86400000L / 3600000L;
                Long fen = ztime % 86400000L % 3600000L / 60000L;
                Long miao = ztime % 86400000L % 3600000L % 60000L / 1000L;
                pageData.put("ZTIME", tian + "\u5929" + shi + "\u65f6" + fen + "\u5206" + miao + "\u79d2");
            }
            pageData.put("auditRemark", this.taskService.getTaskComments(pageData.getString("TASK_ID_")));
        }
        Map varMap = this.taskService.getVariables(taskId);
        varMap.remove("actCommonDomain");
        pd.put("varList", varMap);
        pd.put("hitaskList", hitaskList);
        try {
            String FILENAME = URLDecoder.decode(fileName, "UTF-8");
            pd.put("FILENAME", FILENAME);
            pd.put("imgSrc", this.getBase64Image(FILENAME, processId));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return pd;
    }

    @Override
    public PageData getTaskById(Map<String, Object> map) {
        this.logger.error("act.activiti.ActCommonServiceImpl.getTaskById", (Object)JsonUtil.buildNormalBinder().toJson(map));
        String taskId = map.get("taskId").toString();
        String fileName = map.get("fileName").toString();
        String tenantCode = map.get("tenantCode").toString();
        Object type = map.get("type");
        PageData pageData = new PageData();
        if (type == null) {
            return pageData;
        }
        if ("1".equals(type)) {
            this.getTaskById(taskId, tenantCode, pageData);
        } else {
            this.getHisTask(taskId, tenantCode, pageData);
        }
        String processInstanceId = pageData.getString("processInstanceId");
        map.put("processId", processInstanceId);
        List<PageData> hitaskList = this.actRuProcdefMapper.queryHiTaskList(map);
        for (PageData pd : hitaskList) {
            if (null != pd.get("DURATION_")) {
                Long ztime = Long.parseLong(pd.get("DURATION_").toString());
                Long tian = ztime / 86400000L;
                Long shi = ztime % 86400000L / 3600000L;
                Long fen = ztime % 86400000L % 3600000L / 60000L;
                Long miao = ztime % 86400000L % 3600000L % 60000L / 1000L;
                pd.put("ZTIME", tian + "\u5929" + shi + "\u65f6" + fen + "\u5206" + miao + "\u79d2");
            }
            pageData.put("auditRemark", this.taskService.getTaskComments(pageData.getString("TASK_ID_")));
        }
        pageData.put("hitaskList", hitaskList);
        try {
            String FILENAME = URLDecoder.decode(fileName, "UTF-8");
            pageData.put("FILENAME", FILENAME);
            pageData.put("imgSrc", this.getBase64Image(FILENAME, processInstanceId));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return pageData;
    }

    private void getTaskById(String taskId, String tenantCode, PageData pageData) {
        Task task = (Task)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().includeProcessVariables()).taskId(taskId)).taskTenantId(tenantCode)).singleResult();
        pageData.put("taskId", task.getId());
        pageData.put("name", task.getName());
        pageData.put("assignee", task.getAssignee());
        pageData.put("processInstanceId", task.getProcessInstanceId());
        pageData.put("processDefinitionId", task.getProcessDefinitionId());
        pageData.put("createTime", task.getCreateTime());
        Map varMap = task.getProcessVariables();
        ActCommonDomain actCommonDomain = (ActCommonDomain)varMap.get("actCommonDomain");
        if (actCommonDomain.getParamMap() != null) {
            actCommonDomain.setParamMap(null);
            varMap.put("actCommonDomain", actCommonDomain);
        }
        pageData.put("processVariables", varMap);
    }

    private void getHisTask(String taskId, String tenantCode, PageData pageData) {
        HistoricTaskInstanceQuery query = this.processEngine.getHistoryService().createHistoricTaskInstanceQuery();
        HistoricTaskInstance instance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)query.taskId(taskId)).taskTenantId(tenantCode)).includeProcessVariables()).singleResult();
        pageData.put("taskId", instance.getId());
        pageData.put("name", instance.getName());
        pageData.put("assignee", instance.getAssignee());
        pageData.put("processInstanceId", instance.getProcessInstanceId());
        pageData.put("processDefinitionId", instance.getProcessDefinitionId());
        pageData.put("createTime", instance.getCreateTime());
        Map varMap = instance.getProcessVariables();
        ActCommonDomain actCommonDomain = (ActCommonDomain)varMap.get("actCommonDomain");
        if (actCommonDomain.getParamMap() != null) {
            actCommonDomain.setParamMap(null);
            varMap.put("actCommonDomain", actCommonDomain);
        }
        pageData.put("processVariables", varMap);
    }

    @Override
    public String getPng(Map<String, Object> map) {
        Object deploymentId = map.get("deploymentId");
        Object fileName = map.get("fileName");
        if (deploymentId == null || fileName == null) {
            throw new ApiException("act.activiti.ActCommonServiceImpl.getPng", "\u53c2\u6570\u4e3a\u7a7a");
        }
        this.createXmlAndPng(deploymentId.toString());
        try {
            String imgName = URLDecoder.decode(fileName.toString(), "UTF-8");
            imgName = imgName.replace("\"", "");
            String imgSrcPath = PathUtil.getClasspath() + "uploadFiles/activitiFile/" + imgName;
            String base = ImageAnd64Binary.getImageStr(imgSrcPath);
            base = "data:image/jpeg;base64," + base;
            return base;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<PageData> getProcdefList(Map<String, Object> map) {
        List list = ((ProcessDefinitionQuery)this.processEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionTenantId(map.get("tenantCode").toString()).orderByProcessDefinitionVersion().asc()).list();
        ArrayList<PageData> resultList = new ArrayList<PageData>();
        for (ProcessDefinition processDefinition : list) {
            PageData pageData = new PageData();
            pageData.put("id", processDefinition.getId());
            pageData.put("name", processDefinition.getName());
            pageData.put("key", processDefinition.getKey());
            pageData.put("version", (Object)processDefinition.getVersion());
            pageData.put("resourceName", processDefinition.getResourceName());
            pageData.put("diagramResourceName", processDefinition.getDiagramResourceName());
            pageData.put("deploymentId", processDefinition.getDeploymentId());
            if (map.get("type") != null) {
                Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().deploymentTenantId(map.get("tenantCode").toString()).deploymentId(processDefinition.getDeploymentId()).singleResult();
                pageData.put("deploymentTime", deployment.getDeploymentTime());
            }
            resultList.add(pageData);
        }
        return resultList;
    }

    public ProcessDefinition getProcessDefinition(String processDefinitionKey) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.processEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).singleResult();
        return processDefinition;
    }

    public void createXmlAndPng(String deploymentId) throws ApiException {
        if (StringUtils.isBlank((String)deploymentId)) {
            throw new ApiException("act.activiti.ActCommonServiceImplcreateXmlAndPng", "deploymentId\u4e3a\u7a7a");
        }
        try {
            List names = this.repositoryService.getDeploymentResourceNames(deploymentId);
            for (String name : names) {
                if (name.indexOf("zip") != -1) continue;
                InputStream in = this.repositoryService.getResourceAsStream(deploymentId, name);
                FileUpload.copyFile(in, PathUtil.getClasspath() + "uploadFiles/activitiFile/", name);
                in.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getBase64Image(String fileName, String processId) {
        try {
            String FILENAME = URLDecoder.decode(fileName, "UTF-8");
            FILENAME = FILENAME.replace("\"", "");
            this.createXmlAndPngAtNowTask(processId, FILENAME);
            String imgSrcPath = PathUtil.getClasspath() + "uploadFiles/activitiFile/" + FILENAME;
            return "data:image/jpeg;base64," + ImageAnd64Binary.getImageStr(imgSrcPath);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public Boolean nextTaskIsEnd(String taskId) {
        Task task = (Task)((TaskQuery)((TaskQuery)ProcessEngines.getDefaultProcessEngine().getTaskService().createTaskQuery().includeProcessVariables()).taskId(taskId)).singleResult();
        ExecutionEntity ee = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(task.getExecutionId()).singleResult();
        String crruentActivityId = ee.getActivityId();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        FlowNode flowNode = (FlowNode)bpmnModel.getFlowElement(crruentActivityId);
        List outFlows = flowNode.getOutgoingFlows();
        Iterator iterator = outFlows.iterator();
        if (iterator.hasNext()) {
            SequenceFlow sequenceFlow = (SequenceFlow)iterator.next();
            FlowElement targetFlow = sequenceFlow.getTargetFlowElement();
            return targetFlow instanceof EndEvent;
        }
        return false;
    }

    private void createXmlAndPngAtNowTask(String processId, String fileName) throws ApiException {
        DelAllFile.delFolder(PathUtil.getClasspath() + "uploadFiles/activitiFile");
        InputStream in = this.getResourceDiagramInputStream(processId);
        try {
            FileUpload.copyFile(in, PathUtil.getClasspath() + "uploadFiles/activitiFile/", fileName);
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private InputStream getResourceDiagramInputStream(String PROC_INST_ID_) {
        try {
            HistoricProcessInstance hip = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(PROC_INST_ID_).singleResult();
            List hai = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(PROC_INST_ID_).orderByHistoricActivityInstanceId().asc()).list();
            ArrayList<String> executedActivityIdList = new ArrayList<String>();
            for (HistoricActivityInstance activityInstance : hai) {
                executedActivityIdList.add(activityInstance.getActivityId());
            }
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(hip.getProcessDefinitionId());
            List<String> flowIds = this.getExecutedFlows(bpmnModel, hai);
            ProcessDiagramGenerator processDiagramGenerator = this.processEngine.getProcessEngineConfiguration().getProcessDiagramGenerator();
            InputStream imageStream = processDiagramGenerator.generateDiagram(bpmnModel, "png", executedActivityIdList, flowIds, "\u5b8b\u4f53", "\u5b8b\u4f53", "\u5b8b\u4f53", null, 2.0);
            return imageStream;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<String> getExecutedFlows(BpmnModel bpmnModel, List<HistoricActivityInstance> historicActivityInstances) {
        ArrayList<String> flowIdList = new ArrayList<String>();
        LinkedList<FlowNode> historicFlowNodeList = new LinkedList<FlowNode>();
        LinkedList<HistoricActivityInstance> finishedActivityInstanceList = new LinkedList<HistoricActivityInstance>();
        for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
            historicFlowNodeList.add((FlowNode)bpmnModel.getMainProcess().getFlowElement(historicActivityInstance.getActivityId(), true));
            if (historicActivityInstance.getEndTime() == null) continue;
            finishedActivityInstanceList.add(historicActivityInstance);
        }
        FlowNode currentFlowNode = null;
        for (HistoricActivityInstance currentActivityInstance : finishedActivityInstanceList) {
            Object sequenceFlow22;
            currentFlowNode = (FlowNode)bpmnModel.getMainProcess().getFlowElement(currentActivityInstance.getActivityId(), true);
            List sequenceFlowList = currentFlowNode.getOutgoingFlows();
            FlowNode targetFlowNode = null;
            if (BpmsActivityTypeEnum.PARALLEL_GATEWAY.getType().equals(currentActivityInstance.getActivityType()) || BpmsActivityTypeEnum.INCLUSIVE_GATEWAY.getType().equals(currentActivityInstance.getActivityType())) {
                for (Object sequenceFlow22 : sequenceFlowList) {
                    targetFlowNode = (FlowNode)bpmnModel.getMainProcess().getFlowElement(sequenceFlow22.getTargetRef(), true);
                    if (!historicFlowNodeList.contains(targetFlowNode)) continue;
                    flowIdList.add(sequenceFlow22.getId());
                }
                continue;
            }
            LinkedList<Map<String, String>> tempMapList = new LinkedList<Map<String, String>>();
            sequenceFlow22 = sequenceFlowList.iterator();
            while (sequenceFlow22.hasNext()) {
                SequenceFlow sequenceFlow3 = (SequenceFlow)sequenceFlow22.next();
                for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
                    if (!historicActivityInstance.getActivityId().equals(sequenceFlow3.getTargetRef())) continue;
                    tempMapList.add(UtilMisc.toMap("flowId", sequenceFlow3.getId(), "activityStartTime", String.valueOf(historicActivityInstance.getStartTime().getTime())));
                }
            }
            String flowId = null;
            for (Map map : tempMapList) {
                flowId = (String)map.get("flowId");
                flowIdList.add(flowId);
            }
        }
        return flowIdList;
    }
}

