/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.activiti.service.impl;

import com.yqbsoft.laser.service.activiti.dao.ActProdefMapper;
import com.yqbsoft.laser.service.activiti.domain.ActChannelsendDomain;
import com.yqbsoft.laser.service.activiti.model.ActChannelsend;
import com.yqbsoft.laser.service.activiti.service.ActBaseService;
import com.yqbsoft.laser.service.activiti.service.ActChannelsendService;
import com.yqbsoft.laser.service.activiti.service.ActProcdefService;
import com.yqbsoft.laser.service.activiti.util.ImageAnd64Binary;
import com.yqbsoft.laser.service.activiti.util.PageData;
import com.yqbsoft.laser.service.activiti.util.PathUtil;
import com.yqbsoft.laser.service.activiti.util.Tools;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class ActProcdefServiceImpl
extends BaseServiceImpl
implements ActProcdefService {
    public static final String SYS_CODE = "act.activiti.ActProcdefServiceImpl";
    @Autowired
    private ActBaseService actBaseService;
    @Autowired
    private ActProdefMapper actProdefMapper;
    @Autowired
    private ActChannelsendService actChannelsendService;

    @Override
    public QueryResult<PageData> queryProcdef(Map<String, Object> map) {
        if (null == map) {
            throw new ApiException("act.activiti.ActProcdefServiceImplqueryProcdef", "map\u4e3a\u7a7a");
        }
        String tenantCode = (String)map.get("tenantCode");
        if (StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("act.activiti.ActProcdefServiceImplqueryProcdef", "tenantCode\u4e3a\u7a7a");
        }
        String lastStart = (String)map.get("lastStart");
        String lastEnd = (String)map.get("lastEnd");
        if (StringUtils.isNotBlank((String)lastStart)) {
            map.put("lastStart", lastStart + " 00:00:00");
        }
        if (StringUtils.isNotBlank((String)lastEnd)) {
            map.put("lastEnd", lastEnd + " 00:00:00");
        }
        int startRow = (Integer)map.get("page");
        int rows = (Integer)map.get("rows");
        if (startRow == 0) {
            startRow = 1;
            map.put("startRow", 1);
        }
        if (rows == 0) {
            rows = 5;
        }
        int firstResult = (startRow - 1) * rows;
        map.put("startRow", firstResult);
        map.put("rows", rows);
        List<PageData> list = this.actProdefMapper.queryProcdef(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        queryResult.setPageTools((SupPageTools)pageTools);
        pageTools.setRecordCount(this.count(map));
        queryResult.setList(list);
        return queryResult;
    }

    private int count(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.actProdefMapper.countProdef(map);
        }
        catch (Exception e) {
            this.logger.error("act.activiti.ActProcdefServiceImpl.count", (Throwable)e);
        }
        return i;
    }

    @Override
    public String getXml(String deploymentId, String fileName) {
        this.actBaseService.createXmlAndPng(deploymentId);
        try {
            String code = Tools.readTxtFileAll("uploadFiles/activitiFile/" + URLDecoder.decode(fileName, "UTF-8"), "utf-8");
            return code;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getPng(String deploymentId, String fileName) {
        this.actBaseService.createXmlAndPng(deploymentId);
        try {
            String imgName = URLDecoder.decode(fileName, "UTF-8");
            this.logger.error("act.activiti.ActProcdefServiceImplgetPng", (Object)("imgName ==============: " + imgName));
            imgName = imgName.replace("\"", "");
            this.logger.error("act.activiti.ActProcdefServiceImplgetPng", (Object)("imgName ==============: " + imgName));
            String imgSrcPath = PathUtil.getClasspath() + "uploadFiles/activitiFile/" + imgName;
            String base = ImageAnd64Binary.getImageStr(imgSrcPath);
            base = "data:image/jpeg;base64," + base;
            return base;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<ActChannelsend> deleteProcdef(String deploymentId) {
        PageData pageData = this.actProdefMapper.getProcdef(deploymentId);
        this.actBaseService.deleteDeployment(deploymentId);
        ArrayList<PageData> list = new ArrayList<PageData>();
        list.add(pageData);
        return this.buidProcdefChannelsend(list, "delete");
    }

    @Override
    public List<ActChannelsend> deleteProcdefBatch(String ids) {
        ArrayList<PageData> list = new ArrayList<PageData>();
        if (StringUtils.isBlank((String)ids)) {
            throw new ApiException("act.activiti.ActProcdefServiceImpldeleteProcdefBatch", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String[] ArrayDATA_IDS = ids.split(",");
        for (int i = 0; i < ArrayDATA_IDS.length; ++i) {
            PageData pageData = this.actProdefMapper.getProcdef(ArrayDATA_IDS[i]);
            this.actBaseService.deleteDeployment(ArrayDATA_IDS[i]);
            list.add(pageData);
        }
        return this.buidProcdefChannelsend(list, "delete");
    }

    private List<ActChannelsend> buidProcdefChannelsend(List<PageData> pmPromotionList, String dri) {
        if (ListUtil.isEmpty(pmPromotionList)) {
            return null;
        }
        ArrayList<ActChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<ActChannelsendDomain> disChannelsendDomainList = new ArrayList<ActChannelsendDomain>();
        for (PageData promotion : pmPromotionList) {
            ActChannelsendDomain pmChannelsendDomain = new ActChannelsendDomain();
            pmChannelsendDomain.setChannelsendOpcode(promotion.getString("DEPLOYMENT_ID_"));
            pmChannelsendDomain.setChannelsendType("deployment");
            pmChannelsendDomain.setChannelsendDir(dri);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)promotion));
            pmChannelsendDomain.setTenantCode(promotion.getString("TENANT_ID_"));
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.actChannelsendService.saveSendActChannelsendBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }
}

