/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.activiti.service.impl;

import com.yqbsoft.laser.service.activiti.dao.ActHiProcdefMapper;
import com.yqbsoft.laser.service.activiti.dao.ActRuProcdefMapper;
import com.yqbsoft.laser.service.activiti.domain.ActChannelsendDomain;
import com.yqbsoft.laser.service.activiti.model.ActChannelsend;
import com.yqbsoft.laser.service.activiti.service.ActBusinessService;
import com.yqbsoft.laser.service.activiti.service.ActChannelsendService;
import com.yqbsoft.laser.service.activiti.service.ActHiProcdefService;
import com.yqbsoft.laser.service.activiti.util.ImageAnd64Binary;
import com.yqbsoft.laser.service.activiti.util.PageData;
import com.yqbsoft.laser.service.activiti.util.PathUtil;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class ActHiProcdefServiceImpl
extends BaseServiceImpl
implements ActHiProcdefService {
    public static final String SYS_CODE = "act.activiti.ActHiProcdefServiceImpl";
    @Autowired
    private ActRuProcdefMapper actRuProcdefMapper;
    @Autowired
    private ActBusinessService actBusinessService;
    @Autowired
    private ActHiProcdefMapper actHiProcdefMapper;
    @Autowired
    private ActChannelsendService actChannelsendService;

    @Override
    public QueryResult<PageData> queryHiProcdef(Map<String, Object> map) {
        if (null == map) {
            throw new ApiException("act.activiti.ActHiProcdefServiceImplqueryModel", "map\u4e3a\u7a7a");
        }
        String tenantCode = (String)map.get("tenantCode");
        Integer startRow = (int)((Integer)map.get("page"));
        Integer rows = (int)((Integer)map.get("rows"));
        String keyWords = (String)map.get("keyWords");
        if (StringUtils.isNotBlank((String)keyWords)) {
            map.put("keyWords", keyWords.trim());
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("act.activiti.ActHiProcdefServiceImplqueryRuProcdefByMap", "tenantCode\u4e3a\u7a7a");
        }
        String lastStart = (String)map.get("lastStart");
        String lastEnd = (String)map.get("lastEnd");
        if (StringUtils.isNotBlank((String)lastStart)) {
            map.put("lastStart", lastStart + " 00:00:00");
        }
        if (StringUtils.isNotBlank((String)lastEnd)) {
            map.put("lastEnd", lastEnd + " 00:00:00");
        }
        if (startRow == 0) {
            startRow = 1;
        }
        if (rows == 0) {
            rows = 5;
            map.put("rows", 5);
        }
        int firstResult = (startRow - 1) * rows;
        map.put("startRow", firstResult);
        List<PageData> list = this.actHiProcdefMapper.datalistPage(map);
        for (PageData pageData : list) {
            Long ztime = Long.parseLong(pageData.get("DURATION_").toString());
            Long tian = ztime / 86400000L;
            Long shi = ztime % 86400000L / 3600000L;
            Long fen = ztime % 86400000L % 3600000L / 60000L;
            pageData.put("ZTIME", tian + "\u5929" + shi + "\u65f6" + fen + "\u5206");
            pageData.put("INITATOR", this.actBusinessService.getInitiator(pageData.getString("PROC_INST_ID_")));
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.count(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(list);
        return queryResult;
    }

    private int count(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.actHiProcdefMapper.countDatalist(map);
        }
        catch (Exception e) {
            this.logger.error("act.activiti.ActHiProcdefServiceImpl.count", (Throwable)e);
        }
        return i;
    }

    @Override
    public PageData getHiProcdef(Map<String, Object> map) {
        PageData pd = new PageData();
        String processId = (String)map.get("processId");
        String fileName = (String)map.get("fileName");
        String tenantCode = (String)map.get("tenantCode");
        if (StringUtils.isBlank((String)processId) || StringUtils.isBlank((String)fileName) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("act.activiti.ActHiProcdefServiceImplgetHiProcdef", "\u53c2\u6570\u4e3a\u7a7a");
        }
        List<PageData> varList = this.actHiProcdefMapper.hivarList(map);
        List<PageData> hitaskList = this.actRuProcdefMapper.queryHiTaskList(map);
        for (PageData pageData : hitaskList) {
            if (null == pageData.get("DURATION_")) continue;
            Long ztime = Long.parseLong(pageData.get("DURATION_").toString());
            Long tian = ztime / 86400000L;
            Long shi = ztime % 86400000L / 3600000L;
            Long fen = ztime % 86400000L % 3600000L / 60000L;
            Long miao = ztime % 86400000L % 3600000L % 60000L / 1000L;
            pageData.put("ZTIME", tian + "\u5929" + shi + "\u65f6" + fen + "\u5206" + miao + "\u79d2");
        }
        pd.put("varList", varList);
        pd.put("hitaskList", hitaskList);
        pd.put("tenantCode", tenantCode);
        pd.put("processId", processId);
        try {
            String FILENAME = URLDecoder.decode(fileName, "UTF-8");
            this.actBusinessService.createXmlAndPngAtNowTask(processId, FILENAME);
            pd.put("FILENAME", FILENAME);
            String imgSrcPath = PathUtil.getClasspath() + "uploadFiles/activitiFile/" + FILENAME;
            pd.put("imgSrc", "data:image/jpeg;base64," + ImageAnd64Binary.getImageStr(imgSrcPath));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return pd;
    }

    @Override
    public List<ActChannelsend> deleteHiProcdef(String processId, String fileName, String tenantCode) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("processId", processId);
            map.put("fileName", fileName);
            map.put("fileName", fileName);
            map.put("tenantCode", tenantCode);
            PageData pageData = this.getHiProcdef(map);
            ArrayList<PageData> list = new ArrayList<PageData>();
            list.add(pageData);
            this.actBusinessService.deleteHiProcessInstance(processId);
            return this.buidHiProcdefChannelsend(list, "delete");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<ActChannelsend> buidHiProcdefChannelsend(List<PageData> pmPromotionList, String dri) {
        if (ListUtil.isEmpty(pmPromotionList)) {
            return null;
        }
        ArrayList<ActChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<ActChannelsendDomain> disChannelsendDomainList = new ArrayList<ActChannelsendDomain>();
        for (PageData promotion : pmPromotionList) {
            ActChannelsendDomain pmChannelsendDomain = new ActChannelsendDomain();
            pmChannelsendDomain.setChannelsendOpcode(promotion.getString("processId"));
            pmChannelsendDomain.setChannelsendType("hiProcessInstance");
            pmChannelsendDomain.setChannelsendDir(dri);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)promotion));
            pmChannelsendDomain.setTenantCode(promotion.getString("tenantCode"));
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.actChannelsendService.saveSendActChannelsendBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }
}

