/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.activiti.service.impl;

import com.yqbsoft.laser.service.activiti.dao.ActRuProcdefMapper;
import com.yqbsoft.laser.service.activiti.domain.ActChannelsendDomain;
import com.yqbsoft.laser.service.activiti.model.ActChannelsend;
import com.yqbsoft.laser.service.activiti.service.ActBusinessService;
import com.yqbsoft.laser.service.activiti.service.ActChannelsendService;
import com.yqbsoft.laser.service.activiti.service.ActRuTaskService;
import com.yqbsoft.laser.service.activiti.util.ImageAnd64Binary;
import com.yqbsoft.laser.service.activiti.util.PageData;
import com.yqbsoft.laser.service.activiti.util.PathUtil;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;

public class ActRuTaskServiceImpl
extends BaseServiceImpl
implements ActRuTaskService {
    public static final String SYS_CODE = "act.activiti.ActRuTaskServiceImpl";
    @Autowired
    private ActRuProcdefMapper actRuProcdefMapper;
    @Autowired
    private ActBusinessService actBusinessService;
    @Autowired
    private TaskService taskService;
    @Autowired
    ActChannelsendService actChannelsendService;

    @Override
    public QueryResult<PageData> queryTodoTask(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        String tenantCode = (String)map.get("tenantCode");
        Integer startRow = (int)((Integer)map.get("page"));
        Integer rows = (int)((Integer)map.get("rows"));
        if (StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("act.activiti.ActRuTaskServiceImplqueryModel", "tenantCode\u4e3a\u7a7a");
        }
        String lastStart = (String)map.get("lastStart");
        String lastEnd = (String)map.get("lastEnd");
        if (StringUtils.isNotBlank((String)lastStart)) {
            map.put("lastStart", lastStart + " 00:00:00");
        }
        if (StringUtils.isNotBlank((String)lastEnd)) {
            map.put("lastEnd", lastEnd + " 00:00:00");
        }
        if (startRow == 0) {
            startRow = 1;
        }
        if (rows == 0) {
            rows = 5;
        }
        int firstResult = (startRow - 1) * rows;
        map.put("startRow", firstResult);
        map.put("rows", rows);
        List<PageData> list = this.actRuProcdefMapper.queryRunProdef(map);
        for (PageData pageData : list) {
            pageData.put("INITATOR", this.actBusinessService.getInitiator(pageData.getString("PROC_INST_ID_")));
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.count(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(list);
        return queryResult;
    }

    private int count(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.actRuProcdefMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("act.activiti.ActRuTaskServiceImpl.count", (Throwable)e);
        }
        return i;
    }

    @Override
    public PageData getTask(Map<String, Object> map) {
        PageData pd = new PageData();
        String processId = (String)map.get("processId");
        String taskId = (String)map.get("taskId");
        String fileName = (String)map.get("fileName");
        String tenantCode = (String)map.get("tenantCode");
        if (StringUtils.isBlank((String)processId) || StringUtils.isBlank((String)taskId) || StringUtils.isBlank((String)fileName) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("act.activiti.ActRuTaskServiceImpl.getTask", "\u53c2\u6570\u4e3a\u7a7a");
        }
        List<PageData> varList = this.actRuProcdefMapper.queryvarList(map);
        List<PageData> hitaskList = this.actRuProcdefMapper.queryHiTaskList(map);
        for (PageData pageData : hitaskList) {
            if (null == pageData.get("DURATION_")) continue;
            Long ztime = Long.parseLong(pageData.get("DURATION_").toString());
            Long tian = ztime / 86400000L;
            Long shi = ztime % 86400000L / 3600000L;
            Long fen = ztime % 86400000L % 3600000L / 60000L;
            Long miao = ztime % 86400000L % 3600000L % 60000L / 1000L;
            pageData.put("ZTIME", tian + "\u5929" + shi + "\u65f6" + fen + "\u5206" + miao + "\u79d2");
        }
        pd.put("varList", varList);
        pd.put("hitaskList", hitaskList);
        try {
            String FILENAME = URLDecoder.decode(fileName, "UTF-8");
            FILENAME = FILENAME.replace("\"", "");
            this.actBusinessService.createXmlAndPngAtNowTask(processId, FILENAME);
            pd.put("FILENAME", FILENAME);
            String imgSrcPath = PathUtil.getClasspath() + "uploadFiles/activitiFile/" + FILENAME;
            pd.put("imgSrc", "data:image/jpeg;base64," + ImageAnd64Binary.getImageStr(imgSrcPath));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return pd;
    }

    @Override
    public PageData getTaskDetails(Map<String, Object> map) {
        return this.getTask(map);
    }

    @Override
    public ActChannelsend saveTask(Map<String, Object> map) {
        Task task;
        LinkedHashMap<String, Object> varmap = new LinkedHashMap<String, Object>();
        String processId = (String)map.get("processId");
        String taskId = (String)map.get("taskId");
        String tenantCode = (String)map.get("tenantCode");
        String userName = (String)map.get("userName");
        String option = (String)map.get("option");
        String msg = (String)map.get("msg");
        String assignee = (String)map.get("assignee");
        String sfrom = "";
        Object ofrom = this.actBusinessService.getVariablesByTaskIdAsMap(taskId, "\u5ba1\u6279\u7ed3\u679c");
        if (null != ofrom) {
            sfrom = ofrom.toString();
        }
        if (null == (task = (Task)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).taskAssignee(userName)).taskTenantId(tenantCode)).singleResult())) {
            throw new ApiException("act.activiti.ActRuTaskServiceImpldoTask", "\u6ca1\u6709\u529e\u7406\u4efb\u52a1\u7684\u6743\u9650");
        }
        String OPINION = sfrom + userName + option;
        if ("yes".equals(msg)) {
            varmap.put("\u5ba1\u6279\u7ed3\u679c", "\u3010\u6279\u51c6\u3011" + OPINION);
            this.actBusinessService.setVariablesByTaskIdAsMap(taskId, varmap);
            this.actBusinessService.setVariablesByTaskId(taskId, "RESULT", "\u6279\u51c6");
            this.actBusinessService.completeMyPersonalTask(taskId);
        } else {
            varmap.put("\u5ba1\u6279\u7ed3\u679c", "\u3010\u9a73\u56de\u3011" + OPINION);
            this.actBusinessService.setVariablesByTaskIdAsMap(taskId, varmap);
            this.actBusinessService.setVariablesByTaskId(taskId, "RESULT", "\u9a73\u56de");
            this.actBusinessService.completeMyPersonalTask(taskId);
        }
        try {
            this.actBusinessService.removeVariablesByProcessId(processId, "RESULT");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isNotBlank((String)assignee)) {
            this.actBusinessService.setAssignee(taskId, assignee);
        }
        return this.saveActChannelsend(task, msg, option, tenantCode);
    }

    private ActChannelsend saveActChannelsend(Task task, String msg, String option, String tenantCode) {
        if (null == task) {
            return null;
        }
        ActChannelsendDomain ctChannelsendDomain = new ActChannelsendDomain();
        ctChannelsendDomain.setChannelsendDir(msg);
        ctChannelsendDomain.setChannelsendOpcode(task.getId());
        ctChannelsendDomain.setChannelsendType("task");
        ctChannelsendDomain.setTenantCode(tenantCode);
        ctChannelsendDomain.setChannelsendOpremark(option);
        ctChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)task));
        return this.actChannelsendService.saveChannelsend(ctChannelsendDomain);
    }

    @Override
    public ActChannelsend saveTaskNew(Map<String, Object> map) {
        return this.saveTask(map);
    }
}

