/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.activiti.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.yqbsoft.laser.service.activiti.dao.ActModelMapper;
import com.yqbsoft.laser.service.activiti.domain.ActChannelsendDomain;
import com.yqbsoft.laser.service.activiti.model.ActChannelsend;
import com.yqbsoft.laser.service.activiti.service.ActBaseService;
import com.yqbsoft.laser.service.activiti.service.ActChannelsendService;
import com.yqbsoft.laser.service.activiti.service.ActModelService;
import com.yqbsoft.laser.service.activiti.util.PageData;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.BaseBpmnXMLConverter;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.converter.UserTaskXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.editor.constants.ModelDataJsonConstants;
import org.activiti.editor.language.json.converter.BpmnJsonConverter;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.util.json.JSONException;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ModelQuery;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.springframework.beans.factory.annotation.Autowired;

public class ActModelServiceImpl
extends BaseServiceImpl
implements ModelDataJsonConstants,
ActModelService {
    public static final String SYS_CODE = "act.activiti.ActModelServiceImpl";
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ActBaseService actBaseService;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private ActModelMapper actModelMapper;
    @Autowired
    private ActChannelsendService actChannelsendService;

    @Override
    public ObjectNode getEditorJson(String modelId) {
        if (StringUtils.isBlank((String)modelId)) {
            throw new ApiException("act.activiti.ActModelServiceImplgetEditorJson", "\u53c2\u6570\u4e3a\u7a7a");
        }
        ObjectNode modelNode = null;
        Model model = this.repositoryService.getModel(modelId);
        if (model != null) {
            try {
                if (StringUtils.isNotBlank((String)model.getMetaInfo())) {
                    modelNode = (ObjectNode)this.objectMapper.readTree(model.getMetaInfo());
                } else {
                    modelNode = this.objectMapper.createObjectNode();
                    modelNode.put("name", model.getName());
                }
                modelNode.put("modelId", model.getId());
                ObjectNode editorJsonNode = (ObjectNode)this.objectMapper.readTree(new String(this.repositoryService.getModelEditorSource(model.getId()), StandardCharsets.UTF_8));
                modelNode.put("model", (JsonNode)editorJsonNode);
            }
            catch (Exception e) {
                throw new ActivitiException("Error creating model JSON", (Throwable)e);
            }
        }
        return modelNode;
    }

    @Override
    public void saveModel(String modelId, Map<String, String> values) {
        if (StringUtils.isBlank((String)modelId) || MapUtil.isEmpty(values)) {
            throw new ApiException("act.activiti.ActModelServiceImplsaveModel", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String json_xml = "";
        String TEST_XML_STRING = values.get("json_xml");
        if (StringUtils.isEmpty((String)TEST_XML_STRING)) {
            throw new ApiException("act.activiti.ActModelServiceImplsaveModel", "TEST_XML_STRING\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            BpmnXMLConverter bpmnXMLConverter = new BpmnXMLConverter();
            XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
            StringReader stringReader = new StringReader(TEST_XML_STRING);
            XMLStreamReader xmlStreamReader = null;
            try {
                xmlStreamReader = xmlInputFactory.createXMLStreamReader(stringReader);
            }
            catch (XMLStreamException e) {
                this.logger.error("act.activiti.ActModelServiceImpl.saveModelXMLStreamException", (Throwable)e);
                throw new ActivitiException("saveModelXMLStreamException", (Throwable)e);
            }
            BpmnXMLConverter.addConverter((BaseBpmnXMLConverter)new UserTaskXMLConverter());
            BpmnModel bpmnModel = bpmnXMLConverter.convertToBpmnModel(xmlStreamReader);
            BpmnJsonConverter bpmnJsonConverter = new BpmnJsonConverter();
            ObjectNode jsonNodes = bpmnJsonConverter.convertToJson(bpmnModel);
            json_xml = jsonNodes.toString();
        }
        catch (JSONException je) {
            this.logger.error("act.activiti.ActModelServiceImpl.saveModeJSONException", (Throwable)je);
            throw new ActivitiException("saveModeJSONException", (Throwable)je);
        }
        try {
            Model model = this.repositoryService.getModel(modelId);
            ObjectNode modelJson = (ObjectNode)this.objectMapper.readTree(model.getMetaInfo());
            modelJson.put("name", values.get("name"));
            modelJson.put("description", values.get("description"));
            model.setMetaInfo(modelJson.toString());
            model.setName(values.get("name"));
            this.repositoryService.saveModel(model);
            this.repositoryService.addModelEditorSource(model.getId(), json_xml.getBytes(StandardCharsets.UTF_8));
            ByteArrayInputStream svgStream = new ByteArrayInputStream(values.get("svg_xml").getBytes(StandardCharsets.UTF_8));
            TranscoderInput input = new TranscoderInput((InputStream)svgStream);
            PNGTranscoder transcoder = new PNGTranscoder();
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            TranscoderOutput output = new TranscoderOutput((OutputStream)outStream);
            transcoder.transcode(input, output);
            byte[] result = outStream.toByteArray();
            this.repositoryService.addModelEditorSourceExtra(model.getId(), result);
            outStream.close();
        }
        catch (Exception e) {
            this.logger.error("act.activiti.ActModelServiceImpl.saveModel1", (Throwable)e);
        }
    }

    public QueryResult<Model> queryPersonalTaskList(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        String tenantCode = (String)map.get("tenantCode");
        int startRow = (Integer)map.get("startRow");
        int rows = (Integer)map.get("rows");
        String keyWords = (String)map.get("keyWords");
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        if (startRow == 0) {
            startRow = 1;
            map.put("startRow", 1);
        }
        if (rows == 0) {
            rows = 5;
        }
        int firstResult = (startRow - 1) * rows;
        ModelQuery modelQuery = ((ModelQuery)this.repositoryService.createModelQuery().orderByCreateTime().desc()).modelTenantId(tenantCode).modelNameLike(keyWords);
        long count = modelQuery.count();
        List models = modelQuery.listPage(firstResult, rows);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount((int)count);
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setTotal((long)((int)count));
        queryResult.setList(models);
        return queryResult;
    }

    @Override
    public QueryResult<PageData> queryModel(Map<String, Object> map) {
        if (null == map) {
            throw new ApiException("act.activiti.ActModelServiceImplqueryModel", "map\u4e3a\u7a7a");
        }
        String tenantCode = (String)map.get("tenantCode");
        Integer startRow = (int)((Integer)map.get("page"));
        Integer rows = (int)((Integer)map.get("rows"));
        String keyWords = (String)map.get("keyWords");
        if (StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("act.activiti.ActModelServiceImplqueryModel", "tenantCode\u4e3a\u7a7a");
        }
        if (startRow == 0) {
            startRow = 1;
        }
        if (rows == 0) {
            rows = 5;
            map.put("rows", 5);
        }
        int firstResult = (startRow - 1) * rows;
        map.put("startRow", firstResult);
        List<PageData> pageData = this.actModelMapper.queryModel(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.count(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pageData);
        return queryResult;
    }

    private int count(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.actModelMapper.countModel(map);
        }
        catch (Exception e) {
            this.logger.error("act.activiti.ActModelServiceImpl.count", (Throwable)e);
        }
        return i;
    }

    @Override
    public List<ActChannelsend> saveModelForm(Map<String, Object> map) {
        if (null == map) {
            throw new ApiException("act.activiti.ActModelServiceImplsaveModelForm", "map\u4e3a\u7a7a");
        }
        String processId = (String)map.get("processId");
        if (StringUtils.isBlank((String)processId)) {
            throw new ApiException("act.activiti.ActModelServiceImplsaveModelForm", "processId\u4e3a\u7a7a");
        }
        String processAuthor = (String)map.get("processAuthor");
        String name = (String)map.get("name");
        String modelName = (String)map.get("modelName");
        if (StringUtils.isBlank((String)modelName)) {
            throw new ApiException("act.activiti.ActModelServiceImplsaveModelForm", "modelName\u4e3a\u7a7a");
        }
        String description = (String)map.get("description");
        String category = (String)map.get("category");
        String tenantCode = (String)map.get("tenantCode");
        if (StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("act.activiti.ActModelServiceImpl.saveModelForm", "tenantCode\u4e3a\u7a7a");
        }
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode editorNode = objectMapper.createObjectNode();
        editorNode.put("id", "canvs");
        editorNode.put("resourceId", "canvs");
        ObjectNode stencilSetNode = objectMapper.createObjectNode();
        stencilSetNode.put("namespace", "http://b3mn.org/stencilset/bpmn2.0#");
        stencilSetNode.put("author", "");
        editorNode.set("stencilset", (JsonNode)stencilSetNode);
        ObjectNode propertiesNode = objectMapper.createObjectNode();
        propertiesNode.put("process_id", processId);
        propertiesNode.put("process_author", processAuthor);
        propertiesNode.put("name", name);
        editorNode.set("properties", (JsonNode)propertiesNode);
        ObjectNode modelObjectNode = objectMapper.createObjectNode();
        modelObjectNode.put("name", modelName);
        modelObjectNode.put("revision", 1);
        modelObjectNode.put("description", description);
        modelObjectNode.put("tenantId", tenantCode);
        Model modelData = this.repositoryService.newModel();
        modelData.setCategory(category);
        modelData.setDeploymentId(null);
        modelData.setKey(null);
        modelData.setMetaInfo(modelObjectNode.toString());
        modelData.setName(modelName);
        modelData.setTenantId(tenantCode);
        modelData.setVersion(Integer.valueOf(1));
        this.repositoryService.saveModel(modelData);
        this.repositoryService.addModelEditorSource(modelData.getId(), editorNode.toString().getBytes(StandardCharsets.UTF_8));
        ArrayList<Model> list = new ArrayList<Model>();
        list.add(modelData);
        return this.buidModelChannelsend(list, "insert");
    }

    @Override
    public List<ActChannelsend> deleteModel(String modelId) {
        if (StringUtils.isBlank((String)modelId)) {
            throw new ApiException("act.activiti.ActModelServiceImpl.deleteModel", "modelId\u4e3a\u7a7a");
        }
        Model model = this.repositoryService.getModel(modelId);
        this.repositoryService.deleteModel(modelId);
        ArrayList<Model> list = new ArrayList<Model>();
        list.add(model);
        return this.buidModelChannelsend(list, "delete");
    }

    @Override
    public List<ActChannelsend> deleteModelBatch(String ids) {
        ArrayList<Model> list = new ArrayList<Model>();
        if (StringUtils.isBlank((String)ids)) {
            throw new ApiException("act.activiti.ActModelServiceImpldeleteModelBatch", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String[] ArrayDATA_IDS = ids.split(",");
        for (int i = 0; i < ArrayDATA_IDS.length; ++i) {
            list.add(this.repositoryService.getModel(ArrayDATA_IDS[i]));
            this.repositoryService.deleteModel(ArrayDATA_IDS[i]);
        }
        return this.buidModelChannelsend(list, "delete");
    }

    @Override
    public List<ActChannelsend> saveDeployment(String modelId) {
        if (StringUtils.isBlank((String)modelId)) {
            throw new ApiException("act.activiti.ActModelServiceImpl.saveDeployment", "modelId\u4e3a\u7a7a");
        }
        Deployment deployment = this.actBaseService.saveProcessDefinitionFromModelId(modelId);
        ArrayList<Deployment> list = new ArrayList<Deployment>();
        list.add(deployment);
        return this.buidDeploymentChannelsend(list, "insert");
    }

    @Override
    public String isCanexportXml(String modelId) {
        if (StringUtils.isBlank((String)modelId)) {
            throw new ApiException("act.activiti.ActModelServiceImpl.isCanexportXml", "modelId\u4e3a\u7a7a");
        }
        return this.actBaseService.isCanexportXmlFromModelId(modelId);
    }

    @Override
    public String getXmlFromModelId(String modelId) {
        if (StringUtils.isBlank((String)modelId)) {
            throw new ApiException("act.activiti.ActModelServiceImpl.getXmlFromModelId", "modelId\u4e3a\u7a7a");
        }
        return this.actBaseService.getXmlFromModelId(modelId);
    }

    private List<ActChannelsend> buidModelChannelsend(List<Model> pmPromotionList, String dri) {
        if (ListUtil.isEmpty(pmPromotionList)) {
            return null;
        }
        ArrayList<ActChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<ActChannelsendDomain> disChannelsendDomainList = new ArrayList<ActChannelsendDomain>();
        for (Model promotion : pmPromotionList) {
            ActChannelsendDomain pmChannelsendDomain = new ActChannelsendDomain();
            pmChannelsendDomain.setChannelsendOpcode(promotion.getId());
            pmChannelsendDomain.setChannelsendType("model");
            pmChannelsendDomain.setChannelsendDir(dri);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)promotion));
            pmChannelsendDomain.setTenantCode(promotion.getTenantId());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.actChannelsendService.saveSendActChannelsendBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }

    private List<ActChannelsend> buidDeploymentChannelsend(List<Deployment> pmPromotionList, String dri) {
        if (ListUtil.isEmpty(pmPromotionList)) {
            return null;
        }
        ArrayList<ActChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<ActChannelsendDomain> disChannelsendDomainList = new ArrayList<ActChannelsendDomain>();
        for (Deployment promotion : pmPromotionList) {
            ActChannelsendDomain pmChannelsendDomain = new ActChannelsendDomain();
            pmChannelsendDomain.setChannelsendOpcode(promotion.getId());
            pmChannelsendDomain.setChannelsendType("deployment");
            pmChannelsendDomain.setChannelsendDir(dri);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)promotion));
            pmChannelsendDomain.setTenantCode(promotion.getTenantId());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.actChannelsendService.saveSendActChannelsendBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }
}

