/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.activiti.service.impl;

import com.yqbsoft.laser.service.activiti.service.ActBusinessService;
import com.yqbsoft.laser.service.activiti.util.BpmsActivityTypeEnum;
import com.yqbsoft.laser.service.activiti.util.DelAllFile;
import com.yqbsoft.laser.service.activiti.util.FileUpload;
import com.yqbsoft.laser.service.activiti.util.PathUtil;
import com.yqbsoft.laser.service.activiti.util.UtilMisc;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.activiti.image.ProcessDiagramGenerator;
import org.springframework.beans.factory.annotation.Autowired;

public class ActBusinessServiceImpl
extends BaseServiceImpl
implements ActBusinessService {
    public static final String SYS_CODE = "act.activiti.ActBusinessServiceImpl";
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;

    @Override
    public void setAssignee(String taskId, String assignee) {
        if (StringUtils.isBlank((String)taskId) || StringUtils.isBlank((String)assignee)) {
            throw new ApiException("act.activiti.ActBusinessServiceImplsetAssignee", "\u53c2\u6570\u4e3a\u7a7a");
        }
        this.taskService.setAssignee(taskId, assignee);
    }

    @Override
    public void setVariablesByTaskIdAsMap(String taskId, Map<String, Object> map) {
        if (StringUtils.isBlank((String)taskId)) {
            throw new ApiException("act.activiti.ActBusinessServiceImplsetVariablesByTaskIdAsMap", "taskId\u4e3a\u7a7a");
        }
        this.taskService.setVariablesLocal(taskId, map);
    }

    @Override
    public Object getVariablesByTaskIdAsMap(String taskId, String key) {
        if (StringUtils.isBlank((String)taskId) || StringUtils.isBlank((String)key)) {
            throw new ApiException("act.activiti.ActBusinessServiceImplsetVariablesByTaskIdAsMap", "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.taskService.getVariable(taskId, key);
    }

    @Override
    public void setVariablesByTaskId(String taskId, String key, String value) {
        this.taskService.setVariable(taskId, key, (Object)value);
    }

    @Override
    public void removeVariablesByProcessId(String processId, String key) {
        this.runtimeService.removeVariable(processId, key);
    }

    @Override
    public List<Task> findMyPersonalTask(String userName) {
        return ((TaskQuery)this.taskService.createTaskQuery().taskAssignee(userName)).list();
    }

    @Override
    public void completeMyPersonalTask(String taskId, Map<String, Object> map) {
        this.taskService.complete(taskId, map);
    }

    @Override
    public void completeMyPersonalTask(String taskId) {
        this.taskService.complete(taskId);
    }

    @Override
    public void deleteProcessInstance(String processId, String reason) throws ApiException {
        this.runtimeService.deleteProcessInstance(processId, reason);
    }

    @Override
    public void deleteHiProcessInstance(String processId) throws Exception {
        this.historyService.deleteHistoricProcessInstance(processId);
    }

    @Override
    public void createXmlAndPngAtNowTask(String processId, String fileName) throws ApiException {
        DelAllFile.delFolder(PathUtil.getClasspath() + "uploadFiles/activitiFile");
        InputStream in = this.getResourceDiagramInputStream(processId);
        try {
            FileUpload.copyFile(in, PathUtil.getClasspath() + "uploadFiles/activitiFile/", fileName);
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private InputStream getResourceDiagramInputStream(String PROC_INST_ID_) {
        try {
            HistoricProcessInstance hip = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(PROC_INST_ID_).singleResult();
            List hai = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(PROC_INST_ID_).orderByHistoricActivityInstanceId().asc()).list();
            ArrayList<String> executedActivityIdList = new ArrayList<String>();
            for (HistoricActivityInstance activityInstance : hai) {
                executedActivityIdList.add(activityInstance.getActivityId());
            }
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(hip.getProcessDefinitionId());
            List<String> flowIds = this.getExecutedFlows(bpmnModel, hai);
            ProcessDiagramGenerator processDiagramGenerator = this.processEngine.getProcessEngineConfiguration().getProcessDiagramGenerator();
            InputStream imageStream = processDiagramGenerator.generateDiagram(bpmnModel, "png", executedActivityIdList, flowIds, "\u5b8b\u4f53", "\u5fae\u8f6f\u96c5\u9ed1", "\u9ed1\u4f53", null, 2.0);
            return imageStream;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<String> getExecutedFlows(BpmnModel bpmnModel, List<HistoricActivityInstance> historicActivityInstances) {
        ArrayList<String> flowIdList = new ArrayList<String>();
        LinkedList<FlowNode> historicFlowNodeList = new LinkedList<FlowNode>();
        LinkedList<HistoricActivityInstance> finishedActivityInstanceList = new LinkedList<HistoricActivityInstance>();
        for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
            historicFlowNodeList.add((FlowNode)bpmnModel.getMainProcess().getFlowElement(historicActivityInstance.getActivityId(), true));
            if (historicActivityInstance.getEndTime() == null) continue;
            finishedActivityInstanceList.add(historicActivityInstance);
        }
        FlowNode currentFlowNode = null;
        for (HistoricActivityInstance currentActivityInstance : finishedActivityInstanceList) {
            currentFlowNode = (FlowNode)bpmnModel.getMainProcess().getFlowElement(currentActivityInstance.getActivityId(), true);
            List sequenceFlowList = currentFlowNode.getOutgoingFlows();
            FlowNode targetFlowNode = null;
            if (BpmsActivityTypeEnum.PARALLEL_GATEWAY.getType().equals(currentActivityInstance.getActivityType()) || BpmsActivityTypeEnum.INCLUSIVE_GATEWAY.getType().equals(currentActivityInstance.getActivityType())) {
                for (SequenceFlow sequenceFlow : sequenceFlowList) {
                    targetFlowNode = (FlowNode)bpmnModel.getMainProcess().getFlowElement(sequenceFlow.getTargetRef(), true);
                    if (!historicFlowNodeList.contains(targetFlowNode)) continue;
                    flowIdList.add(sequenceFlow.getId());
                }
                continue;
            }
            LinkedList<Map<String, String>> tempMapList = new LinkedList<Map<String, String>>();
            for (SequenceFlow sequenceFlow : sequenceFlowList) {
                for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
                    if (!historicActivityInstance.getActivityId().equals(sequenceFlow.getTargetRef())) continue;
                    tempMapList.add(UtilMisc.toMap("flowId", sequenceFlow.getId(), "activityStartTime", String.valueOf(historicActivityInstance.getStartTime().getTime())));
                }
            }
            String flowId = null;
            for (Map map : tempMapList) {
                flowId = (String)map.get("flowId");
                flowIdList.add(flowId);
            }
        }
        return flowIdList;
    }

    @Override
    public String getInitiator(String processId) {
        HistoricProcessInstance hip = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processId).singleResult();
        List hais = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processId).orderByHistoricActivityInstanceId().asc()).list();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(hip.getProcessDefinitionId());
        LinkedList<FlowNode> historicFlowNodeList = new LinkedList<FlowNode>();
        for (HistoricActivityInstance hai : hais) {
            historicFlowNodeList.add((FlowNode)bpmnModel.getMainProcess().getFlowElement(hai.getActivityId(), true));
            if (hai.getAssignee() == null) continue;
            return hai.getAssignee();
        }
        return null;
    }
}

