/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.activiti.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.yqbsoft.laser.service.activiti.service.ActBaseService;
import com.yqbsoft.laser.service.activiti.service.ActStartService;
import com.yqbsoft.laser.service.activiti.util.DelAllFile;
import com.yqbsoft.laser.service.activiti.util.FileUpload;
import com.yqbsoft.laser.service.activiti.util.PathUtil;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipInputStream;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.editor.language.json.converter.BpmnJsonConverter;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.DeploymentBuilder;
import org.activiti.engine.repository.Model;
import org.springframework.beans.factory.annotation.Autowired;

public class ActBaseServiceImpl
extends BaseServiceImpl
implements ActBaseService {
    public static final String SYS_CODE = "act.activiti.ActBaseServiceImpl1";
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ActStartService actStartService;

    @Override
    public Map<String, String> getProcessProperties(String modelId) throws ApiException {
        if (StringUtils.isBlank((String)modelId)) {
            throw new ApiException("act.activiti.ActBaseServiceImpl1getProcessProperties", "modelId\u4e3a\u7a7a");
        }
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode editorJsonNode = null;
        try {
            editorJsonNode = (ObjectNode)objectMapper.readTree(new String(this.repositoryService.getModelEditorSource(modelId), StandardCharsets.UTF_8)).get("properties");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processId", editorJsonNode.get("process_id").toString());
        map.put("processAuthor", editorJsonNode.get("process_author").toString());
        map.put("name", editorJsonNode.get("name").toString());
        return map;
    }

    @Override
    public String getXmlFromModelId(String modelId) throws ApiException {
        if (StringUtils.isBlank((String)modelId)) {
            throw new ApiException("act.activiti.ActBaseServiceImpl1getXmlFromModelId", "modelId\u4e3a\u7a7a");
        }
        Model modelData = this.repositoryService.getModel(modelId);
        BpmnJsonConverter jsonConverter = new BpmnJsonConverter();
        ObjectNode modelNode = null;
        try {
            modelNode = (ObjectNode)new ObjectMapper().readTree(this.repositoryService.getModelEditorSource(modelData.getId()));
            BpmnModel bpmnModel = jsonConverter.convertToBpmnModel((JsonNode)modelNode);
            BpmnXMLConverter xmlConverter = new BpmnXMLConverter();
            byte[] bpmnBytes = xmlConverter.convertToXML(bpmnModel);
            ByteArrayInputStream in = new ByteArrayInputStream(bpmnBytes);
            InputStreamReader isr = new InputStreamReader((InputStream)in, StandardCharsets.UTF_8);
            BufferedReader bufferedReader = new BufferedReader(isr);
            StringBuffer xmlContent = new StringBuffer();
            String lineTxt = null;
            while ((lineTxt = bufferedReader.readLine()) != null) {
                xmlContent.append(lineTxt);
                xmlContent.append("\n");
            }
            isr.close();
            return xmlContent.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String isCanexportXmlFromModelId(String modelId) throws ApiException {
        if (StringUtils.isBlank((String)modelId)) {
            throw new ApiException("act.activiti.ActBaseServiceImpl1isCanexportXmlFromModelId", "modelId\u4e3a\u7a7a");
        }
        try {
            Model modelData = this.repositoryService.getModel(modelId);
            BpmnJsonConverter jsonConverter = new BpmnJsonConverter();
            ObjectNode modelNode = null;
            try {
                modelNode = (ObjectNode)new ObjectMapper().readTree(this.repositoryService.getModelEditorSource(modelData.getId()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            BpmnModel bpmnModel = jsonConverter.convertToBpmnModel(modelNode);
            BpmnXMLConverter xmlConverter = new BpmnXMLConverter();
            xmlConverter.convertToXML(bpmnModel);
            return "true";
        }
        catch (Exception e) {
            return "false";
        }
    }

    @Override
    public Deployment saveProcessDefinitionFromModelId(String modelId) throws ApiException {
        if (StringUtils.isBlank((String)modelId)) {
            throw new ApiException("act.activiti.ActBaseServiceImpl1saveProcessDefinitionFromModelId", "modelId\u4e3a\u7a7a");
        }
        Model modelData = this.repositoryService.getModel(modelId);
        ObjectNode modelNode = null;
        try {
            modelNode = (ObjectNode)new ObjectMapper().readTree(this.repositoryService.getModelEditorSource(modelData.getId()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] bpmnBytes = null;
        BpmnJsonConverter BpmnJsonConverter2 = new BpmnJsonConverter();
        BpmnModel model = BpmnJsonConverter2.convertToBpmnModel((JsonNode)modelNode);
        bpmnBytes = new BpmnXMLConverter().convertToXML(model);
        String processName = modelData.getName() + ".bpmn20.xml";
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment().name(modelData.getName()).tenantId(modelData.getTenantId());
        Deployment deployment = null;
        deployment = deploymentBuilder.addString(processName, new String(bpmnBytes, StandardCharsets.UTF_8)).deploy();
        return deployment;
    }

    public String deploymentProcessDefinitionFromClasspath(String name, String xmlpath, String pngpath) {
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment();
        deploymentBuilder.name(name);
        deploymentBuilder.addClasspathResource(xmlpath);
        deploymentBuilder.addClasspathResource(pngpath);
        Deployment deployment = deploymentBuilder.deploy();
        return deployment.getId();
    }

    public String deploymentProcessDefinitionFromZip(String name, String zippath) throws Exception {
        File outfile = new File(zippath);
        FileInputStream inputStream = new FileInputStream(outfile);
        ZipInputStream ipInputStream = new ZipInputStream(inputStream);
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment();
        deploymentBuilder.name(name);
        deploymentBuilder.addZipInputStream(ipInputStream);
        Deployment deployment = deploymentBuilder.deploy();
        ipInputStream.close();
        inputStream.close();
        return deployment.getId();
    }

    @Override
    public void createXmlAndPng(String deploymentId) throws ApiException {
        if (StringUtils.isBlank((String)deploymentId)) {
            throw new ApiException("act.activiti.ActBaseServiceImpl1createXmlAndPng", "deploymentId\u4e3a\u7a7a");
        }
        try {
            DelAllFile.delFolder(PathUtil.getClasspath() + "uploadFiles/activitiFile");
            List names = this.repositoryService.getDeploymentResourceNames(deploymentId);
            for (String name : names) {
                if (name.indexOf("zip") != -1) continue;
                InputStream in = this.repositoryService.getResourceAsStream(deploymentId, name);
                FileUpload.copyFile(in, PathUtil.getClasspath() + "uploadFiles/activitiFile/", name);
                in.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deleteDeployment(String deploymentId) throws ApiException {
        if (StringUtils.isBlank((String)deploymentId)) {
            throw new ApiException("act.activiti.ActBaseServiceImpl1deleteDeployment", "deploymentId\u4e3a\u7a7a");
        }
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    @Override
    public void activateProcessDefinitionById(String deploymentId) throws ApiException {
        if (StringUtils.isBlank((String)deploymentId)) {
            throw new ApiException("act.activiti.ActBaseServiceImpl1activateProcessDefinitionById", "deploymentId\u4e3a\u7a7a");
        }
        this.repositoryService.activateProcessDefinitionById(deploymentId, true, null);
    }

    @Override
    public void suspendProcessDefinitionById(String deploymentId) throws ApiException {
        if (StringUtils.isBlank((String)deploymentId)) {
            throw new ApiException("act.activiti.ActBaseServiceImpl1suspendProcessDefinitionById", "deploymentId\u4e3a\u7a7a");
        }
        this.repositoryService.suspendProcessDefinitionById(deploymentId, true, null);
    }

    @Override
    public void activateProcess(Map<String, Object> map) {
        String interfaceType = map.get("interfaceType").toString();
        String tenantCode = map.get("tenantCode").toString();
        if (StringUtils.isBlank((String)interfaceType) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("act.activiti.ActBaseServiceImpl1activateProcess", "\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5tenantCode/interfaceType\uff01");
        }
        map.remove("interfaceType");
        map.remove("tenantCode");
        this.actStartService.startProcessInstanceByKeyHasVariables1(interfaceType, map, tenantCode);
    }
}

