/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.activiti.service.impl;

import com.yqbsoft.laser.service.activiti.dao.ActRuProcdefMapper;
import com.yqbsoft.laser.service.activiti.service.ActBusinessService;
import com.yqbsoft.laser.service.activiti.service.ActHiTaskService;
import com.yqbsoft.laser.service.activiti.util.PageData;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class ActHiTaskServiceImpl
extends BaseServiceImpl
implements ActHiTaskService {
    public static final String SYS_CODE = "act.activiti.ActHiTaskServiceImpl";
    @Autowired
    private ActRuProcdefMapper actRuProcdefMapper;
    @Autowired
    private ActBusinessService actBusinessService;

    @Override
    public QueryResult<PageData> queryHiTask(Map<String, Object> map) {
        if (null == map) {
            throw new ApiException("act.activiti.ActHiTaskServiceImplqueryModel", "map\u4e3a\u7a7a");
        }
        String tenantCode = (String)map.get("tenantCode");
        Integer startRow = (int)((Integer)map.get("page"));
        Integer rows = (int)((Integer)map.get("rows"));
        String keyWords = (String)map.get("keyWords");
        if (StringUtils.isNotBlank((String)keyWords)) {
            map.put("keyWords", keyWords.trim());
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("act.activiti.ActHiTaskServiceImplqueryRuProcdefByMap", "tenantCode\u4e3a\u7a7a");
        }
        String lastStart = (String)map.get("lastStart");
        String lastEnd = (String)map.get("lastEnd");
        if (StringUtils.isNotBlank((String)lastStart)) {
            map.put("lastStart", lastStart + " 00:00:00");
        }
        if (StringUtils.isNotBlank((String)lastEnd)) {
            map.put("lastEnd", lastEnd + " 00:00:00");
        }
        if (startRow == 0) {
            startRow = 1;
        }
        if (rows == 0) {
            rows = 5;
            map.put("rows", 5);
        }
        int firstResult = (startRow - 1) * rows;
        map.put("startRow", firstResult);
        List<PageData> list = this.actRuProcdefMapper.queryHiTaskDatalistPage(map);
        for (PageData pageData : list) {
            Long ztime = Long.parseLong(pageData.get("DURATION_").toString());
            Long tian = ztime / 86400000L;
            Long shi = ztime % 86400000L / 3600000L;
            Long fen = ztime % 86400000L % 3600000L / 60000L;
            pageData.put("ZTIME", tian + "\u5929" + shi + "\u65f6" + fen + "\u5206");
            pageData.put("INITATOR", this.actBusinessService.getInitiator(pageData.getString("PROC_INST_ID_")));
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        queryResult.setPageTools((SupPageTools)pageTools);
        pageTools.setRecordCount(this.count(map));
        queryResult.setList(list);
        return queryResult;
    }

    private int count(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.actRuProcdefMapper.countPro(map);
        }
        catch (Exception e) {
            this.logger.error("act.activiti.ActHiTaskServiceImpl.count", (Throwable)e);
        }
        return i;
    }
}

