/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.fuji.service.impl;

import com.yqbsoft.laser.service.adapter.fuji.dao.ZtOrderdetailMapper;
import com.yqbsoft.laser.service.adapter.fuji.domain.OcContractDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsSkuDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.ZtOrderdetailDomain;
import com.yqbsoft.laser.service.adapter.fuji.model.RsBrand;
import com.yqbsoft.laser.service.adapter.fuji.model.RsClasstree;
import com.yqbsoft.laser.service.adapter.fuji.model.RsGoodsRel;
import com.yqbsoft.laser.service.adapter.fuji.model.UmUserinfo;
import com.yqbsoft.laser.service.adapter.fuji.model.ZtOrderdetail;
import com.yqbsoft.laser.service.adapter.fuji.model.ZtOrderhead;
import com.yqbsoft.laser.service.adapter.fuji.model.ZtOrderpayment;
import com.yqbsoft.laser.service.adapter.fuji.service.ZtOrderheadService;
import com.yqbsoft.laser.service.adapter.fuji.utils.DataSignUtil;
import com.yqbsoft.laser.service.adapter.fuji.utils.HttpRequestUtiles;
import com.yqbsoft.laser.service.adapter.fuji.utils.TokenUtil;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZtOrderheadServiceImpl
extends BaseServiceImpl
implements ZtOrderheadService {
    private static final String SYS_CODE = "service.adapter.fuji.ZtOrderheadServiceImpl";
    private ZtOrderdetailMapper ztOrderdetailMapper;

    public void setZtOrderdetailMapper(ZtOrderdetailMapper ztOrderdetailMapper) {
        this.ztOrderdetailMapper = ztOrderdetailMapper;
    }

    private ZtOrderdetail makeZtOrderdetail(ZtOrderdetailDomain ztOrderdetailDomain, ZtOrderdetail ztOrderdetail) {
        if (null == ztOrderdetailDomain) {
            return null;
        }
        if (null == ztOrderdetail) {
            ztOrderdetail = new ZtOrderdetail();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ztOrderdetail, (Object)ztOrderdetailDomain);
            return ztOrderdetail;
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.makeZtOrderdetail", (Throwable)e);
            return null;
        }
    }

    private ZtOrderdetailDomain makeZtOrderdetailReDomain(ZtOrderdetail ztOrderdetail) {
        if (null == ztOrderdetail) {
            return null;
        }
        ZtOrderdetailDomain ztOrderdetailDomain = new ZtOrderdetailDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ztOrderdetailDomain, (Object)ztOrderdetail);
            return ztOrderdetailDomain;
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.makeZtOrderdetailDomain", (Throwable)e);
            return null;
        }
    }

    @Override
    public String saveZtOrder(OcContractDomain ocContractDomain) throws ApiException {
        this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.saveZtOrder.intoparam");
        if (ocContractDomain == null) {
            this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.saveZtOrderdetail", (Object)"parame is null!");
            return null;
        }
        String requestUrl = "";
        String key = "";
        if (StringUtils.isNotBlank((String)ocContractDomain.getTenantCode())) {
            key = ocContractDomain.getTenantCode().concat("-").concat("SSURL").concat("-").concat("requestOrderUrl");
            requestUrl = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)key);
        }
        if (StringUtils.isBlank((String)requestUrl)) {
            this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.saveZtOrder.getRequestUrl", (Object)("\u83b7\u53d6\u5730\u5740\u4e3a\u7a7a\uff01\uff01\uff01key\uff1a" + key + ",tenantCode:" + ocContractDomain.getTenantCode()));
            return null;
        }
        String requestJson = this.saveOrder(ocContractDomain);
        if (StringUtils.isBlank((String)requestJson)) {
            this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.saveZtOrder.saveOrder.requestJson", (Object)"requestJson is null");
            return null;
        }
        String jsonResult = null;
        try {
            jsonResult = HttpRequestUtiles.httpPost("/qj/insertZtOrder", requestJson, requestUrl);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.saveZtOrder.httpPost.e", (Object)("\u8bf7\u6c42\u5f02\u5e38\uff01\uff01\uff01url:" + requestUrl + "/qj/insertZtOrder" + ",\u53c2\u6570:" + requestJson));
            return null;
        }
        Map mapResult = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(jsonResult, String.class, Object.class);
        if (!"S".equals(mapResult.get("resCode"))) {
            this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.httpPost.insertZtOrder.resCode", (Object)("respose is false,jsonResult:" + jsonResult + ",\u8bf7\u6c42\u53c2\u6570:" + requestJson + ",\u8bf7\u6c42\u5730\u5740:" + requestUrl + "/qj/insertZtOrder"));
            return null;
        }
        this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.saveZtOrder.success", (Object)(JsonUtil.buildNonDefaultBinder().toJson((Object)jsonResult) + "\uff0c\u5165\u53c2:" + JsonUtil.buildNonNullBinder().toJson((Object)requestJson)));
        return "success";
    }

    @Override
    public Map<String, Map<String, Object>> queryOrderIsFlag(String orderBillList) throws ApiException {
        if (StringUtils.isBlank((String)orderBillList)) {
            this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.queryOrderIsFlag.null", (Object)"queryOrderIsFlag is null");
            return null;
        }
        String requestUrl = "http://wx.52fmart.com:80";
        String jsonResult = null;
        try {
            jsonResult = HttpRequestUtiles.httpPost("/qj/querySellHeadByShfdd", orderBillList, requestUrl);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.queryOrderIsFlag.httpPost.e", (Object)("\u8bf7\u6c42\u5f02\u5e38\uff01\uff01\uff01url:" + requestUrl + "/qj/querySellHeadByShfdd" + ",\u53c2\u6570:" + orderBillList));
            return null;
        }
        Map mapResult = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(jsonResult, String.class, Object.class);
        if (!"S".equals(mapResult.get("resCode"))) {
            this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.httpPost.querySellHeadByShfdd.resCode", (Object)("respose is false,jsonResult:" + jsonResult + ",\u8bf7\u6c42\u53c2\u6570:" + orderBillList + ",\u8bf7\u6c42\u5730\u5740:" + requestUrl + "/qj/insertZtOrder"));
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        List mapList = (List)JsonUtil.buildNormalBinder().getJsonToList(mapResult.get("dataStr").toString(), Map.class);
        HashMap<String, Map<String, Object>> responseMap = new HashMap<String, Map<String, Object>>();
        for (Map map : mapList) {
            String ztSheetNo;
            String shinvno = null == map.get("shinvno") ? "" : String.valueOf(map.get("shinvno"));
            Object shdate = map.get("shdate");
            String formatData = sdf.format(shdate);
            String shoughtpay = null == map.get("shoughtpay") ? "0" : String.valueOf(map.get("shoughtpay"));
            String shfhdd = null == map.get("shfhdd") ? "" : String.valueOf(map.get("shfhdd"));
            String string = ztSheetNo = null == map.get("ztSheetNo") ? "" : String.valueOf(map.get("ztSheetNo"));
            if (StringUtils.isBlank((String)ztSheetNo) || StringUtils.isBlank((String)shinvno)) {
                this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.queryOrderIsFlag.response.null", (Object)(map + "-" + JsonUtil.buildNormalBinder().toJson((Object)mapResult)));
                continue;
            }
            HashMap<String, String> mapParam = new HashMap<String, String>();
            mapParam.put("erpCode", shinvno);
            mapParam.put("erpAmt", shoughtpay);
            mapParam.put("erpDate", formatData);
            responseMap.put(ztSheetNo, mapParam);
        }
        return responseMap;
    }

    private String saveOrder(OcContractDomain ocContractDomain) {
        ZtOrderhead ztOrderhead = new ZtOrderhead();
        BigDecimal entId = null;
        try {
            entId = new BigDecimal(ocContractDomain.getContractBillcode());
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.entId.e", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractDomain), (Throwable)e);
            return null;
        }
        ztOrderhead.setEntId(entId);
        ztOrderhead.setSourceTypeKeyword("ZT");
        String channelCode = ocContractDomain.getChannelCode();
        if (StringUtils.isBlank((String)channelCode)) {
            channelCode = "0";
        }
        if ("be".equals(channelCode)) {
            ztOrderhead.setChannelKeyword("14");
        } else if ("jddj".equals(channelCode)) {
            ztOrderhead.setChannelKeyword("15");
        } else if ("mt".equals(channelCode)) {
            ztOrderhead.setChannelKeyword("13");
        } else {
            this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.ChannelCode", (Object)("ChannelCode:" + channelCode));
            return null;
        }
        ztOrderhead.setBillType("1");
        if ("0".equals(ocContractDomain.getContractPumode())) {
            ztOrderhead.setOrderType("6");
        } else if ("1".equals(ocContractDomain.getContractPumode())) {
            ztOrderhead.setOrderType("5");
        }
        ztOrderhead.setOid(new BigDecimal(ocContractDomain.getContractId()));
        ztOrderhead.setSheetno(ocContractDomain.getContractBillcode());
        ztOrderhead.setChannelSheetno(ocContractDomain.getContractNbbillcode());
        if (StringUtils.isBlank((String)ocContractDomain.getPackageList().get(0).getPackageBillno())) {
            ztOrderhead.setExpressNumber("123456");
        } else {
            ztOrderhead.setExpressNumber(ocContractDomain.getPackageList().get(0).getPackageBillno());
        }
        ztOrderhead.setLogisticsValue(ocContractDomain.getGoodsLogmoney().setScale(3, 4));
        UmUserinfo umUserinfo = this.queryShopInfo(ocContractDomain.getMemberCcode(), ocContractDomain.getTenantCode());
        if (umUserinfo == null) {
            this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.saveOrder.umUserinfo", (Object)("\u67e5\u8be2\u4e3a\u7a7a\uff01\uff01\uff01MemberCode:" + ocContractDomain.getMemberCode()));
            return null;
        }
        ztOrderhead.setLogisticsStore(umUserinfo.getUserinfoOcode());
        ztOrderhead.setLogisticsStoreName(umUserinfo.getUserinfoCompname());
        ztOrderhead.setLogisticsModeKeyword("0");
        if (ocContractDomain.getGoodsReceiptMem() != null) {
            ztOrderhead.setReceiverName(ocContractDomain.getGoodsReceiptMem());
        } else {
            ztOrderhead.setReceiverName("\u7f8e\u56e2\u5ba2\u4eba");
        }
        ztOrderhead.setReceiverAddress(ocContractDomain.getGoodsReceiptArrdess());
        ztOrderhead.setReceiverPhone(ocContractDomain.getGoodsReceiptPhone());
        ztOrderhead.setWeight(ocContractDomain.getDataBweight());
        ztOrderhead.setSellerNote(ocContractDomain.getContractRemark());
        ztOrderhead.setPayOver(BigDecimal.ONE);
        long timeMillis = System.currentTimeMillis();
        ztOrderhead.setOrderTime(timeMillis);
        ztOrderhead.setReceiveTime(timeMillis);
        ztOrderhead.setSendTime(timeMillis);
        ztOrderhead.setDealStatus("0");
        ArrayList<ZtOrderdetail> ztOrderdetailList = new ArrayList<ZtOrderdetail>();
        ztOrderhead.setDetailList(ztOrderdetailList);
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        if (ocContractDomain.getContractPaymoney() == null) {
            ocContractDomain.setContractPaymoney(BigDecimal.ZERO);
        }
        BigDecimal goodsTotalMoney = BigDecimal.ZERO;
        if (ocContractDomain.getContractPaymoney().compareTo(new BigDecimal(0.5)) == 0) {
            OcContractGoodsDomain smallShoppingBag = this.savepackageGoodsParam("765965", new BigDecimal(0.2), BigDecimal.ONE, ocContractDomain.getTenantCode());
            goodsList.add(smallShoppingBag);
            OcContractGoodsDomain bigShoppingBag = this.savepackageGoodsParam("765966", new BigDecimal(0.3), BigDecimal.ONE, ocContractDomain.getTenantCode());
            goodsList.add(bigShoppingBag);
        } else {
            this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.saveOrder.contractPaymoney", (Object)("contractPaymoney:" + ocContractDomain.getContractPaymoney()));
        }
        int count = 1;
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            ZtOrderdetail ztOrderdetail;
            BigDecimal subtract;
            if (ocContractGoodsDomain.getGoodsNum() == null) {
                ocContractGoodsDomain.setGoodsNum(BigDecimal.ZERO);
            }
            if (ocContractGoodsDomain.getContractGoodsRefnum() == null) {
                ocContractGoodsDomain.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            if ((subtract = ocContractGoodsDomain.getGoodsNum().subtract(ocContractGoodsDomain.getContractGoodsRefnum())).compareTo(BigDecimal.ZERO) != 1) {
                this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.saveOrder.goodsnum", (Object)("\u8d2d\u4e70\u6570\u91cf\u7b49\u4e8e\u6216\u8005\u5c0f\u4e8e\u9000\u8d27\u6570\u91cf\uff01\uff01\uff01subtract:" + subtract + ",goodsNum:" + ocContractGoodsDomain.getGoodsNum() + ",contractGoodsRefnum:" + ocContractGoodsDomain.getContractGoodsRefnum()));
                continue;
            }
            String goodsPro = ocContractGoodsDomain.getGoodsPro();
            if ("1000".equals(goodsPro)) {
                HashMap<String, String> map = new HashMap<String, String>();
                HashMap<String, String> mapStr = new HashMap<String, String>();
                mapStr.put("goodsCode", ocContractGoodsDomain.getGoodsCode());
                mapStr.put("goodsRelType", "3");
                mapStr.put("tenantCode", ocContractGoodsDomain.getTenantCode());
                map.put("map", JsonUtil.buildNonDefaultBinder().toJson(mapStr));
                String rsGoodsJson = "";
                try {
                    rsGoodsJson = (String)this.getInternalRouter().inInvoke("rs.goodsOther.queryGoodsRelPage", map);
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.saveOrder.queryGoodsRelPage.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01\uff01\uff01(\u53c2\u6570:map:" + mapStr + ")"), (Throwable)e);
                    return null;
                }
                SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(rsGoodsJson, SupQueryResult.class);
                List pList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), RsGoodsRel.class);
                if (ListUtil.isEmpty((Collection)pList)) {
                    this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.saveOrder.queryGoodsRelPage", (Object)("\u67e5\u8be2\u4e3a\u7a7a\uff01\uff01\uff01(\u53c2\u6570:map:" + mapStr + ")"));
                    return null;
                }
                for (RsGoodsRel rsGoodsRel : pList) {
                    ZtOrderdetail ztOrderdetail2 = this.saveOrderGoodsGroupParam(rsGoodsRel, ztOrderhead, ocContractGoodsDomain, count, subtract);
                    goodsTotalMoney = goodsTotalMoney.add(ztOrderdetail2.getTransactionValue());
                    ztOrderdetailList.add(ztOrderdetail2);
                    ++count;
                }
                continue;
            }
            if ("3".equals(goodsPro)) {
                ztOrderdetail = this.saveMothAndChildGoods(ztOrderhead, ocContractGoodsDomain, count, subtract);
                goodsTotalMoney = goodsTotalMoney.add(ztOrderdetail.getTransactionValue());
                if (ztOrderdetail == null) {
                    this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.saveOrder.saveMothAndChildGoods.ztOrderdetail", (Object)"\u660e\u7ec6\u4e3a\u7a7a\uff01\uff01\uff01");
                    return null;
                }
                ztOrderdetailList.add(ztOrderdetail);
                ++count;
                continue;
            }
            if (!StringUtils.isBlank((String)goodsPro)) continue;
            ztOrderdetail = this.saveCommGoods(ztOrderhead, ocContractGoodsDomain, count, subtract);
            goodsTotalMoney = goodsTotalMoney.add(ztOrderdetail.getTransactionValue());
            if (ztOrderdetail == null) {
                this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.saveOrder.saveCommGoods.ztOrderdetail", (Object)"\u660e\u7ec6\u4e3a\u7a7a\uff01\uff01\uff01");
                return null;
            }
            ztOrderdetailList.add(ztOrderdetail);
            ++count;
        }
        BigDecimal contractMoney = ocContractDomain.getContractMoney();
        ztOrderhead.setTotalItemValue(goodsTotalMoney.setScale(2, 4));
        ztOrderhead.setPayableValue(goodsTotalMoney.setScale(2, 4));
        ztOrderhead.setTotalSaleValue(goodsTotalMoney.setScale(2, 4));
        ztOrderhead.setPayment(goodsTotalMoney.setScale(2, 4));
        ztOrderhead.setRoundValue(BigDecimal.ZERO);
        ztOrderhead.setExchangeDeductionValue(BigDecimal.ZERO);
        ztOrderhead.setTotalDiscValue(BigDecimal.ZERO);
        ArrayList<ZtOrderpayment> ztOrderpaymentList = new ArrayList<ZtOrderpayment>();
        ZtOrderpayment ztOrderpayment = this.savePayMent(ztOrderhead, ocContractDomain);
        ztOrderpaymentList.add(ztOrderpayment);
        ztOrderhead.setPaymentList(ztOrderpaymentList);
        return JsonUtil.buildNormalBinder().toJson((Object)ztOrderhead);
    }

    public OcContractGoodsDomain savepackageGoodsParam(String skuNo, BigDecimal goodsMoney, BigDecimal goodsNum, String tenantCode) {
        OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
        ocContractGoodsDomain.setSkuNo(skuNo);
        ocContractGoodsDomain.setContractGoodsMoney(goodsMoney);
        ocContractGoodsDomain.setGoodsNum(goodsNum);
        ocContractGoodsDomain.setTenantCode(tenantCode);
        return ocContractGoodsDomain;
    }

    public ZtOrderpayment savePayMent(ZtOrderhead ztOrderhead, OcContractDomain ocContractDomain) {
        ZtOrderpayment ztOrderpayment = new ZtOrderpayment();
        ztOrderpayment.setEntId(ztOrderhead.getEntId());
        ztOrderpayment.setChannelKeyword(ztOrderhead.getChannelKeyword());
        ztOrderpayment.setBillType(ztOrderhead.getBillType());
        ztOrderpayment.setOid(ztOrderhead.getOid());
        ztOrderpayment.setSheetno(ztOrderhead.getSheetno());
        ztOrderpayment.setChannelSheetno(ztOrderhead.getChannelSheetno());
        ztOrderpayment.setChannelPaymentSheetno(ztOrderhead.getChannelSheetno());
        if ("be".equals(ocContractDomain.getChannelCode())) {
            ztOrderpayment.setPayModeKeyWord("0205");
        } else if ("jddj".equals(ocContractDomain.getChannelCode())) {
            ztOrderpayment.setPayModeKeyWord("0403");
        } else if ("mt".equals(ocContractDomain.getChannelCode())) {
            ztOrderpayment.setPayModeKeyWord("0204");
        }
        ztOrderpayment.setPayMan(ztOrderhead.getReceiverName());
        ztOrderpayment.setPayment(ztOrderhead.getPayment().setScale(3, 4));
        return ztOrderpayment;
    }

    public ZtOrderdetail saveCommGoods(ZtOrderhead ztOrderhead, OcContractGoodsDomain ocContractGoodsDomain, int count, BigDecimal subtract) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("skuNo", ocContractGoodsDomain.getSkuNo());
        mapStr.put("goodsOrigin", "0");
        mapStr.put("tenantCode", ocContractGoodsDomain.getTenantCode());
        map.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
        String skuJson = "";
        try {
            skuJson = (String)this.getInternalRouter().inInvoke("rs.sku.querySkuPage", map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.saveCommGoods.querySkuPage.e", (Object)("\u67e5\u8be2\u5546\u54c1\u5f02\u5e38\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map:" + map), (Throwable)e);
            return null;
        }
        SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(skuJson, SupQueryResult.class);
        List pList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), RsSkuDomain.class);
        if (ListUtil.isEmpty((Collection)pList)) {
            this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.saveCommGoods.querySkuPage", (Object)("\u67e5\u8be2\u5546\u54c1\u4e3a\u7a7a\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map:" + map));
            return null;
        }
        RsSkuDomain rsSkuDomain = (RsSkuDomain)pList.get(0);
        ZtOrderdetail ztOrderdetail = new ZtOrderdetail();
        ztOrderdetail.setEntId(ztOrderhead.getEntId());
        ztOrderdetail.setOid(ztOrderhead.getOid());
        ztOrderdetail.setChannelKeyword(ztOrderhead.getChannelKeyword());
        ztOrderdetail.setBillType(ztOrderhead.getBillType());
        ztOrderdetail.setSheetno(ztOrderhead.getSheetno());
        ztOrderdetail.setChannelSheetno(ztOrderhead.getChannelSheetno());
        ztOrderdetail.setChannelDetailSheetno(ztOrderhead.getChannelSheetno());
        ztOrderdetail.setSpec(rsSkuDomain.getSkuName());
        ztOrderdetail.setItemCode(rsSkuDomain.getGoodsNo());
        ztOrderdetail.setSkuCode(rsSkuDomain.getSkuNo());
        ztOrderdetail.setItemName(rsSkuDomain.getGoodsName());
        ztOrderdetail.setBarcode(rsSkuDomain.getSkuBarcode());
        BigDecimal contractGoodsMoney = ocContractGoodsDomain.getContractGoodsMoney();
        BigDecimal contractGoodsSinglePrice = contractGoodsMoney.divide(subtract);
        ztOrderdetail.setSalePrice(contractGoodsSinglePrice.setScale(2, 4));
        ztOrderdetail.setSaleQty(subtract);
        ztOrderdetail.setSaleValue(contractGoodsMoney.setScale(2, 4));
        ztOrderdetail.setTransactionValue(contractGoodsMoney.setScale(2, 4));
        ztOrderdetail.setDiscValue(BigDecimal.ZERO);
        ztOrderdetail.setOrderNo(new BigDecimal(count));
        HashMap<String, String> classtreeMap = new HashMap<String, String>();
        classtreeMap.put("classtreeCode", rsSkuDomain.getClasstreeCode());
        classtreeMap.put("tenantCode", rsSkuDomain.getTenantCode());
        HashMap<String, String> classtreeMapStr = new HashMap<String, String>();
        classtreeMapStr.put("map", JsonUtil.buildNonDefaultBinder().toJson(classtreeMap));
        String classtreeJson = "";
        try {
            classtreeJson = (String)this.getInternalRouter().inInvoke("rs.rsClasstree.getClasstreeByCode", classtreeMapStr);
            if (StringUtils.isBlank((String)classtreeJson)) {
                this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.saveCommGoods.getClasstreeByCode", (Object)("\u67e5\u8be2\u5546\u54c1\u5206\u7c7b\u4e3a\u7a7a\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map:" + map));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.saveCommGoods.getClasstreeByCode.e", (Object)("\u67e5\u8be2\u5546\u54c1\u5206\u7c7b\u5f02\u5e38\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map:" + map), (Throwable)e);
            return null;
        }
        RsClasstree rsClasstree = (RsClasstree)JsonUtil.buildNonEmptyBinder().getJsonToObject(classtreeJson, RsClasstree.class);
        ztOrderdetail.setCatCode(rsClasstree.getClasstreeEocode());
        HashMap<String, String> brandMap = new HashMap<String, String>();
        brandMap.put("brandCode", rsSkuDomain.getBrandCode());
        brandMap.put("tenantCode", rsSkuDomain.getTenantCode());
        HashMap<String, String> brandMapStr = new HashMap<String, String>();
        brandMapStr.put("map", JsonUtil.buildNonDefaultBinder().toJson(brandMap));
        String brandJson = "";
        try {
            brandJson = (String)this.getInternalRouter().inInvoke("rs.brand.getBrandByCode", brandMapStr);
            if (StringUtils.isBlank((String)brandJson)) {
                this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.saveCommGoods.getBrandByCode", (Object)("\u67e5\u8be2\u5546\u54c1\u54c1\u724c\u4e3a\u7a7a\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map:" + map));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.saveCommGoods.getBrandByCode.e", (Object)("\u67e5\u8be2\u5546\u54c1\u54c1\u724c\u5f02\u5e38\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map:" + map), (Throwable)e);
            return null;
        }
        RsBrand rsBrand = (RsBrand)JsonUtil.buildNonEmptyBinder().getJsonToObject(brandJson, RsBrand.class);
        ztOrderdetail.setBrandCode(rsBrand.getBrandEocode());
        return ztOrderdetail;
    }

    public ZtOrderdetail saveMothAndChildGoods(ZtOrderhead ztOrderhead, OcContractGoodsDomain ocContractGoodsDomain, int count, BigDecimal subtract) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("skuNo", ocContractGoodsDomain.getSkuNo());
        mapStr.put("goodsOrigin", "20");
        mapStr.put("tenantCode", ocContractGoodsDomain.getTenantCode());
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(mapStr));
        String rsSkuJson = "";
        try {
            rsSkuJson = (String)this.getInternalRouter().inInvoke("rs.sku.querySkuPage", map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.saveMothAndChildGoods.querySkuPage.e", (Object)("\u67e5\u8be2\u5546\u54c1\u5f02\u5e38\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map:" + map), (Throwable)e);
            return null;
        }
        SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(rsSkuJson, SupQueryResult.class);
        List pList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), RsSkuDomain.class);
        if (ListUtil.isEmpty((Collection)pList)) {
            this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.saveMothAndChildGoods.querySkuPage", (Object)("\u67e5\u8be2\u5546\u54c1\u4e3a\u7a7a\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map:" + map));
            return null;
        }
        RsSkuDomain rsSkuDomain = (RsSkuDomain)pList.get(0);
        ZtOrderdetail ztOrderdetail = new ZtOrderdetail();
        ztOrderdetail.setEntId(ztOrderhead.getEntId());
        ztOrderdetail.setOid(ztOrderhead.getOid());
        ztOrderdetail.setChannelKeyword(ztOrderhead.getChannelKeyword());
        ztOrderdetail.setBillType(ztOrderhead.getBillType());
        ztOrderdetail.setSheetno(ztOrderhead.getSheetno());
        ztOrderdetail.setChannelSheetno(ztOrderhead.getChannelSheetno());
        ztOrderdetail.setChannelDetailSheetno(ztOrderhead.getChannelSheetno());
        ztOrderdetail.setSpec(rsSkuDomain.getSkuName());
        ztOrderdetail.setItemCode(rsSkuDomain.getGoodsNo());
        ztOrderdetail.setSkuCode(rsSkuDomain.getSkuNo());
        ztOrderdetail.setItemName(rsSkuDomain.getGoodsName());
        ztOrderdetail.setBarcode(rsSkuDomain.getSkuBarcode());
        BigDecimal contractGoodsMoney = ocContractGoodsDomain.getContractGoodsMoney();
        BigDecimal contractGoodsSinglePrice = contractGoodsMoney.divide(subtract);
        ztOrderdetail.setSalePrice(contractGoodsSinglePrice.setScale(3, 4));
        ztOrderdetail.setSaleQty(subtract);
        ztOrderdetail.setSaleValue(contractGoodsMoney.setScale(3, 4));
        ztOrderdetail.setTransactionValue(contractGoodsMoney.setScale(3, 4));
        ztOrderdetail.setDiscValue(BigDecimal.ZERO);
        ztOrderdetail.setOrderNo(new BigDecimal(count));
        HashMap<String, String> classtreeMap = new HashMap<String, String>();
        classtreeMap.put("classtreeCode", rsSkuDomain.getClasstreeCode());
        classtreeMap.put("tenantCode", rsSkuDomain.getTenantCode());
        HashMap<String, String> classtreeMapStr = new HashMap<String, String>();
        classtreeMapStr.put("map", JsonUtil.buildNonDefaultBinder().toJson(classtreeMap));
        String classtreeJson = "";
        try {
            classtreeJson = (String)this.getInternalRouter().inInvoke("rs.rsClasstree.getClasstreeByCode", classtreeMapStr);
            if (StringUtils.isBlank((String)classtreeJson)) {
                this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.saveMothAndChildGoods.getClasstreeByCode", (Object)("\u67e5\u8be2\u5546\u54c1\u5206\u7c7b\u4e3a\u7a7a\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map:" + map));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.saveMothAndChildGoods.getClasstreeByCode.e", (Object)("\u67e5\u8be2\u5546\u54c1\u5206\u7c7b\u5f02\u5e38\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map:" + map), (Throwable)e);
            return null;
        }
        RsClasstree rsClasstree = (RsClasstree)JsonUtil.buildNonEmptyBinder().getJsonToObject(classtreeJson, RsClasstree.class);
        ztOrderdetail.setCatCode(rsClasstree.getClasstreeEocode());
        HashMap<String, String> brandMap = new HashMap<String, String>();
        brandMap.put("brandCode", rsSkuDomain.getBrandCode());
        brandMap.put("tenantCode", rsSkuDomain.getTenantCode());
        HashMap<String, String> brandMapStr = new HashMap<String, String>();
        brandMapStr.put("map", JsonUtil.buildNonDefaultBinder().toJson(brandMap));
        String brandJson = "";
        try {
            brandJson = (String)this.getInternalRouter().inInvoke("rs.brand.getBrandByCode", brandMapStr);
            if (StringUtils.isBlank((String)brandJson)) {
                this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.saveMothAndChildGoods.getBrandByCode", (Object)("\u67e5\u8be2\u5546\u54c1\u54c1\u724c\u4e3a\u7a7a\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map:" + map));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.saveMothAndChildGoods.getBrandByCode.e", (Object)("\u67e5\u8be2\u5546\u54c1\u54c1\u724c\u5f02\u5e38\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map:" + map), (Throwable)e);
            return null;
        }
        RsBrand rsBrand = (RsBrand)JsonUtil.buildNonEmptyBinder().getJsonToObject(brandJson, RsBrand.class);
        ztOrderdetail.setBrandCode(rsBrand.getBrandEocode());
        return ztOrderdetail;
    }

    public ZtOrderdetail saveOrderGoodsGroupParam(RsGoodsRel rsGoodsRels, ZtOrderhead ztOrderhead, OcContractGoodsDomain ocContractGoodsDomain, int count, BigDecimal subtract) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("skuNo", rsGoodsRels.getSkuCode());
        mapStr.put("goodsOrigin", "0");
        mapStr.put("tenantCode", rsGoodsRels.getTenantCode());
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(mapStr));
        String rsSkuJson = "";
        try {
            rsSkuJson = (String)this.getInternalRouter().inInvoke("rs.sku.querySkuPage", map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.saveOrderGoodsGroupParam.querySkuPage.e", (Object)("\u67e5\u8be2\u5546\u54c1\u5f02\u5e38\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map:" + map), (Throwable)e);
            return null;
        }
        SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(rsSkuJson, SupQueryResult.class);
        List pList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), RsSkuDomain.class);
        if (ListUtil.isEmpty((Collection)pList)) {
            this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.saveOrderGoodsGroupParam.querySkuPage", (Object)("\u67e5\u8be2\u5546\u54c1\u4e3a\u7a7a\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map:" + map));
            return null;
        }
        RsSkuDomain rsSkuDomain = (RsSkuDomain)pList.get(0);
        ZtOrderdetail ztOrderdetail = new ZtOrderdetail();
        ztOrderdetail.setEntId(ztOrderhead.getEntId());
        ztOrderdetail.setOid(ztOrderhead.getOid());
        ztOrderdetail.setChannelKeyword(ztOrderhead.getChannelKeyword());
        ztOrderdetail.setBillType(ztOrderhead.getBillType());
        ztOrderdetail.setSheetno(ztOrderhead.getSheetno());
        ztOrderdetail.setChannelSheetno(ztOrderhead.getChannelSheetno());
        ztOrderdetail.setChannelDetailSheetno(ztOrderhead.getChannelSheetno());
        ztOrderdetail.setSpec(rsSkuDomain.getSkuName());
        ztOrderdetail.setItemCode(rsSkuDomain.getGoodsNo());
        ztOrderdetail.setSkuCode(rsSkuDomain.getSkuNo());
        ztOrderdetail.setItemName(rsSkuDomain.getGoodsName());
        ztOrderdetail.setBarcode(rsSkuDomain.getSkuBarcode());
        ztOrderdetail.setSalePrice(ocContractGoodsDomain.getContractGoodsInmoney().setScale(3, 4));
        ztOrderdetail.setSaleQty(subtract);
        BigDecimal totalPrice = ocContractGoodsDomain.getContractGoodsInmoney().multiply(ocContractGoodsDomain.getGoodsNum());
        ztOrderdetail.setSaleValue(totalPrice.setScale(3, 4));
        BigDecimal discountsSubtract = totalPrice.subtract(ocContractGoodsDomain.getContractGoodsMoney().multiply(ocContractGoodsDomain.getGoodsNum()));
        ztOrderdetail.setDiscValue(discountsSubtract.setScale(3, 4));
        ztOrderdetail.setTransactionValue(ocContractGoodsDomain.getContractGoodsMoney().multiply(ocContractGoodsDomain.getGoodsNum()).setScale(3, 4));
        ztOrderdetail.setOrderNo(new BigDecimal(count));
        HashMap<String, String> classtreeMap = new HashMap<String, String>();
        classtreeMap.put("classtreeCode", rsSkuDomain.getClasstreeCode());
        classtreeMap.put("tenantCode", rsSkuDomain.getTenantCode());
        HashMap<String, String> classtreeMapStr = new HashMap<String, String>();
        classtreeMapStr.put("map", JsonUtil.buildNonDefaultBinder().toJson(classtreeMap));
        String classtreeJson = "";
        try {
            classtreeJson = (String)this.getInternalRouter().inInvoke("rs.rsClasstree.getClasstreeByCode", classtreeMapStr);
            if (StringUtils.isBlank((String)classtreeJson)) {
                this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.saveOrderGoodsGroupParam.getClasstreeByCode", (Object)("\u67e5\u8be2\u5546\u54c1\u5206\u7c7b\u4e3a\u7a7a\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map:" + map));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.saveOrderGoodsGroupParam.getClasstreeByCode.e", (Object)("\u67e5\u8be2\u5546\u54c1\u5206\u7c7b\u5f02\u5e38\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map:" + map), (Throwable)e);
            return null;
        }
        RsClasstree rsClasstree = (RsClasstree)JsonUtil.buildNonEmptyBinder().getJsonToObject(classtreeJson, RsClasstree.class);
        ztOrderdetail.setCatCode(rsClasstree.getClasstreeEocode());
        HashMap<String, String> brandMap = new HashMap<String, String>();
        brandMap.put("brandCode", rsSkuDomain.getBrandCode());
        brandMap.put("tenantCode", rsSkuDomain.getTenantCode());
        HashMap<String, String> brandMapStr = new HashMap<String, String>();
        brandMapStr.put("map", JsonUtil.buildNonDefaultBinder().toJson(brandMap));
        String brandJson = "";
        try {
            brandJson = (String)this.getInternalRouter().inInvoke("rs.brand.getBrandByCode", brandMapStr);
            if (StringUtils.isBlank((String)brandJson)) {
                this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.saveOrderGoodsGroupParam.getBrandByCode", (Object)("\u67e5\u8be2\u5546\u54c1\u54c1\u724c\u4e3a\u7a7a\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map:" + map));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.saveOrderGoodsGroupParam.getBrandByCode.e", (Object)("\u67e5\u8be2\u5546\u54c1\u54c1\u724c\u5f02\u5e38\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map:" + map), (Throwable)e);
            return null;
        }
        RsBrand rsBrand = (RsBrand)JsonUtil.buildNonEmptyBinder().getJsonToObject(brandJson, RsBrand.class);
        ztOrderdetail.setBrandCode(rsBrand.getBrandEocode());
        return ztOrderdetail;
    }

    public UmUserinfo queryShopInfo(String memberCode, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userinfoCode", memberCode);
        map.put("tenantCode", tenantCode);
        String umUserInfoJson = "";
        try {
            umUserInfoJson = (String)this.getInternalRouter().inInvoke("um.user.getUserinfoByUserCode", map);
            if (StringUtils.isBlank((String)umUserInfoJson)) {
                this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.queryShopInfo", (Object)("\u67e5\u8be2\u95e8\u5e97\u4e3a\u7a7a\uff01\uff01\uff01map:" + map));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.ZtOrderheadServiceImpl.queryShopInfo.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01\uff01\uff01map:" + map), (Throwable)e);
            return null;
        }
        return (UmUserinfo)JsonUtil.buildNonEmptyBinder().getJsonToObject(umUserInfoJson, UmUserinfo.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String requestHttp(String requestJson) {
        String urlPath = "http://wx.52fmart.com:8081/qj/insertZtOrder";
        Pattern p = Pattern.compile("\\s*|\t|\r|\n");
        Matcher m = p.matcher(requestJson);
        requestJson = m.replaceAll("");
        DataSignUtil.RequestEntity req = new DataSignUtil.RequestEntity();
        req.setUri("/qj/insertZtOrder");
        req.setUserId("qj");
        req.setProjectCode("SSYH");
        req.setBizData(requestJson);
        req.setReqDate("2019-03-21 15:53:50");
        req.setEncryptKey("SSYH2019");
        String dataSign = null;
        try {
            dataSign = DataSignUtil.generateDataSign(req);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TokenUtil.RequestEntity req2 = new TokenUtil.RequestEntity();
        req2.setDataSign(dataSign);
        req2.setProjectCode("SSYH");
        req2.setReqDate("2019-03-21 15:53:50");
        req2.setUserId("qj");
        String token = null;
        try {
            token = TokenUtil.generateToken(req2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String result = "";
        BufferedReader reader = null;
        try {
            URL url = new URL(urlPath);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setRequestProperty("Charset", "UTF-8");
            conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            if (StringUtils.isNotBlank((String)token)) {
                conn.setRequestProperty("token", token);
            }
            if (requestJson != null && StringUtils.isNotBlank((String)requestJson)) {
                OutputStream os = conn.getOutputStream();
                os.write(requestJson.getBytes());
                os.close();
            }
            if (conn.getResponseCode() == 200) {
                reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                result = reader.readLine();
            }
            if (conn.getResponseCode() == 400) {
                reader = new BufferedReader(new InputStreamReader(conn.getErrorStream()));
                result = reader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static void main(String[] args) {
        String orderBillList = "2019111100000003";
        String requestUrl = "http://wx.52fmart.com:80";
        String jsonResult = null;
        try {
            jsonResult = HttpRequestUtiles.httpPost("/qj/querySellHeadByShfdd", orderBillList, requestUrl);
        }
        catch (Exception e) {
            // empty catch block
        }
        System.out.println(jsonResult);
    }
}

