/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.fuji.service.impl;

import com.yqbsoft.laser.service.adapter.fuji.model.BasePage;
import com.yqbsoft.laser.service.adapter.fuji.model.ViewElabalSend;
import com.yqbsoft.laser.service.adapter.fuji.utils.DataSignUtil;
import com.yqbsoft.laser.service.adapter.fuji.utils.TokenUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpRequest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPost(String methodName, Integer pageNo, Integer pageSize, String shopId, String queryTime) {
        SimpleDateFormat dd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String format = dd.format(new Date());
        String requestJson = "";
        if (StringUtils.isNotBlank((String)shopId)) {
            ViewElabalSend viewElabalSend = new ViewElabalSend();
            viewElabalSend.setShopid(shopId);
            viewElabalSend.setPageNo(pageNo.toString());
            viewElabalSend.setPageNo(pageNo.toString());
            viewElabalSend.setPageSize(pageSize.toString());
            viewElabalSend.setQueryTime(queryTime);
            requestJson = JsonUtil.buildNonDefaultBinder().toJson((Object)viewElabalSend);
        } else {
            BasePage basePage = new BasePage();
            basePage.setPageNo(pageNo.toString());
            basePage.setPageSize(pageSize.toString());
            basePage.setQueryTime(queryTime);
            requestJson = JsonUtil.buildNonDefaultBinder().toJson((Object)basePage);
        }
        Pattern p = Pattern.compile("\\s*|\t|\r|\n");
        Matcher m = p.matcher(requestJson);
        requestJson = m.replaceAll("");
        DataSignUtil.RequestEntity req = new DataSignUtil.RequestEntity();
        req.setUri(methodName);
        req.setUserId("qj");
        req.setProjectCode("SSYH");
        req.setBizData(requestJson);
        req.setReqDate(format);
        req.setEncryptKey("SSYH2019");
        String dataSign = null;
        try {
            dataSign = DataSignUtil.generateDataSign(req);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TokenUtil.RequestEntity req2 = new TokenUtil.RequestEntity();
        req2.setDataSign(dataSign);
        req2.setProjectCode("SSYH");
        req2.setReqDate(format);
        req2.setUserId("qj");
        String token = null;
        try {
            token = TokenUtil.generateToken(req2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String result = "";
        BufferedReader reader = null;
        String urlPath = "http://wx.52fmart.com:8081" + methodName;
        try {
            URL url = new URL(urlPath);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setReadTimeout(1000000);
            conn.setConnectTimeout(1000000);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setRequestProperty("Charset", "UTF-8");
            conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            if (StringUtils.isNotBlank((String)token)) {
                conn.setRequestProperty("token", token);
            }
            if (requestJson != null && StringUtils.isNotBlank((String)requestJson)) {
                OutputStream os = conn.getOutputStream();
                os.write(requestJson.getBytes());
                os.close();
            }
            if (conn.getResponseCode() == 200) {
                reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                result = reader.readLine();
            }
            if (conn.getResponseCode() == 400) {
                reader = new BufferedReader(new InputStreamReader(conn.getErrorStream()));
                result = reader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }
}

