/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.http;

import com.yqbsoft.laser.service.esb.core.auth.AuthUtil;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.core.EsbReBean;
import com.yqbsoft.laser.service.esb.core.router.ProxyInvokeSupport;
import com.yqbsoft.laser.service.esb.core.transformer.InvokeIdParser;
import com.yqbsoft.laser.service.suppercore.core.InMessage;
import com.yqbsoft.laser.service.suppercore.core.Invoke;
import com.yqbsoft.laser.service.suppercore.core.OutMessage;
import com.yqbsoft.laser.service.suppercore.point.RegeditBean;
import com.yqbsoft.laser.service.suppercore.point.RegeditUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class HttpConInvokeService
extends ProxyInvokeSupport {
    private static final String sys_code = "ahttp.adapter.http.HttpInvoke";
    public static final String APPMANAGE_KEY = "Appmanage-key-line";
    public static final String VFOAPPMANAGE_LINEINFO = "EcoreAppmanage-lineInfo";
    public static final Long REGEDIT_OVER_TIME = 60000L;

    public OutMessage channelSendMsg(InMessage inMessage) {
        if (null == inMessage) {
            return new OutMessage("ahttp.adapter.http.HttpInvoke.empty", "\u4fe1\u606f\u4e3a\u7a7a");
        }
        OutMessage outMessage = new OutMessage();
        try {
            String rsp = null;
            Invoke invoke = inMessage.getInvoke();
            Map fileParams = null;
            if (null != invoke.getRetParam()) {
                fileParams = invoke.getRetParam().getFileParams();
            }
            Map params = inMessage.getAllParamMap();
            InvokeIdParser.addInInvokeIdParamByHttp((Map)params, (InMessage)inMessage);
            String url = "http://{appIp}:{appPort}/{contextPath}/laserDirect/http/get?method=" + invoke.getApiProperty().getAppapiCode() + "&version=1.0&charset=utf-8";
            List<String> st = HttpConInvokeService.getPointAppKeys(inMessage.getToAppmanageIcode(), null);
            if (ListUtil.isEmpty(st)) {
                outMessage.setErrorCode("ahttp.adapter.http.HttpInvoke.st");
                outMessage.setMsg("\u670d\u52a1\u4e3a\u542f\u52a8");
            }
            int len = st.size();
            int i = HttpConInvokeService.getRandom(len - 1);
            String appKey = st.get(i);
            url = RegeditUtil.replaceServiceUrl((String)appKey, (String)url);
            this.logger.error(sys_code, (Object)("http request url:" + appKey + "==" + url));
            rsp = WebUtils.doPost((String)url, (Map)params, (Map)fileParams, (String)invoke.getApiRouterProperty().getRouterCharset(), (int)invoke.getApiRouterProperty().getRouterConnecttimeout(), (int)invoke.getApiRouterProperty().getRouterReadtimeout());
            this.logger.error(sys_code, (Object)("http rsp:" + rsp));
            outMessage.setReObj((Object)rsp);
        }
        catch (Exception e) {
            this.logger.error(sys_code, (Object)("\u8c03\u7528\u5f02\u5e38,url:" + inMessage.getInvoke().getRouterServiceName() + ",param" + inMessage.getInvoke().getParams()), (Throwable)e);
            outMessage.setErrorCode("ahttp.adapter.http.HttpInvoke.ex");
            outMessage.setMsg("\u8c03\u7528\u5f02\u5e38");
        }
        return outMessage;
    }

    public static int getRandom(int max) {
        int min = 0;
        Random random = new Random();
        int s = random.nextInt(max) % (max - min + 1) + min;
        return s;
    }

    public static RegeditBean getRegeditBean(String appmanageAppkey) {
        String js = DisUtil.getMap((String)VFOAPPMANAGE_LINEINFO, (String)appmanageAppkey);
        if (StringUtils.isBlank((String)js)) {
            return null;
        }
        RegeditBean regeditBean = (RegeditBean)JsonUtil.buildNormalBinder().getJsonToObject(js, RegeditBean.class);
        return regeditBean;
    }

    public static List<String> getPointAppKeys(String appmanageIcode, String appmanageAppkey) {
        Map appkeyMap = DisUtil.getMapAll((String)APPMANAGE_KEY);
        ArrayList<String> newAppKey = new ArrayList<String>();
        if (null == appkeyMap || appkeyMap.isEmpty()) {
            RegeditBean regeditBean = HttpConInvokeService.getRegeditBean(appmanageAppkey);
            if (null != regeditBean && System.currentTimeMillis() <= regeditBean.getLastDate().getTime() + REGEDIT_OVER_TIME) {
                newAppKey.add(appmanageAppkey);
            }
        } else {
            for (String key : appkeyMap.keySet()) {
                RegeditBean regeditBean;
                if (!appmanageIcode.equals(appkeyMap.get(key)) || (regeditBean = HttpConInvokeService.getRegeditBean(key)) == null || System.currentTimeMillis() > regeditBean.getLastDate().getTime() + REGEDIT_OVER_TIME) continue;
                newAppKey.add(key);
            }
        }
        if (newAppKey.isEmpty()) {
            newAppKey.add(appmanageAppkey);
        }
        return newAppKey;
    }

    public void securityEncoder(InMessage inMessage) {
        Map params = inMessage.getInvoke().getParams();
        if (MapUtil.isEmpty((Map)params)) {
            return;
        }
        String plainText = AuthUtil.getSignCheckContentV1((Map)params);
        String sign = AuthUtil.sendAuth((InMessage)inMessage, (String)plainText);
        inMessage.getInvoke().setSign(sign);
    }

    public void securityDecoder(OutMessage outMessage, InMessage inMessage) {
        if (outMessage == null || inMessage == null) {
            return;
        }
        Map resultMap = null;
        if (outMessage.getReObj() == null) {
            return;
        }
        String resultJson = outMessage.getReObj().toString();
        if (!StringUtils.isMapJson((String)resultJson)) {
            return;
        }
        resultMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(resultJson, String.class, String.class);
        if (MapUtil.isEmpty((Map)resultMap)) {
            return;
        }
        String sign = (String)resultMap.get("sign");
        if (StringUtils.isEmpty((String)sign)) {
            this.logger.error(sys_code, (Object)"securityDecoder sign is null");
            return;
        }
        String plainText = AuthUtil.getSignCheckContentV1((Map)resultMap);
        boolean checkFlag = AuthUtil.returnAuthCheck((InMessage)inMessage, (String)plainText, (String)sign);
        if (!checkFlag) {
            this.logger.error(sys_code, (Object)("validate sign fail plainTest " + plainText));
        }
    }

    protected void handleInvokeId(InMessage inMessage, OutMessage outMessage) {
        EsbReBean jrb;
        String objectJson;
        Object reObject = outMessage.getReObj();
        if (reObject != null && StringUtils.isMapJson((String)(objectJson = reObject.toString())) && null != (jrb = (EsbReBean)JsonUtil.buildNormalBinder().getJsonToObject(objectJson, EsbReBean.class, new Class[]{String.class})) && null != jrb.getInvokeId()) {
            int level = jrb.getInvokeId().getMsgLevel();
            inMessage.getInvokeId().setMsgLevel(level);
        }
        super.handleInvokeId(inMessage, outMessage);
    }

    protected boolean isDispatchAdapter() {
        return true;
    }
}

