/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.http;

import com.yqbsoft.laser.service.adapter.http.OkHttpUtil;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.router.ProxyInvokeSupport;
import com.yqbsoft.laser.service.esb.core.transformer.InvokeIdParser;
import com.yqbsoft.laser.service.suppercore.core.InMessage;
import com.yqbsoft.laser.service.suppercore.core.Invoke;
import com.yqbsoft.laser.service.suppercore.core.OutMessage;
import com.yqbsoft.laser.service.suppercore.point.RegeditBean;
import com.yqbsoft.laser.service.suppercore.point.RegeditUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class HttpInvokeService
extends ProxyInvokeSupport {
    private static final String sys_code = "ahttp.adapter.http.HttpInvokeService";
    public static final String APPMANAGE_KEY = "Appmanage-key-line";
    public static final String VFOAPPMANAGE_LINEINFO = "EcoreAppmanage-lineInfo";
    public static final Long REGEDIT_OVER_TIME = 60000L;

    public OutMessage channelSendMsg(InMessage inMessage) {
        if (null == inMessage) {
            return new OutMessage("ahttp.adapter.http.HttpInvokeService.empty", "\u4fe1\u606f\u4e3a\u7a7a");
        }
        OutMessage outMessage = new OutMessage();
        long s = System.currentTimeMillis();
        String url = "";
        String rsp = null;
        Invoke invoke = inMessage.getInvoke();
        if (null != invoke.getRetParam()) {
            this.logger.error(sys_code, (Object)"============http request fileParams:");
        }
        String apicode = invoke.getApiProperty().getAppapiCode();
        try {
            List<String> st;
            HashMap<String, String> params = new HashMap<String, String>();
            if (null == params) {
                params = new HashMap();
            }
            InvokeIdParser.addInInvokeIdParamByHttp(params, (InMessage)inMessage);
            url = "http://{appIp}:{appPort}/{contextPath}/laserIr/http/ex";
            String inMessagejson = JsonUtil.buildNormalBinder().toJson((Object)inMessage);
            params.put("method", invoke.getApiProperty().getAppapiCode());
            params.put("version", "1.0");
            params.put("charset", "utf-8");
            params.put("inMessage", inMessagejson);
            String appmanageIcode = inMessage.getToAppmanageIcode();
            if (StringUtils.isNotBlank((String)inMessage.getToRAppmanageIcode())) {
                appmanageIcode = inMessage.getToRAppmanageIcode();
            }
            if (ListUtil.isEmpty(st = HttpInvokeService.getPointAppKeys(appmanageIcode, null))) {
                outMessage.setErrorCode("ahttp.adapter.http.HttpInvokeService.st");
                outMessage.setMsg("\u670d\u52a1\u4e3a\u542f\u52a8");
            }
            int len = st.size();
            int i = HttpInvokeService.getRandom(len);
            String appKey = st.get(i);
            url = RegeditUtil.replaceServiceUrl((String)appKey, (String)url);
            String chart = invoke.getApiRouterProperty().getRouterCharset();
            if (StringUtils.isBlank((String)chart)) {
                chart = "utf-8";
            }
            this.logger.info("ahttp.adapter.http.HttpInvokeService." + apicode, (Object)url);
            rsp = OkHttpUtil.httpPostJson(url, params, "application/json;charset=" + chart, invoke.getApiRouterProperty().getRouterCharset(), invoke.getApiRouterProperty().getRouterConnecttimeout(), invoke.getApiRouterProperty().getRouterReadtimeout());
            this.logger.info("ahttp.adapter.http.HttpInvokeService." + apicode + "[" + (System.currentTimeMillis() - s) + "]", (Object)url);
            if (StringUtils.isNotBlank((String)rsp)) {
                OutMessage jrb = (OutMessage)JsonUtil.buildNormalBinder().getJsonToObject(rsp, OutMessage.class);
                return jrb;
            }
            outMessage.setErrorCode("ahttp.adapter.http.HttpInvokeService.null");
            outMessage.setMsg("\u7f51\u7edc\u5f02\u5e38");
        }
        catch (Exception e) {
            this.logger.info("ahttp.adapter.http.HttpInvokeService." + apicode + "[" + (System.currentTimeMillis() - s) + "]", (Object)url);
            this.logger.error("ahttp.adapter.http.HttpInvokeService." + apicode + ".e", (Object)("\u8c03\u7528\u5f02\u5e38,url:" + inMessage.getInvoke().getRouterServiceName() + ",param" + inMessage.getInvoke().getParams()), (Throwable)e);
            outMessage.setErrorCode("ahttp.adapter.http.HttpInvokeService.ex");
            outMessage.setMsg("\u7f51\u7edc\u5f02\u5e38\uff01");
        }
        return outMessage;
    }

    public static int getRandom(int max) {
        int min = 0;
        Random random = new Random();
        int s = random.nextInt(max) % (max - min + 1) + min;
        return s;
    }

    public static void main(String[] args) {
        System.out.println(HttpInvokeService.getRandom(2));
    }

    public static RegeditBean getRegeditBean(String appmanageAppkey) {
        String js = DisUtil.getMap((String)VFOAPPMANAGE_LINEINFO, (String)appmanageAppkey);
        if (StringUtils.isBlank((String)js)) {
            return null;
        }
        RegeditBean regeditBean = (RegeditBean)JsonUtil.buildNormalBinder().getJsonToObject(js, RegeditBean.class);
        return regeditBean;
    }

    public static List<String> getPointAppKeys(String appmanageIcode, String appmanageAppkey) {
        Map appkeyMap = DisUtil.getMapAll((String)APPMANAGE_KEY);
        ArrayList<String> newAppKey = new ArrayList<String>();
        if (null == appkeyMap || appkeyMap.isEmpty()) {
            RegeditBean regeditBean = HttpInvokeService.getRegeditBean(appmanageAppkey);
            if (null != regeditBean && System.currentTimeMillis() <= regeditBean.getLastDate().getTime() + REGEDIT_OVER_TIME) {
                newAppKey.add(appmanageAppkey);
            }
        } else {
            for (String key : appkeyMap.keySet()) {
                RegeditBean regeditBean;
                if (!appmanageIcode.equals(appkeyMap.get(key)) || (regeditBean = HttpInvokeService.getRegeditBean(key)) == null || System.currentTimeMillis() > regeditBean.getLastDate().getTime() + REGEDIT_OVER_TIME) continue;
                newAppKey.add(key);
            }
        }
        if (newAppKey.isEmpty()) {
            newAppKey.add(appmanageAppkey);
        }
        return newAppKey;
    }

    public void securityEncoder(InMessage inMessage) {
    }

    public void securityDecoder(OutMessage outMessage, InMessage inMessage) {
    }

    protected void handleInvokeId(InMessage inMessage, OutMessage outMessage) {
    }

    protected boolean isDispatchAdapter() {
        return true;
    }
}

