/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.http;

import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import okhttp3.Dispatcher;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttpUtil {
    protected static final SupperLogUtil logger = new SupperLogUtil(OkHttpUtil.class);
    public static ExecutorService executorService = new ThreadPoolExecutor(40, 100, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(5000), new ThreadPoolExecutor.CallerRunsPolicy());
    public static OkHttpClient baseClient = new OkHttpClient.Builder().dispatcher(new Dispatcher(executorService)).connectTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).build();
    public static final MediaType FORM_CONTENT_TYPE = MediaType.parse((String)"application/x-www-form-urlencoded; charset=utf-8");
    public static final MediaType JSON_CONTENT_TYPE = MediaType.parse((String)"application/json;charset=UTF-8");

    public static String httpGet(String url, Map<String, String> httpParam, String ctype, String charset, int connectTimeout, int readTimeout) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        if (MapUtil.isNotEmpty(httpParam)) {
            String pstr = "";
            for (String key : httpParam.keySet()) {
                if (StringUtils.isNotBlank((String)pstr)) {
                    pstr = pstr + "&";
                }
                pstr = pstr + key + "=" + httpParam.get(key);
            }
            url = url + "?" + pstr;
        }
        Request request = new Request.Builder().url(url).get().addHeader("Content-Type", ctype).build();
        try {
            OkHttpClient client = baseClient.newBuilder().connectTimeout((long)connectTimeout, TimeUnit.SECONDS).readTimeout((long)readTimeout, TimeUnit.SECONDS).build();
            Response response = client.newCall(request).execute();
            return response.body().string();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String httpPost(String url, Map<String, String> httpParam, String ctype, String charset, int connectTimeout, int readTimeout) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        if (StringUtils.isBlank((String)charset)) {
            charset = "UTF-8";
        }
        StringBuffer sb = new StringBuffer();
        if (MapUtil.isNotEmpty(httpParam)) {
            for (String key : httpParam.keySet()) {
                sb.append(key + "=" + String.valueOf(httpParam.get(key)) + "&");
            }
        }
        RequestBody body = RequestBody.create((MediaType)FORM_CONTENT_TYPE, (String)sb.toString());
        logger.info("============>", (Object)url);
        Request request = new Request.Builder().post(body).addHeader("Content-Type", ctype).url(url).build();
        try {
            OkHttpClient client = baseClient.newBuilder().connectTimeout((long)connectTimeout, TimeUnit.SECONDS).readTimeout((long)readTimeout, TimeUnit.SECONDS).build();
            Response response = client.newCall(request).execute();
            return response.body().string();
        }
        catch (Exception e) {
            logger.info("========ex====>", (Object)url, (Throwable)e);
            return null;
        }
    }

    public static String httpPostJson(String url, Map<String, String> httpParam, String ctype, String charset, int connectTimeout, int readTimeout) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        if (StringUtils.isBlank((String)charset)) {
            charset = "UTF-8";
        }
        StringBuffer sb = new StringBuffer();
        RequestBody body = RequestBody.create((MediaType)JSON_CONTENT_TYPE, (String)JsonUtil.buildNormalBinder().toJson(httpParam));
        Request request = new Request.Builder().post(body).addHeader("Content-Type", ctype).url(url).build();
        try {
            OkHttpClient client = baseClient.newBuilder().connectTimeout((long)connectTimeout, TimeUnit.SECONDS).readTimeout((long)readTimeout, TimeUnit.SECONDS).build();
            Response response = client.newCall(request).execute();
            return response.body().string();
        }
        catch (Exception e) {
            logger.error(".OkHttpUtil.httpPostJson." + url + "." + ".e", (Throwable)e);
            return null;
        }
    }
}

