/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.jd.service.impl;

import com.yqbsoft.laser.service.adapter.jd.JdConstants;
import com.yqbsoft.laser.service.adapter.jd.domain.JdCategorys;
import com.yqbsoft.laser.service.adapter.jd.domain.RsClasstreeDomain;
import com.yqbsoft.laser.service.adapter.jd.model.RsPntree;
import com.yqbsoft.laser.service.adapter.jd.service.JdClasstreeService;
import com.yqbsoft.laser.service.adapter.jd.utils.WebUtils;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JdClasstreeServiceImpl
extends BaseServiceImpl
implements JdClasstreeService {
    public static final String SYS_CODE = "jd.JdClasstreeServiceImpl";
    private static final String CLASSTREE_ADD_API_CODE = "rs.rsClasstree.saveClasstreeList";
    private static final String PNTREE_QUERY_API_CODE = "rs.pntree.queryPntreePage";

    public String getPntreeCode() {
        HashMap<String, String> mapR = new HashMap<String, String>();
        mapR.put("pntreeName", "\u4eac\u4e1c\u9ed8\u8ba4");
        mapR.put("tenantCode", JdConstants.getTenantCode());
        HashMap<String, String> mapP = new HashMap<String, String>();
        mapP.put("map", JsonUtil.buildNormalBinder().toJson(mapR));
        String pntreeStr = (String)this.getInternalRouter().inInvoke(PNTREE_QUERY_API_CODE, mapP);
        List pntreeList = null;
        try {
            SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(pntreeStr, SupQueryResult.class);
            if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
                return null;
            }
            pntreeList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), RsPntree.class);
        }
        catch (Exception e) {
            this.logger.error("jd.JdClasstreeServiceImplgetPntreeCode", (Throwable)e);
        }
        if (ListUtil.isEmpty(pntreeList)) {
            return null;
        }
        return ((RsPntree)pntreeList.get(0)).getPntreeCode();
    }

    @Override
    public void importClasstree() throws Exception {
        String pntreeCode = this.getPntreeCode();
        String url = "https://bizapi.jd.com/api/product/getCategorys";
        int pageSize = 500;
        int pageNo = 0;
        for (int i = 0; i >= 0 && i <= pageNo; ++i) {
            List categorysList;
            String s;
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("token", JdConstants.getToken());
            paramMap.put("pageSize", String.valueOf(pageSize));
            paramMap.put("pageNo", String.valueOf(i + 1));
            String json = null;
            try {
                json = WebUtils.doPost(url, paramMap, 10000, 10000, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
            if (null == map || StringUtils.isBlank((String)(s = JsonUtil.buildNormalBinder().toJson(map.get("result"))))) break;
            Map mm = (Map)JsonUtil.buildNormalBinder().getJsonToMap(s, String.class, Object.class);
            int totalRows = (Integer)mm.get("totalRows");
            String classtreeStr = JsonUtil.buildNormalBinder().toJson(mm.get("categorys"));
            if (pageNo == 0 && (pageNo = (totalRows + pageSize - 1) / pageSize) <= 0 || StringUtils.isBlank((String)classtreeStr) || ListUtil.isEmpty((Collection)(categorysList = (List)JsonUtil.buildNormalBinder().getJsonToList(classtreeStr, JdCategorys.class)))) break;
            ArrayList<RsClasstreeDomain> rsClasstreeDomainList = new ArrayList<RsClasstreeDomain>();
            for (JdCategorys categorys : categorysList) {
                RsClasstreeDomain rsClasstreeDomain = new RsClasstreeDomain();
                rsClasstreeDomain.setClasstreeCode(categorys.getCatId());
                rsClasstreeDomain.setClasstreeName(categorys.getName());
                rsClasstreeDomain.setClasstreeParentcode("-1");
                if (!categorys.getParentId().equals("0")) {
                    rsClasstreeDomain.setClasstreeParentcode(categorys.getParentId());
                }
                rsClasstreeDomain.setClasstreeLast("1");
                if (categorys.getCatClass().equals("2")) {
                    rsClasstreeDomain.setClasstreeLast("0");
                    rsClasstreeDomain.setPntreeCode(pntreeCode);
                }
                rsClasstreeDomain.setClasstreeType("5");
                rsClasstreeDomain.setTenantCode(JdConstants.getTenantCode());
                rsClasstreeDomainList.add(rsClasstreeDomain);
            }
            HashMap<String, String> mapR = new HashMap<String, String>();
            mapR.put("rsClasstreeDomains", JsonUtil.buildNormalBinder().toJson(rsClasstreeDomainList));
            this.getInternalRouter().inInvoke(CLASSTREE_ADD_API_CODE, mapR);
        }
    }
}

