/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.kdniao;

import com.yqbsoft.laser.service.esb.core.auth.AuthUtil;
import com.yqbsoft.laser.service.esb.core.core.EsbReBean;
import com.yqbsoft.laser.service.esb.core.router.ProxyInvokeSupport;
import com.yqbsoft.laser.service.esb.core.transformer.InvokeIdParser;
import com.yqbsoft.laser.service.suppercore.core.InMessage;
import com.yqbsoft.laser.service.suppercore.core.Invoke;
import com.yqbsoft.laser.service.suppercore.core.OutMessage;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;

public class KdniaoInvokeService
extends ProxyInvokeSupport {
    private static final String sys_code = "http.adapter.kdniao.KdniaoInvoke";
    private static char[] base64EncodeChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public OutMessage channelSendMsg(InMessage inMessage) {
        if (null == inMessage) {
            return new OutMessage("http.adapter.kdniao.KdniaoInvoke.empty", "\u4fe1\u606f\u4e3a\u7a7a");
        }
        OutMessage outMessage = new OutMessage();
        try {
            String rsp = null;
            Invoke invoke = inMessage.getInvoke();
            Map params = invoke.getParams();
            InvokeIdParser.addInInvokeIdParamByHttp((Map)params, (InMessage)inMessage);
            String expCode = (String)params.get("expCode");
            String expNo = (String)params.get("expNo");
            String EBusinessID = (String)params.get("EBusinessID");
            String AppKey = (String)params.get("AppKey");
            String ReqURL = invoke.getRouterServiceName();
            rsp = this.getOrderTracesByJson(expCode, expNo, EBusinessID, AppKey, ReqURL);
            this.logger.debug(sys_code, (Object)("http rsp:" + rsp));
            outMessage.setReObj((Object)rsp);
        }
        catch (Exception e) {
            this.logger.error(sys_code, (Object)("\u8c03\u7528\u5f02\u5e38,url:" + inMessage.getInvoke().getRouterServiceName() + ",param" + inMessage.getInvoke().getParams()), (Throwable)e);
            outMessage.setErrorCode("http.adapter.kdniao.KdniaoInvoke.ex");
            outMessage.setMsg("\u8c03\u7528\u5f02\u5e38");
        }
        return outMessage;
    }

    public String getOrderTracesByJson(String expCode, String expNo, String EBusinessID, String AppKey, String ReqURL) throws Exception {
        String requestData = "{'OrderCode':'','ShipperCode':'" + expCode + "','LogisticCode':'" + expNo + "'}";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("RequestData", this.urlEncoder(requestData, "UTF-8"));
        params.put("EBusinessID", EBusinessID);
        params.put("RequestType", "1002");
        String dataSign = this.encrypt(requestData, AppKey, "UTF-8");
        params.put("DataSign", this.urlEncoder(dataSign, "UTF-8"));
        params.put("DataType", "2");
        String result = this.sendPost(ReqURL, params);
        return result;
    }

    private String MD5(String str, String charset) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(str.getBytes(charset));
        byte[] result = md.digest();
        StringBuffer sb = new StringBuffer(32);
        for (int i = 0; i < result.length; ++i) {
            int val = result[i] & 0xFF;
            if (val <= 15) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(val));
        }
        return sb.toString().toLowerCase();
    }

    private String base64(String str, String charset) throws UnsupportedEncodingException {
        String encoded = KdniaoInvokeService.base64Encode(str.getBytes(charset));
        return encoded;
    }

    private String urlEncoder(String str, String charset) throws UnsupportedEncodingException {
        String result = URLEncoder.encode(str, charset);
        return result;
    }

    private String encrypt(String content, String keyValue, String charset) throws UnsupportedEncodingException, Exception {
        if (keyValue != null) {
            return this.base64(this.MD5(content + keyValue, charset), charset);
        }
        return this.base64(this.MD5(content, charset), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendPost(String url, Map<String, String> params) {
        OutputStreamWriter out = null;
        BufferedReader in = null;
        StringBuilder result = new StringBuilder();
        try {
            String line;
            URL realUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)realUrl.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.connect();
            out = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
            if (params != null) {
                StringBuilder param = new StringBuilder();
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    if (param.length() > 0) {
                        param.append("&");
                    }
                    param.append(entry.getKey());
                    param.append("=");
                    param.append(entry.getValue());
                }
                out.write(param.toString());
            }
            out.flush();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return result.toString();
    }

    public static String base64Encode(byte[] data) {
        StringBuffer sb = new StringBuffer();
        int len = data.length;
        int i = 0;
        while (i < len) {
            int b1 = data[i++] & 0xFF;
            if (i == len) {
                sb.append(base64EncodeChars[b1 >>> 2]);
                sb.append(base64EncodeChars[(b1 & 3) << 4]);
                sb.append("==");
                break;
            }
            int b2 = data[i++] & 0xFF;
            if (i == len) {
                sb.append(base64EncodeChars[b1 >>> 2]);
                sb.append(base64EncodeChars[(b1 & 3) << 4 | (b2 & 0xF0) >>> 4]);
                sb.append(base64EncodeChars[(b2 & 0xF) << 2]);
                sb.append("=");
                break;
            }
            int b3 = data[i++] & 0xFF;
            sb.append(base64EncodeChars[b1 >>> 2]);
            sb.append(base64EncodeChars[(b1 & 3) << 4 | (b2 & 0xF0) >>> 4]);
            sb.append(base64EncodeChars[(b2 & 0xF) << 2 | (b3 & 0xC0) >>> 6]);
            sb.append(base64EncodeChars[b3 & 0x3F]);
        }
        return sb.toString();
    }

    public void securityEncoder(InMessage inMessage) {
        Map params = inMessage.getInvoke().getParams();
        if (MapUtil.isEmpty((Map)params)) {
            return;
        }
        String plainText = AuthUtil.getSignCheckContentV1((Map)params);
        String sign = AuthUtil.sendAuth((InMessage)inMessage, (String)plainText);
        inMessage.getInvoke().setSign(sign);
    }

    public void securityDecoder(OutMessage outMessage, InMessage inMessage) {
        if (outMessage == null || inMessage == null) {
            return;
        }
    }

    protected void handleInvokeId(InMessage inMessage, OutMessage outMessage) {
        EsbReBean jrb;
        String objectJson;
        Object reObject = outMessage.getReObj();
        if (reObject != null && StringUtils.isMapJson((String)(objectJson = reObject.toString())) && null != (jrb = (EsbReBean)JsonUtil.buildNormalBinder().getJsonToObject(objectJson, EsbReBean.class, new Class[]{String.class})) && null != jrb.getInvokeId()) {
            int level = jrb.getInvokeId().getMsgLevel();
            inMessage.getInvokeId().setMsgLevel(level);
        }
        super.handleInvokeId(inMessage, outMessage);
    }
}

