/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.mid.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.mid.dao.MidContractGoodsMapper;
import com.yqbsoft.laser.service.mid.dao.MidContractMapper;
import com.yqbsoft.laser.service.mid.dao.MidContractPmgoodsMapper;
import com.yqbsoft.laser.service.mid.domain.MidContractDomain;
import com.yqbsoft.laser.service.mid.domain.MidContractGoodsDomain;
import com.yqbsoft.laser.service.mid.domain.MidContractGoodsReDomain;
import com.yqbsoft.laser.service.mid.domain.MidContractPmgoodsDomain;
import com.yqbsoft.laser.service.mid.domain.MidContractPmgoodsReDomain;
import com.yqbsoft.laser.service.mid.domain.MidContractReDomain;
import com.yqbsoft.laser.service.mid.model.MidContract;
import com.yqbsoft.laser.service.mid.model.MidContractGoods;
import com.yqbsoft.laser.service.mid.model.MidContractPmgoods;
import com.yqbsoft.laser.service.mid.service.MidContractService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MidContractServiceImpl
extends BaseServiceImpl
implements MidContractService {
    private static final String SYS_CODE = "mid.MidContractServiceImpl";
    private MidContractMapper midContractMapper;
    private MidContractGoodsMapper midContractGoodsMapper;
    private MidContractPmgoodsMapper midContractPmgoodsMapper;

    public void setMidContractMapper(MidContractMapper midContractMapper) {
        this.midContractMapper = midContractMapper;
    }

    public void setMidContractGoodsMapper(MidContractGoodsMapper midContractGoodsMapper) {
        this.midContractGoodsMapper = midContractGoodsMapper;
    }

    public void setMidContractPmgoodsMapper(MidContractPmgoodsMapper midContractPmgoodsMapper) {
        this.midContractPmgoodsMapper = midContractPmgoodsMapper;
    }

    private Date getSysDate() {
        try {
            return this.midContractMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mid.MidContractServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkContract(MidContractDomain midContractDomain) {
        if (null == midContractDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)midContractDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setContractDefault(MidContract midContract) {
        if (null == midContract) {
            return;
        }
        if (null == midContract.getDataState()) {
            midContract.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == midContract.getGmtCreate()) {
            midContract.setGmtCreate(date);
        }
        midContract.setGmtModified(date);
        if (StringUtils.isBlank((String)midContract.getContractBillcode())) {
            midContract.setContractBillcode(this.getNo(null, "MidContract", "midContract", midContract.getTenantCode()));
        }
    }

    private int getContractMaxCode() {
        int code = 0;
        try {
            return this.midContractMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mid.MidContractServiceImpl.getContractMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setContractUpdataDefault(MidContract midContract) {
        if (null == midContract) {
            return;
        }
        midContract.setGmtModified(this.getSysDate());
    }

    private void saveContractModel(MidContract midContract) throws ApiException {
        if (null == midContract) {
            return;
        }
        try {
            this.midContractMapper.insert(midContract);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidContractServiceImpl.saveContractModel.ex", (Throwable)e);
        }
    }

    private void saveContractBatchModel(List<MidContract> midContractList) throws ApiException {
        if (null == midContractList || midContractList.isEmpty()) {
            return;
        }
        try {
            this.midContractMapper.insertBatch(midContractList);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidContractServiceImpl.saveContractBatchModel.ex", (Throwable)e);
        }
    }

    private MidContract getContractModelById(Integer contractId) {
        if (null == contractId) {
            return null;
        }
        try {
            return this.midContractMapper.selectByPrimaryKey(contractId);
        }
        catch (Exception e) {
            this.logger.error("mid.MidContractServiceImpl.getContractModelById", (Throwable)e);
            return null;
        }
    }

    private MidContract getContractModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.midContractMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("mid.MidContractServiceImpl.getContractModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delContractModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.midContractMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidContractServiceImpl.delContractModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidContractServiceImpl.delContractModelByCode.num");
        }
    }

    private void deleteContractModel(Integer contractId) throws ApiException {
        if (null == contractId) {
            return;
        }
        int i = 0;
        try {
            i = this.midContractMapper.deleteByPrimaryKey(contractId);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidContractServiceImpl.deleteContractModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidContractServiceImpl.deleteContractModel.num");
        }
    }

    private void updateContractModel(MidContract midContract) throws ApiException {
        if (null == midContract) {
            return;
        }
        int i = 0;
        try {
            i = this.midContractMapper.updateByPrimaryKey(midContract);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidContractServiceImpl.updateContractModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidContractServiceImpl.updateContractModel.num");
        }
    }

    private void updateStateContractModel(Integer contractId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == contractId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractId", contractId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.midContractMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidContractServiceImpl.updateStateContractModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mid.MidContractServiceImpl.updateStateContractModel.null");
        }
    }

    private void updateStateContractModelByCode(String tenantCode, String contractBillcode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)contractBillcode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractBillcode", contractBillcode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.midContractMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidContractServiceImpl.updateStateContractModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mid.MidContractServiceImpl.updateStateContractModelByCode.null");
        }
    }

    private MidContract makeContract(MidContractDomain midContractDomain, MidContract midContract) {
        if (null == midContractDomain) {
            return null;
        }
        if (null == midContract) {
            midContract = new MidContract();
        }
        try {
            BeanUtils.copyAllPropertys((Object)midContract, (Object)midContractDomain);
            return midContract;
        }
        catch (Exception e) {
            this.logger.error("mid.MidContractServiceImpl.makeContract", (Throwable)e);
            return null;
        }
    }

    private MidContractReDomain makeMidContractReDomain(MidContract midContract) {
        if (null == midContract) {
            return null;
        }
        MidContractReDomain midContractReDomain = new MidContractReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)midContractReDomain, (Object)midContract);
            return midContractReDomain;
        }
        catch (Exception e) {
            this.logger.error("mid.MidContractServiceImpl.makeMidContractReDomain", (Throwable)e);
            return null;
        }
    }

    private List<MidContract> queryContractModelPage(Map<String, Object> parammap) {
        try {
            return this.midContractMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mid.MidContractServiceImpl.queryContractModel", (Throwable)e);
            return null;
        }
    }

    private int countContract(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.midContractMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mid.MidContractServiceImpl.countContract", (Throwable)e);
        }
        return i;
    }

    private MidContract createMidContract(MidContractDomain midContractDomain) {
        String msg = this.checkContract(midContractDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mid.MidContractServiceImpl.saveContract.checkContract", msg);
        }
        MidContract midContract = this.makeContract(midContractDomain, null);
        this.setContractDefault(midContract);
        return midContract;
    }

    private String checkContractGoods(MidContractGoodsDomain midContractGoodsDomain) {
        if (null == midContractGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)midContractGoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setContractGoodsDefault(MidContractGoods midContractGoods) {
        if (null == midContractGoods) {
            return;
        }
        if (null == midContractGoods.getDataState()) {
            midContractGoods.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == midContractGoods.getGmtCreate()) {
            midContractGoods.setGmtCreate(date);
        }
        midContractGoods.setGmtModified(date);
        if (StringUtils.isBlank((String)midContractGoods.getContractGoodsCode())) {
            midContractGoods.setContractGoodsCode(this.getNo(null, "MidContractGoods", "midContractGoods", midContractGoods.getTenantCode()));
        }
    }

    private int getContractGoodsMaxCode() {
        int code = 0;
        try {
            return this.midContractGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mid.MidContractServiceImpl.getContractGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setContractGoodsUpdataDefault(MidContractGoods midContractGoods) {
        if (null == midContractGoods) {
            return;
        }
        midContractGoods.setGmtModified(this.getSysDate());
    }

    private void saveContractGoodsModel(MidContractGoods midContractGoods) throws ApiException {
        if (null == midContractGoods) {
            return;
        }
        try {
            this.midContractGoodsMapper.insert(midContractGoods);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidContractServiceImpl.saveContractGoodsModel.ex", (Throwable)e);
        }
    }

    private void saveContractGoodsBatchModel(List<MidContractGoods> midContractGoodsList) throws ApiException {
        if (null == midContractGoodsList || midContractGoodsList.isEmpty()) {
            return;
        }
        try {
            this.midContractGoodsMapper.insertBatch(midContractGoodsList);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidContractServiceImpl.saveContractGoodsBatchModel.ex", (Throwable)e);
        }
    }

    private MidContractGoods getContractGoodsModelById(Integer contractGoodsId) {
        if (null == contractGoodsId) {
            return null;
        }
        try {
            return this.midContractGoodsMapper.selectByPrimaryKey(contractGoodsId);
        }
        catch (Exception e) {
            this.logger.error("mid.MidContractServiceImpl.getContractGoodsModelById", (Throwable)e);
            return null;
        }
    }

    private MidContractGoods getContractGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.midContractGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("mid.MidContractServiceImpl.getContractGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delContractGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.midContractGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidContractServiceImpl.delContractGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidContractServiceImpl.delContractGoodsModelByCode.num");
        }
    }

    private void deleteContractGoodsModel(Integer contractGoodsId) throws ApiException {
        if (null == contractGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.midContractGoodsMapper.deleteByPrimaryKey(contractGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidContractServiceImpl.deleteContractGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidContractServiceImpl.deleteContractGoodsModel.num");
        }
    }

    private void updateContractGoodsModel(MidContractGoods midContractGoods) throws ApiException {
        if (null == midContractGoods) {
            return;
        }
        int i = 0;
        try {
            i = this.midContractGoodsMapper.updateByPrimaryKey(midContractGoods);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidContractServiceImpl.updateContractGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidContractServiceImpl.updateContractGoodsModel.num");
        }
    }

    private void updateStateContractGoodsModel(Integer contractGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == contractGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractGoodsId", contractGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.midContractGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidContractServiceImpl.updateStateContractGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mid.MidContractServiceImpl.updateStateContractGoodsModel.null");
        }
    }

    private void updateStateContractGoodsModelByCode(String tenantCode, String contractGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)contractGoodsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractGoodsCode", contractGoodsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.midContractGoodsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidContractServiceImpl.updateStateContractGoodsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mid.MidContractServiceImpl.updateStateContractGoodsModelByCode.null");
        }
    }

    private MidContractGoods makeContractGoods(MidContractGoodsDomain midContractGoodsDomain, MidContractGoods midContractGoods) {
        if (null == midContractGoodsDomain) {
            return null;
        }
        if (null == midContractGoods) {
            midContractGoods = new MidContractGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)midContractGoods, (Object)midContractGoodsDomain);
            return midContractGoods;
        }
        catch (Exception e) {
            this.logger.error("mid.MidContractServiceImpl.makeContractGoods", (Throwable)e);
            return null;
        }
    }

    private MidContractGoodsReDomain makeMidContractGoodsReDomain(MidContractGoods midContractGoods) {
        if (null == midContractGoods) {
            return null;
        }
        MidContractGoodsReDomain midContractGoodsReDomain = new MidContractGoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)midContractGoodsReDomain, (Object)midContractGoods);
            return midContractGoodsReDomain;
        }
        catch (Exception e) {
            this.logger.error("mid.MidContractServiceImpl.makeMidContractGoodsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<MidContractGoods> queryContractGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.midContractGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mid.MidContractServiceImpl.queryContractGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countContractGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.midContractGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mid.MidContractServiceImpl.countContractGoods", (Throwable)e);
        }
        return i;
    }

    private MidContractGoods createMidContractGoods(MidContractGoodsDomain midContractGoodsDomain) {
        String msg = this.checkContractGoods(midContractGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mid.MidContractServiceImpl.saveContractGoods.checkContractGoods", msg);
        }
        MidContractGoods midContractGoods = this.makeContractGoods(midContractGoodsDomain, null);
        this.setContractGoodsDefault(midContractGoods);
        return midContractGoods;
    }

    private String checkContractPmgoods(MidContractPmgoodsDomain midContractPmgoodsDomain) {
        if (null == midContractPmgoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)midContractPmgoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setContractPmgoodsDefault(MidContractPmgoods midContractPmgoods) {
        if (null == midContractPmgoods) {
            return;
        }
        if (null == midContractPmgoods.getDataState()) {
            midContractPmgoods.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == midContractPmgoods.getGmtCreate()) {
            midContractPmgoods.setGmtCreate(date);
        }
        midContractPmgoods.setGmtModified(date);
        if (StringUtils.isBlank((String)midContractPmgoods.getContractPmgoodsBillcode())) {
            midContractPmgoods.setContractPmgoodsBillcode(this.getNo(null, "MidContractPmgoods", "midContractPmgoods", midContractPmgoods.getTenantCode()));
        }
    }

    private int getContractPmgoodsMaxCode() {
        int code = 0;
        try {
            return this.midContractPmgoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mid.MidContractServiceImpl.getContractPmgoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setContractPmgoodsUpdataDefault(MidContractPmgoods midContractPmgoods) {
        if (null == midContractPmgoods) {
            return;
        }
        midContractPmgoods.setGmtModified(this.getSysDate());
    }

    private void saveContractPmgoodsModel(MidContractPmgoods midContractPmgoods) throws ApiException {
        if (null == midContractPmgoods) {
            return;
        }
        try {
            this.midContractPmgoodsMapper.insert(midContractPmgoods);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidContractServiceImpl.saveContractPmgoodsModel.ex", (Throwable)e);
        }
    }

    private void saveContractPmgoodsBatchModel(List<MidContractPmgoods> midContractPmgoodsList) throws ApiException {
        if (null == midContractPmgoodsList || midContractPmgoodsList.isEmpty()) {
            return;
        }
        try {
            this.midContractPmgoodsMapper.insertBatch(midContractPmgoodsList);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidContractServiceImpl.saveContractPmgoodsBatchModel.ex", (Throwable)e);
        }
    }

    private MidContractPmgoods getContractPmgoodsModelById(Integer contractPmgoodsId) {
        if (null == contractPmgoodsId) {
            return null;
        }
        try {
            return this.midContractPmgoodsMapper.selectByPrimaryKey(contractPmgoodsId);
        }
        catch (Exception e) {
            this.logger.error("mid.MidContractServiceImpl.getContractPmgoodsModelById", (Throwable)e);
            return null;
        }
    }

    private MidContractPmgoods getContractPmgoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.midContractPmgoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("mid.MidContractServiceImpl.getContractPmgoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delContractPmgoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.midContractPmgoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidContractServiceImpl.delContractPmgoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidContractServiceImpl.delContractPmgoodsModelByCode.num");
        }
    }

    private void deleteContractPmgoodsModel(Integer contractPmgoodsId) throws ApiException {
        if (null == contractPmgoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.midContractPmgoodsMapper.deleteByPrimaryKey(contractPmgoodsId);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidContractServiceImpl.deleteContractPmgoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidContractServiceImpl.deleteContractPmgoodsModel.num");
        }
    }

    private void updateContractPmgoodsModel(MidContractPmgoods midContractPmgoods) throws ApiException {
        if (null == midContractPmgoods) {
            return;
        }
        int i = 0;
        try {
            i = this.midContractPmgoodsMapper.updateByPrimaryKey(midContractPmgoods);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidContractServiceImpl.updateContractPmgoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidContractServiceImpl.updateContractPmgoodsModel.num");
        }
    }

    private void updateStateContractPmgoodsModel(Integer contractPmgoodsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == contractPmgoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractPmgoodsId", contractPmgoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.midContractPmgoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidContractServiceImpl.updateStateContractPmgoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mid.MidContractServiceImpl.updateStateContractPmgoodsModel.null");
        }
    }

    private void updateStateContractPmgoodsModelByCode(String tenantCode, String contractPmgoodsBillcode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)contractPmgoodsBillcode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractPmgoodsBillcode", contractPmgoodsBillcode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.midContractPmgoodsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidContractServiceImpl.updateStateContractPmgoodsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mid.MidContractServiceImpl.updateStateContractPmgoodsModelByCode.null");
        }
    }

    private MidContractPmgoods makeContractPmgoods(MidContractPmgoodsDomain midContractPmgoodsDomain, MidContractPmgoods midContractPmgoods) {
        if (null == midContractPmgoodsDomain) {
            return null;
        }
        if (null == midContractPmgoods) {
            midContractPmgoods = new MidContractPmgoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)midContractPmgoods, (Object)midContractPmgoodsDomain);
            return midContractPmgoods;
        }
        catch (Exception e) {
            this.logger.error("mid.MidContractServiceImpl.makeContractPmgoods", (Throwable)e);
            return null;
        }
    }

    private MidContractPmgoodsReDomain makeMidContractPmgoodsReDomain(MidContractPmgoods midContractPmgoods) {
        if (null == midContractPmgoods) {
            return null;
        }
        MidContractPmgoodsReDomain midContractPmgoodsReDomain = new MidContractPmgoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)midContractPmgoodsReDomain, (Object)midContractPmgoods);
            return midContractPmgoodsReDomain;
        }
        catch (Exception e) {
            this.logger.error("mid.MidContractServiceImpl.makeMidContractPmgoodsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<MidContractPmgoods> queryContractPmgoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.midContractPmgoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mid.MidContractServiceImpl.queryContractPmgoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countContractPmgoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.midContractPmgoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mid.MidContractServiceImpl.countContractPmgoods", (Throwable)e);
        }
        return i;
    }

    private MidContractPmgoods createMidContractPmgoods(MidContractPmgoodsDomain midContractPmgoodsDomain) {
        String msg = this.checkContractPmgoods(midContractPmgoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mid.MidContractServiceImpl.saveContractPmgoods.checkContractPmgoods", msg);
        }
        MidContractPmgoods midContractPmgoods = this.makeContractPmgoods(midContractPmgoodsDomain, null);
        this.setContractPmgoodsDefault(midContractPmgoods);
        return midContractPmgoods;
    }

    @Override
    public String saveContract(MidContractDomain midContractDomain) throws ApiException {
        MidContract midContract = this.createMidContract(midContractDomain);
        this.saveContractModel(midContract);
        this.saveContractGoodsList(midContractDomain.getGoodsList(), midContract, midContractDomain.getMidContractPmgoodsDomainList());
        return midContract.getContractBillcode();
    }

    private void saveContractGoodsList(List<MidContractGoodsDomain> midContractGoodsDomainList, MidContract midContract, List<MidContractPmgoodsDomain> midContractPmgoodsDomainList) {
        if (midContractGoodsDomainList == null || midContractGoodsDomainList.isEmpty() || null == midContract) {
            return;
        }
        ArrayList<MidContractGoods> ocContractGoodsList = new ArrayList<MidContractGoods>();
        ArrayList<MidContractPmgoodsDomain> ocContractPmGoodsDomainList = new ArrayList<MidContractPmgoodsDomain>();
        for (MidContractGoodsDomain ocContractGoodsDomain : midContractGoodsDomainList) {
            ocContractGoodsDomain.setContractBillcode(midContract.getContractBillcode());
            ocContractGoodsDomain.setTenantCode(midContract.getTenantCode());
            MidContractGoods ocContractGoods = this.createMidContractGoods(ocContractGoodsDomain);
            ocContractGoodsList.add(ocContractGoods);
        }
        this.saveContractGoodsBatchModel(ocContractGoodsList);
        this.saveContractPmgoodsBatch(ocContractPmGoodsDomainList);
    }

    @Override
    public String saveContractBatch(List<MidContractDomain> midContractDomainList) throws ApiException {
        if (null == midContractDomainList || midContractDomainList.isEmpty()) {
            return null;
        }
        ArrayList<MidContract> midContractList = new ArrayList<MidContract>();
        String code = "";
        for (MidContractDomain midContractDomain : midContractDomainList) {
            MidContract midContract = this.createMidContract(midContractDomain);
            code = midContract.getContractBillcode();
            midContractList.add(midContract);
        }
        this.saveContractBatchModel(midContractList);
        return code;
    }

    @Override
    public void updateContractState(Integer contractId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == contractId) {
            return;
        }
        this.updateStateContractModel(contractId, dataState, oldDataState, map);
    }

    @Override
    public void updateContractStateByCode(String tenantCode, String contractBillcode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateContractModelByCode(tenantCode, contractBillcode, dataState, oldDataState, map);
    }

    @Override
    public void updateContract(MidContractDomain midContractDomain) throws ApiException {
        String msg = this.checkContract(midContractDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mid.MidContractServiceImpl.updateContract.checkContract", msg);
        }
        MidContract oldMidContract = this.getContractModelById(midContractDomain.getContractId());
        if (null == oldMidContract) {
            throw new ApiException("mid.MidContractServiceImpl.updateContract.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MidContract midContract = this.makeContract(midContractDomain, oldMidContract);
        this.setContractUpdataDefault(midContract);
        this.updateContractModel(midContract);
    }

    @Override
    public MidContract getContract(Integer contractId) {
        if (null == contractId) {
            return null;
        }
        return this.getContractModelById(contractId);
    }

    @Override
    public void deleteContract(Integer contractId) throws ApiException {
        if (null == contractId) {
            return;
        }
        this.deleteContractModel(contractId);
    }

    @Override
    public QueryResult<MidContract> queryContractPage(Map<String, Object> map) {
        List<MidContract> midContractList = this.queryContractModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countContract(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(midContractList);
        return queryResult;
    }

    @Override
    public MidContract getContractByCode(String tenantCode, String contractBillcode) throws ApiException {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractBillcode", contractBillcode);
        return this.getContractModelByCode(map);
    }

    @Override
    public void deleteContractByCode(String tenantCode, String contractBillcode) throws ApiException {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractBillcode", contractBillcode);
        this.delContractModelByCode(map);
    }

    @Override
    public String saveContractGoods(MidContractGoodsDomain midContractGoodsDomain) throws ApiException {
        MidContractGoods midContractGoods = this.createMidContractGoods(midContractGoodsDomain);
        this.saveContractGoodsModel(midContractGoods);
        return midContractGoods.getContractGoodsCode();
    }

    @Override
    public String saveContractGoodsBatch(List<MidContractGoodsDomain> midContractGoodsDomainList) throws ApiException {
        if (null == midContractGoodsDomainList || midContractGoodsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<MidContractGoods> midContractGoodsList = new ArrayList<MidContractGoods>();
        String code = "";
        for (MidContractGoodsDomain midContractGoodsDomain : midContractGoodsDomainList) {
            MidContractGoods midContractGoods = this.createMidContractGoods(midContractGoodsDomain);
            code = midContractGoods.getContractGoodsCode();
            midContractGoodsList.add(midContractGoods);
        }
        this.saveContractGoodsBatchModel(midContractGoodsList);
        return code;
    }

    @Override
    public void updateContractGoodsState(Integer contractGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == contractGoodsId) {
            return;
        }
        this.updateStateContractGoodsModel(contractGoodsId, dataState, oldDataState, map);
    }

    @Override
    public void updateContractGoodsStateByCode(String tenantCode, String contractGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)contractGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateContractGoodsModelByCode(tenantCode, contractGoodsCode, dataState, oldDataState, map);
    }

    @Override
    public void updateContractGoods(MidContractGoodsDomain midContractGoodsDomain) throws ApiException {
        String msg = this.checkContractGoods(midContractGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mid.MidContractServiceImpl.updateContractGoods.checkContractGoods", msg);
        }
        MidContractGoods oldMidContractGoods = this.getContractGoodsModelById(midContractGoodsDomain.getContractGoodsId());
        if (null == oldMidContractGoods) {
            throw new ApiException("mid.MidContractServiceImpl.updateContractGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MidContractGoods midContractGoods = this.makeContractGoods(midContractGoodsDomain, oldMidContractGoods);
        this.setContractGoodsUpdataDefault(midContractGoods);
        this.updateContractGoodsModel(midContractGoods);
    }

    @Override
    public MidContractGoods getContractGoods(Integer contractGoodsId) {
        if (null == contractGoodsId) {
            return null;
        }
        return this.getContractGoodsModelById(contractGoodsId);
    }

    @Override
    public void deleteContractGoods(Integer contractGoodsId) throws ApiException {
        if (null == contractGoodsId) {
            return;
        }
        this.deleteContractGoodsModel(contractGoodsId);
    }

    @Override
    public QueryResult<MidContractGoods> queryContractGoodsPage(Map<String, Object> map) {
        List<MidContractGoods> midContractGoodsList = this.queryContractGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countContractGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(midContractGoodsList);
        return queryResult;
    }

    @Override
    public MidContractGoods getContractGoodsByCode(String tenantCode, String contractGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)contractGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractGoodsCode", contractGoodsCode);
        return this.getContractGoodsModelByCode(map);
    }

    @Override
    public void deleteContractGoodsByCode(String tenantCode, String contractGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)contractGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractGoodsCode", contractGoodsCode);
        this.delContractGoodsModelByCode(map);
    }

    @Override
    public String saveContractPmgoods(MidContractPmgoodsDomain midContractPmgoodsDomain) throws ApiException {
        MidContractPmgoods midContractPmgoods = this.createMidContractPmgoods(midContractPmgoodsDomain);
        this.saveContractPmgoodsModel(midContractPmgoods);
        return midContractPmgoods.getContractPmgoodsBillcode();
    }

    @Override
    public String saveContractPmgoodsBatch(List<MidContractPmgoodsDomain> midContractPmgoodsDomainList) throws ApiException {
        if (null == midContractPmgoodsDomainList || midContractPmgoodsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<MidContractPmgoods> midContractPmgoodsList = new ArrayList<MidContractPmgoods>();
        String code = "";
        for (MidContractPmgoodsDomain midContractPmgoodsDomain : midContractPmgoodsDomainList) {
            MidContractPmgoods midContractPmgoods = this.createMidContractPmgoods(midContractPmgoodsDomain);
            code = midContractPmgoods.getContractPmgoodsBillcode();
            midContractPmgoodsList.add(midContractPmgoods);
        }
        this.saveContractPmgoodsBatchModel(midContractPmgoodsList);
        return code;
    }

    @Override
    public void updateContractPmgoodsState(Integer contractPmgoodsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == contractPmgoodsId) {
            return;
        }
        this.updateStateContractPmgoodsModel(contractPmgoodsId, dataState, oldDataState, map);
    }

    @Override
    public void updateContractPmgoodsStateByCode(String tenantCode, String contractPmgoodsBillcode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)contractPmgoodsBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateContractPmgoodsModelByCode(tenantCode, contractPmgoodsBillcode, dataState, oldDataState, map);
    }

    @Override
    public void updateContractPmgoods(MidContractPmgoodsDomain midContractPmgoodsDomain) throws ApiException {
        String msg = this.checkContractPmgoods(midContractPmgoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mid.MidContractServiceImpl.updateContractPmgoods.checkContractPmgoods", msg);
        }
        MidContractPmgoods oldMidContractPmgoods = this.getContractPmgoodsModelById(midContractPmgoodsDomain.getContractPmgoodsId());
        if (null == oldMidContractPmgoods) {
            throw new ApiException("mid.MidContractServiceImpl.updateContractPmgoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MidContractPmgoods midContractPmgoods = this.makeContractPmgoods(midContractPmgoodsDomain, oldMidContractPmgoods);
        this.setContractPmgoodsUpdataDefault(midContractPmgoods);
        this.updateContractPmgoodsModel(midContractPmgoods);
    }

    @Override
    public MidContractPmgoods getContractPmgoods(Integer contractPmgoodsId) {
        if (null == contractPmgoodsId) {
            return null;
        }
        return this.getContractPmgoodsModelById(contractPmgoodsId);
    }

    @Override
    public void deleteContractPmgoods(Integer contractPmgoodsId) throws ApiException {
        if (null == contractPmgoodsId) {
            return;
        }
        this.deleteContractPmgoodsModel(contractPmgoodsId);
    }

    @Override
    public QueryResult<MidContractPmgoods> queryContractPmgoodsPage(Map<String, Object> map) {
        List<MidContractPmgoods> midContractPmgoodsList = this.queryContractPmgoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countContractPmgoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(midContractPmgoodsList);
        return queryResult;
    }

    @Override
    public MidContractPmgoods getContractPmgoodsByCode(String tenantCode, String contractPmgoodsBillcode) throws ApiException {
        if (StringUtils.isBlank((String)contractPmgoodsBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractPmgoodsBillcode", contractPmgoodsBillcode);
        return this.getContractPmgoodsModelByCode(map);
    }

    @Override
    public void deleteContractPmgoodsByCode(String tenantCode, String contractPmgoodsBillcode) throws ApiException {
        if (StringUtils.isBlank((String)contractPmgoodsBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractPmgoodsBillcode", contractPmgoodsBillcode);
        this.delContractPmgoodsModelByCode(map);
    }

    public static void main(String[] args) {
        System.out.println();
    }
}

