/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.mid.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.mid.dao.MidShopdeMapper;
import com.yqbsoft.laser.service.mid.domain.MidShopdeDomain;
import com.yqbsoft.laser.service.mid.domain.MidShopdeReDomain;
import com.yqbsoft.laser.service.mid.model.MidShopde;
import com.yqbsoft.laser.service.mid.service.MidShopdeService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MidShopdeServiceImpl
extends BaseServiceImpl
implements MidShopdeService {
    private static final String SYS_CODE = "mid.MidShopdeServiceImpl";
    private MidShopdeMapper midShopdeMapper;

    public void setMidShopdeMapper(MidShopdeMapper midShopdeMapper) {
        this.midShopdeMapper = midShopdeMapper;
    }

    private Date getSysDate() {
        try {
            return this.midShopdeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mid.MidShopdeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkshopde(MidShopdeDomain midShopdeDomain) {
        if (null == midShopdeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)midShopdeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setshopdeDefault(MidShopde midShopde) {
        if (null == midShopde) {
            return;
        }
        if (null == midShopde.getDataState()) {
            midShopde.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == midShopde.getGmtCreate()) {
            midShopde.setGmtCreate(date);
        }
        midShopde.setGmtModified(date);
        if (StringUtils.isBlank((String)midShopde.getShopdeCode())) {
            midShopde.setShopdeCode(this.getNo(null, "MidShopde", "midShopde", midShopde.getTenantCode()));
        }
    }

    private int getshopdeMaxCode() {
        int code = 0;
        try {
            return this.midShopdeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mid.MidShopdeServiceImpl.getshopdeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setshopdeUpdataDefault(MidShopde midShopde) {
        if (null == midShopde) {
            return;
        }
        midShopde.setGmtModified(this.getSysDate());
    }

    private void saveshopdeModel(MidShopde midShopde) throws ApiException {
        if (null == midShopde) {
            return;
        }
        try {
            this.midShopdeMapper.insert(midShopde);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidShopdeServiceImpl.saveshopdeModel.ex", (Throwable)e);
        }
    }

    private void saveshopdeBatchModel(List<MidShopde> midShopdeList) throws ApiException {
        if (null == midShopdeList || midShopdeList.isEmpty()) {
            return;
        }
        try {
            this.midShopdeMapper.insertBatch(midShopdeList);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidShopdeServiceImpl.saveshopdeBatchModel.ex", (Throwable)e);
        }
    }

    private MidShopde getshopdeModelById(Integer shopdeId) {
        if (null == shopdeId) {
            return null;
        }
        try {
            return this.midShopdeMapper.selectByPrimaryKey(shopdeId);
        }
        catch (Exception e) {
            this.logger.error("mid.MidShopdeServiceImpl.getshopdeModelById", (Throwable)e);
            return null;
        }
    }

    private MidShopde getshopdeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.midShopdeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("mid.MidShopdeServiceImpl.getshopdeModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delshopdeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.midShopdeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidShopdeServiceImpl.delshopdeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidShopdeServiceImpl.delshopdeModelByCode.num");
        }
    }

    private void deleteshopdeModel(Integer shopdeId) throws ApiException {
        if (null == shopdeId) {
            return;
        }
        int i = 0;
        try {
            i = this.midShopdeMapper.deleteByPrimaryKey(shopdeId);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidShopdeServiceImpl.deleteshopdeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidShopdeServiceImpl.deleteshopdeModel.num");
        }
    }

    private void updateshopdeModel(MidShopde midShopde) throws ApiException {
        if (null == midShopde) {
            return;
        }
        int i = 0;
        try {
            i = this.midShopdeMapper.updateByPrimaryKey(midShopde);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidShopdeServiceImpl.updateshopdeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidShopdeServiceImpl.updateshopdeModel.num");
        }
    }

    private void updateStateshopdeModel(Integer shopdeId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == shopdeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("shopdeId", shopdeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.midShopdeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidShopdeServiceImpl.updateStateshopdeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mid.MidShopdeServiceImpl.updateStateshopdeModel.null");
        }
    }

    private void updateStateshopdeModelByCode(String tenantCode, String shopdeCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)shopdeCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("shopdeCode", shopdeCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.midShopdeMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidShopdeServiceImpl.updateStateshopdeModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mid.MidShopdeServiceImpl.updateStateshopdeModelByCode.null");
        }
    }

    private MidShopde makeshopde(MidShopdeDomain midShopdeDomain, MidShopde midShopde) {
        if (null == midShopdeDomain) {
            return null;
        }
        if (null == midShopde) {
            midShopde = new MidShopde();
        }
        try {
            BeanUtils.copyAllPropertys((Object)midShopde, (Object)midShopdeDomain);
            return midShopde;
        }
        catch (Exception e) {
            this.logger.error("mid.MidShopdeServiceImpl.makeshopde", (Throwable)e);
            return null;
        }
    }

    private MidShopdeReDomain makeMidShopdeReDomain(MidShopde midShopde) {
        if (null == midShopde) {
            return null;
        }
        MidShopdeReDomain midShopdeReDomain = new MidShopdeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)midShopdeReDomain, (Object)midShopde);
            return midShopdeReDomain;
        }
        catch (Exception e) {
            this.logger.error("mid.MidShopdeServiceImpl.makeMidShopdeReDomain", (Throwable)e);
            return null;
        }
    }

    private List<MidShopde> queryshopdeModelPage(Map<String, Object> parammap) {
        try {
            return this.midShopdeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mid.MidShopdeServiceImpl.queryshopdeModel", (Throwable)e);
            return null;
        }
    }

    private int countshopde(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.midShopdeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mid.MidShopdeServiceImpl.countshopde", (Throwable)e);
        }
        return i;
    }

    private MidShopde createMidShopde(MidShopdeDomain midShopdeDomain) {
        String msg = this.checkshopde(midShopdeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mid.MidShopdeServiceImpl.saveshopde.checkshopde", msg);
        }
        MidShopde midShopde = this.makeshopde(midShopdeDomain, null);
        this.setshopdeDefault(midShopde);
        return midShopde;
    }

    @Override
    public String saveshopde(MidShopdeDomain midShopdeDomain) throws ApiException {
        MidShopde midShopde = this.createMidShopde(midShopdeDomain);
        this.saveshopdeModel(midShopde);
        return midShopde.getShopdeCode();
    }

    @Override
    public String saveshopdeBatch(List<MidShopdeDomain> midShopdeDomainList) throws ApiException {
        if (null == midShopdeDomainList || midShopdeDomainList.isEmpty()) {
            return null;
        }
        ArrayList<MidShopde> midShopdeList = new ArrayList<MidShopde>();
        String code = "";
        for (MidShopdeDomain midShopdeDomain : midShopdeDomainList) {
            MidShopde midShopde = this.createMidShopde(midShopdeDomain);
            code = midShopde.getShopdeCode();
            midShopdeList.add(midShopde);
        }
        this.saveshopdeBatchModel(midShopdeList);
        return code;
    }

    @Override
    public void updateshopdeState(Integer shopdeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == shopdeId) {
            return;
        }
        this.updateStateshopdeModel(shopdeId, dataState, oldDataState, map);
    }

    @Override
    public void updateshopdeStateByCode(String tenantCode, String shopdeCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)shopdeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateshopdeModelByCode(tenantCode, shopdeCode, dataState, oldDataState, map);
    }

    @Override
    public void updateshopde(MidShopdeDomain midShopdeDomain) throws ApiException {
        String msg = this.checkshopde(midShopdeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mid.MidShopdeServiceImpl.updateshopde.checkshopde", msg);
        }
        MidShopde oldMidShopde = this.getshopdeModelById(midShopdeDomain.getShopdeId());
        if (null == oldMidShopde) {
            throw new ApiException("mid.MidShopdeServiceImpl.updateshopde.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MidShopde midShopde = this.makeshopde(midShopdeDomain, oldMidShopde);
        this.setshopdeUpdataDefault(midShopde);
        this.updateshopdeModel(midShopde);
    }

    @Override
    public MidShopde getshopde(Integer shopdeId) {
        if (null == shopdeId) {
            return null;
        }
        return this.getshopdeModelById(shopdeId);
    }

    @Override
    public void deleteshopde(Integer shopdeId) throws ApiException {
        if (null == shopdeId) {
            return;
        }
        this.deleteshopdeModel(shopdeId);
    }

    @Override
    public QueryResult<MidShopde> queryshopdePage(Map<String, Object> map) {
        List<MidShopde> midShopdeList = this.queryshopdeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countshopde(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(midShopdeList);
        return queryResult;
    }

    @Override
    public MidShopde getshopdeByCode(String tenantCode, String shopdeCode) throws ApiException {
        if (StringUtils.isBlank((String)shopdeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("shopdeCode", shopdeCode);
        return this.getshopdeModelByCode(map);
    }

    @Override
    public void deleteshopdeByCode(String tenantCode, String shopdeCode) throws ApiException {
        if (StringUtils.isBlank((String)shopdeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("shopdeCode", shopdeCode);
        this.delshopdeModelByCode(map);
    }
}

