/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.mid.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.mid.dao.MidSkuMapper;
import com.yqbsoft.laser.service.mid.domain.MidSkuDomain;
import com.yqbsoft.laser.service.mid.domain.MidSkuReDomain;
import com.yqbsoft.laser.service.mid.model.MidSku;
import com.yqbsoft.laser.service.mid.service.MidSkuService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MidSkuServiceImpl
extends BaseServiceImpl
implements MidSkuService {
    private static final String SYS_CODE = "mid.MidSkuServiceImpl";
    private MidSkuMapper midSkuMapper;

    public void setMidSkuMapper(MidSkuMapper midSkuMapper) {
        this.midSkuMapper = midSkuMapper;
    }

    private Date getSysDate() {
        try {
            return this.midSkuMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mid.MidSkuServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checksku(MidSkuDomain midSkuDomain) {
        if (null == midSkuDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)midSkuDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setskuDefault(MidSku midSku) {
        if (null == midSku) {
            return;
        }
        if (null == midSku.getDataState()) {
            midSku.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == midSku.getGmtCreate()) {
            midSku.setGmtCreate(date);
        }
        midSku.setGmtModified(date);
        if (StringUtils.isBlank((String)midSku.getSkuCode())) {
            midSku.setSkuCode(this.getNo(null, "MidSku", "midSku", midSku.getTenantCode()));
        }
    }

    private int getskuMaxCode() {
        int code = 0;
        try {
            return this.midSkuMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mid.MidSkuServiceImpl.getskuMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setskuUpdataDefault(MidSku midSku) {
        if (null == midSku) {
            return;
        }
        midSku.setGmtModified(this.getSysDate());
    }

    private void saveskuModel(MidSku midSku) throws ApiException {
        if (null == midSku) {
            return;
        }
        try {
            this.midSkuMapper.insert(midSku);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidSkuServiceImpl.saveskuModel.ex", (Throwable)e);
        }
    }

    private void saveskuBatchModel(List<MidSku> midSkuList) throws ApiException {
        if (null == midSkuList || midSkuList.isEmpty()) {
            return;
        }
        try {
            this.midSkuMapper.insertBatch(midSkuList);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidSkuServiceImpl.saveskuBatchModel.ex", (Throwable)e);
        }
    }

    private MidSku getskuModelById(Integer skuId) {
        if (null == skuId) {
            return null;
        }
        try {
            return this.midSkuMapper.selectByPrimaryKey(skuId);
        }
        catch (Exception e) {
            this.logger.error("mid.MidSkuServiceImpl.getskuModelById", (Throwable)e);
            return null;
        }
    }

    private MidSku getskuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.midSkuMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("mid.MidSkuServiceImpl.getskuModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delskuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.midSkuMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidSkuServiceImpl.delskuModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidSkuServiceImpl.delskuModelByCode.num");
        }
    }

    private void deleteskuModel(Integer skuId) throws ApiException {
        if (null == skuId) {
            return;
        }
        int i = 0;
        try {
            i = this.midSkuMapper.deleteByPrimaryKey(skuId);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidSkuServiceImpl.deleteskuModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidSkuServiceImpl.deleteskuModel.num");
        }
    }

    private void updateskuModel(MidSku midSku) throws ApiException {
        if (null == midSku) {
            return;
        }
        int i = 0;
        try {
            i = this.midSkuMapper.updateByPrimaryKey(midSku);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidSkuServiceImpl.updateskuModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidSkuServiceImpl.updateskuModel.num");
        }
    }

    private void updateStateskuModel(Integer skuId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == skuId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuId", skuId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.midSkuMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidSkuServiceImpl.updateStateskuModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mid.MidSkuServiceImpl.updateStateskuModel.null");
        }
    }

    private void updateStateskuModelByCode(String tenantCode, String skuCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)skuCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("skuCode", skuCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.midSkuMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidSkuServiceImpl.updateStateskuModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mid.MidSkuServiceImpl.updateStateskuModelByCode.null");
        }
    }

    private MidSku makesku(MidSkuDomain midSkuDomain, MidSku midSku) {
        if (null == midSkuDomain) {
            return null;
        }
        if (null == midSku) {
            midSku = new MidSku();
        }
        try {
            BeanUtils.copyAllPropertys((Object)midSku, (Object)midSkuDomain);
            return midSku;
        }
        catch (Exception e) {
            this.logger.error("mid.MidSkuServiceImpl.makesku", (Throwable)e);
            return null;
        }
    }

    private MidSkuReDomain makeMidSkuReDomain(MidSku midSku) {
        if (null == midSku) {
            return null;
        }
        MidSkuReDomain midSkuReDomain = new MidSkuReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)midSkuReDomain, (Object)midSku);
            return midSkuReDomain;
        }
        catch (Exception e) {
            this.logger.error("mid.MidSkuServiceImpl.makeMidSkuReDomain", (Throwable)e);
            return null;
        }
    }

    private List<MidSku> queryskuModelPage(Map<String, Object> parammap) {
        try {
            return this.midSkuMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mid.MidSkuServiceImpl.queryskuModel", (Throwable)e);
            return null;
        }
    }

    private int countsku(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.midSkuMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mid.MidSkuServiceImpl.countsku", (Throwable)e);
        }
        return i;
    }

    private MidSku createMidSku(MidSkuDomain midSkuDomain) {
        String msg = this.checksku(midSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mid.MidSkuServiceImpl.savesku.checksku", msg);
        }
        MidSku midSku = this.makesku(midSkuDomain, null);
        this.setskuDefault(midSku);
        return midSku;
    }

    @Override
    public String savesku(MidSkuDomain midSkuDomain) throws ApiException {
        MidSku midSku = this.createMidSku(midSkuDomain);
        this.saveskuModel(midSku);
        return midSku.getSkuCode();
    }

    @Override
    public String saveskuBatch(List<MidSkuDomain> midSkuDomainList) throws ApiException {
        if (null == midSkuDomainList || midSkuDomainList.isEmpty()) {
            return null;
        }
        ArrayList<MidSku> midSkuList = new ArrayList<MidSku>();
        String code = "";
        for (MidSkuDomain midSkuDomain : midSkuDomainList) {
            MidSku midSku = this.createMidSku(midSkuDomain);
            code = midSku.getSkuCode();
            midSkuList.add(midSku);
        }
        this.saveskuBatchModel(midSkuList);
        return code;
    }

    @Override
    public void updateskuState(Integer skuId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == skuId) {
            return;
        }
        this.updateStateskuModel(skuId, dataState, oldDataState, map);
    }

    @Override
    public void updateskuStateByCode(String tenantCode, String skuCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateskuModelByCode(tenantCode, skuCode, dataState, oldDataState, map);
    }

    @Override
    public void updatesku(MidSkuDomain midSkuDomain) throws ApiException {
        String msg = this.checksku(midSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mid.MidSkuServiceImpl.updatesku.checksku", msg);
        }
        MidSku oldMidSku = this.getskuModelById(midSkuDomain.getSkuId());
        if (null == oldMidSku) {
            throw new ApiException("mid.MidSkuServiceImpl.updatesku.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MidSku midSku = this.makesku(midSkuDomain, oldMidSku);
        this.setskuUpdataDefault(midSku);
        this.updateskuModel(midSku);
    }

    @Override
    public MidSku getsku(Integer skuId) {
        if (null == skuId) {
            return null;
        }
        return this.getskuModelById(skuId);
    }

    @Override
    public void deletesku(Integer skuId) throws ApiException {
        if (null == skuId) {
            return;
        }
        this.deleteskuModel(skuId);
    }

    @Override
    public QueryResult<MidSku> queryskuPage(Map<String, Object> map) {
        List<MidSku> midSkuList = this.queryskuModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countsku(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(midSkuList);
        return queryResult;
    }

    @Override
    public MidSku getskuByCode(String tenantCode, String skuCode) throws ApiException {
        if (StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("skuCode", skuCode);
        return this.getskuModelByCode(map);
    }

    @Override
    public void deleteskuByCode(String tenantCode, String skuCode) throws ApiException {
        if (StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("skuCode", skuCode);
        this.delskuModelByCode(map);
    }
}

