/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.mid.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.mid.dao.MidUpointsListMapper;
import com.yqbsoft.laser.service.mid.dao.MidUpointsMapper;
import com.yqbsoft.laser.service.mid.domain.MidUpointsDomain;
import com.yqbsoft.laser.service.mid.domain.MidUpointsListDomain;
import com.yqbsoft.laser.service.mid.domain.MidUpointsListReDomain;
import com.yqbsoft.laser.service.mid.domain.MidUpointsReDomain;
import com.yqbsoft.laser.service.mid.model.MidUpoints;
import com.yqbsoft.laser.service.mid.model.MidUpointsList;
import com.yqbsoft.laser.service.mid.service.MidUpointsService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MidUpointsServiceImpl
extends BaseServiceImpl
implements MidUpointsService {
    private static final String SYS_CODE = "mid.MidUpointsServiceImpl";
    private MidUpointsMapper midUpointsMapper;
    private MidUpointsListMapper midUpointsListMapper;

    public void setMidUpointsMapper(MidUpointsMapper midUpointsMapper) {
        this.midUpointsMapper = midUpointsMapper;
    }

    public void setMidUpointsListMapper(MidUpointsListMapper midUpointsListMapper) {
        this.midUpointsListMapper = midUpointsListMapper;
    }

    private Date getSysDate() {
        try {
            return this.midUpointsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mid.MidUpointsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUpoints(MidUpointsDomain midUpointsDomain) {
        if (null == midUpointsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)midUpointsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUpointsDefault(MidUpoints midUpoints) {
        if (null == midUpoints) {
            return;
        }
        if (null == midUpoints.getDataState()) {
            midUpoints.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == midUpoints.getGmtCreate()) {
            midUpoints.setGmtCreate(date);
        }
        midUpoints.setGmtModified(date);
        if (StringUtils.isBlank((String)midUpoints.getUpointsCode())) {
            midUpoints.setUpointsCode(this.getNo(null, "MidUpoints", "midUpoints", midUpoints.getTenantCode()));
        }
    }

    private int getUpointsMaxCode() {
        int code = 0;
        try {
            return this.midUpointsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mid.MidUpointsServiceImpl.getUpointsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUpointsUpdataDefault(MidUpoints midUpoints) {
        if (null == midUpoints) {
            return;
        }
        midUpoints.setGmtModified(this.getSysDate());
    }

    private void saveUpointsModel(MidUpoints midUpoints) throws ApiException {
        if (null == midUpoints) {
            return;
        }
        try {
            this.midUpointsMapper.insert(midUpoints);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidUpointsServiceImpl.saveUpointsModel.ex", (Throwable)e);
        }
    }

    private void saveUpointsBatchModel(List<MidUpoints> midUpointsList) throws ApiException {
        if (null == midUpointsList || midUpointsList.isEmpty()) {
            return;
        }
        try {
            this.midUpointsMapper.insertBatch(midUpointsList);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidUpointsServiceImpl.saveUpointsBatchModel.ex", (Throwable)e);
        }
    }

    private MidUpoints getUpointsModelById(Integer upointsId) {
        if (null == upointsId) {
            return null;
        }
        try {
            return this.midUpointsMapper.selectByPrimaryKey(upointsId);
        }
        catch (Exception e) {
            this.logger.error("mid.MidUpointsServiceImpl.getUpointsModelById", (Throwable)e);
            return null;
        }
    }

    private MidUpoints getUpointsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.midUpointsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("mid.MidUpointsServiceImpl.getUpointsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUpointsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.midUpointsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidUpointsServiceImpl.delUpointsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidUpointsServiceImpl.delUpointsModelByCode.num");
        }
    }

    private void deleteUpointsModel(Integer upointsId) throws ApiException {
        if (null == upointsId) {
            return;
        }
        int i = 0;
        try {
            i = this.midUpointsMapper.deleteByPrimaryKey(upointsId);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidUpointsServiceImpl.deleteUpointsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidUpointsServiceImpl.deleteUpointsModel.num");
        }
    }

    private void updateUpointsModel(MidUpoints midUpoints) throws ApiException {
        if (null == midUpoints) {
            return;
        }
        int i = 0;
        try {
            i = this.midUpointsMapper.updateByPrimaryKey(midUpoints);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidUpointsServiceImpl.updateUpointsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidUpointsServiceImpl.updateUpointsModel.num");
        }
    }

    private void updateStateUpointsModel(Integer upointsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == upointsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("upointsId", upointsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.midUpointsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidUpointsServiceImpl.updateStateUpointsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mid.MidUpointsServiceImpl.updateStateUpointsModel.null");
        }
    }

    private void updateStateUpointsModelByCode(String tenantCode, String upointsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)upointsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upointsCode", upointsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.midUpointsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidUpointsServiceImpl.updateStateUpointsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mid.MidUpointsServiceImpl.updateStateUpointsModelByCode.null");
        }
    }

    private MidUpoints makeUpoints(MidUpointsDomain midUpointsDomain, MidUpoints midUpoints) {
        if (null == midUpointsDomain) {
            return null;
        }
        if (null == midUpoints) {
            midUpoints = new MidUpoints();
        }
        try {
            BeanUtils.copyAllPropertys((Object)midUpoints, (Object)midUpointsDomain);
            return midUpoints;
        }
        catch (Exception e) {
            this.logger.error("mid.MidUpointsServiceImpl.makeUpoints", (Throwable)e);
            return null;
        }
    }

    private MidUpointsReDomain makeMidUpointsReDomain(MidUpoints midUpoints) {
        if (null == midUpoints) {
            return null;
        }
        MidUpointsReDomain midUpointsReDomain = new MidUpointsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)midUpointsReDomain, (Object)midUpoints);
            return midUpointsReDomain;
        }
        catch (Exception e) {
            this.logger.error("mid.MidUpointsServiceImpl.makeMidUpointsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<MidUpoints> queryUpointsModelPage(Map<String, Object> parammap) {
        try {
            return this.midUpointsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mid.MidUpointsServiceImpl.queryUpointsModel", (Throwable)e);
            return null;
        }
    }

    private int countUpoints(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.midUpointsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mid.MidUpointsServiceImpl.countUpoints", (Throwable)e);
        }
        return i;
    }

    private MidUpoints createMidUpoints(MidUpointsDomain midUpointsDomain) {
        String msg = this.checkUpoints(midUpointsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mid.MidUpointsServiceImpl.saveUpoints.checkUpoints", msg);
        }
        MidUpoints midUpoints = this.makeUpoints(midUpointsDomain, null);
        this.setUpointsDefault(midUpoints);
        return midUpoints;
    }

    private String checkUpointsList(MidUpointsListDomain midUpointsListDomain) {
        if (null == midUpointsListDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)midUpointsListDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUpointsListDefault(MidUpointsList midUpointsList) {
        if (null == midUpointsList) {
            return;
        }
        if (null == midUpointsList.getDataState()) {
            midUpointsList.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == midUpointsList.getGmtCreate()) {
            midUpointsList.setGmtCreate(date);
        }
        midUpointsList.setGmtModified(date);
        if (StringUtils.isBlank((String)midUpointsList.getUpointsListCode())) {
            midUpointsList.setUpointsListCode(this.getNo(null, "MidUpointsList", "midUpointsList", midUpointsList.getTenantCode()));
        }
    }

    private int getUpointsListMaxCode() {
        int code = 0;
        try {
            return this.midUpointsListMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mid.MidUpointsServiceImpl.getUpointsListMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUpointsListUpdataDefault(MidUpointsList midUpointsList) {
        if (null == midUpointsList) {
            return;
        }
        midUpointsList.setGmtModified(this.getSysDate());
    }

    private void saveUpointsListModel(MidUpointsList midUpointsList) throws ApiException {
        if (null == midUpointsList) {
            return;
        }
        try {
            this.midUpointsListMapper.insert(midUpointsList);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidUpointsServiceImpl.saveUpointsListModel.ex", (Throwable)e);
        }
    }

    private void saveUpointsListBatchModel(List<MidUpointsList> midUpointsListList) throws ApiException {
        if (null == midUpointsListList || midUpointsListList.isEmpty()) {
            return;
        }
        try {
            this.midUpointsListMapper.insertBatch(midUpointsListList);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidUpointsServiceImpl.saveUpointsListBatchModel.ex", (Throwable)e);
        }
    }

    private MidUpointsList getUpointsListModelById(Integer upointsListId) {
        if (null == upointsListId) {
            return null;
        }
        try {
            return this.midUpointsListMapper.selectByPrimaryKey(upointsListId);
        }
        catch (Exception e) {
            this.logger.error("mid.MidUpointsServiceImpl.getUpointsListModelById", (Throwable)e);
            return null;
        }
    }

    private MidUpointsList getUpointsListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.midUpointsListMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("mid.MidUpointsServiceImpl.getUpointsListModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUpointsListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.midUpointsListMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidUpointsServiceImpl.delUpointsListModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidUpointsServiceImpl.delUpointsListModelByCode.num");
        }
    }

    private void deleteUpointsListModel(Integer upointsListId) throws ApiException {
        if (null == upointsListId) {
            return;
        }
        int i = 0;
        try {
            i = this.midUpointsListMapper.deleteByPrimaryKey(upointsListId);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidUpointsServiceImpl.deleteUpointsListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidUpointsServiceImpl.deleteUpointsListModel.num");
        }
    }

    private void updateUpointsListModel(MidUpointsList midUpointsList) throws ApiException {
        if (null == midUpointsList) {
            return;
        }
        int i = 0;
        try {
            i = this.midUpointsListMapper.updateByPrimaryKey(midUpointsList);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidUpointsServiceImpl.updateUpointsListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidUpointsServiceImpl.updateUpointsListModel.num");
        }
    }

    private void updateStateUpointsListModel(Integer upointsListId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == upointsListId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("upointsListId", upointsListId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.midUpointsListMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidUpointsServiceImpl.updateStateUpointsListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mid.MidUpointsServiceImpl.updateStateUpointsListModel.null");
        }
    }

    private void updateStateUpointsListModelByCode(String tenantCode, String upointsListCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)upointsListCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upointsListCode", upointsListCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.midUpointsListMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidUpointsServiceImpl.updateStateUpointsListModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mid.MidUpointsServiceImpl.updateStateUpointsListModelByCode.null");
        }
    }

    private MidUpointsList makeUpointsList(MidUpointsListDomain midUpointsListDomain, MidUpointsList midUpointsList) {
        if (null == midUpointsListDomain) {
            return null;
        }
        if (null == midUpointsList) {
            midUpointsList = new MidUpointsList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)midUpointsList, (Object)midUpointsListDomain);
            return midUpointsList;
        }
        catch (Exception e) {
            this.logger.error("mid.MidUpointsServiceImpl.makeUpointsList", (Throwable)e);
            return null;
        }
    }

    private MidUpointsListReDomain makeMidUpointsListReDomain(MidUpointsList midUpointsList) {
        if (null == midUpointsList) {
            return null;
        }
        MidUpointsListReDomain midUpointsListReDomain = new MidUpointsListReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)midUpointsListReDomain, (Object)midUpointsList);
            return midUpointsListReDomain;
        }
        catch (Exception e) {
            this.logger.error("mid.MidUpointsServiceImpl.makeMidUpointsListReDomain", (Throwable)e);
            return null;
        }
    }

    private List<MidUpointsList> queryUpointsListModelPage(Map<String, Object> parammap) {
        try {
            return this.midUpointsListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mid.MidUpointsServiceImpl.queryUpointsListModel", (Throwable)e);
            return null;
        }
    }

    private int countUpointsList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.midUpointsListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mid.MidUpointsServiceImpl.countUpointsList", (Throwable)e);
        }
        return i;
    }

    private MidUpointsList createMidUpointsList(MidUpointsListDomain midUpointsListDomain) {
        String msg = this.checkUpointsList(midUpointsListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mid.MidUpointsServiceImpl.saveUpointsList.checkUpointsList", msg);
        }
        MidUpointsList midUpointsList = this.makeUpointsList(midUpointsListDomain, null);
        this.setUpointsListDefault(midUpointsList);
        return midUpointsList;
    }

    @Override
    public String saveUpoints(MidUpointsDomain midUpointsDomain) throws ApiException {
        MidUpoints midUpoints = this.createMidUpoints(midUpointsDomain);
        this.saveUpointsModel(midUpoints);
        return midUpoints.getUpointsCode();
    }

    @Override
    public String saveUpointsBatch(List<MidUpointsDomain> midUpointsDomainList) throws ApiException {
        if (null == midUpointsDomainList || midUpointsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<MidUpoints> midUpointsList = new ArrayList<MidUpoints>();
        String code = "";
        for (MidUpointsDomain midUpointsDomain : midUpointsDomainList) {
            MidUpoints midUpoints = this.createMidUpoints(midUpointsDomain);
            code = midUpoints.getUpointsCode();
            midUpointsList.add(midUpoints);
        }
        this.saveUpointsBatchModel(midUpointsList);
        return code;
    }

    @Override
    public void updateUpointsState(Integer upointsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == upointsId) {
            return;
        }
        this.updateStateUpointsModel(upointsId, dataState, oldDataState, map);
    }

    @Override
    public void updateUpointsStateByCode(String tenantCode, String upointsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)upointsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUpointsModelByCode(tenantCode, upointsCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUpoints(MidUpointsDomain midUpointsDomain) throws ApiException {
        String msg = this.checkUpoints(midUpointsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mid.MidUpointsServiceImpl.updateUpoints.checkUpoints", msg);
        }
        MidUpoints oldMidUpoints = this.getUpointsModelById(midUpointsDomain.getUpointsId());
        if (null == oldMidUpoints) {
            throw new ApiException("mid.MidUpointsServiceImpl.updateUpoints.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MidUpoints midUpoints = this.makeUpoints(midUpointsDomain, oldMidUpoints);
        this.setUpointsUpdataDefault(midUpoints);
        this.updateUpointsModel(midUpoints);
    }

    @Override
    public MidUpoints getUpoints(Integer upointsId) {
        if (null == upointsId) {
            return null;
        }
        return this.getUpointsModelById(upointsId);
    }

    @Override
    public void deleteUpoints(Integer upointsId) throws ApiException {
        if (null == upointsId) {
            return;
        }
        this.deleteUpointsModel(upointsId);
    }

    @Override
    public QueryResult<MidUpoints> queryUpointsPage(Map<String, Object> map) {
        List<MidUpoints> midUpointsList = this.queryUpointsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUpoints(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(midUpointsList);
        return queryResult;
    }

    @Override
    public MidUpoints getUpointsByCode(String tenantCode, String upointsCode) throws ApiException {
        if (StringUtils.isBlank((String)upointsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upointsCode", upointsCode);
        return this.getUpointsModelByCode(map);
    }

    @Override
    public void deleteUpointsByCode(String tenantCode, String upointsCode) throws ApiException {
        if (StringUtils.isBlank((String)upointsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upointsCode", upointsCode);
        this.delUpointsModelByCode(map);
    }

    @Override
    public String saveUpointsList(MidUpointsListDomain midUpointsListDomain) throws ApiException {
        MidUpointsList midUpointsList = this.createMidUpointsList(midUpointsListDomain);
        this.saveUpointsListModel(midUpointsList);
        return midUpointsList.getUpointsListCode();
    }

    @Override
    public String saveUpointsListBatch(List<MidUpointsListDomain> midUpointsListDomainList) throws ApiException {
        if (null == midUpointsListDomainList || midUpointsListDomainList.isEmpty()) {
            return null;
        }
        ArrayList<MidUpointsList> midUpointsListList = new ArrayList<MidUpointsList>();
        String code = "";
        for (MidUpointsListDomain midUpointsListDomain : midUpointsListDomainList) {
            MidUpointsList midUpointsList = this.createMidUpointsList(midUpointsListDomain);
            code = midUpointsList.getUpointsListCode();
            midUpointsListList.add(midUpointsList);
        }
        this.saveUpointsListBatchModel(midUpointsListList);
        return code;
    }

    @Override
    public void updateUpointsListState(Integer upointsListId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == upointsListId) {
            return;
        }
        this.updateStateUpointsListModel(upointsListId, dataState, oldDataState, map);
    }

    @Override
    public void updateUpointsListStateByCode(String tenantCode, String upointsListCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)upointsListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUpointsListModelByCode(tenantCode, upointsListCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUpointsList(MidUpointsListDomain midUpointsListDomain) throws ApiException {
        String msg = this.checkUpointsList(midUpointsListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mid.MidUpointsServiceImpl.updateUpointsList.checkUpointsList", msg);
        }
        MidUpointsList oldMidUpointsList = this.getUpointsListModelById(midUpointsListDomain.getUpointsListId());
        if (null == oldMidUpointsList) {
            throw new ApiException("mid.MidUpointsServiceImpl.updateUpointsList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MidUpointsList midUpointsList = this.makeUpointsList(midUpointsListDomain, oldMidUpointsList);
        this.setUpointsListUpdataDefault(midUpointsList);
        this.updateUpointsListModel(midUpointsList);
    }

    @Override
    public MidUpointsList getUpointsList(Integer upointsListId) {
        if (null == upointsListId) {
            return null;
        }
        return this.getUpointsListModelById(upointsListId);
    }

    @Override
    public void deleteUpointsList(Integer upointsListId) throws ApiException {
        if (null == upointsListId) {
            return;
        }
        this.deleteUpointsListModel(upointsListId);
    }

    @Override
    public QueryResult<MidUpointsList> queryUpointsListPage(Map<String, Object> map) {
        List<MidUpointsList> midUpointsListList = this.queryUpointsListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUpointsList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(midUpointsListList);
        return queryResult;
    }

    @Override
    public MidUpointsList getUpointsListByCode(String tenantCode, String upointsListCode) throws ApiException {
        if (StringUtils.isBlank((String)upointsListCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upointsListCode", upointsListCode);
        return this.getUpointsListModelByCode(map);
    }

    @Override
    public void deleteUpointsListByCode(String tenantCode, String upointsListCode) throws ApiException {
        if (StringUtils.isBlank((String)upointsListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upointsListCode", upointsListCode);
        this.delUpointsListModelByCode(map);
    }
}

