/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.mnsjd;

import com.yqbsoft.laser.service.adapter.mnsjd.Sender;
import com.yqbsoft.laser.service.adapter.mnsjd.SmsResponse;
import com.yqbsoft.laser.service.esb.core.auth.AuthUtil;
import com.yqbsoft.laser.service.esb.core.core.EsbReBean;
import com.yqbsoft.laser.service.esb.core.router.ProxyInvokeSupport;
import com.yqbsoft.laser.service.esb.core.transformer.InvokeIdParser;
import com.yqbsoft.laser.service.suppercore.core.InMessage;
import com.yqbsoft.laser.service.suppercore.core.Invoke;
import com.yqbsoft.laser.service.suppercore.core.OutMessage;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class MnsJdInvokeService
extends ProxyInvokeSupport {
    private static final String SYS_CODE = "http.adapter.mnsjd.MnsJdInvoke";

    public OutMessage channelSendMsg(InMessage inMessage) {
        if (null == inMessage) {
            return new OutMessage("http.adapter.mnsjd.MnsJdInvoke.empty", "\u4fe1\u606f\u4e3a\u7a7a");
        }
        OutMessage outMessage = new OutMessage();
        try {
            Invoke invoke = inMessage.getInvoke();
            Map params = invoke.getParams();
            InvokeIdParser.addInInvokeIdParamByHttp((Map)params, (InMessage)inMessage);
            String username = (String)params.get("accessKeyId");
            String password = (String)params.get("accessKeySecret");
            String phone = (String)params.get("phone");
            String content = (String)params.get("content");
            String signName = (String)params.get("signName");
            String paramMapjson = (String)params.get("paramMap");
            Map templateParams = null;
            if (StringUtils.isNotBlank((String)paramMapjson)) {
                templateParams = (Map)JsonUtil.buildNormalBinder().getJsonToMap(paramMapjson, String.class, String.class);
            }
            String mnslistCode = (String)params.get("mnslistCode");
            Sender sender = new Sender(username, password, signName);
            SmsResponse smsResponse = sender.send(phone, content, templateParams);
            this.logger.error("http.adapter.mnsjd.MnsJdInvoke.channelSendMsg", (Object)String.format("phone: %s, code: %s, msg: %s, requestId: %s", phone, smsResponse.getCode(), smsResponse.getMsg(), smsResponse.getRequestId()));
            if (!"00".equals(smsResponse.getCode())) {
                HashMap<String, String> mapStr = new HashMap<String, String>();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("mnslistCode", mnslistCode);
                map.put("mnslistActiveid", smsResponse.getRequestId());
                mapStr.put("map", JsonUtil.buildNormalBinder().toJson(map));
                this.getInternalRouter().inInvoke("mns.mns.updateFail", mapStr);
            }
            outMessage.setReObj((Object)smsResponse.getRequestId());
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)("\u8c03\u7528\u5f02\u5e38\uff0cURL\uff1a" + inMessage.getInvoke().getRouterServiceName() + ",param" + inMessage.getInvoke().getParams()), (Throwable)e);
            outMessage.setErrorCode("http.adapter.mnsjd.MnsJdInvoke.ex");
            outMessage.setMsg("\u8c03\u7528\u5f02\u5e38");
        }
        return outMessage;
    }

    public void securityEncoder(InMessage inMessage) {
        Map params = inMessage.getInvoke().getParams();
        if (MapUtil.isEmpty((Map)params)) {
            return;
        }
        String plainText = AuthUtil.getSignCheckContentV1((Map)params);
        String sign = AuthUtil.sendAuth((InMessage)inMessage, (String)plainText);
        inMessage.getInvoke().setSign(sign);
    }

    public void securityDecoder(OutMessage outMessage, InMessage inMessage) {
        if (outMessage == null || inMessage == null) {
            return;
        }
        if (outMessage.getReObj() == null) {
            return;
        }
        String resultJson = outMessage.getReObj().toString();
        if (!StringUtils.isMapJson((String)resultJson)) {
            return;
        }
        Map resultMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(resultJson, String.class, String.class);
        if (MapUtil.isEmpty((Map)resultMap)) {
            return;
        }
        String sign = (String)resultMap.get("sign");
        if (StringUtils.isEmpty((String)sign)) {
            this.logger.error(SYS_CODE, (Object)"securityDecoder sign is null");
            return;
        }
        String plainText = AuthUtil.getSignCheckContentV1((Map)resultMap);
        boolean checkFlag = AuthUtil.returnAuthCheck((InMessage)inMessage, (String)plainText, (String)sign);
        if (!checkFlag) {
            this.logger.error(SYS_CODE, (Object)"validating sign with plainText failed");
        }
    }

    protected void handleInvokeId(InMessage inMessage, OutMessage outMessage) {
        EsbReBean jrb;
        String objectJson;
        Object reObject = outMessage.getReObj();
        if (reObject != null && StringUtils.isMapJson((String)(objectJson = reObject.toString())) && null != (jrb = (EsbReBean)JsonUtil.buildNormalBinder().getJsonToObject(objectJson, EsbReBean.class, new Class[]{String.class})) && null != jrb.getInvokeId()) {
            int level = jrb.getInvokeId().getMsgLevel();
            inMessage.getInvokeId().setMsgLevel(level);
        }
        super.handleInvokeId(inMessage, outMessage);
    }
}

