/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.ucc.service.impl;

import com.yqbsoft.laser.service.adapter.ucc.service.ContractFilingService;
import com.yqbsoft.laser.service.adapter.ucc.utils.FddEncryptTool;
import com.yqbsoft.laser.service.adapter.ucc.utils.WebUtils;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ContractFilingServiceImpl
extends BaseServiceImpl
implements ContractFilingService {
    private static String URL = "http://test.api.fabigbig.com:8888/api/";
    private static String APP_ID = "401755";

    @Override
    public String contractFiling() throws ApiException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        HashMap<String, String> map = new HashMap<String, String>();
        String timestamp = sdf.format(new Date());
        String sha1 = null;
        try {
            sha1 = FddEncryptTool.sha1("APP_ID" + FddEncryptTool.md5Digest(timestamp) + FddEncryptTool.sha1("XC0iSolSgYvLtKRU39Q8SQ9D123548215648518"));
        }
        catch (Exception e) {
            // empty catch block
        }
        String msgDigest = new String(FddEncryptTool.Base64Encode(sha1.getBytes()));
        map.put("app_id", APP_ID);
        map.put("v", "2.0");
        map.put("timestamp", timestamp);
        map.put("contract_id", "123548215648518");
        map.put("msg_digest", msgDigest);
        String returnValue = null;
        try {
            returnValue = WebUtils.doPost(URL + "contractFiling.api", map, 1000, 1000);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (StringUtils.isBlank(returnValue)) {
            // empty if block
        }
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(returnValue, String.class, String.class);
        return (String)jsonToMap.get("result");
    }

    @Override
    public String contractQuery() throws ApiException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        HashMap<String, String> map = new HashMap<String, String>();
        String timestamp = sdf.format(new Date());
        String sha1 = null;
        map.put("app_id", APP_ID);
        map.put("v", "2.0");
        map.put("timestamp", timestamp);
        map.put("contract_id", "123548215648518");
        map.put("customer_id", "123456");
        try {
            sha1 = FddEncryptTool.sha1(APP_ID + FddEncryptTool.md5Digest(timestamp) + FddEncryptTool.sha1("XC0iSolSgYvLtKRU39Q8SQ9D123548215648518123456"));
        }
        catch (Exception e) {
            // empty catch block
        }
        String msgDigest = new String(FddEncryptTool.Base64Encode(sha1.getBytes()));
        map.put("msg_digest", msgDigest);
        String returnValue = null;
        try {
            returnValue = WebUtils.doPost(URL + "query_signstatus.api", map, 1000, 1000);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (StringUtils.isBlank(returnValue)) {
            // empty if block
        }
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(returnValue, String.class, String.class);
        System.out.println(jsonToMap);
        return (String)jsonToMap.get("result");
    }

    public static void main(String[] args) {
        ContractFilingServiceImpl contractFilingService = new ContractFilingServiceImpl();
        System.out.println(contractFilingService.contractFiling());
    }
}

