/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.ucc.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;

public final class Base64Support {
    private static Base64Support base64Support = null;

    private Base64Support() {
    }

    public static synchronized Base64Support getInstance() {
        if (base64Support == null) {
            base64Support = new Base64Support();
        }
        return base64Support;
    }

    public String toStr(byte[] bytes) {
        Base64 base64 = new Base64();
        try {
            return new String(base64.encode(bytes), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encodeBase64ToString(String data) {
        try {
            return new String(Base64Support.encodeBase64(data.getBytes("UTF-8")), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Ecode base64 string error", e);
        }
    }

    public static byte[] encodeBase64(byte[] data) {
        return Base64.encodeBase64((byte[])data);
    }

    public byte[] fromStr(String str) throws IOException {
        if (str == null) {
            return null;
        }
        str = str.replaceAll("_", "+");
        str = str.replaceAll("-", "/");
        str = str.replaceAll("\\.", "=");
        Base64 base64 = new Base64();
        return base64.decode(str.getBytes("UTF-8"));
    }

    public String fromString(String str) throws IOException {
        if (str == null) {
            return null;
        }
        str = str.replaceAll("_", "+");
        str = str.replaceAll("-", "/");
        str = str.replaceAll("\\.", "=");
        Base64 base64 = new Base64();
        return new String(base64.decode(str.getBytes("UTF-8")));
    }
}

