/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.ucc.service.impl;

import com.yqbsoft.laser.service.adapter.ucc.domain.OcContractReDomain;
import com.yqbsoft.laser.service.adapter.ucc.model.OcContractGoods;
import com.yqbsoft.laser.service.adapter.ucc.model.UmUser;
import com.yqbsoft.laser.service.adapter.ucc.model.UmUserinfo;
import com.yqbsoft.laser.service.adapter.ucc.service.UccToFddService;
import com.yqbsoft.laser.service.adapter.ucc.utils.FddEncryptTool;
import com.yqbsoft.laser.service.adapter.ucc.utils.WebUtils;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.FileItem;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UccToFddServiceImpl
extends BaseServiceImpl
implements UccToFddService {
    private static final String SYS_CODE = "adapter.ucc.service.impl.UccToFddServiceImpl";
    private static final String APPLAYCA_URL = "http://test.api.fabigbig.com:8888/api/syncPerson_auto.api";
    private static final String UPLOADTEMPLATE_URL = "https://testapi.fadada.com:8443/api/uploadtemplate.api";
    private static final String GENERATE_CONTRACT_URL = "https://testapi.fadada.com:8443/api/generate_contract.api";
    private static final String EXTSIGN_URL = "https://testapi.fadada.com:8443/api/extsign.api";
    private static final String QUERYPACT_URL = "http://test.api.fabigbig.com:8888/api/query_signstatus.api";
    private static final String CONTRACTFILING_URL = "http://test.api.fabigbig.com:8888/api/contractFiling.api";
    private static String APP_ID = "401755";
    private static String APP_SECRET = "XC0iSolSgYvLtKRU39Q8SQ9D";

    @Override
    public String applyCA(UmUser umUser, UmUserinfo umUserinfo) throws ApiException {
        if (umUser == null || umUserinfo == null) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.applyCA.umUser|umUserinfo", (Object)("umUser:" + umUser + ",umUserinfo" + umUserinfo));
            return this.returnResult("error", "\u4f20\u53c2\u4e3a\u7a7a", null);
        }
        if (StringUtils.isBlank((String)umUserinfo.getUserinfoCoid())) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.applyCA", (Object)("userinfoCoid" + umUserinfo.getUserinfoCoid()));
            return this.returnResult("success", "\u8eab\u4efd\u8bc1\u53f7\u7801\u4e3a\u7a7a\uff01\uff01\uff01", null);
        }
        if (StringUtils.isNotBlank((String)umUser.getTenantCode())) {
            APP_ID = this.getUrl(umUser.getTenantCode(), "UccToFdd", "app_id");
            APP_SECRET = this.getUrl(umUser.getTenantCode(), "UccToFdd", "app_secret");
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.applyCA.getUrl", (Object)("APP_ID:" + APP_ID + ",APP_SECRET:" + APP_SECRET + ",TenantCode:" + umUser.getTenantCode()));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String timeStamp = sdf.format(new Date());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("app_id", APP_ID);
        map.put("timestamp", timeStamp);
        map.put("customer_name", umUserinfo.getUserinfoCorp());
        String id_mobile = umUserinfo.getUserinfoCoid() + "|" + umUserinfo.getUserinfoPhone();
        String encrypt = null;
        try {
            encrypt = FddEncryptTool.encrypt(id_mobile, APP_SECRET);
        }
        catch (Exception e) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.applyCA.encrypt:", (Object)encrypt, (Throwable)e);
            return this.returnResult("error", "\u52a0\u5bc6\u5931\u8d25", null);
        }
        map.put("id_mobile", encrypt);
        String msgDigest = "";
        try {
            String sha1 = FddEncryptTool.sha1(APP_ID + FddEncryptTool.md5Digest(timeStamp) + FddEncryptTool.sha1(APP_SECRET));
            msgDigest = new String(FddEncryptTool.Base64Encode(sha1.getBytes()));
            if (StringUtils.isBlank((String)msgDigest)) {
                this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.applyCA.msgDigest:", (Object)msgDigest);
                return this.returnResult("error", "\u52a0\u5bc6\u53c2\u6570\u4e3a\u7a7a", null);
            }
        }
        catch (Exception e) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.applyCA.msgDigest:", (Object)msgDigest, (Throwable)e);
            return this.returnResult("error", "\u52a0\u5bc6\u5f02\u5e38", null);
        }
        map.put("msg_digest", msgDigest);
        String returnValue = null;
        String applyCA_url = "";
        try {
            if (StringUtils.isNotBlank((String)umUser.getTenantCode())) {
                applyCA_url = this.getUrl(umUser.getTenantCode(), "UccToFdd", "applyCAurl");
            }
            if (StringUtils.isBlank((String)(returnValue = com.yqbsoft.laser.service.tool.util.WebUtils.doPost((String)applyCA_url, map, (int)5000, (int)5000)))) {
                this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.applyCA.returnValue:", (Object)("\u8bf7\u6c42\u54cd\u5e94\u7684\u7ed3\u679creturnValue:" + returnValue + ",\u8bf7\u6c42\u5730\u5740applyCA_url\uff1a" + applyCA_url + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + ((Object)map).toString()));
                return this.returnResult("error", "\u8bf7\u6c42\u6cd5\u5927\u5927CA\u63a5\u53e3\u83b7\u53d6\u7ed3\u679c\u4e3a\u7a7a\uff01", null);
            }
        }
        catch (IOException e) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.applyCA.returnValue.e", (Object)("\u8bf7\u6c42\u5730\u5740applyCA_url\uff1a" + applyCA_url + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + ((Object)map).toString()), (Throwable)e);
            return this.returnResult("error", "\u8bf7\u6c42\u6cd5\u5927\u5927CA\u63a5\u53e3\u83b7\u53d6\u7ed3\u679c\u4e3a\u7a7a\uff01\uff01\uff01", null);
        }
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(returnValue, String.class, String.class);
        String result = (String)jsonToMap.get("result");
        if (!"success".equals(result)) {
            if ("\u8eab\u4efd\u8bc1\u53f7\u7801\u4e0d\u6b63\u786e".equals(jsonToMap.get("msg"))) {
                return this.returnResult("success", "\u8eab\u4efd\u8bc1\u53f7\u7801\u4e0d\u6b63\u786e\uff01", null);
            }
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.applyCA.result", (Object)(result + ",MSG:" + (String)jsonToMap.get("msg") + "\u8bf7\u6c42\u5730\u5740applyCA_url\uff1a" + applyCA_url + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + ((Object)map).toString()));
            return this.returnResult("error", (String)jsonToMap.get("msg"), null);
        }
        String customer_id = (String)jsonToMap.get("customer_id");
        HashMap<String, String> updateUmMap = new HashMap<String, String>();
        updateUmMap.put("userPhone", umUser.getUserPhone());
        updateUmMap.put("userCacode", customer_id);
        updateUmMap.put("tenantCode", umUser.getTenantCode());
        try {
            this.getInternalRouter().inInvoke("um.user.updateUserCacode", updateUmMap);
        }
        catch (Exception e) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.applyCA.um.user.updateUserCacode", (Object)"\u66f4\u65b0CA\u63a5\u53e3");
            return this.returnResult("error", "\u66f4\u65b0\u5931\u8d25\uff01", null);
        }
        return this.returnResult("success", "\u66f4\u65b0\u6210\u529f\uff01", null);
    }

    @Override
    public String sendContractTemplate() throws ApiException {
        APP_ID = this.getUrl("00000025", "UccToFdd", "app_id");
        APP_SECRET = this.getUrl("00000025", "UccToFdd", "app_secret");
        this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.sendContractTemplate.getUrl", (Object)("APP_ID:" + APP_ID + ",APP_SECRET:" + APP_SECRET));
        String template_id = "00000030";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String timeStamp = sdf.format(new Date());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("app_id", APP_ID);
        map.put("v", "2.0");
        map.put("timestamp", timeStamp);
        map.put("template_id", template_id);
        String msgDigest = "";
        try {
            String sha1 = FddEncryptTool.sha1(APP_ID + FddEncryptTool.md5Digest(timeStamp) + FddEncryptTool.sha1(APP_SECRET + template_id));
            msgDigest = new String(FddEncryptTool.Base64Encode(sha1.getBytes()));
            if (StringUtils.isBlank((String)msgDigest) || StringUtils.isBlank((String)sha1)) {
                this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.msgDigest||sha1:", (Object)(msgDigest + "||" + sha1));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.msgDigest:", (Object)msgDigest, (Throwable)e);
            return null;
        }
        map.put("msg_digest", msgDigest);
        HashMap<String, FileItem> fileParams = new HashMap<String, FileItem>();
        FileItem fileItem = new FileItem(new File("C:/Users/Administrator/Desktop/\u4e91\u7aef\u6d17\u70eb\u8bbe\u5907\u8d2d\u9500\u5408\u540c\u6700\u7ec8\u7248\u672c2018.pdf"));
        String returnValue = null;
        fileParams.put("file", fileItem);
        try {
            returnValue = com.yqbsoft.laser.service.tool.util.WebUtils.doPost((String)UPLOADTEMPLATE_URL, map, fileParams, (int)1000, (int)1000);
            if (StringUtils.isBlank((String)returnValue)) {
                this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.returnValue:", (Object)returnValue);
                return null;
            }
        }
        catch (IOException e) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.returnValue:", (Object)returnValue, (Throwable)e);
            return null;
        }
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(returnValue, String.class, String.class);
        System.out.println(jsonToMap);
        return (String)jsonToMap.get("result");
    }

    @Override
    public String sign(String contractBillcode, String userCode, String return_url, String tenantCode) throws ApiException {
        if (StringUtils.isEmpty((String)contractBillcode) || StringUtils.isEmpty((String)userCode) || StringUtils.isEmpty((String)tenantCode)) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.sign.params", (Object)("contractBillcode:" + contractBillcode + ",userCode:" + userCode + "," + "tenantCode:" + tenantCode));
            return this.returnResult("error", "\u53c2\u6570\u4e3a\u7a7a\uff01\uff01\uff01", null);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> contractMap = new HashMap<String, String>();
        contractMap.put("contractBillcode", contractBillcode);
        contractMap.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNormalBinder().toJson(contractMap));
        String ocContractReDomainStr = (String)this.getInternalRouter().inInvoke("oc.contract.getContractByCode", map);
        OcContractReDomain contractReDomain = (OcContractReDomain)JsonUtil.buildNonNullBinder().getJsonToObject(ocContractReDomainStr, OcContractReDomain.class);
        if (contractReDomain == null) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.sign.oc.contract.getContractByCode", (Object)"\u83b7\u53d6\u8ba2\u5355\u5bf9\u8c61\u4e3a\u7a7a");
            return this.returnResult("error", "\u8ba2\u5355\u4e0d\u5b58\u5728", null);
        }
        HashMap<String, String> createContractMap = new HashMap<String, String>();
        createContractMap.put("ocContractReDomain", JsonUtil.buildNormalBinder().toJson((Object)contractReDomain));
        createContractMap.put("userCode", userCode);
        String createCOntractStr = (String)this.getInternalRouter().inInvoke("omns.ucc.createContract", createContractMap);
        Map result = (Map)JsonUtil.buildNonNullBinder().getJsonToMap(createCOntractStr, String.class, String.class);
        String state = (String)result.get("state");
        if (!state.equals("success")) {
            String news = (String)result.get("news");
            if (news.equals("\u5bf9\u4e0d\u8d77\uff0c\u5408\u540c\u7f16\u53f7\u91cd\u590d\uff01")) {
                String compName = (String)result.get("result");
                HashMap<String, String> signContractMap = new HashMap<String, String>();
                signContractMap.put("ocContractReDomain", JsonUtil.buildNormalBinder().toJson((Object)contractReDomain));
                signContractMap.put("userCode", userCode);
                signContractMap.put("compName", compName);
                signContractMap.put("url", return_url);
                String resultStr = (String)this.getInternalRouter().inInvoke("omns.ucc.signcontract", signContractMap);
                if (StringUtils.isBlank((String)resultStr)) {
                    this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.sign.contract.sign.Url.omns.ucc.signcontract", (Object)resultStr);
                    return this.returnResult("error", null, null);
                }
                Map jsonRes = (Map)JsonUtil.buildNonNullBinder().getJsonToMap(resultStr, String.class, String.class);
                if (!"success".equals(jsonRes.get("state"))) {
                    this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.sign.contract.sign.Url.jsonRes", (Object)("MSG:" + (String)jsonRes.get("news")));
                    return this.returnResult("error", (String)jsonRes.get("news"), null);
                }
                return this.returnResult("success", "\u6210\u529f", (String)jsonRes.get("result"));
            }
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.sign.omns.ucc.createContract", (Object)(state + "|" + news));
            return this.returnResult("error", news, null);
        }
        String compName = (String)result.get("result");
        HashMap<String, String> signContractMap = new HashMap<String, String>();
        signContractMap.put("ocContractReDomain", JsonUtil.buildNormalBinder().toJson((Object)contractReDomain));
        signContractMap.put("userCode", userCode);
        signContractMap.put("compName", compName);
        signContractMap.put("url", return_url);
        String resultStr = (String)this.getInternalRouter().inInvoke("omns.ucc.signcontract", signContractMap);
        if (StringUtils.isBlank((String)resultStr)) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.sign.contract.signUrl.omns.ucc.signcontract", (Object)resultStr);
            return this.returnResult("error", null, null);
        }
        Map jsonRes = (Map)JsonUtil.buildNonNullBinder().getJsonToMap(resultStr, String.class, String.class);
        if (!"success".equals(jsonRes.get("state"))) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.sign.Url.jsonRes", (Object)("MSG:" + (String)jsonRes.get("news")));
            return this.returnResult("error", (String)jsonRes.get("news"), null);
        }
        return this.returnResult("success", "\u6210\u529f", (String)jsonRes.get("result"));
    }

    @Override
    public String creatContract(OcContractReDomain ocContractReDomain, String userCode) throws ApiException {
        if (StringUtils.isBlank((String)userCode)) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.creatContract.userCode", (Object)userCode);
            return this.returnResult("error", "userCode\u4e3a\u7a7a\uff01", null);
        }
        if (ocContractReDomain == null) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.creatContract.ocContractReDomain", (Object)ocContractReDomain);
            return this.returnResult("error", "ocContractReDomain\u4e3a\u7a7a\uff01", null);
        }
        HashMap<String, String> umMap = new HashMap<String, String>();
        umMap.put("userCode", userCode);
        umMap.put("tenantCode", ocContractReDomain.getTenantCode());
        String umuserStr = (String)this.getInternalRouter().inInvoke("um.user.getUserByUserCode", umMap);
        UmUser umUser = (UmUser)JsonUtil.buildNonNullBinder().getJsonToObject(umuserStr, UmUser.class);
        if (umUser == null) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.creatContract.umUser", (Object)umUser);
            return this.returnResult("error", "\u6839\u636euserCode\u67e5\u8be2\u4e0d\u5230\uff01", null);
        }
        if (StringUtils.isBlank((String)umUser.getUserCacode())) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.creatContract.umUser.CA", (Object)umUser.getUserCacode());
            return this.returnResult("error", "\u8be5\u7528\u6237\u4e0d\u5b58\u5728CA\uff01", null);
        }
        HashMap<String, String> userInfomap = new HashMap<String, String>();
        userInfomap.put("userinfoCode", umUser.getUserPcode());
        userInfomap.put("tenantCode", umUser.getTenantCode());
        String umUserInfoStr = (String)this.getInternalRouter().inInvoke("um.user.getUserinfoByUserCode", userInfomap);
        UmUserinfo umUserinfo = (UmUserinfo)JsonUtil.buildNonNullBinder().getJsonToObject(umUserInfoStr, UmUserinfo.class);
        if (umUserinfo == null) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.creatContract.umUserinfo", (Object)umUserinfo.toString());
            return this.returnResult("error", "\u8be5\u7528\u6237\u4e0d\u5b58\u5728\uff01", null);
        }
        String template_id = "";
        String compName = "";
        String jsonParam = "";
        HashMap<String, String> contractGoodsMap = new HashMap<String, String>();
        HashMap<String, String> contractGoodsMapStr = new HashMap<String, String>();
        contractGoodsMapStr.put("contractBillcode", ocContractReDomain.getContractBillcode());
        contractGoodsMapStr.put("tenantCode", ocContractReDomain.getTenantCode());
        contractGoodsMap.put("map", JsonUtil.buildNormalBinder().toJson(contractGoodsMapStr));
        String ocCorDerGoodsListStr = (String)this.getInternalRouter().inInvoke("oc.corderGoods.queryCorderGoodsByBillcode", contractGoodsMap);
        if (StringUtils.isBlank((String)ocCorDerGoodsListStr)) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.creatContract.creatContract", (Object)("\u6839\u636e\u8ba2\u5355\u53f7\u67e5\u8be2\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728\uff01\uff0c\u4f20\u5165\u53c2\u6570\u4e3acontractGoodsMap\uff1a" + ((Object)contractGoodsMap).toString()));
            return this.returnResult("error", "\u6839\u636e\u8ba2\u5355\u53f7\u67e5\u8be2\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728\uff01", null);
        }
        List ocCorDerGoodsList = (List)JsonUtil.buildNonNullBinder().getJsonToList(ocCorDerGoodsListStr, OcContractGoods.class);
        ArrayList paramList = new ArrayList();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        ArrayList paramdata = new ArrayList();
        int i = 0;
        BigDecimal sumGoodsCamount = new BigDecimal(0);
        boolean flag = false;
        for (OcContractGoods ocContractGoods : ocCorDerGoodsList) {
            String cacheKey;
            String memberCcode = "";
            if (StringUtils.isNotBlank((String)ocContractGoods.getTenantCode()) && StringUtils.isBlank((String)(memberCcode = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(cacheKey = ocContractGoods.getTenantCode().concat("-").concat("UccToFdd").concat("-").concat(ocContractGoods.getMemberCcode())))))) {
                this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.creatContract.memberCcode", (Object)("\u7f13\u5b58memberCcode\u4e3a\u7a7a\uff01\uff01\uff01memberCcode\uff1a" + memberCcode));
                return this.returnResult("error", "\u8bbe\u5907\u5408\u540c\u751f\u6210\u5931\u8d25\uff01\uff01\uff01\uff01", null);
            }
            if (memberCcode.equals(ocContractGoods.getMemberCcode())) {
                if (StringUtils.isBlank((String)jsonParam)) {
                    template_id = "00000030";
                    compName = "\u8bbe\u5907\u5408\u540c";
                    jsonParam = this.createDeviceParma(umUserinfo, ocContractReDomain);
                    if ("false".equals(jsonParam)) {
                        this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.creatContract.template_id", (Object)("\u8bbe\u5907\u5408\u540c" + template_id));
                        return this.returnResult("error", "\u8bbe\u5907\u5408\u540c\u751f\u6210\u5931\u8d25\uff01\uff01\uff01\uff01", null);
                    }
                }
                ArrayList<Object> paramStringList = new ArrayList<Object>();
                paramStringList.add(String.valueOf(++i));
                paramStringList.add(ocContractGoods.getSkuNo());
                paramStringList.add(ocContractGoods.getGoodsName() + ocContractGoods.getGoodsSpec());
                if (ocContractGoods.getGoodsCamount() != null) {
                    paramStringList.add(ocContractGoods.getGoodsCamount().setScale(2));
                    sumGoodsCamount = sumGoodsCamount.add(ocContractGoods.getGoodsCamount().setScale(2));
                }
                if (StringUtils.isBlank((String)ocContractGoods.getPartsnameNumunit())) {
                    paramStringList.add("\u53f0");
                } else {
                    paramStringList.add(ocContractGoods.getPartsnameNumunit());
                }
                paramStringList.add(ocContractGoods.getMemo());
                paramdata.add(paramStringList);
                flag = true;
                continue;
            }
            if ("07".equals(ocContractGoods.getGoodsType())) {
                template_id = "00000027";
                compName = "\u52a0\u76df\u5408\u540c";
                jsonParam = this.createJoinParma(umUserinfo, ocContractReDomain);
                if (!"false".equals(jsonParam)) continue;
                this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.creatContract.template_id", (Object)("\u52a0\u76df\u5408\u540c" + template_id));
                return this.returnResult("error", "\u52a0\u76df\u5408\u540c\u751f\u6210\u5931\u8d25\uff01\uff01\uff01\uff01", null);
            }
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.creatContract.template_id", (Object)("\u6ca1\u6709\u5bf9\u5e94\u6a21\u677f\uff01\uff01\uff01template_id\uff1a" + template_id));
            return this.returnResult("error", "\u6ca1\u6709\u5bf9\u5e94\u6a21\u677f\uff01\uff01\uff01\uff01", null);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (flag) {
            ArrayList<Object> paramStringList = new ArrayList<Object>();
            paramStringList.clear();
            paramStringList.add("\u5408\u8ba1");
            paramStringList.add("");
            paramStringList.add("");
            paramStringList.add(sumGoodsCamount);
            paramStringList.add("");
            paramStringList.add("");
            paramdata.add(paramStringList);
            paramMap.put("datas", paramdata);
            ArrayList<String> paramHeadersList = new ArrayList<String>();
            paramHeadersList.add("\u5e8f\u53f7");
            paramHeadersList.add("\u8d27\u53f7");
            paramHeadersList.add("\u54c1\u540d");
            paramHeadersList.add("\u6570\u91cf");
            paramHeadersList.add("\u5355\u4f4d");
            paramHeadersList.add("\u8bbe\u5907\u5b9a\u5236\u8981\u6c42");
            paramMap.put("headers", paramHeadersList);
            ArrayList<Integer> paramcolWidthPercentList = new ArrayList<Integer>();
            paramcolWidthPercentList.add(1);
            paramcolWidthPercentList.add(2);
            paramcolWidthPercentList.add(4);
            paramcolWidthPercentList.add(1);
            paramcolWidthPercentList.add(1);
            paramcolWidthPercentList.add(3);
            paramMap.put("colWidthPercent", paramcolWidthPercentList);
            paramMap.put("cellHeight", 30);
            paramMap.put("cellHorizontalAlignment", 0);
            paramMap.put("cellVerticalAlignment", 5);
            paramMap.put("insertWay", 1);
            paramMap.put("keyword", "\u914d\u7f6e\u660e\u7ec6\u5982");
            paramMap.put("theFirstHeader", "  ");
            paramMap.put("insertWay", 1);
            paramMap.put("tableWidth", 85);
            paramList.add(paramMap);
            map.put("dynamic_tables", JsonUtil.buildNormalBinder().toJson(paramList));
        }
        if (StringUtils.isNotBlank((String)ocContractReDomain.getTenantCode())) {
            APP_ID = this.getUrl(ocContractReDomain.getTenantCode(), "UccToFdd", "app_id");
            APP_SECRET = this.getUrl(ocContractReDomain.getTenantCode(), "UccToFdd", "app_secret");
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.creatContract.getUrl", (Object)("APP_ID:" + APP_ID + ",APP_SECRET:" + APP_SECRET + ",TenantCode\uff1a" + ocContractReDomain.getTenantCode()));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String timeStamp = sdf.format(new Date());
        map.put("app_id", APP_ID);
        map.put("v", "2.0");
        map.put("timestamp", timeStamp);
        map.put("font_size", "16");
        map.put("font_type", "2");
        map.put("doc_title", compName);
        map.put("template_id", template_id);
        String contracct_id = ocContractReDomain.getContractBillcode();
        map.put("contract_id", contracct_id);
        map.put("parameter_map", jsonParam);
        String msgDigest = "";
        try {
            String sha1 = FddEncryptTool.sha1(APP_ID + FddEncryptTool.md5Digest(timeStamp) + FddEncryptTool.sha1(APP_SECRET + template_id + contracct_id) + jsonParam);
            msgDigest = new String(FddEncryptTool.Base64Encode(sha1.getBytes()));
            if (StringUtils.isBlank((String)msgDigest) || StringUtils.isBlank((String)sha1)) {
                this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.creatContract.msgDigest||sha1:", (Object)(msgDigest + "||" + sha1));
                return this.returnResult("error", "\u5931\u8d25", msgDigest);
            }
        }
        catch (Exception e) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.creatContract.msgDigest:", (Object)msgDigest, (Throwable)e);
            return this.returnResult("error", "\u5931\u8d25", null);
        }
        map.put("msg_digest", msgDigest);
        String returnValue = null;
        String generateContractUrl = "";
        try {
            if (StringUtils.isNotBlank((String)umUser.getTenantCode())) {
                generateContractUrl = this.getUrl(umUser.getTenantCode(), "UccToFdd", "generateContractUrl");
            }
            if (StringUtils.isBlank((String)(returnValue = com.yqbsoft.laser.service.tool.util.WebUtils.doPost((String)generateContractUrl, map, (int)100000, (int)100000)))) {
                this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.creatContract.WebUtils", (Object)("\u54cd\u5e94\u7ed3\u679c\u4e3a\u7a7a\uff01\uff01\uff01returnValue:" + returnValue + "\u8bf7\u6c42\u5730\u5740generateContractUrl\uff1a" + generateContractUrl + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + ((Object)map).toString()));
                return this.returnResult("error", "\u5931\u8d25", returnValue);
            }
        }
        catch (IOException e) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.creatContract.WebUtils.e", (Object)("\u8bf7\u6c42\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u5730\u5740generateContractUrl\uff1a" + generateContractUrl + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + map), (Throwable)e);
            return this.returnResult("error", "\u5931\u8d25", null);
        }
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(returnValue, String.class, String.class);
        if (!"success".equals(jsonToMap.get("result"))) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.creatContract.returnValue", (Object)("\u8fd4\u56de\u503creturnValue\uff1a" + returnValue + "\uff0c\u8bf7\u6c42\u5730\u5740generateContractUrl\uff1a" + generateContractUrl + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + map));
            return this.returnResult((String)jsonToMap.get("result"), (String)jsonToMap.get("msg"), compName);
        }
        return this.returnResult((String)jsonToMap.get("result"), (String)jsonToMap.get("msg"), compName);
    }

    @Override
    public String signContract(OcContractReDomain ocContractReDomain, String userCode, String compName, String url) throws ApiException {
        if (ocContractReDomain == null || StringUtils.isBlank((String)userCode) || StringUtils.isBlank((String)compName)) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.signContract.inParam", (Object)("ocContractReDomain:" + ocContractReDomain + "|userCode:" + userCode + "|compName:" + compName));
            return this.returnResult("error", "signContract\u65b9\u6cd5\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a\uff01", null);
        }
        HashMap<String, String> umuserMap = new HashMap<String, String>();
        umuserMap.put("userCode", userCode);
        umuserMap.put("tenantCode", ocContractReDomain.getTenantCode());
        String umuserStr = (String)this.getInternalRouter().inInvoke("um.user.getUserByUserCode", umuserMap);
        UmUser umUser = (UmUser)JsonUtil.buildNonNullBinder().getJsonToObject(umuserStr, UmUser.class);
        if (umUser == null) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.signContract.umUser", (Object)umUser);
            return this.returnResult("error", "\u6839\u636euserCode\u67e5\u8be2\u4e0d\u5230\uff01", null);
        }
        if (StringUtils.isBlank((String)umUser.getUserCacode())) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.signContract.umUser.CA", (Object)umUser.getUserCacode());
            return this.returnResult("error", "\u8be5\u7528\u6237\u4e0d\u5b58\u5728CA\uff01", null);
        }
        String notify_url = "";
        if (StringUtils.isNotBlank((String)ocContractReDomain.getTenantCode())) {
            notify_url = this.getUrl(ocContractReDomain.getTenantCode(), "UccToFdd", "notifyUrl");
        }
        if (StringUtils.isBlank((String)notify_url)) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.signContract.returnGoods.ADD_URL", (Object)("\u8bf7\u6c42\u5730\u5740\u4e3a\u7a7a\uff01\uff01\uff01notify_url\uff1a" + notify_url + ",\u8bf7\u6c42\u53c2\u6570\u4e3atenantCode\uff1a" + ocContractReDomain.getTenantCode() + "," + "flagSettingType:UccToFdd,flagSettingCode:notifyUrl"));
            return this.returnResult("error", "notify_url\u5f02\u6b65\u901a\u77e5\u5730\u5740\u4e3a\u7a7a\uff01\uff01\uff01", null);
        }
        if (StringUtils.isNotBlank((String)ocContractReDomain.getTenantCode())) {
            APP_ID = this.getUrl(ocContractReDomain.getTenantCode(), "UccToFdd", "app_id");
            APP_SECRET = this.getUrl(ocContractReDomain.getTenantCode(), "UccToFdd", "app_secret");
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.signContract.getUrl", (Object)("APP_ID:" + APP_ID + ",APP_SECRET:" + APP_SECRET + ",TenantCode\uff1a" + ocContractReDomain.getTenantCode()));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String timeStamp = sdf.format(new Date());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("app_id", APP_ID);
        map.put("v", "2.0");
        map.put("timestamp", timeStamp);
        map.put("transaction_id", ocContractReDomain.getContractBillcode());
        map.put("contract_id", ocContractReDomain.getContractBillcode());
        map.put("customer_id", umUser.getUserCacode());
        map.put("doc_title", compName);
        map.put("return_url", url);
        map.put("notify_url", notify_url);
        String msgDigest = "";
        try {
            String sha1 = FddEncryptTool.sha1(APP_ID + FddEncryptTool.md5Digest(ocContractReDomain.getContractBillcode() + timeStamp) + FddEncryptTool.sha1(APP_SECRET + umUser.getUserCacode()));
            msgDigest = new String(FddEncryptTool.Base64Encode(sha1.getBytes()));
        }
        catch (Exception e) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.signContract.msgDigest", (Object)"\u9a8c\u7b7e\u5931\u8d25\uff01\uff01\uff01");
            return this.returnResult("error", "\u9a8c\u7b7e\u5931\u8d25\uff01", null);
        }
        map.put("msg_digest", msgDigest);
        String params = "";
        try {
            params = com.yqbsoft.laser.service.tool.util.WebUtils.buildQuery(map, (String)"UTF-8");
            if (StringUtils.isBlank((String)params)) {
                this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.signContract.params", (Object)("\u8bf7\u6c42\u53c2\u6570,params:" + params));
                return this.returnResult("error", "\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\uff01\uff01", null);
            }
        }
        catch (IOException e) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.signContract.WebUtils", (Object)"\u8bf7\u6c42\u5931\u8d25\uff01\uff01\uff01", (Throwable)e);
            return this.returnResult("error", "\u8bf7\u6c42\u5931\u8d25\uff01\uff01", null);
        }
        String extsignUrl = "";
        if (StringUtils.isNotBlank((String)umUser.getTenantCode())) {
            extsignUrl = this.getUrl(umUser.getTenantCode(), "UccToFdd", "extsignUrl");
        }
        if (StringUtils.isBlank((String)extsignUrl)) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.signContract", (Object)("\u83b7\u53d6\u7684extsignUrl\u4e3a\u7a7a\uff0cextsignUrl:" + extsignUrl + "," + "\u83b7\u53d6\u5730\u5740\u4f20\u5165\u53c2\u6570\uff01\uff01\uff01tenantCode:" + umUser.getTenantCode() + ",flagSettingType:UccToFdd," + "flagSettingCode:extsignUrl"));
        }
        String address = extsignUrl + "?" + params;
        return this.returnResult("success", "\u8bf7\u6c42\u6210\u529f\uff01\uff01", address);
    }

    @Override
    public String contractQuery(String contract_id, String customer_id) throws ApiException {
        contract_id = "110202000110";
        customer_id = "EBCF0CFC46FE0D3756CBDB7BA1CC4137";
        String app_id = "401755";
        APP_ID = this.getUrl("00000025", "UccToFdd", "app_id");
        APP_SECRET = this.getUrl("00000025", "UccToFdd", "app_secret");
        this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.contractQuery.getUrl", (Object)("APP_ID:" + APP_ID + ",APP_SECRET:" + APP_SECRET + ",TenantCode\uff1a" + "00000025"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        HashMap<String, String> map = new HashMap<String, String>();
        String timestamp = sdf.format(new Date());
        String sha1 = null;
        map.put("app_id", app_id);
        map.put("v", "2.0");
        map.put("timestamp", timestamp);
        map.put("contract_id", contract_id);
        map.put("customer_id", customer_id);
        try {
            sha1 = FddEncryptTool.sha1(app_id + FddEncryptTool.md5Digest(timestamp) + FddEncryptTool.sha1(APP_SECRET + contract_id + customer_id));
        }
        catch (Exception e) {
            // empty catch block
        }
        String msgDigest = new String(FddEncryptTool.Base64Encode(sha1.getBytes()));
        map.put("msg_digest", msgDigest);
        String returnValue = null;
        try {
            returnValue = WebUtils.doPost(QUERYPACT_URL, map, 1000, 1000);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (StringUtils.isBlank(returnValue)) {
            // empty if block
        }
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(returnValue, String.class, String.class);
        System.out.println(jsonToMap);
        return (String)jsonToMap.get("result");
    }

    @Override
    public String fddtouccNotice(String transaction_id, String contract_id, String result_code, String result_desc, String download_url, String viewpdf_url, String timestamp, String msg_digest, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)transaction_id) && StringUtils.isBlank((String)contract_id) && StringUtils.isBlank((String)result_code) && StringUtils.isBlank((String)result_desc) && StringUtils.isBlank((String)download_url) && StringUtils.isBlank((String)viewpdf_url) && StringUtils.isBlank((String)timestamp) && StringUtils.isBlank((String)msg_digest)) {
            return "\u516c\u5171\u53c2\u6570\u9519\u8bef";
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            tenantCode = "00000025";
        }
        if (StringUtils.isNotBlank((String)tenantCode)) {
            APP_ID = this.getUrl(tenantCode, "UccToFdd", "app_id");
            APP_SECRET = this.getUrl(tenantCode, "UccToFdd", "app_secret");
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.fddtouccNotice.getUrl", (Object)("APP_ID:" + APP_ID + ",APP_SECRET:" + APP_SECRET + ",TenantCode\uff1a" + tenantCode));
        }
        String sha1 = "";
        try {
            sha1 = FddEncryptTool.sha1(APP_ID + FddEncryptTool.md5Digest(timestamp) + FddEncryptTool.sha1(APP_SECRET + transaction_id));
        }
        catch (Exception e) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.sha1", (Object)"\u9a8c\u7b7e\u5931\u8d25\uff01\uff01");
            return "500";
        }
        String msgDigest = new String(FddEncryptTool.Base64Encode(sha1.getBytes()));
        if (!msgDigest.equals(msg_digest)) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.fddtouccNotice.sign", (Object)("transaction_id=" + transaction_id + "contract_id=" + contract_id + "result_code=" + result_code + "result_desc=" + result_desc + "download_url=" + download_url + "timestamp=" + timestamp + "msg_digest=" + msg_digest));
            return "\u9a8c\u7b7e\u5931\u8d25";
        }
        if (StringUtils.isBlank((String)viewpdf_url)) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImplState", (Object)(contract_id + "\u5408\u540c\u7b7e\u7f72\u5931\u8d25" + "\u65b9\u6cd5\u5165\u53c2\uff1a" + "transaction_id=" + transaction_id + ",contract_id=" + contract_id + ",result_code=" + result_code + ",result_desc=" + result_desc + ",download_url=" + download_url + "viewpdf_url:" + viewpdf_url + ",timestamp=" + timestamp + ",msg_digest=" + msg_digest + ",tenantCode:" + tenantCode));
            return "500";
        }
        HashMap<String, String> contractMap = new HashMap<String, String>();
        contractMap.put("contractBillcode", contract_id);
        contractMap.put("tenantCode", tenantCode);
        contractMap.put("contractEcurl", viewpdf_url);
        contractMap.put("dataState", "2");
        contractMap.put("oldDataState", "1");
        try {
            this.getInternalRouter().inInvoke("oc.contract.updateContractEcflagstate", contractMap);
        }
        catch (Exception e) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.fddtouccNotice.updateContractEcflagstate", (Object)("\u66f4\u65b0\u8ba2\u5355\u7b7e\u7f72\u5408\u540c\u72b6\u6001\u5931\u8d25!\u4f20\u5165\u53c2\u6570\u4e3a\uff1acontractBillcode\uff1a" + contract_id + ",tenantCode:" + tenantCode + ",contractEcurl" + viewpdf_url + ",dataState:2\uff0coldDataState:1"));
            return "500";
        }
        String result = this.contractFiling(contract_id, tenantCode);
        if (!"success".equals(result)) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.fddtouccNotice.contractFiling", (Object)"\u5408\u540c\u5f52\u6863\u5931\u8d25\uff01\uff01\uff01");
            return "500";
        }
        this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.fddtouccNotice.result", (Object)("result:" + result));
        return "200";
    }

    public String contractFiling(String contract_id, String tenantCode) throws ApiException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        HashMap<String, String> map = new HashMap<String, String>();
        String timestamp = sdf.format(new Date());
        if (StringUtils.isNotBlank((String)tenantCode)) {
            APP_ID = this.getUrl(tenantCode, "UccToFdd", "app_id");
            APP_SECRET = this.getUrl(tenantCode, "UccToFdd", "app_secret");
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.fddtouccNotice.contractFiling.getUrl", (Object)("APP_ID:" + APP_ID + ",APP_SECRET:" + APP_SECRET + ",TenantCode\uff1a" + tenantCode));
        }
        String sha1 = null;
        try {
            sha1 = FddEncryptTool.sha1(APP_ID + FddEncryptTool.md5Digest(timestamp) + FddEncryptTool.sha1(APP_SECRET + contract_id));
        }
        catch (Exception e) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.fddtouccNotice.contractFiling", (Object)"\u9a8c\u7b7e\u5931\u8d25\uff01\uff01\uff01");
            return "error";
        }
        String contractfiling_url = "";
        if (StringUtils.isNotBlank((String)tenantCode)) {
            contractfiling_url = this.getUrl(tenantCode, "UccToFdd", "contractfiling_url");
        }
        if (StringUtils.isBlank((String)contractfiling_url)) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl..fddtouccNotice.contractFiling.contractfiling_url", (Object)("\u8bf7\u6c42\u5730\u5740\u4e3a\u7a7a\uff01\uff01\uff01contractfiling_url\uff1a" + contractfiling_url + ",\u8bf7\u6c42\u53c2\u6570\u4e3atenantCode\uff1a" + tenantCode + "," + "flagSettingType:UccToFdd,flagSettingCode:contractfiling_url"));
            return "error";
        }
        String msgDigest = new String(FddEncryptTool.Base64Encode(sha1.getBytes()));
        map.put("app_id", APP_ID);
        map.put("v", "2.0");
        map.put("timestamp", timestamp);
        map.put("contract_id", contract_id);
        map.put("msg_digest", msgDigest);
        String returnValue = null;
        try {
            returnValue = com.yqbsoft.laser.service.tool.util.WebUtils.doPost((String)contractfiling_url, map, (int)1000, (int)1000);
            if (StringUtils.isBlank((String)returnValue)) {
                this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.fddtouccNotice.contractFiling.returnValue", (Object)("\u54cd\u5e94\u7ed3\u679c\uff01\uff01\uff01returnValue\uff1a" + returnValue + ",\u8bf7\u6c42\u5730\u5740contractfiling_url\uff1a" + contractfiling_url + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + map));
                return "error";
            }
        }
        catch (IOException e) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.fddtouccNotice.contractFiling.doPost.e", (Object)("\u8bf7\u6c42\u5730\u5740contractfiling_url\uff1a" + contractfiling_url + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + map));
            return "error";
        }
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(returnValue, String.class, String.class);
        String result = (String)jsonToMap.get("result");
        if (!"success".equals(result)) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.fddtouccNotice.contractFiling", (Object)("\u5f52\u6863\u5931\u8d25\uff01\uff01\uff01msg\uff1a" + (String)jsonToMap.get("msg") + ",code:" + (String)jsonToMap.get("code")));
            return "error";
        }
        return result;
    }

    private String createDeviceParma(UmUserinfo umUserinfo, OcContractReDomain ocContractReDomain) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("buyer_name", umUserinfo.getUserinfoCorp());
        map.put("buyer_identification_card", umUserinfo.getUserinfoCoid());
        map.put("contract_number", ocContractReDomain.getContractBillcode());
        if (ocContractReDomain.getContractMoney() == null) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.createDeviceParma", (Object)("\u8bbe\u5907\u5408\u540cContractBillcode:" + ocContractReDomain.getContractBillcode()));
            return "false";
        }
        map.put("order_amount", ocContractReDomain.getContractMoney().setScale(2, 5).toString());
        Date gmtCreate = ocContractReDomain.getGmtCreate();
        if (gmtCreate == null) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.createDeviceParma", (Object)("\u8bbe\u5907\u5408\u540c\u65f6\u95f4GmtCreate:" + gmtCreate));
            return "false";
        }
        SimpleDateFormat dd = new SimpleDateFormat("yyyy-MM-dd");
        String[] time = dd.format(gmtCreate).split("-");
        map.put("seller_signing_year", time[0]);
        map.put("seller_signing_month", time[1]);
        map.put("seller_signing_day", time[2]);
        map.put("buyer_signing_year", time[0]);
        map.put("buyer_signing_month", time[1]);
        map.put("buyer_signing_day", time[2]);
        map.put("buyer_addr", umUserinfo.getCompanyAddress());
        map.put("seller_legal_person", null);
        map.put("buyer_legal_persion", umUserinfo.getUserinfoCorp());
        map.put("seller_agent_person", null);
        map.put("buyer_agent_person", null);
        map.put("seller_tel", null);
        map.put("buyer_tel", umUserinfo.getUserinfoPhone());
        map.put("seller_email", null);
        map.put("buyer_email", umUserinfo.getUserinfoEmail());
        return JsonUtil.buildNormalBinder().toJson(map);
    }

    private String createJoinParma(UmUserinfo umUserinfo, OcContractReDomain ocContractReDomain) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("serial_number", ocContractReDomain.getContractBillcode());
        map.put("contract_no", ocContractReDomain.getContractBillcode());
        map.put("second_party", umUserinfo.getUserinfoCorp());
        map.put("accommodation", umUserinfo.getCompanyAddress());
        map.put("phone", umUserinfo.getUserinfoPhone());
        map.put("legal_representative", umUserinfo.getUserinfoCorp());
        map.put("registration_number", null);
        Date gmtCreate = ocContractReDomain.getGmtCreate();
        if (gmtCreate == null) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.createJoinParma", (Object)("\u8bbe\u5907\u5408\u540c\u65f6\u95f4GmtCreate:" + gmtCreate));
            return "false";
        }
        SimpleDateFormat dd = new SimpleDateFormat("yyyy-MM-dd");
        String[] tm = dd.format(gmtCreate).toString().split("-");
        map.put("year", tm[0]);
        map.put("month", tm[1]);
        map.put("day", tm[2]);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(gmtCreate);
        calendar.add(1, 3);
        calendar.add(5, -1);
        Date resultDate = calendar.getTime();
        if (resultDate == null) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.createJoinParma", (Object)("\u8bbe\u5907\u5408\u540c\u65f6\u95f4resultDate:" + resultDate));
            return "false";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String[] time = sdf.format(resultDate).split("-");
        map.put("year_1", time[0]);
        map.put("month_1", time[1]);
        map.put("day_1", time[2]);
        map.put("province", umUserinfo.getCityCode());
        map.put("county", umUserinfo.getAreaCode());
        map.put("adress_1", umUserinfo.getRoadName());
        map.put("month_3", time[1]);
        map.put("day_3", time[2]);
        map.put("money", null);
        map.put("account", null);
        map.put("account_1", null);
        map.put("other", null);
        map.put("second_party_email", umUserinfo.getUserinfoEmail());
        map.put("relation_1", null);
        map.put("second_party_3", null);
        map.put("adress_2", umUserinfo.getCompanyAddress());
        map.put("postal_code", null);
        map.put("relation_1", umUserinfo.getUserinfoCorp());
        map.put("phone_2", umUserinfo.getUserinfoPhone());
        map.put("facsimile", null);
        map.put("first_party", null);
        map.put("yifang", umUserinfo.getUserinfoCorp());
        map.put("shoupingdaibiao", null);
        map.put("shouquandaibiao_1", null);
        Date gmtCreate1 = ocContractReDomain.getGmtCreate();
        if (gmtCreate1 == null) {
            this.logger.error("adapter.ucc.service.impl.UccToFddServiceImpl.createJoinParma", (Object)("\u8bbe\u5907\u5408\u540c\u65f6\u95f4gmtCreate1:" + gmtCreate1));
            return "false";
        }
        String tim = gmtCreate1.toString();
        map.put("date_2", tim);
        map.put("date_1", tim);
        map.put("qianyu_2", tim);
        map.put("qianyu_1", tim);
        return JsonUtil.buildNormalBinder().toJson(map);
    }

    private String returnResult(String state, String news, String params) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("state", state);
        map.put("news", news);
        map.put("result", params);
        return JsonUtil.buildNormalBinder().toJson(map);
    }

    private String getUrl(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    public static void main(String[] args) {
        OcContractReDomain ocContractReDomain = new OcContractReDomain();
        ocContractReDomain.setContractMoney(new BigDecimal(11.625));
        ocContractReDomain.getContractMoney().setScale(2, 5);
        System.out.println("=======");
    }
}

