/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.webshop.service;

import com.yqbsoft.laser.service.adapter.webshop.domain.DownloadFileDomainBean;
import com.yqbsoft.laser.service.adapter.webshop.domain.FmFileDomainBean;
import com.yqbsoft.laser.service.adapter.webshop.domain.FmFileReDomainBean;
import com.yqbsoft.laser.service.adapter.webshop.service.FileService;
import com.yqbsoft.laser.service.adapter.webshop.utils.FtpClientUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.file.FileBean;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;

public class FileServiceImpl
extends BaseServiceImpl
implements FileService {
    @Override
    public void uploadFile(byte[] bytes, String fileName, String userCode, String fileType, String path, String tenantCode) {
        if (bytes == null || bytes.length <= 0 || StringUtils.isBlank((String)fileName) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("FileServiceImol.exportComExcel.saveExcel", (Object)(bytes.length + "-" + fileName + "-" + userCode + "-" + "-" + fileType + "-" + tenantCode));
            return;
        }
        FmFileReDomainBean fmFileReDomainBean = new FmFileReDomainBean();
        fmFileReDomainBean.setFileName(fileName);
        fmFileReDomainBean.setFileOwner(userCode);
        fmFileReDomainBean.setFileType("0");
        fmFileReDomainBean.setFileContext(bytes);
        fmFileReDomainBean.setFlag(true);
        fmFileReDomainBean.setRootPath(path);
        FileBean fileBean = new FileBean();
        fileBean.setBytes(bytes);
        fileBean.setFileType(fileType);
        fileBean.setOriginalFilename(fileName);
        fileBean.setSize(Long.valueOf(1L));
        this.saveFile(fileBean, tenantCode, "FILE_11", fmFileReDomainBean);
    }

    private FmFileReDomainBean saveFile(FileBean fileBean, String tenantCode, String fileSort, FmFileDomainBean FmFileDomainBeanBean) {
        if (null == FmFileDomainBeanBean || null == fileBean) {
            this.logger.error("SpringmvnNewController.exportComExcel.saveFile", (Object)"param is null");
            return null;
        }
        FmFileReDomainBean fmFileReDomainBean = null;
        try {
            String fileUrl;
            HashMap<String, String> map = new HashMap<String, String>();
            FmFileDomainBeanBean.setFileType("0");
            FmFileDomainBeanBean.setFileSort(StringUtils.isBlank((String)fileSort) ? "FILE_02" : fileSort);
            FmFileDomainBeanBean.setTenantCode(tenantCode);
            FmFileDomainBeanBean.setRootPath(tenantCode + "/");
            ArrayList<FileBean> fileBeanList = new ArrayList<FileBean>();
            fileBeanList.add(fileBean);
            map.put("fmFileDomainBean", JsonUtil.buildNormalBinder().toJson((Object)FmFileDomainBeanBean));
            map.put("fileBeanList", JsonUtil.buildNormalBinder().toJson(fileBeanList));
            String key = "filePath";
            String settingType = "0";
            String fmFileJson = (String)this.getInternalRouter().inInvoke("fm.file.saveFile", map);
            fmFileReDomainBean = (FmFileReDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(fmFileJson, FmFileReDomainBean.class);
            String httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-" + settingType + "-" + key));
            if (StringUtils.isBlank((String)httpPath)) {
                httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)("00000000-" + settingType + "-" + key));
            }
            if (StringUtils.isNotBlank((String)(fileUrl = fmFileReDomainBean.getFileUrl()))) {
                String separator = System.getProperties().getProperty("file.separator");
                if (fileUrl.startsWith("/") || fileUrl.startsWith("\\")) {
                    separator = "";
                }
                fmFileReDomainBean.setFileUrl(httpPath + separator + fileUrl);
            }
            fmFileReDomainBean.setRootPath(fileUrl);
        }
        catch (Exception e) {
            this.logger.error("SpringmvnNewController.exportComExcel.saveFile", (Object)"Exception");
            return null;
        }
        return fmFileReDomainBean;
    }

    @Override
    public DownloadFileDomainBean downloadFileByName(String fileName, String tenantCode) {
        if (StringUtils.isBlank((String)fileName) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fileName", fileName);
        map.put("tenantCode", tenantCode);
        String str = (String)this.getInternalRouter().inInvoke("fm.file.downloadFileByName", map);
        return (DownloadFileDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(str, DownloadFileDomainBean.class);
    }

    @Override
    public DownloadFileDomainBean downloadFileDirect(String filePath, String tenantCode) {
        if (StringUtils.isBlank((String)filePath) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("filePath", filePath);
        map.put("tenantCode", tenantCode);
        String str = (String)this.getInternalRouter().inInvoke("fm.file.downloadFileDirect", map);
        return (DownloadFileDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(str, DownloadFileDomainBean.class);
    }

    @Override
    public boolean deleteFileDirect(String filePath, String fileName, String tenantCode) {
        if (StringUtils.isBlank((String)filePath) || StringUtils.isBlank((String)fileName)) {
            return false;
        }
        return FtpClientUtil.deleteFile("", 80, "", "", filePath + "/" + fileName);
    }
}

