/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.webshop.utils;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.file.FileBean;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class FtpClientUtil {
    public static boolean uploadFile(String url, int port, String username, String password, String path, String filename, String encoding, InputStream input) {
        boolean success = false;
        FTPClient ftp = null;
        try {
            ftp = FtpClientUtil.createFtp(url, port, username, password, path, encoding);
            if (null == ftp) {
                boolean bl = success;
                return bl;
            }
            success = ftp.storeFile(filename, input);
            input.close();
            ftp.logout();
            success = true;
        }
        catch (IOException e) {
            throw new ApiException("uploadFile", "==ftp uploadFile==", (Throwable)e);
        }
        finally {
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException ioe) {
                    throw new ApiException("uploadFile", "==ftp disconnect==", (Throwable)ioe);
                }
            }
        }
        return success;
    }

    public static FTPClient createFtp(String url, int port, String username, String password, String path, String encoding) {
        FTPClient ftp = new FTPClient();
        try {
            ftp.connect(url, port);
            if (!ftp.login(username, password)) {
                throw new ApiException("createFtp", "==ftp login faile==" + username);
            }
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                ftp.disconnect();
                return null;
            }
            if (StringUtils.isBlank((String)encoding)) {
                encoding = "UTF-8";
            }
            ftp.setControlEncoding(encoding);
            ftp.setFileType(2);
            ftp.enterLocalPassiveMode();
            if (!ftp.changeWorkingDirectory(path)) {
                String[] paths;
                for (String string : paths = path.split("/")) {
                    if ("".equals(string) || ftp.changeWorkingDirectory(string)) continue;
                    if (!ftp.makeDirectory(string)) {
                        ftp.disconnect();
                        throw new ApiException("createFtp", "==ftp changeWorkingDirectory faile==" + path + "==" + string);
                    }
                    if (ftp.changeWorkingDirectory(string)) continue;
                    ftp.disconnect();
                    throw new ApiException("createFtp", "==ftp changeWorkingDirectory faile==" + path + "==" + string);
                }
            }
        }
        catch (IOException e) {
            throw new ApiException("createFtp", "==ftp createFtp==", (Throwable)e);
        }
        return ftp;
    }

    public static boolean uploadFile(String url, int port, String username, String password, String path, String filename, String encoding, byte[] content) {
        ByteArrayInputStream input = new ByteArrayInputStream(content);
        return FtpClientUtil.uploadFile(url, port, username, password, path, filename, encoding, input);
    }

    public static boolean uploadFileList(String url, int port, String username, String password, String path, String encoding, List<FileBean> fileBeanList) {
        if (null == fileBeanList || fileBeanList.isEmpty()) {
            return false;
        }
        boolean success = false;
        FTPClient ftp = FtpClientUtil.createFtp(url, port, username, password, path, encoding);
        if (null == ftp) {
            return success;
        }
        try {
            ByteArrayInputStream input = null;
            success = true;
            for (FileBean fileBean : fileBeanList) {
                input = new ByteArrayInputStream(fileBean.getBytes());
                if (!ftp.storeFile(fileBean.getName(), (InputStream)input)) {
                    success = false;
                }
                ((InputStream)input).close();
            }
            ftp.logout();
        }
        catch (Exception e) {
            success = false;
            throw new ApiException("uploadFileList", "==ftp uploadFileList==", (Throwable)e);
        }
        finally {
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException ioe) {
                    throw new ApiException("uploadFileList", "==ftp disconnect==", (Throwable)ioe);
                }
            }
        }
        return success;
    }

    public static byte[] downFile(String url, int port, String username, String password, String remotePath, String fileName, String encoding) {
        FTPClient ftp = FtpClientUtil.createFtp(url, port, username, password, remotePath, encoding);
        try {
            FTPFile[] fs = ftp.listFiles();
            InputStream input = null;
            for (FTPFile ff : fs) {
                if (!ff.getName().equals(fileName)) continue;
                input = ftp.retrieveFileStream(ff.getName());
                break;
            }
            byte[] imgdata = null;
            if (null != input) {
                int ch;
                ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
                while ((ch = input.read()) != -1) {
                    bytestream.write(ch);
                }
                imgdata = bytestream.toByteArray();
                bytestream.close();
                input.close();
            }
            ftp.logout();
            byte[] byArray = imgdata;
            return byArray;
        }
        catch (Exception e) {
            throw new ApiException("downFile", "==ftp downFile==", (Throwable)e);
        }
        finally {
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException ioe) {
                    throw new ApiException("downFile", "==ftp disconnect==", (Throwable)ioe);
                }
            }
        }
    }

    public static List<Map<String, byte[]>> downFileList(String url, int port, String username, String password, String remotePath, String encoding) {
        FTPClient ftp = FtpClientUtil.createFtp(url, port, username, password, remotePath, encoding);
        ArrayList<Map<String, byte[]>> maplist = new ArrayList<Map<String, byte[]>>();
        HashMap<String, byte[]> map = null;
        try {
            FTPFile[] fs = ftp.listFiles();
            InputStream input = null;
            byte[] imgdata = null;
            for (FTPFile ff : fs) {
                int ch;
                map = new HashMap<String, byte[]>();
                input = ftp.retrieveFileStream(ff.getName());
                if (null == input) continue;
                ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
                while ((ch = input.read()) != -1) {
                    bytestream.write(ch);
                }
                imgdata = bytestream.toByteArray();
                bytestream.close();
                input.close();
                ftp.completePendingCommand();
                map.put(ff.getName(), imgdata);
                maplist.add(map);
            }
            ftp.logout();
            ArrayList<Map<String, byte[]>> arrayList = maplist;
            return arrayList;
        }
        catch (Exception e) {
            throw new ApiException("downFile", "==ftp downFile==", (Throwable)e);
        }
        finally {
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException ioe) {
                    throw new ApiException("downFile", "==ftp disconnect==", (Throwable)ioe);
                }
            }
        }
    }

    public static boolean deleteFile(String url, int port, String username, String password, String path) {
        Boolean deleteFlag = false;
        FTPClient ftp = new FTPClient();
        try {
            ftp.connect(url, port);
            if (!ftp.login(username, password)) {
                return false;
            }
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                ftp.disconnect();
                return false;
            }
            deleteFlag = ftp.deleteFile(path);
        }
        catch (IOException e) {
            return deleteFlag;
        }
        return deleteFlag;
    }
}

