/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.zq.utils;

import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Map;

public class WdtClient {
    private String appkey;
    private String appsecret;
    private String sid;
    private String baseUrl;
    private int connectTimeout = 3000;
    private int readTimeout = 15000;

    public WdtClient(String sid, String appkey, String appsecret, String baseUrl) {
        this.sid = sid;
        this.appkey = appkey;
        this.appsecret = appsecret;
        this.baseUrl = baseUrl;
        if (!this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl + "/";
        }
    }

    public void setTimeout(int connectTimeout, int readTimeout) {
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    private static String getStringFromException(Throwable e) {
        String result = "";
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        e.printStackTrace(ps);
        try {
            result = bos.toString("UTF-8");
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return result;
    }

    private static byte[] encryptMD5(String data) throws IOException {
        byte[] bytes = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            bytes = md.digest(data.getBytes("UTF-8"));
        }
        catch (GeneralSecurityException gse) {
            String msg = WdtClient.getStringFromException(gse);
            throw new IOException(msg);
        }
        return bytes;
    }

    private static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex);
        }
        return sign.toString();
    }

    public static String signRequest(Map<String, String> params, String appsecret) throws IOException {
        Object[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder query = new StringBuilder();
        for (Object key : keys) {
            if ("sign".equals(key)) continue;
            if (query.length() > 0) {
                query.append(';');
            }
            int len = ((String)key).length();
            query.append(String.format("%02d", len)).append('-').append((String)key).append(':');
            String value = params.get(key);
            len = value.length();
            query.append(String.format("%04d", len)).append('-').append(value);
        }
        query.append(appsecret);
        byte[] bytes = WdtClient.encryptMD5(query.toString());
        return WdtClient.byte2hex(bytes);
    }

    public String execute(String relativeUrl, Map<String, String> params) throws IOException {
        params.put("appkey", this.appkey);
        params.put("sid", this.sid);
        params.put("timestamp", Long.toString(System.currentTimeMillis() / 1000L));
        params.put("sign", WdtClient.signRequest(params, this.appsecret));
        return WebUtils.doPost((String)(this.baseUrl + relativeUrl), params, (String)"UTF-8", (int)this.connectTimeout, (int)this.readTimeout, null);
    }
}

