/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.miniprogramservice.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.miniprogramservice.dao.AiCappClassMapper;
import com.yqbsoft.laser.service.miniprogramservice.domain.AiCappClassDomain;
import com.yqbsoft.laser.service.miniprogramservice.domain.AiCappClassReDomain;
import com.yqbsoft.laser.service.miniprogramservice.model.AiCappClass;
import com.yqbsoft.laser.service.miniprogramservice.service.AiCappClassService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AiCappClassServiceImpl
extends BaseServiceImpl
implements AiCappClassService {
    private static final String SYS_CODE = "mini.AiCappClassServiceImpl";
    private AiCappClassMapper aiCappClassMapper;

    public void setAiCappClassMapper(AiCappClassMapper aiCappClassMapper) {
        this.aiCappClassMapper = aiCappClassMapper;
    }

    private Date getSysDate() {
        try {
            return this.aiCappClassMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mini.AiCappClassServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkAiCappClass(AiCappClassDomain aiCappClassDomain) {
        if (null == aiCappClassDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)aiCappClassDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setAiCappClassDefault(AiCappClass aiCappClass) {
        if (null == aiCappClass) {
            return;
        }
        if (null == aiCappClass.getDataState()) {
            aiCappClass.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == aiCappClass.getGmtCreate()) {
            aiCappClass.setGmtCreate(date);
        }
        aiCappClass.setGmtModified(date);
        if (StringUtils.isBlank((String)aiCappClass.getCappClassCode())) {
            aiCappClass.setCappClassCode(this.getNo(null, "AiCappClass", "aiCappClass", aiCappClass.getTenantCode()));
        }
    }

    private int getAiCappClassMaxCode() {
        int code = 0;
        try {
            return this.aiCappClassMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mini.AiCappClassServiceImpl.getAiCappClassMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAiCappClassUpdataDefault(AiCappClass aiCappClass) {
        if (null == aiCappClass) {
            return;
        }
        aiCappClass.setGmtModified(this.getSysDate());
    }

    private void saveAiCappClassModel(AiCappClass aiCappClass) throws ApiException {
        if (null == aiCappClass) {
            return;
        }
        try {
            this.aiCappClassMapper.insert(aiCappClass);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCappClassServiceImpl.saveAiCappClassModel.ex", (Throwable)e);
        }
    }

    private void saveAiCappClassBatchModel(List<AiCappClass> aiCappClassList) throws ApiException {
        if (null == aiCappClassList || aiCappClassList.isEmpty()) {
            return;
        }
        try {
            this.aiCappClassMapper.insertBatch(aiCappClassList);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCappClassServiceImpl.saveAiCappClassBatchModel.ex", (Throwable)e);
        }
    }

    private AiCappClass getAiCappClassModelById(Integer cappClassId) {
        if (null == cappClassId) {
            return null;
        }
        try {
            return this.aiCappClassMapper.selectByPrimaryKey(cappClassId);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCappClassServiceImpl.getAiCappClassModelById", (Throwable)e);
            return null;
        }
    }

    private AiCappClass getAiCappClassModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.aiCappClassMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCappClassServiceImpl.getAiCappClassModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delAiCappClassModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.aiCappClassMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCappClassServiceImpl.delAiCappClassModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mini.AiCappClassServiceImpl.delAiCappClassModelByCode.num");
        }
    }

    private void deleteAiCappClassModel(Integer cappClassId) throws ApiException {
        if (null == cappClassId) {
            return;
        }
        int i = 0;
        try {
            i = this.aiCappClassMapper.deleteByPrimaryKey(cappClassId);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCappClassServiceImpl.deleteAiCappClassModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mini.AiCappClassServiceImpl.deleteAiCappClassModel.num");
        }
    }

    private void updateAiCappClassModel(AiCappClass aiCappClass) throws ApiException {
        if (null == aiCappClass) {
            return;
        }
        int i = 0;
        try {
            i = this.aiCappClassMapper.updateByPrimaryKey(aiCappClass);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCappClassServiceImpl.updateAiCappClassModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mini.AiCappClassServiceImpl.updateAiCappClassModel.num");
        }
    }

    private void updateStateAiCappClassModel(Integer cappClassId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == cappClassId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cappClassId", cappClassId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.aiCappClassMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCappClassServiceImpl.updateStateAiCappClassModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mini.AiCappClassServiceImpl.updateStateAiCappClassModel.null");
        }
    }

    private void updateStateAiCappClassModelByCode(String tenantCode, String cappClassCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)cappClassCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cappClassCode", cappClassCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.aiCappClassMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCappClassServiceImpl.updateStateAiCappClassModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mini.AiCappClassServiceImpl.updateStateAiCappClassModelByCode.null");
        }
    }

    private AiCappClass makeAiCappClass(AiCappClassDomain aiCappClassDomain, AiCappClass aiCappClass) {
        if (null == aiCappClassDomain) {
            return null;
        }
        if (null == aiCappClass) {
            aiCappClass = new AiCappClass();
        }
        try {
            BeanUtils.copyAllPropertys((Object)aiCappClass, (Object)aiCappClassDomain);
            return aiCappClass;
        }
        catch (Exception e) {
            this.logger.error("mini.AiCappClassServiceImpl.makeAiCappClass", (Throwable)e);
            return null;
        }
    }

    private AiCappClassReDomain makeAiCappClassReDomain(AiCappClass aiCappClass) {
        if (null == aiCappClass) {
            return null;
        }
        AiCappClassReDomain aiCappClassReDomain = new AiCappClassReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)aiCappClassReDomain, (Object)aiCappClass);
            return aiCappClassReDomain;
        }
        catch (Exception e) {
            this.logger.error("mini.AiCappClassServiceImpl.makeAiCappClassReDomain", (Throwable)e);
            return null;
        }
    }

    private List<AiCappClass> queryAiCappClassModelPage(Map<String, Object> parammap) {
        try {
            return this.aiCappClassMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCappClassServiceImpl.queryAiCappClassModel", (Throwable)e);
            return null;
        }
    }

    private int countAiCappClass(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.aiCappClassMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCappClassServiceImpl.countAiCappClass", (Throwable)e);
        }
        return i;
    }

    private AiCappClass createAiCappClass(AiCappClassDomain aiCappClassDomain) {
        String msg = this.checkAiCappClass(aiCappClassDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mini.AiCappClassServiceImpl.saveAiCappClass.checkAiCappClass", msg);
        }
        AiCappClass aiCappClass = this.makeAiCappClass(aiCappClassDomain, null);
        this.setAiCappClassDefault(aiCappClass);
        return aiCappClass;
    }

    @Override
    public String saveAiCappClass(AiCappClassDomain aiCappClassDomain) throws ApiException {
        AiCappClass aiCappClass = this.createAiCappClass(aiCappClassDomain);
        this.saveAiCappClassModel(aiCappClass);
        return aiCappClass.getCappClassCode();
    }

    @Override
    public String saveAiCappClassBatch(List<AiCappClassDomain> aiCappClassDomainList) throws ApiException {
        if (null == aiCappClassDomainList || aiCappClassDomainList.isEmpty()) {
            return null;
        }
        ArrayList<AiCappClass> aiCappClassList = new ArrayList<AiCappClass>();
        String code = "";
        for (AiCappClassDomain aiCappClassDomain : aiCappClassDomainList) {
            AiCappClass aiCappClass = this.createAiCappClass(aiCappClassDomain);
            code = aiCappClass.getCappClassCode();
            aiCappClassList.add(aiCappClass);
        }
        this.saveAiCappClassBatchModel(aiCappClassList);
        return code;
    }

    @Override
    public void updateAiCappClassState(Integer cappClassId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == cappClassId) {
            return;
        }
        this.updateStateAiCappClassModel(cappClassId, dataState, oldDataState, map);
    }

    @Override
    public void updateAiCappClassStateByCode(String tenantCode, String cappClassCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)cappClassCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateAiCappClassModelByCode(tenantCode, cappClassCode, dataState, oldDataState, map);
    }

    @Override
    public void updateAiCappClass(AiCappClassDomain aiCappClassDomain) throws ApiException {
        String msg = this.checkAiCappClass(aiCappClassDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mini.AiCappClassServiceImpl.updateAiCappClass.checkAiCappClass", msg);
        }
        AiCappClass oldAiCappClass = this.getAiCappClassModelById(aiCappClassDomain.getCappClassId());
        if (null == oldAiCappClass) {
            throw new ApiException("mini.AiCappClassServiceImpl.updateAiCappClass.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        AiCappClass aiCappClass = this.makeAiCappClass(aiCappClassDomain, oldAiCappClass);
        this.setAiCappClassUpdataDefault(aiCappClass);
        this.updateAiCappClassModel(aiCappClass);
    }

    @Override
    public AiCappClass getAiCappClass(Integer cappClassId) {
        if (null == cappClassId) {
            return null;
        }
        return this.getAiCappClassModelById(cappClassId);
    }

    @Override
    public void deleteAiCappClass(Integer cappClassId) throws ApiException {
        if (null == cappClassId) {
            return;
        }
        this.deleteAiCappClassModel(cappClassId);
    }

    @Override
    public QueryResult<AiCappClass> queryAiCappClassPage(Map<String, Object> map) {
        List<AiCappClass> aiCappClassList = this.queryAiCappClassModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAiCappClass(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(aiCappClassList);
        return queryResult;
    }

    @Override
    public AiCappClass getAiCappClassByCode(String tenantCode, String cappClassCode) throws ApiException {
        if (StringUtils.isBlank((String)cappClassCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cappClassCode", cappClassCode);
        return this.getAiCappClassModelByCode(map);
    }

    @Override
    public void deleteAiCappClassByCode(String tenantCode, String cappClassCode) throws ApiException {
        if (StringUtils.isBlank((String)cappClassCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cappClassCode", cappClassCode);
        this.delAiCappClassModelByCode(map);
    }
}

