/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.miniprogramservice.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.miniprogramservice.dao.AiCappCodeMapper;
import com.yqbsoft.laser.service.miniprogramservice.domain.AiCappCodeDomain;
import com.yqbsoft.laser.service.miniprogramservice.domain.AiCappCodeReDomain;
import com.yqbsoft.laser.service.miniprogramservice.model.AiCappCode;
import com.yqbsoft.laser.service.miniprogramservice.service.AiCappCodeService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AiCappCodeServiceImpl
extends BaseServiceImpl
implements AiCappCodeService {
    private static final String SYS_CODE = "mini.AiCappCodeServiceImpl";
    private AiCappCodeMapper aiCappCodeMapper;

    public void setAiCappCodeMapper(AiCappCodeMapper aiCappCodeMapper) {
        this.aiCappCodeMapper = aiCappCodeMapper;
    }

    private Date getSysDate() {
        try {
            return this.aiCappCodeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mini.AiCappCodeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkAiCappCode(AiCappCodeDomain aiCappCodeDomain) {
        if (null == aiCappCodeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)aiCappCodeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setAiCappCodeDefault(AiCappCode aiCappCode) {
        if (null == aiCappCode) {
            return;
        }
        if (null == aiCappCode.getDataState()) {
            aiCappCode.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == aiCappCode.getGmtCreate()) {
            aiCappCode.setGmtCreate(date);
        }
        aiCappCode.setGmtModified(date);
        if (StringUtils.isBlank((String)aiCappCode.getCappCodeCode())) {
            aiCappCode.setCappCodeCode(this.getNo(null, "AiCappCode", "aiCappCode", aiCappCode.getTenantCode()));
        }
    }

    private int getAiCappCodeMaxCode() {
        int code = 0;
        try {
            return this.aiCappCodeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mini.AiCappCodeServiceImpl.getAiCappCodeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAiCappCodeUpdataDefault(AiCappCode aiCappCode) {
        if (null == aiCappCode) {
            return;
        }
        aiCappCode.setGmtModified(this.getSysDate());
    }

    private void saveAiCappCodeModel(AiCappCode aiCappCode) throws ApiException {
        if (null == aiCappCode) {
            return;
        }
        try {
            this.aiCappCodeMapper.insert(aiCappCode);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCappCodeServiceImpl.saveAiCappCodeModel.ex", (Throwable)e);
        }
    }

    private void saveAiCappCodeBatchModel(List<AiCappCode> aiCappCodeList) throws ApiException {
        if (null == aiCappCodeList || aiCappCodeList.isEmpty()) {
            return;
        }
        try {
            this.aiCappCodeMapper.insertBatch(aiCappCodeList);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCappCodeServiceImpl.saveAiCappCodeBatchModel.ex", (Throwable)e);
        }
    }

    private AiCappCode getAiCappCodeModelById(Integer cappCodeId) {
        if (null == cappCodeId) {
            return null;
        }
        try {
            return this.aiCappCodeMapper.selectByPrimaryKey(cappCodeId);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCappCodeServiceImpl.getAiCappCodeModelById", (Throwable)e);
            return null;
        }
    }

    private AiCappCode getAiCappCodeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.aiCappCodeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCappCodeServiceImpl.getAiCappCodeModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delAiCappCodeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.aiCappCodeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCappCodeServiceImpl.delAiCappCodeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mini.AiCappCodeServiceImpl.delAiCappCodeModelByCode.num");
        }
    }

    private void deleteAiCappCodeModel(Integer cappCodeId) throws ApiException {
        if (null == cappCodeId) {
            return;
        }
        int i = 0;
        try {
            i = this.aiCappCodeMapper.deleteByPrimaryKey(cappCodeId);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCappCodeServiceImpl.deleteAiCappCodeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mini.AiCappCodeServiceImpl.deleteAiCappCodeModel.num");
        }
    }

    private void updateAiCappCodeModel(AiCappCode aiCappCode) throws ApiException {
        if (null == aiCappCode) {
            return;
        }
        int i = 0;
        try {
            i = this.aiCappCodeMapper.updateByPrimaryKey(aiCappCode);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCappCodeServiceImpl.updateAiCappCodeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mini.AiCappCodeServiceImpl.updateAiCappCodeModel.num");
        }
    }

    private void updateStateAiCappCodeModel(Integer cappCodeId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == cappCodeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cappCodeId", cappCodeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.aiCappCodeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCappCodeServiceImpl.updateStateAiCappCodeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mini.AiCappCodeServiceImpl.updateStateAiCappCodeModel.null");
        }
    }

    private void updateStateAiCappCodeModelByCode(String tenantCode, String cappCodeCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)cappCodeCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cappCodeCode", cappCodeCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.aiCappCodeMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCappCodeServiceImpl.updateStateAiCappCodeModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mini.AiCappCodeServiceImpl.updateStateAiCappCodeModelByCode.null");
        }
    }

    private AiCappCode makeAiCappCode(AiCappCodeDomain aiCappCodeDomain, AiCappCode aiCappCode) {
        if (null == aiCappCodeDomain) {
            return null;
        }
        if (null == aiCappCode) {
            aiCappCode = new AiCappCode();
        }
        try {
            BeanUtils.copyAllPropertys((Object)aiCappCode, (Object)aiCappCodeDomain);
            return aiCappCode;
        }
        catch (Exception e) {
            this.logger.error("mini.AiCappCodeServiceImpl.makeAiCappCode", (Throwable)e);
            return null;
        }
    }

    private AiCappCodeReDomain makeAiCappCodeReDomain(AiCappCode aiCappCode) {
        if (null == aiCappCode) {
            return null;
        }
        AiCappCodeReDomain aiCappCodeReDomain = new AiCappCodeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)aiCappCodeReDomain, (Object)aiCappCode);
            return aiCappCodeReDomain;
        }
        catch (Exception e) {
            this.logger.error("mini.AiCappCodeServiceImpl.makeAiCappCodeReDomain", (Throwable)e);
            return null;
        }
    }

    private List<AiCappCode> queryAiCappCodeModelPage(Map<String, Object> parammap) {
        try {
            return this.aiCappCodeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCappCodeServiceImpl.queryAiCappCodeModel", (Throwable)e);
            return null;
        }
    }

    private int countAiCappCode(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.aiCappCodeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCappCodeServiceImpl.countAiCappCode", (Throwable)e);
        }
        return i;
    }

    private AiCappCode createAiCappCode(AiCappCodeDomain aiCappCodeDomain) {
        String msg = this.checkAiCappCode(aiCappCodeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mini.AiCappCodeServiceImpl.saveAiCappCode.checkAiCappCode", msg);
        }
        AiCappCode aiCappCode = this.makeAiCappCode(aiCappCodeDomain, null);
        this.setAiCappCodeDefault(aiCappCode);
        return aiCappCode;
    }

    @Override
    public String saveAiCappCode(AiCappCodeDomain aiCappCodeDomain) throws ApiException {
        AiCappCode aiCappCode = this.createAiCappCode(aiCappCodeDomain);
        this.saveAiCappCodeModel(aiCappCode);
        return aiCappCode.getCappCodeCode();
    }

    @Override
    public String saveAiCappCodeBatch(List<AiCappCodeDomain> aiCappCodeDomainList) throws ApiException {
        if (null == aiCappCodeDomainList || aiCappCodeDomainList.isEmpty()) {
            return null;
        }
        ArrayList<AiCappCode> aiCappCodeList = new ArrayList<AiCappCode>();
        String code = "";
        for (AiCappCodeDomain aiCappCodeDomain : aiCappCodeDomainList) {
            AiCappCode aiCappCode = this.createAiCappCode(aiCappCodeDomain);
            code = aiCappCode.getCappCodeCode();
            aiCappCodeList.add(aiCappCode);
        }
        this.saveAiCappCodeBatchModel(aiCappCodeList);
        return code;
    }

    @Override
    public void updateAiCappCodeState(Integer cappCodeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == cappCodeId) {
            return;
        }
        this.updateStateAiCappCodeModel(cappCodeId, dataState, oldDataState, map);
    }

    @Override
    public void updateAiCappCodeStateByCode(String tenantCode, String cappCodeCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)cappCodeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateAiCappCodeModelByCode(tenantCode, cappCodeCode, dataState, oldDataState, map);
    }

    @Override
    public void updateAiCappCode(AiCappCodeDomain aiCappCodeDomain) throws ApiException {
        String msg = this.checkAiCappCode(aiCappCodeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mini.AiCappCodeServiceImpl.updateAiCappCode.checkAiCappCode", msg);
        }
        AiCappCode oldAiCappCode = this.getAiCappCodeModelById(aiCappCodeDomain.getCappCodeId());
        if (null == oldAiCappCode) {
            throw new ApiException("mini.AiCappCodeServiceImpl.updateAiCappCode.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        AiCappCode aiCappCode = this.makeAiCappCode(aiCappCodeDomain, oldAiCappCode);
        this.setAiCappCodeUpdataDefault(aiCappCode);
        this.updateAiCappCodeModel(aiCappCode);
    }

    @Override
    public AiCappCode getAiCappCode(Integer cappCodeId) {
        if (null == cappCodeId) {
            return null;
        }
        return this.getAiCappCodeModelById(cappCodeId);
    }

    @Override
    public void deleteAiCappCode(Integer cappCodeId) throws ApiException {
        if (null == cappCodeId) {
            return;
        }
        this.deleteAiCappCodeModel(cappCodeId);
    }

    @Override
    public QueryResult<AiCappCode> queryAiCappCodePage(Map<String, Object> map) {
        List<AiCappCode> aiCappCodeList = this.queryAiCappCodeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAiCappCode(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(aiCappCodeList);
        return queryResult;
    }

    @Override
    public AiCappCode getAiCappCodeByCode(String tenantCode, String cappCodeCode) throws ApiException {
        if (StringUtils.isBlank((String)cappCodeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cappCodeCode", cappCodeCode);
        return this.getAiCappCodeModelByCode(map);
    }

    @Override
    public void deleteAiCappCodeByCode(String tenantCode, String cappCodeCode) throws ApiException {
        if (StringUtils.isBlank((String)cappCodeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cappCodeCode", cappCodeCode);
        this.delAiCappCodeModelByCode(map);
    }
}

