/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.miniprogramservice.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.miniprogramservice.dao.AiCclassMapper;
import com.yqbsoft.laser.service.miniprogramservice.domain.AiCclassDomain;
import com.yqbsoft.laser.service.miniprogramservice.domain.AiCclassReDomain;
import com.yqbsoft.laser.service.miniprogramservice.domain.AiChannelSendDomain;
import com.yqbsoft.laser.service.miniprogramservice.model.AiCclass;
import com.yqbsoft.laser.service.miniprogramservice.model.AiChannelSend;
import com.yqbsoft.laser.service.miniprogramservice.service.AiCclassService;
import com.yqbsoft.laser.service.miniprogramservice.service.AiChannelSendService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AiCclassServiceImpl
extends BaseServiceImpl
implements AiCclassService {
    private static final String SYS_CODE = "mini.AiCclassServiceImpl";
    private AiCclassMapper aiCclassMapper;
    private AiChannelSendService aiChannelSendService;

    private Date getSysDate() {
        try {
            return this.aiCclassMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mini.AiCclassServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getCategory(String token) {
        if (StringUtils.isBlank((String)token)) {
            throw new ApiException("mini.AiCclassServiceImpl.getCategory.null", "param is null");
        }
        String url = "https://api.weixin.qq.com/wxa/get_category?access_token=" + token;
        String json = this.microMessengerGetInformation(url);
        return json;
    }

    @Override
    public String modifycategory(String token, String strParam) {
        if (StringUtils.isBlank((String)token) || StringUtils.isBlank((String)strParam)) {
            throw new ApiException("mini.AiCclassServiceImpl.modifycategory.null", "param is null");
        }
        String url = "https://api.weixin.qq.com/cgi-bin/wxopen/modifycategory?access_token=" + token;
        String json = this.microMessengerAddCclassToWX(url, strParam);
        if (StringUtils.isBlank((String)json)) {
            throw new ApiException("mini.AiCclassServiceImpl.delCclassToWX.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        return json;
    }

    @Override
    public String delCclassToWX(String token, String first, String second) {
        if (StringUtils.isBlank((String)token) || StringUtils.isBlank((String)first) || StringUtils.isBlank((String)second)) {
            throw new ApiException("mini.AiCclassServiceImpl.delCclassToWX.null", "param is null");
        }
        String url = "https://api.weixin.qq.com/cgi-bin/wxopen/deletecategory?access_token=" + token;
        String json = this.microMessengerDelCclassToWX(url, first, second);
        if (StringUtils.isBlank((String)json)) {
            throw new ApiException("mini.AiCclassServiceImpl.delCclassToWX.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        return json;
    }

    private String microMessengerDelCclassToWX(String url, String first, String second) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("first", first);
        map.put("second", second);
        String res = "";
        try {
            res = WebUtils.doPostJson((String)url, map, (int)10000, (int)10000, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    @Override
    public String addCclassToWX(String token, String strParam) {
        if (StringUtils.isBlank((String)token) || StringUtils.isBlank((String)strParam)) {
            throw new ApiException("mini.AiCclassServiceImpl.addCclassToWX.null", "param is null");
        }
        String url = "https://api.weixin.qq.com/cgi-bin/wxopen/addcategory?access_token=" + token;
        String json = this.microMessengerAddCclassToWX(url, strParam);
        if (StringUtils.isBlank((String)json)) {
            throw new ApiException("mini.AiCclassServiceImpl.addCclassToWX.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        return json;
    }

    private String microMessengerAddCclassToWX(String url, String strParam) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("strParam", strParam);
        String res = "";
        try {
            res = WebUtils.doPostJson((String)url, map, (int)10000, (int)10000, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    @Override
    public String updateFunctionRecommend(String token, String signature) throws ApiException {
        if (StringUtils.isBlank((String)token) || StringUtils.isBlank((String)signature)) {
            throw new ApiException("mini.AiCclassServiceImpl.updateFunctionRecommend.null", "param is null");
        }
        String url = "https://api.weixin.qq.com/cgi-bin/account/modifysignature?access_token=" + token;
        String json = this.microMessengerUpdateFunctionRecommend(url, signature);
        if (StringUtils.isBlank((String)json)) {
            throw new ApiException("mini.AiCclassServiceImpl.updateFunctionRecommend.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        return json;
    }

    private String microMessengerUpdateFunctionRecommend(String url, String signature) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("signature", signature);
        String res = "";
        try {
            res = WebUtils.doPostJson((String)url, map, (int)10000, (int)10000, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    @Override
    public String setName(String token, String nick_name, String id_card, String license, String naming_other_stuff_1, String naming_other_stuff_2, String naming_other_stuff_3, String naming_other_stuff_4, String naming_other_stuff_5) throws ApiException {
        if (StringUtils.isBlank((String)token) || StringUtils.isBlank((String)nick_name) || StringUtils.isBlank((String)id_card) || StringUtils.isBlank((String)license)) {
            throw new ApiException("mini.AiCclassServiceImpl.setName.null", "param is null");
        }
        String url = "https://api.weixin.qq.com/wxa/setnickname?access_token=" + token;
        String json = this.microMessengerSetName(url, nick_name, id_card, license, naming_other_stuff_1, naming_other_stuff_2, naming_other_stuff_3, naming_other_stuff_4, naming_other_stuff_5);
        if (StringUtils.isBlank((String)json)) {
            throw new ApiException("mini.AiCclassServiceImpl.setName.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        return json;
    }

    private String microMessengerSetName(String url, String nick_name, String id_card, String license, String naming_other_stuff_1, String naming_other_stuff_2, String naming_other_stuff_3, String naming_other_stuff_4, String naming_other_stuff_5) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("nick_name", nick_name);
        map.put("id_card", id_card);
        map.put("license", license);
        map.put("naming_other_stuff_1", naming_other_stuff_1);
        map.put("naming_other_stuff_2", naming_other_stuff_2);
        map.put("naming_other_stuff_3", naming_other_stuff_3);
        map.put("naming_other_stuff_4", naming_other_stuff_4);
        map.put("naming_other_stuff_5", naming_other_stuff_5);
        String res = "";
        try {
            res = WebUtils.doPostJson((String)url, map, (int)10000, (int)10000, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    @Override
    public String setBusinessHttp(String token, String action, String webviewdomain) throws ApiException {
        if (StringUtils.isBlank((String)token) || StringUtils.isBlank((String)action)) {
            throw new ApiException("mini.AiCclassServiceImpl.setBusinessHttp.null", "param is null");
        }
        String url = "https://api.weixin.qq.com/wxa/setwebviewdomain?access_token=" + token;
        String json = this.microMessengerSetBusinessHttp(url, action, webviewdomain);
        if (StringUtils.isBlank((String)json)) {
            throw new ApiException("mini.AiCclassServiceImpl.setServiceHttp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        return json;
    }

    private String microMessengerSetBusinessHttp(String url, String action, String webviewdomain) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("action", action);
        map.put("webviewdomain", webviewdomain);
        String res = "";
        try {
            res = WebUtils.doPostJson((String)url, map, (int)10000, (int)10000, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    @Override
    public String setServiceHttp(String token, String action, String requestdomain, String wsrequestdomain, String uploaddomain, String downloaddomain) throws ApiException {
        if (StringUtils.isBlank((String)token) || StringUtils.isBlank((String)action)) {
            throw new ApiException("mini.AiCclassServiceImpl.setServiceHttp.null", "param is null");
        }
        String url = "https://api.weixin.qq.com/wxa/modify_domain?access_token=" + token;
        String json = this.microMessengerSetServiceHttp(url, action, requestdomain, wsrequestdomain, uploaddomain, downloaddomain);
        if (StringUtils.isBlank((String)json)) {
            throw new ApiException("mini.AiCclassServiceImpl.setServiceHttp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        return json;
    }

    private String microMessengerSetServiceHttp(String url, String action, String requestdomain, String wsrequestdomain, String uploaddomain, String downloaddomain) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("action", action);
        map.put("requestdomain", requestdomain);
        map.put("wsrequestdomain", wsrequestdomain);
        map.put("uploaddomain", uploaddomain);
        map.put("downloaddomain", downloaddomain);
        String res = "";
        try {
            res = WebUtils.doPostJson((String)url, map, (int)10000, (int)10000, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    @Override
    public void getCanDoCclass(String token, String tenantCode, String userInfoCode, String userName, String cclassUrl, String cclassType) throws ApiException {
        if (StringUtils.isBlank((String)token)) {
            throw new ApiException("mini.AiCclassServiceImpl.getCanDoCclass.null", "token is null");
        }
        AiCclassDomain aiCclassDomain = new AiCclassDomain();
        String url = "https://api.weixin.qq.com/cgi-bin/wxopen/getallcategories?access_token=" + token;
        String json = this.microMessengerGetInformation(url);
        if (StringUtils.isBlank((String)json)) {
            throw new ApiException("mini.AiCclassServiceImpl.getCanDoCclass.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        JsonUtil.buildNormalBinder();
        Map map = JsonUtil.getJsonToMap((String)json);
        if (map == null || map.size() <= 0) {
            throw new ApiException("mini.AiCclassServiceImpl.getCanDoCclass.null", "\u83b7\u53d6\u53ef\u8bbe\u7f6e\u7684\u6240\u6709\u7c7b\u76ee\u5931\u8d25map");
        }
        String errcode = (String)map.get("errcode");
        if (!"0".equals(errcode)) {
            throw new ApiException("mini.AiCclassServiceImpl.getCanDoCclass.null", "\u5fae\u4fe1\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        String list = (String)map.get("categories");
        if (StringUtils.isBlank((String)list)) {
            throw new ApiException("mini.AiCclassServiceImpl.getCanDoCclass.null", "\u83b7\u53d6\u53ef\u8bbe\u7f6e\u7684\u6240\u6709\u7c7b\u76ee\u5931\u8d25list");
        }
        List aiCclasses = (List)JsonUtil.buildNormalBinder().getJsonToList(list, Map.class);
        if (aiCclasses == null || aiCclasses.size() <= 0) {
            throw new ApiException("mini.AiCclassServiceImpl.getCanDoCclass.null", "\u83b7\u53d6\u53ef\u8bbe\u7f6e\u7684\u6240\u6709\u7c7b\u76ee\u5931\u8d25aiCclasses");
        }
        for (Map aiCclass : aiCclasses) {
            aiCclassDomain.setCclassName((String)aiCclass.get("name"));
            aiCclassDomain.setCclassLevel(Integer.parseInt((String)aiCclass.get("level")));
            aiCclassDomain.setCclassSens(Integer.parseInt((String)aiCclass.get("sensitive_type")));
            aiCclassDomain.setTenantCode(tenantCode);
            aiCclassDomain.setMemberCode(userInfoCode);
            aiCclassDomain.setMemberName(userName);
            aiCclassDomain.setCclassType(cclassType);
            aiCclassDomain.setCclassUrl(cclassUrl);
            this.saveAiCclass(aiCclassDomain);
        }
    }

    private String microMessengerGetInformation(String url) {
        HashMap map = new HashMap();
        String res = "";
        try {
            res = WebUtils.doPostJson((String)url, map, (int)10000, (int)10000, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    @Override
    public String getSetedCclass(String token, String tenantCode, String userInfoCode, String userName, String cclassUrl, String cclassType) throws ApiException {
        AiCclassDomain aiCclassDomain = new AiCclassDomain();
        if (StringUtils.isBlank((String)token)) {
            throw new ApiException("mini.AiCclassServiceImpl.getSetedCclass.null", "param is null");
        }
        String url = "https://api.weixin.qq.com/cgi-bin/wxopen/getcategory?access_token=" + token;
        String json = this.microMessengerGetSetedCclass(url);
        return json;
    }

    private String microMessengerGetSetedCclass(String url) {
        HashMap map = new HashMap();
        String res = "";
        try {
            res = WebUtils.doPostJson((String)url, map, (int)10000, (int)10000, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    private String checkAiCclass(AiCclassDomain aiCclassDomain) {
        if (null == aiCclassDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)aiCclassDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setAiCclassDefault(AiCclass aiCclass) {
        if (null == aiCclass) {
            return;
        }
        if (null == aiCclass.getDataState()) {
            aiCclass.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == aiCclass.getGmtCreate()) {
            aiCclass.setGmtCreate(date);
        }
        aiCclass.setGmtModified(date);
        if (StringUtils.isBlank((String)aiCclass.getCclassCode())) {
            aiCclass.setCclassCode(this.getNo(null, "AiCclass", "aiCclass", aiCclass.getTenantCode()));
        }
    }

    private int getAiCclassMaxCode() {
        int code = 0;
        try {
            return this.aiCclassMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mini.AiCclassServiceImpl.getAiCclassMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAiCclassUpdataDefault(AiCclass aiCclass) {
        if (null == aiCclass) {
            return;
        }
        aiCclass.setGmtModified(this.getSysDate());
    }

    private void saveAiCclassModel(AiCclass aiCclass) throws ApiException {
        if (null == aiCclass) {
            return;
        }
        try {
            this.aiCclassMapper.insert(aiCclass);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCclassServiceImpl.saveAiCclassModel.ex", (Throwable)e);
        }
    }

    private void saveAiCclassBatchModel(List<AiCclass> aiCclassList) throws ApiException {
        if (null == aiCclassList || aiCclassList.isEmpty()) {
            return;
        }
        try {
            this.aiCclassMapper.insertBatch(aiCclassList);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCclassServiceImpl.saveAiCclassBatchModel.ex", (Throwable)e);
        }
    }

    private AiCclass getAiCclassModelById(Integer cclassId) {
        if (null == cclassId) {
            return null;
        }
        try {
            return this.aiCclassMapper.selectByPrimaryKey(cclassId);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCclassServiceImpl.getAiCclassModelById", (Throwable)e);
            return null;
        }
    }

    private AiCclass getAiCclassModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.aiCclassMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCclassServiceImpl.getAiCclassModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delAiCclassModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.aiCclassMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCclassServiceImpl.delAiCclassModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mini.AiCclassServiceImpl.delAiCclassModelByCode.num");
        }
    }

    private void deleteAiCclassModel(Integer cclassId) throws ApiException {
        if (null == cclassId) {
            return;
        }
        int i = 0;
        try {
            i = this.aiCclassMapper.deleteByPrimaryKey(cclassId);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCclassServiceImpl.deleteAiCclassModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mini.AiCclassServiceImpl.deleteAiCclassModel.num");
        }
    }

    private void updateAiCclassModel(AiCclass aiCclass) throws ApiException {
        if (null == aiCclass) {
            return;
        }
        int i = 0;
        try {
            i = this.aiCclassMapper.updateByPrimaryKey(aiCclass);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCclassServiceImpl.updateAiCclassModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mini.AiCclassServiceImpl.updateAiCclassModel.num");
        }
    }

    private void updateStateAiCclassModel(Integer cclassId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == cclassId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cclassId", cclassId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.aiCclassMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCclassServiceImpl.updateStateAiCclassModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mini.AiCclassServiceImpl.updateStateAiCclassModel.null");
        }
    }

    private void updateStateAiCclassModelByCode(String tenantCode, String cclassCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)cclassCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cclassCode", cclassCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.aiCclassMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCclassServiceImpl.updateStateAiCclassModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mini.AiCclassServiceImpl.updateStateAiCclassModelByCode.null");
        }
    }

    private AiCclass makeAiCclass(AiCclassDomain aiCclassDomain, AiCclass aiCclass) {
        if (null == aiCclassDomain) {
            return null;
        }
        if (null == aiCclass) {
            aiCclass = new AiCclass();
        }
        try {
            BeanUtils.copyAllPropertys((Object)aiCclass, (Object)aiCclassDomain);
            return aiCclass;
        }
        catch (Exception e) {
            this.logger.error("mini.AiCclassServiceImpl.makeAiCclass", (Throwable)e);
            return null;
        }
    }

    private AiCclassReDomain makeAiCclassReDomain(AiCclass aiCclass) {
        if (null == aiCclass) {
            return null;
        }
        AiCclassReDomain aiCclassReDomain = new AiCclassReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)aiCclassReDomain, (Object)aiCclass);
            return aiCclassReDomain;
        }
        catch (Exception e) {
            this.logger.error("mini.AiCclassServiceImpl.makeAiCclassReDomain", (Throwable)e);
            return null;
        }
    }

    private List<AiCclass> queryAiCclassModelPage(Map<String, Object> parammap) {
        try {
            return this.aiCclassMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCclassServiceImpl.queryAiCclassModel", (Throwable)e);
            return null;
        }
    }

    private int countAiCclass(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.aiCclassMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCclassServiceImpl.countAiCclass", (Throwable)e);
        }
        return i;
    }

    private AiCclass createAiCclass(AiCclassDomain aiCclassDomain) {
        String msg = this.checkAiCclass(aiCclassDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mini.AiCclassServiceImpl.saveAiCclass.checkAiCclass", msg);
        }
        AiCclass aiCclass = this.makeAiCclass(aiCclassDomain, null);
        this.setAiCclassDefault(aiCclass);
        return aiCclass;
    }

    @Override
    public List<AiChannelSend> saveAiCclass(AiCclassDomain aiCclassDomain) throws ApiException {
        AiCclass aiCclass = this.createAiCclass(aiCclassDomain);
        this.saveAiCclassModel(aiCclass);
        ArrayList<AiCclass> list = new ArrayList<AiCclass>();
        list.add(aiCclass);
        return this.buidPmChannelsend(list, "insert");
    }

    @Override
    public String saveAiCclassBatch(List<AiCclassDomain> aiCclassDomainList) throws ApiException {
        if (null == aiCclassDomainList || aiCclassDomainList.isEmpty()) {
            return null;
        }
        ArrayList<AiCclass> aiCclassList = new ArrayList<AiCclass>();
        ArrayList<AiCclass> list = new ArrayList<AiCclass>();
        String code = "";
        for (AiCclassDomain aiCclassDomain : aiCclassDomainList) {
            AiCclass aiCclass = this.createAiCclass(aiCclassDomain);
            code = aiCclass.getCclassCode();
            aiCclassList.add(aiCclass);
            list.add(aiCclass);
            this.saveAiCclass(aiCclassDomain);
        }
        return code;
    }

    @Override
    public List<AiChannelSend> updateAiCclassState(Integer cclassId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateAiCclassModel(cclassId, dataState, oldDataState, map);
        AiCclass aiCclass = this.getAiCclass(cclassId);
        ArrayList<AiCclass> list = new ArrayList<AiCclass>();
        list.add(aiCclass);
        return this.buidPmChannelsend(list, "update");
    }

    @Override
    public List<AiChannelSend> updateAiCclassStateByCode(String tenantCode, String cclassCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateAiCclassModelByCode(tenantCode, cclassCode, dataState, oldDataState, map);
        AiCclass aiCclass = this.getAiCclassByCode(tenantCode, cclassCode);
        ArrayList<AiCclass> list = new ArrayList<AiCclass>();
        list.add(aiCclass);
        return this.buidPmChannelsend(list, "update");
    }

    @Override
    public List<AiChannelSend> updateAiCclass(AiCclassDomain aiCclassDomain) throws ApiException {
        String msg = this.checkAiCclass(aiCclassDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mini.AiCclassServiceImpl.updateAiCclass.checkAiCclass", msg);
        }
        AiCclass oldAiCclass = this.getAiCclassModelById(aiCclassDomain.getCclassId());
        if (null == oldAiCclass) {
            throw new ApiException("mini.AiCclassServiceImpl.updateAiCclass.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        AiCclass aiCclass = this.makeAiCclass(aiCclassDomain, oldAiCclass);
        this.setAiCclassUpdataDefault(aiCclass);
        this.updateAiCclassModel(aiCclass);
        ArrayList<AiCclass> list = new ArrayList<AiCclass>();
        list.add(aiCclass);
        return this.buidPmChannelsend(list, "update");
    }

    @Override
    public AiCclass getAiCclass(Integer cclassId) {
        if (null == cclassId) {
            return null;
        }
        return this.getAiCclassModelById(cclassId);
    }

    @Override
    public List<AiChannelSend> deleteAiCclass(Integer cclassId) throws ApiException {
        AiCclass aiCclass = this.getAiCclass(cclassId);
        this.deleteAiCclassModel(cclassId);
        ArrayList<AiCclass> list = new ArrayList<AiCclass>();
        list.add(aiCclass);
        return this.buidPmChannelsend(list, "delete");
    }

    @Override
    public QueryResult<AiCclass> queryAiCclassPage(Map<String, Object> map) {
        List<AiCclass> aiCclassList = this.queryAiCclassModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAiCclass(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(aiCclassList);
        return queryResult;
    }

    @Override
    public AiCclass getAiCclassByCode(String tenantCode, String cclassCode) throws ApiException {
        if (StringUtils.isBlank((String)cclassCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cclassCode", cclassCode);
        return this.getAiCclassModelByCode(map);
    }

    @Override
    public List<AiChannelSend> deleteAiCclassByCode(String tenantCode, String cclassCode) throws ApiException {
        AiCclass aiCclass = this.getAiCclassByCode(tenantCode, cclassCode);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cclassCode", cclassCode);
        this.delAiCclassModelByCode(map);
        ArrayList<AiCclass> list = new ArrayList<AiCclass>();
        list.add(aiCclass);
        return this.buidPmChannelsend(list, "delete");
    }

    private List<AiChannelSend> buidPmChannelsend(List<AiCclass> aiCclassList, String dri) {
        if (ListUtil.isEmpty(aiCclassList)) {
            return null;
        }
        ArrayList<AiChannelSend> pmChannelsendList = new ArrayList();
        ArrayList<AiChannelSendDomain> disChannelsendDomainList = new ArrayList<AiChannelSendDomain>();
        for (AiCclass promotion : aiCclassList) {
            AiChannelSendDomain pmChannelsendDomain = new AiChannelSendDomain();
            pmChannelsendDomain.setChannelsendOpcode(promotion.getCclassCode());
            pmChannelsendDomain.setChannelsendType("aiCclass");
            pmChannelsendDomain.setChannelsendDir(dri);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)promotion));
            pmChannelsendDomain.setTenantCode(promotion.getTenantCode());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.aiChannelSendService.saveSendAiChannelsendBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }
}

