/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.miniprogramservice.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.miniprogramservice.dao.AiCnumListMapper;
import com.yqbsoft.laser.service.miniprogramservice.domain.AiCnumListDomain;
import com.yqbsoft.laser.service.miniprogramservice.domain.AiCnumListReDomain;
import com.yqbsoft.laser.service.miniprogramservice.model.AiCnumList;
import com.yqbsoft.laser.service.miniprogramservice.service.AiCnumListService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AiCnumListServiceImpl
extends BaseServiceImpl
implements AiCnumListService {
    private static final String SYS_CODE = "mini.AiCnumListServiceImpl";
    private AiCnumListMapper aiCnumListMapper;

    public void setAiCnumListMapper(AiCnumListMapper aiCnumListMapper) {
        this.aiCnumListMapper = aiCnumListMapper;
    }

    private Date getSysDate() {
        try {
            return this.aiCnumListMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mini.AiCnumListServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkAiCnumList(AiCnumListDomain aiCnumListDomain) {
        if (null == aiCnumListDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)aiCnumListDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setAiCnumListDefault(AiCnumList aiCnumList) {
        if (null == aiCnumList) {
            return;
        }
        if (null == aiCnumList.getDataState()) {
            aiCnumList.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == aiCnumList.getGmtCreate()) {
            aiCnumList.setGmtCreate(date);
        }
        aiCnumList.setGmtModified(date);
        if (StringUtils.isBlank((String)aiCnumList.getCnumListCode())) {
            aiCnumList.setCnumListCode(this.getNo(null, "AiCnumList", "aiCnumList", aiCnumList.getTenantCode()));
        }
    }

    private int getAiCnumListMaxCode() {
        int code = 0;
        try {
            return this.aiCnumListMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mini.AiCnumListServiceImpl.getAiCnumListMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAiCnumListUpdataDefault(AiCnumList aiCnumList) {
        if (null == aiCnumList) {
            return;
        }
        aiCnumList.setGmtModified(this.getSysDate());
    }

    private void saveAiCnumListModel(AiCnumList aiCnumList) throws ApiException {
        if (null == aiCnumList) {
            return;
        }
        try {
            this.aiCnumListMapper.insert(aiCnumList);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCnumListServiceImpl.saveAiCnumListModel.ex", (Throwable)e);
        }
    }

    private void saveAiCnumListBatchModel(List<AiCnumList> aiCnumListList) throws ApiException {
        if (null == aiCnumListList || aiCnumListList.isEmpty()) {
            return;
        }
        try {
            this.aiCnumListMapper.insertBatch(aiCnumListList);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCnumListServiceImpl.saveAiCnumListBatchModel.ex", (Throwable)e);
        }
    }

    private AiCnumList getAiCnumListModelById(Integer cnumListId) {
        if (null == cnumListId) {
            return null;
        }
        try {
            return this.aiCnumListMapper.selectByPrimaryKey(cnumListId);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCnumListServiceImpl.getAiCnumListModelById", (Throwable)e);
            return null;
        }
    }

    private AiCnumList getAiCnumListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.aiCnumListMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCnumListServiceImpl.getAiCnumListModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delAiCnumListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.aiCnumListMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCnumListServiceImpl.delAiCnumListModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mini.AiCnumListServiceImpl.delAiCnumListModelByCode.num");
        }
    }

    private void deleteAiCnumListModel(Integer cnumListId) throws ApiException {
        if (null == cnumListId) {
            return;
        }
        int i = 0;
        try {
            i = this.aiCnumListMapper.deleteByPrimaryKey(cnumListId);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCnumListServiceImpl.deleteAiCnumListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mini.AiCnumListServiceImpl.deleteAiCnumListModel.num");
        }
    }

    private void updateAiCnumListModel(AiCnumList aiCnumList) throws ApiException {
        if (null == aiCnumList) {
            return;
        }
        int i = 0;
        try {
            i = this.aiCnumListMapper.updateByPrimaryKey(aiCnumList);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCnumListServiceImpl.updateAiCnumListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mini.AiCnumListServiceImpl.updateAiCnumListModel.num");
        }
    }

    private void updateStateAiCnumListModel(Integer cnumListId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == cnumListId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cnumListId", cnumListId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.aiCnumListMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCnumListServiceImpl.updateStateAiCnumListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mini.AiCnumListServiceImpl.updateStateAiCnumListModel.null");
        }
    }

    private void updateStateAiCnumListModelByCode(String tenantCode, String cnumListCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)cnumListCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cnumListCode", cnumListCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.aiCnumListMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCnumListServiceImpl.updateStateAiCnumListModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mini.AiCnumListServiceImpl.updateStateAiCnumListModelByCode.null");
        }
    }

    private AiCnumList makeAiCnumList(AiCnumListDomain aiCnumListDomain, AiCnumList aiCnumList) {
        if (null == aiCnumListDomain) {
            return null;
        }
        if (null == aiCnumList) {
            aiCnumList = new AiCnumList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)aiCnumList, (Object)aiCnumListDomain);
            return aiCnumList;
        }
        catch (Exception e) {
            this.logger.error("mini.AiCnumListServiceImpl.makeAiCnumList", (Throwable)e);
            return null;
        }
    }

    private AiCnumListReDomain makeAiCnumListReDomain(AiCnumList aiCnumList) {
        if (null == aiCnumList) {
            return null;
        }
        AiCnumListReDomain aiCnumListReDomain = new AiCnumListReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)aiCnumListReDomain, (Object)aiCnumList);
            return aiCnumListReDomain;
        }
        catch (Exception e) {
            this.logger.error("mini.AiCnumListServiceImpl.makeAiCnumListReDomain", (Throwable)e);
            return null;
        }
    }

    private List<AiCnumList> queryAiCnumListModelPage(Map<String, Object> parammap) {
        try {
            return this.aiCnumListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCnumListServiceImpl.queryAiCnumListModel", (Throwable)e);
            return null;
        }
    }

    private int countAiCnumList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.aiCnumListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCnumListServiceImpl.countAiCnumList", (Throwable)e);
        }
        return i;
    }

    private AiCnumList createAiCnumList(AiCnumListDomain aiCnumListDomain) {
        String msg = this.checkAiCnumList(aiCnumListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mini.AiCnumListServiceImpl.saveAiCnumList.checkAiCnumList", msg);
        }
        AiCnumList aiCnumList = this.makeAiCnumList(aiCnumListDomain, null);
        this.setAiCnumListDefault(aiCnumList);
        return aiCnumList;
    }

    @Override
    public String saveAiCnumList(AiCnumListDomain aiCnumListDomain) throws ApiException {
        AiCnumList aiCnumList = this.createAiCnumList(aiCnumListDomain);
        this.saveAiCnumListModel(aiCnumList);
        return aiCnumList.getCnumListCode();
    }

    @Override
    public String saveAiCnumListBatch(List<AiCnumListDomain> aiCnumListDomainList) throws ApiException {
        if (null == aiCnumListDomainList || aiCnumListDomainList.isEmpty()) {
            return null;
        }
        ArrayList<AiCnumList> aiCnumListList = new ArrayList<AiCnumList>();
        String code = "";
        for (AiCnumListDomain aiCnumListDomain : aiCnumListDomainList) {
            AiCnumList aiCnumList = this.createAiCnumList(aiCnumListDomain);
            code = aiCnumList.getCnumListCode();
            aiCnumListList.add(aiCnumList);
        }
        this.saveAiCnumListBatchModel(aiCnumListList);
        return code;
    }

    @Override
    public void updateAiCnumListState(Integer cnumListId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == cnumListId) {
            return;
        }
        this.updateStateAiCnumListModel(cnumListId, dataState, oldDataState, map);
    }

    @Override
    public void updateAiCnumListStateByCode(String tenantCode, String cnumListCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)cnumListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateAiCnumListModelByCode(tenantCode, cnumListCode, dataState, oldDataState, map);
    }

    @Override
    public void updateAiCnumList(AiCnumListDomain aiCnumListDomain) throws ApiException {
        String msg = this.checkAiCnumList(aiCnumListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mini.AiCnumListServiceImpl.updateAiCnumList.checkAiCnumList", msg);
        }
        AiCnumList oldAiCnumList = this.getAiCnumListModelById(aiCnumListDomain.getCnumListId());
        if (null == oldAiCnumList) {
            throw new ApiException("mini.AiCnumListServiceImpl.updateAiCnumList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        AiCnumList aiCnumList = this.makeAiCnumList(aiCnumListDomain, oldAiCnumList);
        this.setAiCnumListUpdataDefault(aiCnumList);
        this.updateAiCnumListModel(aiCnumList);
    }

    @Override
    public AiCnumList getAiCnumList(Integer cnumListId) {
        if (null == cnumListId) {
            return null;
        }
        return this.getAiCnumListModelById(cnumListId);
    }

    @Override
    public void deleteAiCnumList(Integer cnumListId) throws ApiException {
        if (null == cnumListId) {
            return;
        }
        this.deleteAiCnumListModel(cnumListId);
    }

    @Override
    public QueryResult<AiCnumList> queryAiCnumListPage(Map<String, Object> map) {
        List<AiCnumList> aiCnumListList = this.queryAiCnumListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAiCnumList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(aiCnumListList);
        return queryResult;
    }

    @Override
    public AiCnumList getAiCnumListByCode(String tenantCode, String cnumListCode) throws ApiException {
        if (StringUtils.isBlank((String)cnumListCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cnumListCode", cnumListCode);
        return this.getAiCnumListModelByCode(map);
    }

    @Override
    public void deleteAiCnumListByCode(String tenantCode, String cnumListCode) throws ApiException {
        if (StringUtils.isBlank((String)cnumListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cnumListCode", cnumListCode);
        this.delAiCnumListModelByCode(map);
    }
}

