/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.miniprogramservice.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.miniprogramservice.dao.AiCnumMapper;
import com.yqbsoft.laser.service.miniprogramservice.domain.AiCnumDomain;
import com.yqbsoft.laser.service.miniprogramservice.domain.AiCnumReDomain;
import com.yqbsoft.laser.service.miniprogramservice.model.AiCnum;
import com.yqbsoft.laser.service.miniprogramservice.service.AiCnumService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AiCnumServiceImpl
extends BaseServiceImpl
implements AiCnumService {
    private static final String SYS_CODE = "mini.AiCnumServiceImpl";
    private AiCnumMapper aiCnumMapper;

    public void setAiCnumMapper(AiCnumMapper aiCnumMapper) {
        this.aiCnumMapper = aiCnumMapper;
    }

    private Date getSysDate() {
        try {
            return this.aiCnumMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mini.AiCnumServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkAiCnum(AiCnumDomain aiCnumDomain) {
        if (null == aiCnumDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)aiCnumDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setAiCnumDefault(AiCnum aiCnum) {
        if (null == aiCnum) {
            return;
        }
        if (null == aiCnum.getDataState()) {
            aiCnum.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == aiCnum.getGmtCreate()) {
            aiCnum.setGmtCreate(date);
        }
        aiCnum.setGmtModified(date);
        if (StringUtils.isBlank((String)aiCnum.getCnumCode())) {
            aiCnum.setCnumCode(this.getNo(null, "AiCnum", "aiCnum", aiCnum.getTenantCode()));
        }
    }

    private int getAiCnumMaxCode() {
        int code = 0;
        try {
            return this.aiCnumMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mini.AiCnumServiceImpl.getAiCnumMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAiCnumUpdataDefault(AiCnum aiCnum) {
        if (null == aiCnum) {
            return;
        }
        aiCnum.setGmtModified(this.getSysDate());
    }

    private void saveAiCnumModel(AiCnum aiCnum) throws ApiException {
        if (null == aiCnum) {
            return;
        }
        try {
            this.aiCnumMapper.insert(aiCnum);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCnumServiceImpl.saveAiCnumModel.ex", (Throwable)e);
        }
    }

    private void saveAiCnumBatchModel(List<AiCnum> aiCnumList) throws ApiException {
        if (null == aiCnumList || aiCnumList.isEmpty()) {
            return;
        }
        try {
            this.aiCnumMapper.insertBatch(aiCnumList);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCnumServiceImpl.saveAiCnumBatchModel.ex", (Throwable)e);
        }
    }

    private AiCnum getAiCnumModelById(Integer cnumId) {
        if (null == cnumId) {
            return null;
        }
        try {
            return this.aiCnumMapper.selectByPrimaryKey(cnumId);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCnumServiceImpl.getAiCnumModelById", (Throwable)e);
            return null;
        }
    }

    private AiCnum getAiCnumModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.aiCnumMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCnumServiceImpl.getAiCnumModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delAiCnumModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.aiCnumMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCnumServiceImpl.delAiCnumModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mini.AiCnumServiceImpl.delAiCnumModelByCode.num");
        }
    }

    private void deleteAiCnumModel(Integer cnumId) throws ApiException {
        if (null == cnumId) {
            return;
        }
        int i = 0;
        try {
            i = this.aiCnumMapper.deleteByPrimaryKey(cnumId);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCnumServiceImpl.deleteAiCnumModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mini.AiCnumServiceImpl.deleteAiCnumModel.num");
        }
    }

    private void updateAiCnumModel(AiCnum aiCnum) throws ApiException {
        if (null == aiCnum) {
            return;
        }
        int i = 0;
        try {
            i = this.aiCnumMapper.updateByPrimaryKey(aiCnum);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCnumServiceImpl.updateAiCnumModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mini.AiCnumServiceImpl.updateAiCnumModel.num");
        }
    }

    private void updateStateAiCnumModel(Integer cnumId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == cnumId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cnumId", cnumId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.aiCnumMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCnumServiceImpl.updateStateAiCnumModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mini.AiCnumServiceImpl.updateStateAiCnumModel.null");
        }
    }

    private void updateStateAiCnumModelByCode(String tenantCode, String cnumCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)cnumCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cnumCode", cnumCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.aiCnumMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCnumServiceImpl.updateStateAiCnumModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mini.AiCnumServiceImpl.updateStateAiCnumModelByCode.null");
        }
    }

    private AiCnum makeAiCnum(AiCnumDomain aiCnumDomain, AiCnum aiCnum) {
        if (null == aiCnumDomain) {
            return null;
        }
        if (null == aiCnum) {
            aiCnum = new AiCnum();
        }
        try {
            BeanUtils.copyAllPropertys((Object)aiCnum, (Object)aiCnumDomain);
            return aiCnum;
        }
        catch (Exception e) {
            this.logger.error("mini.AiCnumServiceImpl.makeAiCnum", (Throwable)e);
            return null;
        }
    }

    private AiCnumReDomain makeAiCnumReDomain(AiCnum aiCnum) {
        if (null == aiCnum) {
            return null;
        }
        AiCnumReDomain aiCnumReDomain = new AiCnumReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)aiCnumReDomain, (Object)aiCnum);
            return aiCnumReDomain;
        }
        catch (Exception e) {
            this.logger.error("mini.AiCnumServiceImpl.makeAiCnumReDomain", (Throwable)e);
            return null;
        }
    }

    private List<AiCnum> queryAiCnumModelPage(Map<String, Object> parammap) {
        try {
            return this.aiCnumMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCnumServiceImpl.queryAiCnumModel", (Throwable)e);
            return null;
        }
    }

    private int countAiCnum(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.aiCnumMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCnumServiceImpl.countAiCnum", (Throwable)e);
        }
        return i;
    }

    private AiCnum createAiCnum(AiCnumDomain aiCnumDomain) {
        String msg = this.checkAiCnum(aiCnumDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mini.AiCnumServiceImpl.saveAiCnum.checkAiCnum", msg);
        }
        AiCnum aiCnum = this.makeAiCnum(aiCnumDomain, null);
        this.setAiCnumDefault(aiCnum);
        return aiCnum;
    }

    @Override
    public String saveAiCnum(AiCnumDomain aiCnumDomain) throws ApiException {
        AiCnum aiCnum = this.createAiCnum(aiCnumDomain);
        this.saveAiCnumModel(aiCnum);
        return aiCnum.getCnumCode();
    }

    @Override
    public String saveAiCnumBatch(List<AiCnumDomain> aiCnumDomainList) throws ApiException {
        if (null == aiCnumDomainList || aiCnumDomainList.isEmpty()) {
            return null;
        }
        ArrayList<AiCnum> aiCnumList = new ArrayList<AiCnum>();
        String code = "";
        for (AiCnumDomain aiCnumDomain : aiCnumDomainList) {
            AiCnum aiCnum = this.createAiCnum(aiCnumDomain);
            code = aiCnum.getCnumCode();
            aiCnumList.add(aiCnum);
        }
        this.saveAiCnumBatchModel(aiCnumList);
        return code;
    }

    @Override
    public void updateAiCnumState(Integer cnumId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == cnumId) {
            return;
        }
        this.updateStateAiCnumModel(cnumId, dataState, oldDataState, map);
    }

    @Override
    public void updateAiCnumStateByCode(String tenantCode, String cnumCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)cnumCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateAiCnumModelByCode(tenantCode, cnumCode, dataState, oldDataState, map);
    }

    @Override
    public void updateAiCnum(AiCnumDomain aiCnumDomain) throws ApiException {
        String msg = this.checkAiCnum(aiCnumDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mini.AiCnumServiceImpl.updateAiCnum.checkAiCnum", msg);
        }
        AiCnum oldAiCnum = this.getAiCnumModelById(aiCnumDomain.getCnumId());
        if (null == oldAiCnum) {
            throw new ApiException("mini.AiCnumServiceImpl.updateAiCnum.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        AiCnum aiCnum = this.makeAiCnum(aiCnumDomain, oldAiCnum);
        this.setAiCnumUpdataDefault(aiCnum);
        this.updateAiCnumModel(aiCnum);
    }

    @Override
    public AiCnum getAiCnum(Integer cnumId) {
        if (null == cnumId) {
            return null;
        }
        return this.getAiCnumModelById(cnumId);
    }

    @Override
    public void deleteAiCnum(Integer cnumId) throws ApiException {
        if (null == cnumId) {
            return;
        }
        this.deleteAiCnumModel(cnumId);
    }

    @Override
    public QueryResult<AiCnum> queryAiCnumPage(Map<String, Object> map) {
        List<AiCnum> aiCnumList = this.queryAiCnumModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAiCnum(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(aiCnumList);
        return queryResult;
    }

    @Override
    public AiCnum getAiCnumByCode(String tenantCode, String cnumCode) throws ApiException {
        if (StringUtils.isBlank((String)cnumCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cnumCode", cnumCode);
        return this.getAiCnumModelByCode(map);
    }

    @Override
    public void deleteAiCnumByCode(String tenantCode, String cnumCode) throws ApiException {
        if (StringUtils.isBlank((String)cnumCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cnumCode", cnumCode);
        this.delAiCnumModelByCode(map);
    }
}

