/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.miniprogramservice.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.miniprogramservice.dao.AiCuserMapper;
import com.yqbsoft.laser.service.miniprogramservice.domain.AiCuserDomain;
import com.yqbsoft.laser.service.miniprogramservice.domain.AiCuserReDomain;
import com.yqbsoft.laser.service.miniprogramservice.model.AiCuser;
import com.yqbsoft.laser.service.miniprogramservice.service.AiCuserService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AiCuserServiceImpl
extends BaseServiceImpl
implements AiCuserService {
    private static final String SYS_CODE = "mini.AiCuserServiceImpl";
    private AiCuserMapper aiCuserMapper;

    public void setAiCuserMapper(AiCuserMapper aiCuserMapper) {
        this.aiCuserMapper = aiCuserMapper;
    }

    private Date getSysDate() {
        try {
            return this.aiCuserMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mini.AiCuserServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkAiCuser(AiCuserDomain aiCuserDomain) {
        if (null == aiCuserDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)aiCuserDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setAiCuserDefault(AiCuser aiCuser) {
        if (null == aiCuser) {
            return;
        }
        if (null == aiCuser.getDataState()) {
            aiCuser.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == aiCuser.getGmtCreate()) {
            aiCuser.setGmtCreate(date);
        }
        aiCuser.setGmtModified(date);
        if (StringUtils.isBlank((String)aiCuser.getCuserCode())) {
            aiCuser.setCuserCode(this.getNo(null, "AiCuser", "aiCuser", aiCuser.getTenantCode()));
        }
    }

    private int getAiCuserMaxCode() {
        int code = 0;
        try {
            return this.aiCuserMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mini.AiCuserServiceImpl.getAiCuserMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAiCuserUpdataDefault(AiCuser aiCuser) {
        if (null == aiCuser) {
            return;
        }
        aiCuser.setGmtModified(this.getSysDate());
    }

    private void saveAiCuserModel(AiCuser aiCuser) throws ApiException {
        if (null == aiCuser) {
            return;
        }
        try {
            this.aiCuserMapper.insert(aiCuser);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCuserServiceImpl.saveAiCuserModel.ex", (Throwable)e);
        }
    }

    private void saveAiCuserBatchModel(List<AiCuser> aiCuserList) throws ApiException {
        if (null == aiCuserList || aiCuserList.isEmpty()) {
            return;
        }
        try {
            this.aiCuserMapper.insertBatch(aiCuserList);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCuserServiceImpl.saveAiCuserBatchModel.ex", (Throwable)e);
        }
    }

    private AiCuser getAiCuserModelById(Integer cuserId) {
        if (null == cuserId) {
            return null;
        }
        try {
            return this.aiCuserMapper.selectByPrimaryKey(cuserId);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCuserServiceImpl.getAiCuserModelById", (Throwable)e);
            return null;
        }
    }

    private AiCuser getAiCuserModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.aiCuserMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCuserServiceImpl.getAiCuserModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delAiCuserModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.aiCuserMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCuserServiceImpl.delAiCuserModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mini.AiCuserServiceImpl.delAiCuserModelByCode.num");
        }
    }

    private void deleteAiCuserModel(Integer cuserId) throws ApiException {
        if (null == cuserId) {
            return;
        }
        int i = 0;
        try {
            i = this.aiCuserMapper.deleteByPrimaryKey(cuserId);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCuserServiceImpl.deleteAiCuserModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mini.AiCuserServiceImpl.deleteAiCuserModel.num");
        }
    }

    private void updateAiCuserModel(AiCuser aiCuser) throws ApiException {
        if (null == aiCuser) {
            return;
        }
        int i = 0;
        try {
            i = this.aiCuserMapper.updateByPrimaryKey(aiCuser);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCuserServiceImpl.updateAiCuserModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mini.AiCuserServiceImpl.updateAiCuserModel.num");
        }
    }

    private void updateStateAiCuserModel(Integer cuserId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == cuserId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cuserId", cuserId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.aiCuserMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCuserServiceImpl.updateStateAiCuserModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mini.AiCuserServiceImpl.updateStateAiCuserModel.null");
        }
    }

    private void updateStateAiCuserModelByCode(String tenantCode, String cuserCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)cuserCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cuserCode", cuserCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.aiCuserMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCuserServiceImpl.updateStateAiCuserModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mini.AiCuserServiceImpl.updateStateAiCuserModelByCode.null");
        }
    }

    private AiCuser makeAiCuser(AiCuserDomain aiCuserDomain, AiCuser aiCuser) {
        if (null == aiCuserDomain) {
            return null;
        }
        if (null == aiCuser) {
            aiCuser = new AiCuser();
        }
        try {
            BeanUtils.copyAllPropertys((Object)aiCuser, (Object)aiCuserDomain);
            return aiCuser;
        }
        catch (Exception e) {
            this.logger.error("mini.AiCuserServiceImpl.makeAiCuser", (Throwable)e);
            return null;
        }
    }

    private AiCuserReDomain makeAiCuserReDomain(AiCuser aiCuser) {
        if (null == aiCuser) {
            return null;
        }
        AiCuserReDomain aiCuserReDomain = new AiCuserReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)aiCuserReDomain, (Object)aiCuser);
            return aiCuserReDomain;
        }
        catch (Exception e) {
            this.logger.error("mini.AiCuserServiceImpl.makeAiCuserReDomain", (Throwable)e);
            return null;
        }
    }

    private List<AiCuser> queryAiCuserModelPage(Map<String, Object> parammap) {
        try {
            return this.aiCuserMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCuserServiceImpl.queryAiCuserModel", (Throwable)e);
            return null;
        }
    }

    private int countAiCuser(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.aiCuserMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCuserServiceImpl.countAiCuser", (Throwable)e);
        }
        return i;
    }

    private AiCuser createAiCuser(AiCuserDomain aiCuserDomain) {
        String msg = this.checkAiCuser(aiCuserDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mini.AiCuserServiceImpl.saveAiCuser.checkAiCuser", msg);
        }
        AiCuser aiCuser = this.makeAiCuser(aiCuserDomain, null);
        this.setAiCuserDefault(aiCuser);
        return aiCuser;
    }

    @Override
    public String saveAiCuser(AiCuserDomain aiCuserDomain) throws ApiException {
        AiCuser aiCuser = this.createAiCuser(aiCuserDomain);
        this.saveAiCuserModel(aiCuser);
        return aiCuser.getCuserCode();
    }

    @Override
    public String saveAiCuserBatch(List<AiCuserDomain> aiCuserDomainList) throws ApiException {
        if (null == aiCuserDomainList || aiCuserDomainList.isEmpty()) {
            return null;
        }
        ArrayList<AiCuser> aiCuserList = new ArrayList<AiCuser>();
        String code = "";
        for (AiCuserDomain aiCuserDomain : aiCuserDomainList) {
            AiCuser aiCuser = this.createAiCuser(aiCuserDomain);
            code = aiCuser.getCuserCode();
            aiCuserList.add(aiCuser);
        }
        this.saveAiCuserBatchModel(aiCuserList);
        return code;
    }

    @Override
    public void updateAiCuserState(Integer cuserId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == cuserId) {
            return;
        }
        this.updateStateAiCuserModel(cuserId, dataState, oldDataState, map);
    }

    @Override
    public void updateAiCuserStateByCode(String tenantCode, String cuserCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)cuserCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateAiCuserModelByCode(tenantCode, cuserCode, dataState, oldDataState, map);
    }

    @Override
    public void updateAiCuser(AiCuserDomain aiCuserDomain) throws ApiException {
        String msg = this.checkAiCuser(aiCuserDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mini.AiCuserServiceImpl.updateAiCuser.checkAiCuser", msg);
        }
        AiCuser oldAiCuser = this.getAiCuserModelById(aiCuserDomain.getCuserId());
        if (null == oldAiCuser) {
            throw new ApiException("mini.AiCuserServiceImpl.updateAiCuser.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        AiCuser aiCuser = this.makeAiCuser(aiCuserDomain, oldAiCuser);
        this.setAiCuserUpdataDefault(aiCuser);
        this.updateAiCuserModel(aiCuser);
    }

    @Override
    public AiCuser getAiCuser(Integer cuserId) {
        if (null == cuserId) {
            return null;
        }
        return this.getAiCuserModelById(cuserId);
    }

    @Override
    public void deleteAiCuser(Integer cuserId) throws ApiException {
        if (null == cuserId) {
            return;
        }
        this.deleteAiCuserModel(cuserId);
    }

    @Override
    public QueryResult<AiCuser> queryAiCuserPage(Map<String, Object> map) {
        List<AiCuser> aiCuserList = this.queryAiCuserModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAiCuser(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(aiCuserList);
        return queryResult;
    }

    @Override
    public AiCuser getAiCuserByCode(String tenantCode, String cuserCode) throws ApiException {
        if (StringUtils.isBlank((String)cuserCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cuserCode", cuserCode);
        return this.getAiCuserModelByCode(map);
    }

    @Override
    public void deleteAiCuserByCode(String tenantCode, String cuserCode) throws ApiException {
        if (StringUtils.isBlank((String)cuserCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cuserCode", cuserCode);
        this.delAiCuserModelByCode(map);
    }
}

