/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.miniprogramservice.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.miniprogramservice.dao.AiCappMapper;
import com.yqbsoft.laser.service.miniprogramservice.domain.AiCappDomain;
import com.yqbsoft.laser.service.miniprogramservice.domain.AiCappReDomain;
import com.yqbsoft.laser.service.miniprogramservice.model.AiCapp;
import com.yqbsoft.laser.service.miniprogramservice.service.AiCappService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AiCappServiceImpl
extends BaseServiceImpl
implements AiCappService {
    private static final String SYS_CODE = "mini.AiCappServiceImpl";
    private AiCappMapper aiCappMapper;

    public void setAiCappMapper(AiCappMapper aiCappMapper) {
        this.aiCappMapper = aiCappMapper;
    }

    @Override
    public String bindTester(String token, String wechatid) throws Exception {
        if (StringUtils.isBlank((String)token) || StringUtils.isBlank((String)wechatid)) {
            throw new ApiException("mini.AiCappServiceImpl.bindTester.null", "bindTester param is null");
        }
        String url = "https://api.weixin.qq.com/wxa/bind_tester?access_token=" + token;
        String json = this.microMessengerBindTester(url, wechatid);
        return json;
    }

    private String microMessengerBindTester(String url, String wechatid) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("wechatid", wechatid);
        String res = "";
        try {
            res = WebUtils.doPostJson((String)url, map, (int)10000, (int)10000, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    @Override
    public String getQrcode(String token, String path) throws Exception {
        if (StringUtils.isBlank((String)token)) {
            throw new ApiException("mini.AiCappServiceImpl.getQrcode.null", "param is null");
        }
        String url = "https://api.weixin.qq.com/wxa/get_qrcode?access_token=" + token + "&path=" + path;
        String json = this.microMessengerRevertcoderelease(url);
        return json;
    }

    @Override
    public String revertcoderelease(String token) throws Exception {
        if (StringUtils.isBlank((String)token)) {
            throw new ApiException("mini.AiCappServiceImpl.revertcoderelease.null", "param is null");
        }
        String url = "https://api.weixin.qq.com/wxa/revertcoderelease?access_token=" + token;
        String json = this.microMessengerRevertcoderelease(url);
        return json;
    }

    private String microMessengerRevertcoderelease(String url) {
        HashMap map = new HashMap();
        String res = "";
        try {
            res = WebUtils.doPostJson((String)url, map, (int)10000, (int)10000, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    @Override
    public String speedupaudit(String token, String auditid) throws Exception {
        if (StringUtils.isBlank((String)token) || StringUtils.isBlank((String)auditid)) {
            throw new ApiException("mini.AiCappServiceImpl.speedupaudit.null", "param is null");
        }
        String url = "https://api.weixin.qq.com/wxa/speedupaudit?access_token=" + token;
        String json = this.microMessengerGetAuditstatus(url, auditid);
        return json;
    }

    @Override
    public String release(String token) throws Exception {
        if (StringUtils.isBlank((String)token)) {
            throw new ApiException("mini.AiCappServiceImpl.release.null", "param is null");
        }
        String url = "https://api.weixin.qq.com/wxa/release?access_token=" + token;
        String json = this.microMessengerRelease(url);
        return json;
    }

    private String microMessengerRelease(String url) {
        HashMap map = new HashMap();
        String res = "";
        try {
            res = WebUtils.doPostJson((String)url, map, (int)10000, (int)10000, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    @Override
    public String getAuditstatus(String token, String auditid) throws Exception {
        if (StringUtils.isBlank((String)token) || StringUtils.isBlank((String)auditid)) {
            throw new ApiException("mini.AiCappServiceImpl.getAuditstatus.null", "param is null");
        }
        String url = "https://api.weixin.qq.com/wxa/get_auditstatus?access_token=" + token;
        String json = this.microMessengerGetAuditstatus(url, auditid);
        return json;
    }

    private String microMessengerGetAuditstatus(String url, String auditid) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auditid", auditid);
        String res = "";
        try {
            res = WebUtils.doPostJson((String)url, map, (int)10000, (int)10000, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    @Override
    public String submitAudit(String token, String item_list, String preview_info, String version_desc, String feedback_info, String feedback_stuff) throws Exception {
        if (StringUtils.isBlank((String)token)) {
            throw new ApiException("mini.AiCappServiceImpl.submitAudit.null", "param is null");
        }
        String url = "https://api.weixin.qq.com/wxa/submit_audit?access_token=" + token;
        String json = this.microMessengerSubmitAudit(url, item_list, preview_info, version_desc, feedback_info, feedback_stuff);
        return json;
    }

    private String microMessengerSubmitAudit(String url, String item_list, String preview_info, String version_desc, String feedback_info, String feedback_stuff) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("item_list", item_list);
        map.put("preview_info", preview_info);
        map.put("version_desc", version_desc);
        map.put("feedback_info", feedback_info);
        map.put("feedback_stuff", feedback_stuff);
        String res = "";
        try {
            res = WebUtils.doPostJson((String)url, map, (int)10000, (int)10000, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    @Override
    public String commitCode(String token, String tenantCode, String template_id, String extApp_id, String user_version, String user_desc, String ext_json) throws Exception {
        if (StringUtils.isBlank((String)token) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)template_id) || StringUtils.isBlank((String)user_version) || StringUtils.isBlank((String)user_desc)) {
            throw new ApiException("mini.AiCappServiceImpl.commitCode.null", "param is null");
        }
        String url = "https://api.weixin.qq.com/wxa/commit?access_token=" + token;
        AiCapp aiCapp = this.getExtJson();
        if (aiCapp == null) {
            throw new ApiException("mini.AiCappServiceImpl.commitCode.null", "aiCapp is null");
        }
        String cappOpenConf = aiCapp.getCappOpenconf();
        JsonUtil.buildNormalBinder();
        Map map = JsonUtil.getJsonToMap((String)cappOpenConf);
        map.put("extAppid", "wxd0619dfe118939ff");
        String extJson = JsonUtil.buildNormalBinder().getMapToJson(map);
        String json = this.microMessengerCommitCode(url, template_id, extJson, user_version, user_desc);
        if (StringUtils.isBlank((String)json)) {
            throw new ApiException("mini.AiCappServiceImpl.commitCode.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        return json;
    }

    private String microMessengerCommitCode(String url, String template_id, String ext_json, String user_version, String user_desc) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("template_id", template_id);
        map.put("ext_json", ext_json);
        map.put("user_version", user_version);
        map.put("user_desc", user_desc);
        String res = "";
        try {
            res = WebUtils.doPostJson((String)url, map, (int)10000, (int)10000, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    private Date getSysDate() {
        try {
            return this.aiCappMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mini.AiCappServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private AiCapp getExtJson() {
        try {
            return this.getAiCapp(1);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCappServiceImpl.getExtJson", (Throwable)e);
            return null;
        }
    }

    private String checkAiCapp(AiCappDomain aiCappDomain) {
        if (null == aiCappDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)aiCappDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setAiCappDefault(AiCapp aiCapp) {
        if (null == aiCapp) {
            return;
        }
        if (null == aiCapp.getDataState()) {
            aiCapp.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == aiCapp.getGmtCreate()) {
            aiCapp.setGmtCreate(date);
        }
        aiCapp.setGmtModified(date);
        if (StringUtils.isBlank((String)aiCapp.getCappCode())) {
            aiCapp.setCappCode(this.getNo(null, "AiCapp", "aiCapp", aiCapp.getTenantCode()));
        }
    }

    private int getAiCappMaxCode() {
        int code = 0;
        try {
            return this.aiCappMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mini.AiCappServiceImpl.getAiCappMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAiCappUpdataDefault(AiCapp aiCapp) {
        if (null == aiCapp) {
            return;
        }
        aiCapp.setGmtModified(this.getSysDate());
    }

    private void saveAiCappModel(AiCapp aiCapp) throws ApiException {
        if (null == aiCapp) {
            return;
        }
        try {
            this.aiCappMapper.insert(aiCapp);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCappServiceImpl.saveAiCappModel.ex", (Throwable)e);
        }
    }

    private void saveAiCappBatchModel(List<AiCapp> aiCappList) throws ApiException {
        if (null == aiCappList || aiCappList.isEmpty()) {
            return;
        }
        try {
            this.aiCappMapper.insertBatch(aiCappList);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCappServiceImpl.saveAiCappBatchModel.ex", (Throwable)e);
        }
    }

    private AiCapp getAiCappModelById(Integer cappId) {
        if (null == cappId) {
            return null;
        }
        try {
            return this.aiCappMapper.selectByPrimaryKey(cappId);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCappServiceImpl.getAiCappModelById", (Throwable)e);
            return null;
        }
    }

    private AiCapp getAiCappModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.aiCappMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCappServiceImpl.getAiCappModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delAiCappModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.aiCappMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCappServiceImpl.delAiCappModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mini.AiCappServiceImpl.delAiCappModelByCode.num");
        }
    }

    private void deleteAiCappModel(Integer cappId) throws ApiException {
        if (null == cappId) {
            return;
        }
        int i = 0;
        try {
            i = this.aiCappMapper.deleteByPrimaryKey(cappId);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCappServiceImpl.deleteAiCappModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mini.AiCappServiceImpl.deleteAiCappModel.num");
        }
    }

    private void updateAiCappModel(AiCapp aiCapp) throws ApiException {
        if (null == aiCapp) {
            return;
        }
        int i = 0;
        try {
            i = this.aiCappMapper.updateByPrimaryKey(aiCapp);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCappServiceImpl.updateAiCappModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mini.AiCappServiceImpl.updateAiCappModel.num");
        }
    }

    private void updateStateAiCappModel(Integer cappId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == cappId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cappId", cappId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.aiCappMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCappServiceImpl.updateStateAiCappModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mini.AiCappServiceImpl.updateStateAiCappModel.null");
        }
    }

    private void updateStateAiCappModelByCode(String tenantCode, String cappCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)cappCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cappCode", cappCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.aiCappMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCappServiceImpl.updateStateAiCappModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mini.AiCappServiceImpl.updateStateAiCappModelByCode.null");
        }
    }

    private AiCapp makeAiCapp(AiCappDomain aiCappDomain, AiCapp aiCapp) {
        if (null == aiCappDomain) {
            return null;
        }
        if (null == aiCapp) {
            aiCapp = new AiCapp();
        }
        try {
            BeanUtils.copyAllPropertys((Object)aiCapp, (Object)aiCappDomain);
            return aiCapp;
        }
        catch (Exception e) {
            this.logger.error("mini.AiCappServiceImpl.makeAiCapp", (Throwable)e);
            return null;
        }
    }

    private AiCappReDomain makeAiCappReDomain(AiCapp aiCapp) {
        if (null == aiCapp) {
            return null;
        }
        AiCappReDomain aiCappReDomain = new AiCappReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)aiCappReDomain, (Object)aiCapp);
            return aiCappReDomain;
        }
        catch (Exception e) {
            this.logger.error("mini.AiCappServiceImpl.makeAiCappReDomain", (Throwable)e);
            return null;
        }
    }

    private List<AiCapp> queryAiCappModelPage(Map<String, Object> parammap) {
        try {
            return this.aiCappMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCappServiceImpl.queryAiCappModel", (Throwable)e);
            return null;
        }
    }

    private int countAiCapp(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.aiCappMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCappServiceImpl.countAiCapp", (Throwable)e);
        }
        return i;
    }

    private AiCapp createAiCapp(AiCappDomain aiCappDomain) {
        String msg = this.checkAiCapp(aiCappDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mini.AiCappServiceImpl.saveAiCapp.checkAiCapp", msg);
        }
        AiCapp aiCapp = this.makeAiCapp(aiCappDomain, null);
        this.setAiCappDefault(aiCapp);
        return aiCapp;
    }

    @Override
    public String saveAiCapp(AiCappDomain aiCappDomain) throws ApiException {
        AiCapp aiCapp = this.createAiCapp(aiCappDomain);
        this.saveAiCappModel(aiCapp);
        return aiCapp.getCappCode();
    }

    @Override
    public String saveAiCappBatch(List<AiCappDomain> aiCappDomainList) throws ApiException {
        if (null == aiCappDomainList || aiCappDomainList.isEmpty()) {
            return null;
        }
        ArrayList<AiCapp> aiCappList = new ArrayList<AiCapp>();
        String code = "";
        for (AiCappDomain aiCappDomain : aiCappDomainList) {
            AiCapp aiCapp = this.createAiCapp(aiCappDomain);
            code = aiCapp.getCappCode();
            aiCappList.add(aiCapp);
        }
        this.saveAiCappBatchModel(aiCappList);
        return code;
    }

    @Override
    public void updateAiCappState(Integer cappId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == cappId) {
            return;
        }
        this.updateStateAiCappModel(cappId, dataState, oldDataState, map);
    }

    @Override
    public void updateAiCappStateByCode(String tenantCode, String cappCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)cappCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateAiCappModelByCode(tenantCode, cappCode, dataState, oldDataState, map);
    }

    @Override
    public void updateAiCapp(AiCappDomain aiCappDomain) throws ApiException {
        String msg = this.checkAiCapp(aiCappDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mini.AiCappServiceImpl.updateAiCapp.checkAiCapp", msg);
        }
        AiCapp oldAiCapp = this.getAiCappModelById(aiCappDomain.getCappId());
        if (null == oldAiCapp) {
            throw new ApiException("mini.AiCappServiceImpl.updateAiCapp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        AiCapp aiCapp = this.makeAiCapp(aiCappDomain, oldAiCapp);
        this.setAiCappUpdataDefault(aiCapp);
        this.updateAiCappModel(aiCapp);
    }

    @Override
    public AiCapp getAiCapp(Integer cappId) {
        if (null == cappId) {
            return null;
        }
        return this.getAiCappModelById(cappId);
    }

    @Override
    public void deleteAiCapp(Integer cappId) throws ApiException {
        if (null == cappId) {
            return;
        }
        this.deleteAiCappModel(cappId);
    }

    @Override
    public QueryResult<AiCapp> queryAiCappPage(Map<String, Object> map) {
        List<AiCapp> aiCappList = this.queryAiCappModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAiCapp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(aiCappList);
        return queryResult;
    }

    @Override
    public AiCapp getAiCappByCode(String tenantCode, String cappCode) throws ApiException {
        if (StringUtils.isBlank((String)cappCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cappCode", cappCode);
        return this.getAiCappModelByCode(map);
    }

    @Override
    public void deleteAiCappByCode(String tenantCode, String cappCode) throws ApiException {
        if (StringUtils.isBlank((String)cappCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cappCode", cappCode);
        this.delAiCappModelByCode(map);
    }
}

