/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.auction.job.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.json.JSONUtil;
import com.yqbsoft.laser.service.auction.job.dao.TtAuctionTimerMapper;
import com.yqbsoft.laser.service.auction.job.listener.AuctionEndListener;
import com.yqbsoft.laser.service.auction.job.listener.AuctionStartListener;
import com.yqbsoft.laser.service.auction.job.model.AtAuction;
import com.yqbsoft.laser.service.auction.job.model.TtAuctionTimer;
import com.yqbsoft.laser.service.auction.job.queue.AtAuctionQueue;
import com.yqbsoft.laser.service.auction.job.service.TtAuctionTimerService;
import com.yqbsoft.laser.service.auction.job.thread.ThreadFactoryImpl;
import com.yqbsoft.laser.service.auction.job.timer.AuctionTimerExeService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class TtAuctionTimerServiceImpl
extends BaseServiceImpl
implements TtAuctionTimerService,
AuctionEndListener,
AuctionStartListener {
    private static final String AUCTION_ID = "AUCTION_ID_";
    private static final String AUCTION_GINFO_ID = "AUCTION_GINFO_ID_";
    private AtAuctionQueue atAuctionQueue;
    private TtAuctionTimerMapper ttAuctionTimerMapper;

    @Override
    public String addAuctionTimer(String atAuctionStr) throws ApiException {
        AtAuction atAuction = (AtAuction)JsonUtil.buildNonNullBinder().getJsonToObject(atAuctionStr, AtAuction.class);
        TtAuctionTimer tt = this.ttAuctionTimerMapper.findAuctionTimerByAuctionId(atAuction.getAuctionId().toString());
        DateTime date = DateUtil.date();
        if (null == tt) {
            tt = new TtAuctionTimer();
            tt.setTimerCode(UUID.randomUUID().toString());
            tt.setTimerAuctionId(atAuction.getAuctionId().toString());
            tt.setTimerGoodsInfoId("0");
            tt.setTimerStartDatetime(atAuction.getAuctionSdate());
            tt.setTimerEndDatetime(atAuction.getAuctionEdate());
            tt.setTimerState(0);
            tt.setGmtCreate((Date)date);
            tt.setGmtModified((Date)date);
            tt.setTenantCode(atAuction.getTenantCode());
            int result = this.ttAuctionTimerMapper.insert(tt);
            this.logger.error("==================addAuctionTimer=", (Object)("\u4fdd\u5b58\u7ed3\u679c\uff1a" + result));
        } else {
            this.updateAuctionTimer(atAuction);
        }
        if (tt.getTimerStartDatetime().getTime() - date.getTime() <= 0L) {
            final TtAuctionTimer finalTt = tt;
            new ThreadFactoryImpl("NOTICE_AUCTION_" + finalTt.getTimerAuctionId(), false).newThread(new Runnable(){

                @Override
                public void run() {
                    TtAuctionTimerServiceImpl.this.noticeAuctionStart(finalTt);
                }
            });
        } else {
            this.atAuctionQueue.addAuction(tt);
            this.logger.error("==================addAuctionTimer=", (Object)("\u653e\u5165\u7f13\u5b58 id:" + atAuction.getAuctionId()));
        }
        return "SUCCESS";
    }

    private String noticeAuctionStart(TtAuctionTimer timer) {
        String apiCode = "at.atAuction.auctionStartWithTimer";
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("auctionId", timer.getTimerAuctionId());
        String result = this.internalInvoke(apiCode, queryMap);
        timer.setTimerState(1);
        this.ttAuctionTimerMapper.updateByPrimaryKey(timer);
        this.logger.error("===========\u573a\u6b21id\uff1a" + timer.getTimerAuctionId() + "\u63d0\u4ea4\u5b9a\u65f6\u4efb\u52a1\u670d\u52a1\u8fd4\u56de============" + result);
        return result;
    }

    @Override
    public String updateAuctionTimer(AtAuction atAuction) throws ApiException {
        TtAuctionTimer tt = this.ttAuctionTimerMapper.findAuctionTimerByAuctionId(atAuction.getAuctionId().toString());
        if (tt.getTimerStartDatetime().getTime() - atAuction.getAuctionSdate().getTime() != 0L || tt.getTimerEndDatetime().getTime() - atAuction.getAuctionEdate().getTime() != 0L) {
            tt.setTimerStartDatetime(atAuction.getAuctionSdate());
            tt.setTimerEndDatetime(atAuction.getAuctionEdate());
            this.ttAuctionTimerMapper.updateByPrimaryKey(tt);
            AuctionTimerExeService.getInstance().stopTimer(AUCTION_ID + tt.getTimerAuctionId());
            this.atAuctionQueue.removeAuction(tt);
        }
        return "SUCCESS";
    }

    @Override
    public String addGoodsInfoTimers(String atAuctionStr, String goodsInfoIdListStr) throws ApiException {
        this.logger.error("===========atAuctionStr\uff1a" + atAuctionStr + " goodsInfoIdListStr============" + goodsInfoIdListStr);
        AtAuction atAuction = (AtAuction)JsonUtil.buildNonNullBinder().getJsonToObject(atAuctionStr, AtAuction.class);
        this.logger.error("===========atAuction\uff1a" + JSONUtil.toJsonStr((Object)atAuction));
        List goodsInfoIds = JSONUtil.parseArray((String)goodsInfoIdListStr).toList(String.class);
        this.logger.error(" goodsInfoIdListStr============" + JsonUtil.buildNormalBinder().toJson((Object)goodsInfoIds));
        DateTime date = DateUtil.date();
        for (String id : goodsInfoIds) {
            TtAuctionTimer tt = this.ttAuctionTimerMapper.findAuctionTimerByGoodsInfoId(id);
            if (null == tt) {
                tt = new TtAuctionTimer();
                tt.setTimerCode(UUID.randomUUID().toString());
                tt.setTimerAuctionId(atAuction.getAuctionId().toString());
                tt.setTimerGoodsInfoId(id);
                tt.setTimerState(1);
                tt.setTimerStartDatetime(atAuction.getAuctionSdate());
                tt.setTimerEndDatetime(atAuction.getAuctionEdate());
                tt.setGmtCreate((Date)date);
                tt.setGmtModified((Date)date);
                tt.setTenantCode(atAuction.getTenantCode());
                this.ttAuctionTimerMapper.insert(tt);
            }
            if (tt.getTimerEndDatetime().getTime() - date.getTime() <= 0L) {
                this.auctionEnd(tt.getTimerAuctionId(), tt.getTimerGoodsInfoId());
                continue;
            }
            AuctionTimerExeService.getInstance().auctionEndTimer(AUCTION_GINFO_ID + tt.getTimerGoodsInfoId(), tt.getTimerEndDatetime(), tt, this);
        }
        return "SUCCESS";
    }

    @Override
    public String updateGoodsInfoTimer(String goodsInfoId, String endDatetimeStr) throws ApiException {
        this.logger.error("======================\u7ade\u4ef7\u5ef6\u65f6===========", (Object)(" ==========\u5ef6\u65f6\u5546\u54c1ID=" + goodsInfoId + " \u5ef6\u65f6\u65f6\u95f4\uff1a" + endDatetimeStr));
        TtAuctionTimer tt = this.ttAuctionTimerMapper.findAuctionTimerByGoodsInfoId(goodsInfoId);
        if (null != tt) {
            DateTime date = DateUtil.parseDate((String)endDatetimeStr);
            tt.setTimerEndDatetime((Date)date);
            int res = this.ttAuctionTimerMapper.updateByPrimaryKey(tt);
            this.logger.error("======================\u66f4\u65b0\u5ef6\u65f6===========", (Object)(" ==========\u6570\u636e\u5e93\u66f4\u65b0\u8fd4\u56de=" + res));
            TtAuctionTimer auctionTimer = this.ttAuctionTimerMapper.findAuctionTimerByAuctionId(tt.getTimerAuctionId());
            if (auctionTimer.getTimerEndDatetime().getTime() < tt.getTimerEndDatetime().getTime()) {
                auctionTimer.setTimerEndDatetime(tt.getTimerEndDatetime());
                res = this.ttAuctionTimerMapper.updateByPrimaryKey(auctionTimer);
                this.logger.error("======================\u66f4\u65b0\u66f4\u65b0\u573a\u6b21\u7ed3\u675f\u65f6\u95f4===========", (Object)(" ==========\u6570\u636e\u5e93\u66f4\u65b0\u8fd4\u56de=" + res));
            }
            AuctionTimerExeService.getInstance().stopTimer(AUCTION_GINFO_ID + tt.getTimerGoodsInfoId());
            AuctionTimerExeService.getInstance().auctionEndTimer(AUCTION_GINFO_ID + tt.getTimerGoodsInfoId(), tt.getTimerEndDatetime(), tt, this);
        }
        return "SUCCESS";
    }

    @Override
    public String initAuctionTimer() throws ApiException {
        this.logger.error("======================\u7ade\u4ef7\u573a\u6b21\u521d\u59cb\u5316\u5f00\u59cb===========");
        this.atAuctionQueue = new AtAuctionQueue(this);
        try {
            this.atAuctionQueue.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AuctionTimerExeService.getInstance().start();
        DateTime date = DateUtil.date();
        List<TtAuctionTimer> list = this.ttAuctionTimerMapper.selectUnfinishedTimer();
        for (TtAuctionTimer tt : list) {
            if (tt.getTimerState() == 0) {
                if (tt.getTimerStartDatetime().getTime() - date.getTime() <= 0L) {
                    this.noticeAuctionStart(tt);
                    continue;
                }
                this.atAuctionQueue.addAuction(tt);
                this.logger.error("==================initAuctionTimer=", (Object)("\u653e\u5165\u7f13\u5b58 id:" + tt.getTimerAuctionId()));
                continue;
            }
            if (tt.getTimerEndDatetime().getTime() - date.getTime() <= 0L) {
                tt.setTimerState(2);
                this.ttAuctionTimerMapper.updateByPrimaryKey(tt);
                if (!tt.getTimerGoodsInfoId().equals("0")) continue;
                String result = this.noticeAtAuctionEnd(tt.getTimerAuctionId(), tt.getTimerEndDatetime());
                this.logger.error("=================\u901a\u77e5\u7ade\u4ef7\u4e1a\u52a1\u670d\u52a1=", (Object)("\u7ed3\u679c:" + result));
                continue;
            }
            if (tt.getTimerGoodsInfoId().equals("0")) continue;
            AuctionTimerExeService.getInstance().auctionEndTimer(AUCTION_GINFO_ID + tt.getTimerGoodsInfoId(), tt.getTimerEndDatetime(), tt, this);
        }
        this.logger.error("======================\u7ade\u4ef7\u573a\u6b21\u521d\u59cb\u5316\u7ed3\u675f===========");
        return "SUCCESS";
    }

    private String noticeAtAuctionEnd(String auctionId, Date datetime) {
        String apiCode = "at.atAuction.auctionEndWithTimer";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("auctionId", auctionId);
        paramMap.put("endTime", JsonUtil.buildNonDefaultBinder().toJson((Object)datetime));
        return this.internalInvoke(apiCode, paramMap);
    }

    @Override
    public void auctionEnd(String auctionId, String goodsInfoId) {
        this.logger.error("===========\u7ade\u4ef7\u5546\u54c1id\uff1a" + goodsInfoId + " ===================\u5f00\u59cb\u7ed3\u7b97===============");
        String apiCode = "cct.cleaning.auctionGoodsInfoCleaning";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("auctionId", auctionId);
        paramMap.put("goodsInfoId", goodsInfoId);
        String result = this.internalInvoke(apiCode, paramMap);
        this.logger.error("===========\u573a\u6b21id\uff1a" + auctionId + " \u7ade\u4ef7\u5546\u54c1\uff1a" + goodsInfoId + " \u8bc4\u6807\u7ed3\u7b97\uff1a" + result);
        this.ttAuctionTimerMapper.updateAuctionGoodsInfoTimerFinish(goodsInfoId);
        int count = this.ttAuctionTimerMapper.findAuctionTimerUnfinished(auctionId);
        if (count <= 0) {
            TtAuctionTimer tt = this.ttAuctionTimerMapper.findAuctionTimerByGoodsInfoId(goodsInfoId);
            String noticeResult = this.noticeAtAuctionEnd(auctionId, tt.getTimerEndDatetime());
            this.logger.error("===========\u573a\u6b21id\uff1a" + auctionId + " \u901a\u77e5\u7ed3\u679c\uff1a" + noticeResult);
            this.ttAuctionTimerMapper.updateAuctionTimerFinish(auctionId);
        }
        this.logger.error("===========\u7ade\u4ef7\u5546\u54c1id\uff1a" + goodsInfoId + " ===================\u7ed3\u7b97\u5b8c\u6210===============");
    }

    @Override
    public void auctionStart(TtAuctionTimer auction) {
        this.noticeAuctionStart(auction);
    }

    public void setTtAuctionTimerMapper(TtAuctionTimerMapper ttAuctionTimerMapper) {
        this.ttAuctionTimerMapper = ttAuctionTimerMapper;
    }
}

