/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.auction.job.timer;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.cron.CronUtil;
import cn.hutool.cron.task.Task;
import com.yqbsoft.laser.service.auction.job.exception.TimerException;
import com.yqbsoft.laser.service.auction.job.exception.enums.TimerExceptionEnum;
import com.yqbsoft.laser.service.auction.job.listener.AuctionEndListener;
import com.yqbsoft.laser.service.auction.job.listener.AuctionStartListener;
import com.yqbsoft.laser.service.auction.job.model.TtAuctionTimer;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import java.util.Date;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class AuctionTimerExeService {
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private final SupperLogUtil logger = new SupperLogUtil(AuctionTimerExeService.class.getClass());

    public static AuctionTimerExeService getInstance() {
        return InstanceTimer.timerExeService;
    }

    public void start() {
        if (this.isStarted()) {
            return;
        }
        CronUtil.setMatchSecond((boolean)true);
        CronUtil.start((boolean)false);
    }

    public boolean isStarted() {
        return CronUtil.getScheduler().isStarted();
    }

    public void stop() {
        CronUtil.stop();
    }

    public void stop(boolean clearTasks) {
        CronUtil.getScheduler().stop(clearTasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void auctionStartTimer(final String taskId, Date date, final TtAuctionTimer auction, final AuctionStartListener listener) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            if (StrUtil.isBlank((CharSequence)taskId)) {
                throw new TimerException(TimerExceptionEnum.PARAM_HAS_NULL, "taskId");
            }
            if (null == date) {
                throw new TimerException(TimerExceptionEnum.PARAM_HAS_NULL, "cron");
            }
            String cron = this.dateFormatCron(date);
            this.logger.error("AuctionTimerExeService,auctionStartTimer", (Object)("========\u5b9a\u65f6\u4efb\u52a1=======" + cron));
            Task task = new Task(){

                public void execute() {
                    AuctionTimerExeService.this.logger.error("AuctionTimerExeService,auctionStartTimer", (Object)"========\u5b9a\u65f6\u4efb\u52a1 \u5f00\u59cb=======");
                    listener.auctionStart(auction);
                    AuctionTimerExeService.this.stopTimer(taskId);
                }
            };
            String id = CronUtil.schedule((String)taskId, (String)cron, (Task)task);
            this.logger.error("AuctionTimerExeService,auctionStartTimer", (Object)("========\u5b9a\u65f6\u4efb\u52a1======id=" + id));
        }
        finally {
            writeLock.unlock();
        }
    }

    public void auctionEndTimer(final String taskId, Date date, final TtAuctionTimer auction, final AuctionEndListener listener) {
        this.logger.error("=================\u5546\u54c1\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1============", (Object)("taskId:" + taskId + " "));
        if (StrUtil.isBlank((CharSequence)taskId)) {
            throw new TimerException(TimerExceptionEnum.PARAM_HAS_NULL, "taskId");
        }
        if (null == date) {
            throw new TimerException(TimerExceptionEnum.PARAM_HAS_NULL, "cron");
        }
        String cron = this.dateFormatCron(date);
        this.logger.error("\u5546\u54c1\u5b9a\u65f6\u4efb\u52a1\u8868\u8fbe\u5f0f", (Object)("========cron=======" + cron));
        Task task = new Task(){

            public void execute() {
                listener.auctionEnd(auction.getTimerAuctionId(), auction.getTimerGoodsInfoId());
                AuctionTimerExeService.this.stopTimer(taskId);
            }
        };
        CronUtil.schedule((String)taskId, (String)cron, (Task)task);
    }

    private String dateFormatCron(Date date) {
        StringBuffer sb = new StringBuffer();
        sb.append(DateUtil.second((Date)date));
        sb.append(" ");
        sb.append(DateUtil.minute((Date)date));
        sb.append(" ");
        sb.append(DateUtil.hour((Date)date, (boolean)true));
        sb.append(" ");
        sb.append(DateUtil.dayOfMonth((Date)date));
        sb.append(" ");
        sb.append(DateUtil.month((Date)date) + 1);
        sb.append(" ");
        sb.append("?");
        sb.append(" ");
        sb.append(DateUtil.year((Date)date));
        return sb.toString();
    }

    public void stopTimer(String taskId) {
        CronUtil.remove((String)taskId);
    }

    private AuctionTimerExeService() {
    }

    private static class InstanceTimer {
        public static AuctionTimerExeService timerExeService = new AuctionTimerExeService();

        private InstanceTimer() {
        }
    }
}

