/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.auction.job.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.json.JSONUtil;
import com.yqbsoft.laser.service.auction.job.dao.TtAuctionTimerMapper;
import com.yqbsoft.laser.service.auction.job.listener.AuctionCleaningListener;
import com.yqbsoft.laser.service.auction.job.listener.AuctionStartListener;
import com.yqbsoft.laser.service.auction.job.model.AtAuction;
import com.yqbsoft.laser.service.auction.job.model.TtAuctionTimer;
import com.yqbsoft.laser.service.auction.job.queue.CleaningQueue;
import com.yqbsoft.laser.service.auction.job.service.TtAuctionTimerService;
import com.yqbsoft.laser.service.auction.job.timer.AuctionTimerExeService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class TtAuctionTimerServiceImpl
extends BaseServiceImpl
implements TtAuctionTimerService,
AuctionStartListener,
AuctionCleaningListener {
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private static ExecutorService executor = ThreadUtil.newExecutor((int)5);
    private static final String AUCTION_ID = "AUCTION_ID_";
    private static final String AUCTION_GINFO_ID = "AUCTION_GINFO_ID_";
    private CleaningQueue cleaningQueue;
    private TtAuctionTimerMapper ttAuctionTimerMapper;

    @Override
    public String addAuctionTimer(String atAuctionStr) throws ApiException {
        AtAuction atAuction = (AtAuction)JsonUtil.buildNonNullBinder().getJsonToObject(atAuctionStr, AtAuction.class);
        TtAuctionTimer tt = this.ttAuctionTimerMapper.findAuctionTimerByAuctionId(atAuction.getAuctionId().toString());
        DateTime date = DateUtil.date();
        if (null == tt) {
            tt = new TtAuctionTimer();
            tt.setTimerCode(UUID.randomUUID().toString());
            tt.setTimerAuctionId(atAuction.getAuctionId().toString());
            tt.setTimerGoodsInfoId("0");
            tt.setTimerStartDatetime(atAuction.getAuctionSdate());
            tt.setTimerEndDatetime(atAuction.getAuctionEdate());
            tt.setTimerState(0);
            tt.setGmtCreate((Date)date);
            tt.setGmtModified((Date)date);
            tt.setTenantCode(atAuction.getTenantCode());
            int result = this.ttAuctionTimerMapper.insert(tt);
            this.logger.error("==================addAuctionTimer=", (Object)("\u4fdd\u5b58\u7ed3\u679c\uff1a" + result));
        } else {
            this.updateAuctionTimer(atAuction);
        }
        if (tt.getTimerStartDatetime().getTime() - date.getTime() <= 0L) {
            final TtAuctionTimer finalTt = tt;
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    TtAuctionTimerServiceImpl.this.noticeAuctionStart(finalTt);
                }
            });
        } else {
            AuctionTimerExeService.getInstance().auctionStartTimer(AUCTION_ID + tt.getTimerAuctionId(), tt.getTimerStartDatetime(), tt, this);
            this.logger.error("==================addAuctionTimer=", (Object)("\u653e\u5165\u7f13\u5b58 id:" + atAuction.getAuctionId()));
        }
        return "SUCCESS";
    }

    private String noticeAuctionStart(TtAuctionTimer timer) {
        String apiCode = "at.atAuction.auctionStartWithTimer";
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("auctionId", timer.getTimerAuctionId());
        String result = this.internalInvoke(apiCode, queryMap);
        timer.setTimerState(1);
        this.ttAuctionTimerMapper.updateByPrimaryKey(timer);
        this.logger.error("=======noticeAuctionStart====\u573a\u6b21id\uff1a" + timer.getTimerAuctionId() + "\u63d0\u4ea4\u5b9a\u65f6\u4efb\u52a1\u670d\u52a1\u8fd4\u56de============" + result);
        return result;
    }

    @Override
    public String updateAuctionTimer(AtAuction atAuction) throws ApiException {
        TtAuctionTimer tt = this.ttAuctionTimerMapper.findAuctionTimerByAuctionId(atAuction.getAuctionId().toString());
        if (tt.getTimerStartDatetime().getTime() - atAuction.getAuctionSdate().getTime() != 0L || tt.getTimerEndDatetime().getTime() - atAuction.getAuctionEdate().getTime() != 0L) {
            tt.setTimerStartDatetime(atAuction.getAuctionSdate());
            tt.setTimerEndDatetime(atAuction.getAuctionEdate());
            this.ttAuctionTimerMapper.updateByPrimaryKey(tt);
            AuctionTimerExeService.getInstance().stopTimer(AUCTION_ID + tt.getTimerAuctionId());
        }
        return "SUCCESS";
    }

    @Override
    public String addGoodsInfoTimers(String atAuctionStr, String goodsInfoIdListStr) throws ApiException {
        this.logger.error("===========atAuctionStr\uff1a" + atAuctionStr + " goodsInfoIdListStr============" + goodsInfoIdListStr);
        AtAuction atAuction = (AtAuction)JsonUtil.buildNonNullBinder().getJsonToObject(atAuctionStr, AtAuction.class);
        this.logger.error("===========atAuction\uff1a" + JSONUtil.toJsonStr((Object)atAuction));
        List goodsInfoIds = JSONUtil.parseArray((String)goodsInfoIdListStr).toList(String.class);
        this.logger.error(" goodsInfoIdListStr============" + JsonUtil.buildNormalBinder().toJson((Object)goodsInfoIds));
        DateTime date = DateUtil.date();
        for (String id : goodsInfoIds) {
            TtAuctionTimer tt = this.ttAuctionTimerMapper.findAuctionTimerByGoodsInfoId(id);
            if (null == tt) {
                tt = new TtAuctionTimer();
                tt.setTimerCode(UUID.randomUUID().toString());
                tt.setTimerAuctionId(atAuction.getAuctionId().toString());
                tt.setTimerGoodsInfoId(id);
                tt.setTimerState(1);
                tt.setTimerStartDatetime(atAuction.getAuctionSdate());
                tt.setTimerEndDatetime(atAuction.getAuctionEdate());
                tt.setGmtCreate((Date)date);
                tt.setGmtModified((Date)date);
                tt.setTenantCode(atAuction.getTenantCode());
                this.ttAuctionTimerMapper.insert(tt);
            }
            if (tt.getTimerEndDatetime().getTime() - date.getTime() > 0L) continue;
            this.auctionEnd(tt);
        }
        return "SUCCESS";
    }

    @Override
    public String updateGoodsInfoTimer(String goodsInfoId, String endDatetimeStr) throws ApiException {
        this.logger.error("======================\u7ade\u4ef7\u5ef6\u65f6===========", (Object)(" ==========\u5ef6\u65f6\u5546\u54c1ID=" + goodsInfoId + " \u5ef6\u65f6\u65f6\u95f4\uff1a" + endDatetimeStr));
        TtAuctionTimer tt = this.ttAuctionTimerMapper.findAuctionTimerByGoodsInfoId(goodsInfoId);
        if (null != tt) {
            DateTime date = DateUtil.parseDateTime((String)endDatetimeStr);
            tt.setTimerEndDatetime((Date)date);
            int res = this.ttAuctionTimerMapper.updateByPrimaryKey(tt);
            this.logger.error("======================\u66f4\u65b0\u5ef6\u65f6===========", (Object)(" ==========\u6570\u636e\u5e93\u66f4\u65b0\u8fd4\u56de=" + res));
            TtAuctionTimer auctionTimer = this.ttAuctionTimerMapper.findAuctionTimerByAuctionId(tt.getTimerAuctionId());
            if (auctionTimer.getTimerEndDatetime().getTime() < tt.getTimerEndDatetime().getTime()) {
                auctionTimer.setTimerEndDatetime(tt.getTimerEndDatetime());
                res = this.ttAuctionTimerMapper.updateByPrimaryKey(auctionTimer);
                this.logger.error("======================\u66f4\u65b0\u66f4\u65b0\u573a\u6b21\u7ed3\u675f\u65f6\u95f4===========", (Object)(" ==========\u6570\u636e\u5e93\u66f4\u65b0\u8fd4\u56de=" + res));
            }
        }
        return "SUCCESS";
    }

    @Override
    public String initAuctionTimer() throws ApiException {
        this.logger.error("======================\u7ade\u4ef7\u573a\u6b21\u521d\u59cb\u5316\u5f00\u59cb===========");
        this.cleaningQueue = new CleaningQueue(this);
        try {
            this.cleaningQueue.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AuctionTimerExeService.getInstance().start();
        List<TtAuctionTimer> list = this.ttAuctionTimerMapper.selectUnfinishedAuctionTimer();
        DateTime date = DateUtil.date();
        for (TtAuctionTimer auctionTimer : list) {
            if (auctionTimer.getTimerStartDatetime().getTime() - date.getTime() <= 0L) {
                this.noticeAuctionStart(auctionTimer);
                continue;
            }
            AuctionTimerExeService.getInstance().auctionStartTimer(AUCTION_ID + auctionTimer.getTimerAuctionId(), auctionTimer.getTimerStartDatetime(), auctionTimer, this);
        }
        this.logger.error("======================\u7ade\u4ef7\u573a\u6b21\u521d\u59cb\u5316\u7ed3\u675f===========");
        return "SUCCESS";
    }

    @Override
    public void revealAllTimer() {
        DateTime date = DateUtil.date();
        List<TtAuctionTimer> list = this.ttAuctionTimerMapper.selectUnfinishedAuctionTimer();
        for (TtAuctionTimer tt : list) {
            if (tt.getTimerGoodsInfoId().equals("0") || tt.getTimerEndDatetime().getTime() - date.getTime() > 0L) continue;
            this.auctionEnd(tt);
        }
    }

    private String noticeAtAuctionEnd(String auctionId, Date datetime) {
        String apiCode = "at.atAuction.auctionEndWithTimer";
        String temp = DateUtil.formatDateTime((Date)datetime);
        this.logger.error("========\u901a\u77e5\u7ade\u4ef7\u670d\u52a1\uff0c\u573a\u6b21\u7ed3\u675f=====noticeAtAuctionEnd" + temp);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("auctionId", auctionId);
        paramMap.put("endTime", temp);
        return this.internalInvoke(apiCode, paramMap);
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.parse((String)"2022-03-15 16:20:00", (String)"yyyy-MM-dd HH:mm:ss"));
    }

    public void auctionEnd(TtAuctionTimer timer) {
        this.logger.error("===========\u7ade\u4ef7\u5546\u54c1id\uff1a" + timer.getTimerGoodsInfoId() + " ===================\u5f00\u59cb\u6dfb\u52a0\u5230\u961f\u5217\u524d===============", (Object)("\u961f\u5217\u957f\u5ea6\u3010" + this.cleaningQueue.getQueueSize() + "\u3011"));
        this.cleaningQueue.addAuction(timer);
        this.logger.error("===========\u7ade\u4ef7\u5546\u54c1id\uff1a" + timer.getTimerGoodsInfoId() + " ===================\u6dfb\u52a0\u5230\u961f\u5217\u540e===============", (Object)("\u961f\u5217\u957f\u5ea6\u3010" + this.cleaningQueue.getQueueSize() + "\u3011"));
    }

    @Override
    public void auctionStart(TtAuctionTimer auction) {
        this.noticeAuctionStart(auction);
    }

    @Override
    public void auctionGoodsInfoCleaning(final TtAuctionTimer timer) {
        this.logger.error("===========\u7ade\u4ef7\u5546\u54c1id\uff1a" + timer.getTimerGoodsInfoId() + " ===================\u5f00\u59cb\u7ed3\u7b97===============");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                String apiCode = "cct.cleaning.auctionGoodsInfoCleaning";
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("auctionId", timer.getTimerAuctionId());
                paramMap.put("goodsInfoId", timer.getTimerGoodsInfoId());
                String result = TtAuctionTimerServiceImpl.this.internalInvoke(apiCode, paramMap);
                TtAuctionTimerServiceImpl.this.logger.error("===========\u573a\u6b21id\uff1a" + timer.getTimerAuctionId() + " \u7ade\u4ef7\u5546\u54c1\uff1a" + timer.getTimerGoodsInfoId() + " \u8bc4\u6807\u7ed3\u7b97\uff1a" + result);
            }
        });
        this.ttAuctionTimerMapper.updateAuctionGoodsInfoTimerFinish(timer.getTimerGoodsInfoId());
        int count = this.ttAuctionTimerMapper.findAuctionTimerUnfinished(timer.getTimerAuctionId());
        int timerCount = AuctionTimerExeService.getInstance().getScheduler().size();
        this.logger.error("==========\u8fd8\u5269 \u3010" + count + "\u3011\u4e2a\u5546\u54c1\u672a\u7ed3\u7b97" + " \u4efb\u52a1\u4e2a\u6570\u3010" + timerCount + "]");
        if (count <= 0) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    String noticeResult = TtAuctionTimerServiceImpl.this.noticeAtAuctionEnd(timer.getTimerAuctionId(), timer.getTimerEndDatetime());
                    TtAuctionTimerServiceImpl.this.logger.error("===========\u573a\u6b21id\uff1a" + timer.getTimerAuctionId() + " \u901a\u77e5\u7ed3\u679c\uff1a" + noticeResult);
                }
            });
            this.ttAuctionTimerMapper.updateAuctionTimerFinish(timer.getTimerAuctionId());
        }
        this.logger.error("===========\u7ade\u4ef7\u5546\u54c1id\uff1a" + timer.getTimerGoodsInfoId() + " ===================\u7ed3\u7b97\u5b8c\u6210===============");
    }

    public void setTtAuctionTimerMapper(TtAuctionTimerMapper ttAuctionTimerMapper) {
        this.ttAuctionTimerMapper = ttAuctionTimerMapper;
    }
}

