/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.auction.job.queue;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.yqbsoft.laser.service.auction.job.listener.AuctionStartListener;
import com.yqbsoft.laser.service.auction.job.model.TtAuctionTimer;
import com.yqbsoft.laser.service.auction.job.thread.ThreadFactoryImpl;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;

public class AtAuctionQueue
implements Runnable {
    private final SupperLogUtil logger = new SupperLogUtil(this.getClass());
    private AuctionStartListener startListener;
    private BlockingQueue<TtAuctionTimer> auctionQueue;
    private ExecutorService exService;
    private final int poolSize;
    private static final String AUCTION_ID = "AUCTION_ID_";
    private static final String AUCTION_GINFO_ID = "AUCTION_GINFO_ID_";

    public AtAuctionQueue(AuctionStartListener startListener) {
        this.poolSize = 1;
        this.startListener = startListener;
        this.auctionQueue = new LinkedBlockingDeque<TtAuctionTimer>();
        this.exService = Executors.newFixedThreadPool(this.poolSize, new ThreadFactoryImpl("AT_AUCTION_WORKER_", true));
    }

    public void start() throws Exception {
        new Thread(this).start();
    }

    public void addAuction(TtAuctionTimer auctionTimer) {
        this.auctionQueue.add(auctionTimer);
    }

    public void removeAuction(TtAuctionTimer auctionTimer) {
        this.auctionQueue.remove(auctionTimer);
    }

    @Override
    public void run() {
        this.exService.execute(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            TtAuctionTimer timer;
                            if (null == (timer = (TtAuctionTimer)AtAuctionQueue.this.auctionQueue.take())) {
                                Thread.sleep(1000L);
                                continue;
                            }
                            AtAuctionQueue.this.startListener.auctionStart(timer);
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
    }

    public static void main(String[] args) {
        DateTime d1 = DateUtil.date();
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        DateTime d2 = DateUtil.date();
        System.out.println("d1.compareTo(d2)=" + (d1.getTime() - d2.getTime() <= 60000L));
    }
}

