/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.auction.job.queue;

import com.yqbsoft.laser.service.auction.job.listener.AuctionCleaningListener;
import com.yqbsoft.laser.service.auction.job.model.TtAuctionTimer;
import com.yqbsoft.laser.service.auction.job.thread.ThreadFactoryImpl;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;

public class CleaningQueue
implements Runnable {
    private AuctionCleaningListener listener;
    private final SupperLogUtil logger = new SupperLogUtil(this.getClass());
    private BlockingQueue<TtAuctionTimer> cleaningQueue;
    private ExecutorService exService;
    private final int poolSize;

    public CleaningQueue(AuctionCleaningListener listener) {
        this.poolSize = 1;
        this.listener = listener;
        this.cleaningQueue = new LinkedBlockingDeque<TtAuctionTimer>();
        this.exService = Executors.newFixedThreadPool(this.poolSize, new ThreadFactoryImpl("AUCTION_CLEANING_WORKER_", true));
    }

    public void start() throws Exception {
        new Thread(this).start();
    }

    public void addAuction(TtAuctionTimer auctionTimer) {
        this.cleaningQueue.add(auctionTimer);
    }

    public void removeAuction(TtAuctionTimer auctionTimer) {
        this.cleaningQueue.remove(auctionTimer);
    }

    public int getQueueSize() {
        return this.cleaningQueue.size();
    }

    @Override
    public void run() {
        this.exService.execute(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            CleaningQueue.this.logger.error("===========\u7ed3\u7b97\u961f\u5217\uff1a ===================\u53d6\u51fa\u524d===============", (Object)("\u961f\u5217\u957f\u5ea6\u3010" + CleaningQueue.this.cleaningQueue.size() + "\u3011"));
                            TtAuctionTimer timer = (TtAuctionTimer)CleaningQueue.this.cleaningQueue.take();
                            if (null == timer) {
                                Thread.sleep(100L);
                                continue;
                            }
                            CleaningQueue.this.listener.auctionGoodsInfoCleaning(timer);
                            CleaningQueue.this.logger.error("===========\u7ed3\u7b97\u961f\u5217\uff1a ===================\u53d6\u51fa\u540e===============", (Object)("\u961f\u5217\u957f\u5ea6\u3010" + CleaningQueue.this.cleaningQueue.size() + "\u3011"));
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
    }
}

