/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.balanceaccount.service.impl;

import com.yqbsoft.laser.service.balanceaccount.constant.BaBalanceaOnStateEnum;
import com.yqbsoft.laser.service.balanceaccount.dao.BaBalanceaFileMapper;
import com.yqbsoft.laser.service.balanceaccount.dao.BaBalanceaFilelistMapper;
import com.yqbsoft.laser.service.balanceaccount.domain.BaBalanceaCmChannelBar;
import com.yqbsoft.laser.service.balanceaccount.domain.BaBalanceaFileDomain;
import com.yqbsoft.laser.service.balanceaccount.domain.BaBalanceaFilelistDomain;
import com.yqbsoft.laser.service.balanceaccount.domain.BaDownloadFileDomainBean;
import com.yqbsoft.laser.service.balanceaccount.model.BaBalanceaFile;
import com.yqbsoft.laser.service.balanceaccount.model.BaBalanceaFilelist;
import com.yqbsoft.laser.service.balanceaccount.service.BaBalanceaFileService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class BaBalanceaFileServiceImpl
extends BaseServiceImpl
implements BaBalanceaFileService {
    private static final String SYS_CODE = "ba.BaBalanceaFileServiceImpl";
    private BaBalanceaFileMapper baBalanceaFileMapper;
    private BaBalanceaFilelistMapper baBalanceaFilelistMapper;

    public void setBaBalanceaFileMapper(BaBalanceaFileMapper baBalanceaFileMapper) {
        this.baBalanceaFileMapper = baBalanceaFileMapper;
    }

    public void setBaBalanceaFilelistMapper(BaBalanceaFilelistMapper baBalanceaFilelistMapper) {
        this.baBalanceaFilelistMapper = baBalanceaFilelistMapper;
    }

    private Date getSysDate() {
        try {
            return this.baBalanceaFileMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ba.BaBalanceaFileServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkBalanceaFile(BaBalanceaFileDomain baBalanceaFileDomain) {
        if (null == baBalanceaFileDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        return "";
    }

    private void setBalanceaFileDefault(BaBalanceaFile baBalanceaFile) {
        if (null == baBalanceaFile) {
            return;
        }
        if (null == baBalanceaFile.getDataState()) {
            baBalanceaFile.setDataState(0);
        }
        if (null == baBalanceaFile.getGmtCreate()) {
            baBalanceaFile.setGmtCreate(this.getSysDate());
        }
        baBalanceaFile.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)baBalanceaFile.getBalanceaFileSeqno())) {
            baBalanceaFile.setBalanceaFileSeqno(this.createUUIDString());
        }
    }

    private int getBalanceaFileMaxCode() {
        int code = 0;
        try {
            return this.baBalanceaFileMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ba.BaBalanceaFileServiceImpl.getBalanceaFileMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setBalanceaFileUpdataDefault(BaBalanceaFile baBalanceaFile) {
        if (null == baBalanceaFile) {
            return;
        }
        baBalanceaFile.setGmtModified(this.getSysDate());
    }

    private void saveBalanceaFileModel(BaBalanceaFile baBalanceaFile) throws ApiException {
        if (null == baBalanceaFile) {
            return;
        }
        try {
            this.baBalanceaFileMapper.insert(baBalanceaFile);
        }
        catch (Exception e) {
            throw new ApiException("ba.BaBalanceaFileServiceImpl.saveBalanceaFileModel.ex", (Throwable)e);
        }
    }

    private BaBalanceaFile getBalanceaFileModelById(Integer balanceaFileId) {
        if (null == balanceaFileId) {
            return null;
        }
        try {
            return this.baBalanceaFileMapper.selectByPrimaryKey(balanceaFileId);
        }
        catch (Exception e) {
            this.logger.error("ba.BaBalanceaFileServiceImpl.getBalanceaFileModelById", (Throwable)e);
            return null;
        }
    }

    private BaBalanceaFile getBalanceaFileModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.baBalanceaFileMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ba.BaBalanceaFileServiceImpl.getBalanceaFileModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delBalanceaFileModelByCode(Map<String, Object> map) {
        int i;
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            i = this.baBalanceaFileMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ba.BaBalanceaFileServiceImpl.delBalanceaFileModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ba.BaBalanceaFileServiceImpl.delBalanceaFileModelByCode.num");
        }
    }

    private void deleteBalanceaFileModel(Integer balanceaFileId) throws ApiException {
        int i;
        if (null == balanceaFileId) {
            return;
        }
        try {
            i = this.baBalanceaFileMapper.deleteByPrimaryKey(balanceaFileId);
        }
        catch (Exception e) {
            throw new ApiException("ba.BaBalanceaFileServiceImpl.deleteBalanceaFileModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ba.BaBalanceaFileServiceImpl.deleteBalanceaFileModel.num");
        }
    }

    private void updateBalanceaFileModel(BaBalanceaFile baBalanceaFile) throws ApiException {
        if (null == baBalanceaFile) {
            return;
        }
        try {
            this.baBalanceaFileMapper.updateByPrimaryKeySelective(baBalanceaFile);
        }
        catch (Exception e) {
            throw new ApiException("ba.BaBalanceaFileServiceImpl.updateBalanceaFileModel.ex", (Throwable)e);
        }
    }

    private void updateStateBalanceaFileModel(Integer balanceaFileId, Integer dataState, Integer oldDataState) throws ApiException {
        int i;
        if (null == balanceaFileId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("balanceaFileId", balanceaFileId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        try {
            i = this.baBalanceaFileMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ba.BaBalanceaFileServiceImpl.updateStateBalanceaFileModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ba.BaBalanceaFileServiceImpl.updateStateBalanceaFileModel.null");
        }
    }

    private BaBalanceaFile makeBalanceaFile(BaBalanceaFileDomain baBalanceaFileDomain, BaBalanceaFile baBalanceaFile) {
        if (null == baBalanceaFileDomain) {
            return null;
        }
        if (null == baBalanceaFile) {
            baBalanceaFile = new BaBalanceaFile();
        }
        try {
            BeanUtils.copyAllPropertys((Object)baBalanceaFile, (Object)baBalanceaFileDomain);
            return baBalanceaFile;
        }
        catch (Exception e) {
            this.logger.error("ba.BaBalanceaFileServiceImpl.makeBalanceaFile", (Throwable)e);
            return null;
        }
    }

    private List<BaBalanceaFile> queryBalanceaFileModelPage(Map<String, Object> parammap) {
        try {
            return this.baBalanceaFileMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ba.BaBalanceaFileServiceImpl.queryBalanceaFileModel", (Throwable)e);
            return null;
        }
    }

    private int countBalanceaFile(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.baBalanceaFileMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ba.BaBalanceaFileServiceImpl.countBalanceaFile", (Throwable)e);
        }
        return i;
    }

    private String checkBalanceaFilelist(BaBalanceaFilelistDomain baBalanceaFilelistDomain) {
        if (null == baBalanceaFilelistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        return "";
    }

    private void setBalanceaFilelistDefault(BaBalanceaFilelist baBalanceaFilelist) {
        if (null == baBalanceaFilelist) {
            return;
        }
        if (null == baBalanceaFilelist.getDataState()) {
            baBalanceaFilelist.setDataState(0);
        }
        if (null == baBalanceaFilelist.getGmtCreate()) {
            baBalanceaFilelist.setGmtCreate(this.getSysDate());
        }
        baBalanceaFilelist.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)baBalanceaFilelist.getBalanceaFilelistSeqno())) {
            baBalanceaFilelist.setBalanceaFilelistSeqno(this.createUUIDString());
        }
    }

    private int getBalanceaFilelistMaxCode() {
        int code = 0;
        try {
            return this.baBalanceaFilelistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ba.BaBalanceaFileServiceImpl.getBalanceaFilelistMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setBalanceaFilelistUpdataDefault(BaBalanceaFilelist baBalanceaFilelist) {
        if (null == baBalanceaFilelist) {
            return;
        }
        baBalanceaFilelist.setGmtModified(this.getSysDate());
    }

    private void saveBalanceaFilelistModel(BaBalanceaFilelist baBalanceaFilelist) throws ApiException {
        if (null == baBalanceaFilelist) {
            return;
        }
        try {
            this.baBalanceaFilelistMapper.insert(baBalanceaFilelist);
        }
        catch (Exception e) {
            throw new ApiException("ba.BaBalanceaFileServiceImpl.saveBalanceaFilelistModel.ex", (Throwable)e);
        }
    }

    private BaBalanceaFilelist getBalanceaFilelistModelById(Integer balanceaFilelistId) {
        if (null == balanceaFilelistId) {
            return null;
        }
        try {
            return this.baBalanceaFilelistMapper.selectByPrimaryKey(balanceaFilelistId);
        }
        catch (Exception e) {
            this.logger.error("ba.BaBalanceaFileServiceImpl.getBalanceaFilelistModelById", (Throwable)e);
            return null;
        }
    }

    private BaBalanceaFilelist getBalanceaFilelistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.baBalanceaFilelistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ba.BaBalanceaFileServiceImpl.getBalanceaFilelistModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delBalanceaFilelistModelByCode(Map<String, Object> map) {
        int i;
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            i = this.baBalanceaFilelistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ba.BaBalanceaFileServiceImpl.delBalanceaFilelistModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ba.BaBalanceaFileServiceImpl.delBalanceaFilelistModelByCode.num");
        }
    }

    private void deleteBalanceaFilelistModel(Integer balanceaFilelistId) throws ApiException {
        int i;
        if (null == balanceaFilelistId) {
            return;
        }
        try {
            i = this.baBalanceaFilelistMapper.deleteByPrimaryKey(balanceaFilelistId);
        }
        catch (Exception e) {
            throw new ApiException("ba.BaBalanceaFileServiceImpl.deleteBalanceaFilelistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ba.BaBalanceaFileServiceImpl.deleteBalanceaFilelistModel.num");
        }
    }

    private void updateBalanceaFilelistModel(BaBalanceaFilelist baBalanceaFilelist) throws ApiException {
        if (null == baBalanceaFilelist) {
            return;
        }
        try {
            this.baBalanceaFilelistMapper.updateByPrimaryKeySelective(baBalanceaFilelist);
        }
        catch (Exception e) {
            throw new ApiException("ba.BaBalanceaFileServiceImpl.updateBalanceaFilelistModel.ex", (Throwable)e);
        }
    }

    private void updateStateBalanceaFilelistModel(Integer balanceaFilelistId, Integer dataState, Integer oldDataState) throws ApiException {
        int i;
        if (null == balanceaFilelistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("balanceaFilelistId", balanceaFilelistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        try {
            i = this.baBalanceaFilelistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ba.BaBalanceaFileServiceImpl.updateStateBalanceaFilelistModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ba.BaBalanceaFileServiceImpl.updateStateBalanceaFilelistModel.null");
        }
    }

    private BaBalanceaFilelist makeBalanceaFilelist(BaBalanceaFilelistDomain baBalanceaFilelistDomain, BaBalanceaFilelist baBalanceaFilelist) {
        if (null == baBalanceaFilelistDomain) {
            return null;
        }
        if (null == baBalanceaFilelist) {
            baBalanceaFilelist = new BaBalanceaFilelist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)baBalanceaFilelist, (Object)baBalanceaFilelistDomain);
            return baBalanceaFilelist;
        }
        catch (Exception e) {
            this.logger.error("ba.BaBalanceaFileServiceImpl.makeBalanceaFilelist", (Throwable)e);
            return null;
        }
    }

    private List<BaBalanceaFilelist> queryBalanceaFilelistModelPage(Map<String, Object> parammap) {
        try {
            return this.baBalanceaFilelistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ba.BaBalanceaFileServiceImpl.queryBalanceaFilelistModel", (Throwable)e);
            return null;
        }
    }

    private int countBalanceaFilelist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.baBalanceaFilelistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ba.BaBalanceaFileServiceImpl.countBalanceaFilelist", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveBalanceaFile(BaBalanceaFileDomain baBalanceaFileDomain) throws ApiException {
        String msg = this.checkBalanceaFile(baBalanceaFileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ba.BaBalanceaFileServiceImpl.saveBalanceaFile.checkBalanceaFile", msg);
        }
        BaBalanceaFile baBalanceaFile = this.makeBalanceaFile(baBalanceaFileDomain, null);
        this.setBalanceaFileDefault(baBalanceaFile);
        this.saveBalanceaFileModel(baBalanceaFile);
    }

    @Override
    public void updateBalanceaFileState(Integer balanceaFileId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateBalanceaFileModel(balanceaFileId, dataState, oldDataState);
    }

    @Override
    public void updateBalanceaFile(BaBalanceaFileDomain baBalanceaFileDomain) throws ApiException {
        String msg = this.checkBalanceaFile(baBalanceaFileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ba.BaBalanceaFileServiceImpl.updateBalanceaFile.checkBalanceaFile", msg);
        }
        BaBalanceaFile oldBaBalanceaFile = this.getBalanceaFileModelById(baBalanceaFileDomain.getBalanceaFileId());
        if (null == oldBaBalanceaFile) {
            throw new ApiException("ba.BaBalanceaFileServiceImpl.updateBalanceaFile.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        BaBalanceaFile baBalanceaFile = this.makeBalanceaFile(baBalanceaFileDomain, oldBaBalanceaFile);
        this.setBalanceaFileUpdataDefault(baBalanceaFile);
        this.updateBalanceaFileModel(baBalanceaFile);
    }

    @Override
    public BaBalanceaFile getBalanceaFile(Integer balanceaFileId) {
        return this.getBalanceaFileModelById(balanceaFileId);
    }

    @Override
    public void deleteBalanceaFile(Integer balanceaFileId) throws ApiException {
        this.deleteBalanceaFileModel(balanceaFileId);
    }

    @Override
    public QueryResult<BaBalanceaFile> queryBalanceaFilePage(Map<String, Object> map) {
        List<BaBalanceaFile> baBalanceaFileList = this.queryBalanceaFileModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countBalanceaFile(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(baBalanceaFileList);
        return queryResult;
    }

    @Override
    public BaBalanceaFile getBalanceaFileByCode(Map<String, Object> map) {
        return this.getBalanceaFileModelByCode(map);
    }

    @Override
    public void delBalanceaFileByCode(Map<String, Object> map) throws ApiException {
        this.delBalanceaFileModelByCode(map);
    }

    @Override
    public void saveBalanceaFilelist(BaBalanceaFilelistDomain baBalanceaFilelistDomain) throws ApiException {
        String msg = this.checkBalanceaFilelist(baBalanceaFilelistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ba.BaBalanceaFileServiceImpl.saveBalanceaFilelist.checkBalanceaFilelist", msg);
        }
        BaBalanceaFilelist baBalanceaFilelist = this.makeBalanceaFilelist(baBalanceaFilelistDomain, null);
        this.setBalanceaFilelistDefault(baBalanceaFilelist);
        this.saveBalanceaFilelistModel(baBalanceaFilelist);
    }

    @Override
    public void updateBalanceaFilelistState(Integer balanceaFilelistId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateBalanceaFilelistModel(balanceaFilelistId, dataState, oldDataState);
    }

    @Override
    public void updateBalanceaFilelist(BaBalanceaFilelistDomain baBalanceaFilelistDomain) throws ApiException {
        String msg = this.checkBalanceaFilelist(baBalanceaFilelistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ba.BaBalanceaFileServiceImpl.updateBalanceaFilelist.checkBalanceaFilelist", msg);
        }
        BaBalanceaFilelist oldBaBalanceaFilelist = this.getBalanceaFilelistModelById(baBalanceaFilelistDomain.getBalanceaFilelistId());
        if (null == oldBaBalanceaFilelist) {
            throw new ApiException("ba.BaBalanceaFileServiceImpl.updateBalanceaFilelist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        BaBalanceaFilelist baBalanceaFilelist = this.makeBalanceaFilelist(baBalanceaFilelistDomain, oldBaBalanceaFilelist);
        this.setBalanceaFilelistUpdataDefault(baBalanceaFilelist);
        this.updateBalanceaFilelistModel(baBalanceaFilelist);
    }

    @Override
    public BaBalanceaFilelist getBalanceaFilelist(Integer balanceaFilelistId) {
        return this.getBalanceaFilelistModelById(balanceaFilelistId);
    }

    @Override
    public void deleteBalanceaFilelist(Integer balanceaFilelistId) throws ApiException {
        this.deleteBalanceaFilelistModel(balanceaFilelistId);
    }

    @Override
    public QueryResult<BaBalanceaFilelist> queryBalanceaFilelistPage(Map<String, Object> map) {
        List<BaBalanceaFilelist> baBalanceaFilelistList = this.queryBalanceaFilelistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countBalanceaFilelist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(baBalanceaFilelistList);
        return queryResult;
    }

    @Override
    public BaBalanceaFilelist getBalanceaFilelistByCode(Map<String, Object> map) {
        return this.getBalanceaFilelistModelByCode(map);
    }

    @Override
    public void delBalanceaFilelistByCode(Map<String, Object> map) throws ApiException {
        this.delBalanceaFilelistModelByCode(map);
    }

    @Override
    public void batchBarFile(String date) {
        String dateParam = date == null ? DateUtil.getDateStr((String)"yyyy-MM-dd") : date;
        HashMap<String, String> outerParams = new HashMap<String, String>();
        HashMap<String, String> innerParams = new HashMap<String, String>();
        innerParams.put("date", dateParam);
        outerParams.put("map", JsonUtil.buildNormalBinder().toJson(innerParams));
        String json = this.internalInvoke("cm.channelBar.getSuccess", outerParams);
        this.logger.info("ba.baBalanceaFile.batchBarFile:cm.channelBar.getSuccess", (Object)json);
        List baBalanceaCmChannelBars = (List)JsonUtil.buildNormalBinder().getJsonToList(json, BaBalanceaCmChannelBar.class);
        for (BaBalanceaCmChannelBar bar : baBalanceaCmChannelBars) {
            if (null == bar.getChannelBarFilecode()) continue;
            this.logger.info(bar.getFchannelType(), (Object)"start parse bill");
            this.parseBillFileAndSaveDetil(bar);
            this.saveBillFileSnapshot(bar);
        }
    }

    @Override
    public BaBalanceaFile getBalanceaFileByUnique(String tenantCode, String fchannelCode, Date billDate) {
        assert (StringUtils.hasBlank((String[])new String[]{tenantCode, fchannelCode}) || billDate == null);
        if (StringUtils.hasBlank((String[])new String[]{tenantCode, fchannelCode}) || billDate == null) {
            return null;
        }
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("tenantCode", tenantCode);
        queryParams.put("fchannelCode", fchannelCode);
        queryParams.put("balanceaFileTime", DateUtils.getDateString((Date)billDate, (String)"yyyy-MM-dd"));
        return this.baBalanceaFileMapper.getByBalanceaFileTimeAndTenantCodeAndFchannelCode(queryParams);
    }

    private void saveBillFileSnapshot(BaBalanceaCmChannelBar bar) {
        if (StringUtils.hasBlank((String[])new String[]{bar.getTenantCode(), bar.getFchannelType()})) {
            this.logger.error("IllegalArgument", (Object)"tenantCode, fchannelCode can`t be null");
            return;
        }
        Map<String, Object> queryParams = this.convertMap(this.stringToDateAbleNull(bar.getChannelBarDate(), "yyyy-MM-dd"), bar.getTenantCode(), bar.getFchannelType());
        double sum = this.getSumByFileList(queryParams);
        int count = this.countBalanceaFilelist(queryParams);
        BaBalanceaFile record = new BaBalanceaFile();
        record.setBalanceaFileTime(bar.getChannelBarDate());
        record.setBalanceaFileNum(count);
        record.setBalanceaFileAmount(new BigDecimal(sum + ""));
        record.setFchannelCode(bar.getFchannelType());
        record.setDicPayType("ALL");
        record.setTenantCode(bar.getTenantCode());
        record.setDataState(1);
        BaBalanceaFile exists = this.baBalanceaFileMapper.getByBalanceaFileTimeAndTenantCodeAndFchannelCode(queryParams);
        if (null != exists) {
            record.setBalanceaFileId(exists.getBalanceaFileId());
            record.setGmtModified(Calendar.getInstance().getTime());
            this.updateBalanceaFileModel(record);
        } else {
            this.setBalanceaFileDefault(record);
            this.insertSelectiveBaFile(record);
        }
    }

    private String stringToDateAbleNull(String dateStr, String pattern) {
        if (StringUtils.isBlank((String)dateStr)) {
            return DateUtil.getDateStr((String)pattern);
        }
        return DateUtil.getDateString((String)dateStr, (String)pattern);
    }

    private void parseBillFileAndSaveDetil(BaBalanceaCmChannelBar bar) {
        BaDownloadFileDomainBean baDownloadFileDomainBean = this.getDownloadBillFile(bar.getChannelBarFilecode());
        if (baDownloadFileDomainBean.getFilecontent() == null) {
            this.logger.error("ba.baBalanceaFile.batchBarFile.parseBillFileAndSaveDetil", (Object)String.format("channelBarFileCode: %s, fchannelType: %s, channelBarDate: %s, tenantCode: %s", bar.getChannelBarFilecode(), bar.getFchannelType(), bar.getChannelBarDate(), bar.getTenantCode()));
            return;
        }
        this.logger.info("ba.baBalanceaFile.batchBarFile:parseBillFileAndSaveDetil", (Object)new String(baDownloadFileDomainBean.getFilecontent()));
        List<BaBalanceaFilelist> baBalanceaFilelists = this.parseBillContentDistinct(baDownloadFileDomainBean, bar.getFchannelType(), bar.getChannelBarDate());
        this.batchInsert(baBalanceaFilelists);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<BaBalanceaFilelist> parseBillContentDistinct(BaDownloadFileDomainBean baDownloadFileDomainBean, String fChannelType, String billDate) {
        try (BufferedReader read = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(baDownloadFileDomainBean.getFilecontent()), "GBK"));){
            String line;
            read.readLine();
            ArrayList<BaBalanceaFilelist> baBalanceaFilelists = new ArrayList<BaBalanceaFilelist>();
            while ((line = read.readLine()) != null) {
                try {
                    line = line.replace("\t", "").replace("\"", "");
                    String[] document = line.split(",");
                    if (document.length < 1) break;
                    BaBalanceaFilelist balanceaFilelist = new BaBalanceaFilelist();
                    this.setBalanceaFilelistDefault(balanceaFilelist);
                    balanceaFilelist.setBalanceaFileTime(DateUtil.getDateToString((String)billDate, (String)"yyyy-MM-dd"));
                    balanceaFilelist.setBalanceaFilelistNo(document[3] == null ? "" : document[3]);
                    balanceaFilelist.setBalanceaFilelistOpno(document[4] == null ? "" : document[4]);
                    balanceaFilelist.setBalanceaFilelistState(document[6] == null ? "" : document[6]);
                    String amount = document[5].replace("-", "");
                    balanceaFilelist.setBalanceaFilelistAmount(new BigDecimal(amount));
                    balanceaFilelist.setFchannelCode(fChannelType);
                    String PayType = "PAY,IN";
                    this.logger.info("~~~~~~~~~~~~~~" + document[2]);
                    if ("\u9000\u6b3e".equals(document[2])) {
                        PayType = "OUT";
                    }
                    balanceaFilelist.setDicPayType(PayType);
                    this.logger.debug(balanceaFilelist.getDicPayType() + "~~~~~~~~~~");
                    balanceaFilelist.setTenantCode(document[7] == null ? "" : document[7]);
                    balanceaFilelist.setDataState(BaBalanceaOnStateEnum.NOT_ON_ACCOUNT_0.getCode());
                    balanceaFilelist.setMemo("");
                    if (this.isExisted(balanceaFilelist.getBalanceaFilelistOpno(), balanceaFilelist.getTenantCode())) continue;
                    baBalanceaFilelists.add(balanceaFilelist);
                }
                catch (Exception e) {
                    this.logger.error((Throwable)e);
                }
            }
            ArrayList<BaBalanceaFilelist> arrayList = baBalanceaFilelists;
            return arrayList;
        }
        catch (IOException e) {
            this.logger.error((Throwable)e);
            return Collections.emptyList();
        }
    }

    private BaDownloadFileDomainBean getDownloadBillFile(String channelBarFileCode) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("fileCode", channelBarFileCode);
        String json = this.internalInvoke("fm.file.getDownloadFile", parameters);
        return (BaDownloadFileDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(json, BaDownloadFileDomainBean.class);
    }

    private boolean isExisted(String balanceaFilelistNo, String tenantCode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("balanceaFilelistOpno", balanceaFilelistNo);
        param.put("tenantCode", tenantCode);
        return this.baBalanceaFilelistMapper.count(param) > 0;
    }

    private void batchInsert(List<BaBalanceaFilelist> baBalanceaFilelists) {
        try {
            if (CollectionUtils.isEmpty(baBalanceaFilelists)) {
                return;
            }
            this.baBalanceaFilelistMapper.insertBatch(baBalanceaFilelists);
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
        }
    }

    private void insertSelectiveBaFile(BaBalanceaFile record) {
        this.baBalanceaFileMapper.insertSelective(record);
    }

    private Map<String, Object> convertMap(String billDate, String tenantCode, String fchannelCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("balanceaFileTime", billDate);
        params.put("tenantCode", tenantCode);
        params.put("fchannelCode", fchannelCode);
        return params;
    }

    private double getSumByFileList(Map<String, Object> params) {
        return this.baBalanceaFilelistMapper.getSum(params);
    }
}

