/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.balanceaccount.service.impl;

import com.yqbsoft.laser.service.balanceaccount.constant.BaBalanceaOnStateEnum;
import com.yqbsoft.laser.service.balanceaccount.constant.BaBalanceaStateEnum;
import com.yqbsoft.laser.service.balanceaccount.dao.BaBalanceaClearMapper;
import com.yqbsoft.laser.service.balanceaccount.dao.BaBalanceaMapper;
import com.yqbsoft.laser.service.balanceaccount.domain.BaBalanceaClearDomain;
import com.yqbsoft.laser.service.balanceaccount.domain.BaBalanceaDomain;
import com.yqbsoft.laser.service.balanceaccount.model.BaBalancea;
import com.yqbsoft.laser.service.balanceaccount.model.BaBalanceaClear;
import com.yqbsoft.laser.service.balanceaccount.model.BaBalanceaFile;
import com.yqbsoft.laser.service.balanceaccount.model.BaBalanceaFilelist;
import com.yqbsoft.laser.service.balanceaccount.model.BaChannelClear;
import com.yqbsoft.laser.service.balanceaccount.service.BaBalanceaFileService;
import com.yqbsoft.laser.service.balanceaccount.service.BaBalanceaService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.supper.SupperRuestDomain;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class BaBalanceaServiceImpl
extends BaseServiceImpl
implements BaBalanceaService {
    private static final String SYS_CODE = "ba.BaBalanceaServiceImpl";
    @Autowired
    private BaBalanceaMapper baBalanceaMapper;
    @Autowired
    private BaBalanceaClearMapper baBalanceaClearMapper;
    @Autowired
    private BaBalanceaFileService baBalanceaFileService;

    private Date getSysDate() {
        try {
            return this.baBalanceaMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ba.BaBalanceaServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkBalancea(BaBalanceaDomain baBalanceaDomain) {
        if (null == baBalanceaDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        return "";
    }

    private void setBalanceaDefault(BaBalancea baBalancea) {
        if (null == baBalancea) {
            return;
        }
        if (null == baBalancea.getDataState()) {
            baBalancea.setDataState(0);
        }
        if (null == baBalancea.getGmtCreate()) {
            baBalancea.setGmtCreate(this.getSysDate());
        }
        baBalancea.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)baBalancea.getBalanceaSeqno())) {
            baBalancea.setBalanceaSeqno(this.createUUIDString());
        }
    }

    private int getBalanceaMaxCode() {
        int code = 0;
        try {
            return this.baBalanceaMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ba.BaBalanceaServiceImpl.getBalanceaMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setBalanceaUpdataDefault(BaBalancea baBalancea) {
        if (null == baBalancea) {
            return;
        }
        baBalancea.setGmtModified(this.getSysDate());
    }

    private void saveBalanceaModel(BaBalancea baBalancea) throws ApiException {
        if (null == baBalancea) {
            return;
        }
        try {
            this.baBalanceaMapper.insert(baBalancea);
        }
        catch (Exception e) {
            throw new ApiException("ba.BaBalanceaServiceImpl.saveBalanceaModel.ex", (Throwable)e);
        }
    }

    private BaBalancea getBalanceaModelById(Integer balanceaId) {
        if (null == balanceaId) {
            return null;
        }
        try {
            return this.baBalanceaMapper.selectByPrimaryKey(balanceaId);
        }
        catch (Exception e) {
            this.logger.error("ba.BaBalanceaServiceImpl.getBalanceaModelById", (Throwable)e);
            return null;
        }
    }

    private BaBalancea getBalanceaModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.baBalanceaMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ba.BaBalanceaServiceImpl.getBalanceaModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delBalanceaModelByCode(Map<String, Object> map) {
        int i;
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            i = this.baBalanceaMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ba.BaBalanceaServiceImpl.delBalanceaModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ba.BaBalanceaServiceImpl.delBalanceaModelByCode.num");
        }
    }

    private void deleteBalanceaModel(Integer balanceaId) throws ApiException {
        int i;
        if (null == balanceaId) {
            return;
        }
        try {
            i = this.baBalanceaMapper.deleteByPrimaryKey(balanceaId);
        }
        catch (Exception e) {
            throw new ApiException("ba.BaBalanceaServiceImpl.deleteBalanceaModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ba.BaBalanceaServiceImpl.deleteBalanceaModel.num");
        }
    }

    private void updateBalanceaModel(BaBalancea baBalancea) throws ApiException {
        if (null == baBalancea) {
            return;
        }
        try {
            this.baBalanceaMapper.updateByPrimaryKeySelective(baBalancea);
        }
        catch (Exception e) {
            throw new ApiException("ba.BaBalanceaServiceImpl.updateBalanceaModel.ex", (Throwable)e);
        }
    }

    private void updateStateBalanceaModel(Integer balanceaId, Integer dataState, Integer oldDataState) throws ApiException {
        int i;
        if (null == balanceaId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("balanceaId", balanceaId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        try {
            i = this.baBalanceaMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ba.BaBalanceaServiceImpl.updateStateBalanceaModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ba.BaBalanceaServiceImpl.updateStateBalanceaModel.null");
        }
    }

    private void updateStateBalanceaModelByCode(String balanceaSeqno, String tenantCode, Integer balanceaClearState, Integer balanceaClearCallstate, Integer balanceaClearOnstate, Integer oldBalanceaClearState) throws ApiException {
        int i;
        if (null == balanceaSeqno || null == tenantCode) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("balanceaSeqno", balanceaSeqno);
        map.put("tenantCode", tenantCode);
        map.put("balanceaClearState", balanceaClearState);
        map.put("balanceaClearCallstate", balanceaClearCallstate);
        map.put("balanceaClearOnstate", balanceaClearOnstate);
        map.put("oldBalanceaClearState", oldBalanceaClearState);
        try {
            i = this.baBalanceaMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ba.BaBalanceaServiceImpl.updateStateBalanceaModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ba.BaBalanceaServiceImpl.updateStateBalanceaModelByCode.null");
        }
    }

    private BaBalancea makeBalancea(BaBalanceaDomain baBalanceaDomain, BaBalancea baBalancea) {
        if (null == baBalanceaDomain) {
            return null;
        }
        if (null == baBalancea) {
            baBalancea = new BaBalancea();
        }
        try {
            BeanUtils.copyAllPropertys((Object)baBalancea, (Object)baBalanceaDomain);
            return baBalancea;
        }
        catch (Exception e) {
            this.logger.error("ba.BaBalanceaServiceImpl.makeBalancea", (Throwable)e);
            return null;
        }
    }

    private List<BaBalancea> queryBalanceaModelPage(Map<String, Object> parammap) {
        try {
            return this.baBalanceaMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ba.BaBalanceaServiceImpl.queryBalanceaModel", (Throwable)e);
            return null;
        }
    }

    private int countBalancea(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.baBalanceaMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ba.BaBalanceaServiceImpl.countBalancea", (Throwable)e);
        }
        return i;
    }

    private String checkBalanceaClear(BaBalanceaClearDomain baBalanceaClearDomain) {
        if (null == baBalanceaClearDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setBalanceaClearDefault(BaBalanceaClear baBalanceaClear) {
        if (null == baBalanceaClear) {
            return;
        }
        if (null == baBalanceaClear.getDataState()) {
            baBalanceaClear.setDataState(0);
        }
        if (null == baBalanceaClear.getGmtCreate()) {
            baBalanceaClear.setGmtCreate(this.getSysDate());
        }
        baBalanceaClear.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)baBalanceaClear.getBalanceaClearSeqno())) {
            baBalanceaClear.setBalanceaClearSeqno(this.createUUIDString());
        }
    }

    private int getBalanceaClearMaxCode() {
        int code = 0;
        try {
            return this.baBalanceaClearMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ba.BaBalanceaServiceImpl.getBalanceaClearMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setBalanceaClearUpdataDefault(BaBalanceaClear baBalanceaClear) {
        if (null == baBalanceaClear) {
            return;
        }
        baBalanceaClear.setGmtModified(this.getSysDate());
    }

    private void saveBalanceaClearModel(BaBalanceaClear baBalanceaClear) throws ApiException {
        if (null == baBalanceaClear) {
            return;
        }
        try {
            this.baBalanceaClearMapper.insert(baBalanceaClear);
        }
        catch (Exception e) {
            throw new ApiException("ba.BaBalanceaServiceImpl.saveBalanceaClearModel.ex", (Throwable)e);
        }
    }

    private void saveBalanceaClearBatchModel(List<BaBalanceaClear> baBalanceaClearList) throws ApiException {
        if (null == baBalanceaClearList || baBalanceaClearList.isEmpty()) {
            return;
        }
        try {
            this.baBalanceaClearMapper.insertBatch(baBalanceaClearList);
        }
        catch (Exception e) {
            throw new ApiException("ba.BaBalanceaServiceImpl.saveBalanceaClearBatchModel.ex", (Throwable)e);
        }
    }

    private BaBalanceaClear getBalanceaClearModelById(Integer balanceaClearId) {
        if (null == balanceaClearId) {
            return null;
        }
        try {
            return this.baBalanceaClearMapper.selectByPrimaryKey(balanceaClearId);
        }
        catch (Exception e) {
            this.logger.error("ba.BaBalanceaServiceImpl.getBalanceaClearModelById", (Throwable)e);
            return null;
        }
    }

    private BaBalancea getBalancea(String tenantCode, Date balanceaTime, String fchannelCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantCode", tenantCode);
        params.put("fchannelCode", fchannelCode);
        params.put("balanceaTime", DateUtil.getDateString((Date)balanceaTime, (String)"yyyy-MM-dd"));
        List<BaBalancea> baBalanceas = this.baBalanceaMapper.query(params);
        if (CollectionUtils.isEmpty(baBalanceas)) {
            return null;
        }
        return baBalanceas.get(0);
    }

    private BaBalanceaClear getBalanceaClearModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.baBalanceaClearMapper.getByBalanceaClearSeqnoStrictlyAndTenantCode(map);
        }
        catch (Exception e) {
            this.logger.error("ba.BaBalanceaServiceImpl.getBalanceaClearModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delBalanceaClearModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.baBalanceaClearMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ba.BaBalanceaServiceImpl.delBalanceaClearModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ba.BaBalanceaServiceImpl.delBalanceaClearModelByCode.num");
        }
    }

    private void deleteBalanceaClearModel(Integer balanceaClearId) throws ApiException {
        int i;
        if (null == balanceaClearId) {
            return;
        }
        try {
            i = this.baBalanceaClearMapper.deleteByPrimaryKey(balanceaClearId);
        }
        catch (Exception e) {
            throw new ApiException("ba.BaBalanceaServiceImpl.deleteBalanceaClearModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ba.BaBalanceaServiceImpl.deleteBalanceaClearModel.num");
        }
    }

    private void updateBalanceaClearModel(BaBalanceaClear baBalanceaClear) throws ApiException {
        if (null == baBalanceaClear) {
            return;
        }
        try {
            this.baBalanceaClearMapper.updateByPrimaryKeySelective(baBalanceaClear);
        }
        catch (Exception e) {
            throw new ApiException("ba.BaBalanceaServiceImpl.updateBalanceaClearModel.ex", (Throwable)e);
        }
    }

    private void updateStateBalanceaClearModel(Integer balanceaClearId, Integer dataState, Integer oldDataState) throws ApiException {
        int i;
        if (null == balanceaClearId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("balanceaClearId", balanceaClearId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        try {
            i = this.baBalanceaClearMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ba.BaBalanceaServiceImpl.updateStateBalanceaClearModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ba.BaBalanceaServiceImpl.updateStateBalanceaClearModel.null");
        }
    }

    private void updateSStateBalanceaClearModel(BaBalanceaClear baBalanceaClear) throws ApiException {
        int flag;
        if (null == baBalanceaClear.getBalanceaClearSeqno() || null == baBalanceaClear.getTenantCode()) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("balanceaClearSeqno", baBalanceaClear.getBalanceaClearSeqno());
        map.put("tenantCode", baBalanceaClear.getTenantCode());
        map.put("balanceaClearState", baBalanceaClear.getBalanceaClearState());
        map.put("balanceaClearCallstate", baBalanceaClear.getBalanceaClearCallstate());
        map.put("balanceaClearOnstate", baBalanceaClear.getBalanceaClearOnstate());
        map.put("memo", baBalanceaClear.getMemo());
        try {
            flag = this.baBalanceaClearMapper.updateSStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ba.BaBalanceaServiceImpl.updateSStateBalanceaClearModel.ex", (Throwable)e);
        }
        if (flag <= 0) {
            throw new ApiException("ba.BaBalanceaServiceImpl.updateSStateBalanceaClearModel.null");
        }
    }

    private void updateCallStateBalanceaClearModel(String balanceaClearSeqno, String tenantCode, Integer balanceaClearCallstate, Integer oldBalanceaClearCallstate) throws ApiException {
        if (null == balanceaClearSeqno || null == tenantCode) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("balanceaClearSeqno", balanceaClearSeqno);
        map.put("tenantCode", tenantCode);
        map.put("balanceaClearCallstate", balanceaClearCallstate);
        map.put("oldBalanceaClearCallstate", oldBalanceaClearCallstate);
        try {
            this.baBalanceaClearMapper.updateCallStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ba.BaBalanceaServiceImpl.updateCallStateBalanceaClearModel.ex", (Throwable)e);
        }
    }

    private BaBalanceaClear makeBalanceaClear(BaBalanceaClearDomain baBalanceaClearDomain, BaBalanceaClear baBalanceaClear) {
        if (null == baBalanceaClearDomain) {
            return null;
        }
        if (null == baBalanceaClear) {
            baBalanceaClear = new BaBalanceaClear();
        }
        try {
            BeanUtils.copyAllPropertys((Object)baBalanceaClear, (Object)baBalanceaClearDomain);
            return baBalanceaClear;
        }
        catch (Exception e) {
            this.logger.error("ba.BaBalanceaServiceImpl.makeBalanceaClear", (Throwable)e);
            return null;
        }
    }

    private List<BaBalanceaClear> queryBalanceaClearModelPage(Map<String, Object> parammap) {
        try {
            return this.baBalanceaClearMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ba.BaBalanceaServiceImpl.queryBalanceaClearModel", (Throwable)e);
            return null;
        }
    }

    private int countBalanceaClear(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.baBalanceaClearMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ba.BaBalanceaServiceImpl.countBalanceaClear", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveBalancea(BaBalanceaDomain baBalanceaDomain) throws ApiException {
        BaBalancea baBalancea = this.createBalancea(baBalanceaDomain);
        this.saveBalanceaModel(baBalancea);
    }

    private BaBalancea createBalancea(BaBalanceaDomain baBalanceaDomain) {
        String msg = this.checkBalancea(baBalanceaDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ba.BaBalanceaServiceImpl.saveBalancea.checkBalancea", msg);
        }
        BaBalancea baBalancea = this.makeBalancea(baBalanceaDomain, null);
        this.setBalanceaDefault(baBalancea);
        return baBalancea;
    }

    @Override
    public void updateBalanceaState(Integer balanceaId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateBalanceaModel(balanceaId, dataState, oldDataState);
    }

    @Override
    public void updateBalancea(BaBalanceaDomain baBalanceaDomain) throws ApiException {
        String msg = this.checkBalancea(baBalanceaDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ba.BaBalanceaServiceImpl.updateBalancea.checkBalancea", msg);
        }
        BaBalancea oldBaBalancea = this.getBalanceaModelById(baBalanceaDomain.getBalanceaId());
        if (null == oldBaBalancea) {
            throw new ApiException("ba.BaBalanceaServiceImpl.updateBalancea.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        BaBalancea baBalancea = this.makeBalancea(baBalanceaDomain, oldBaBalancea);
        this.setBalanceaUpdataDefault(baBalancea);
        this.updateBalanceaModel(baBalancea);
    }

    @Override
    public BaBalancea getBalancea(Integer balanceaId) {
        return this.getBalanceaModelById(balanceaId);
    }

    @Override
    public void deleteBalancea(Integer balanceaId) throws ApiException {
        this.deleteBalanceaModel(balanceaId);
    }

    @Override
    public QueryResult<BaBalancea> queryBalanceaPage(Map<String, Object> map) {
        List<BaBalancea> baBalanceaList = this.queryBalanceaModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countBalancea(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(baBalanceaList);
        return queryResult;
    }

    @Override
    public BaBalancea getBalanceaByCode(Map<String, Object> map) {
        return this.getBalanceaModelByCode(map);
    }

    @Override
    public void delBalanceaByCode(Map<String, Object> map) throws ApiException {
        this.delBalanceaModelByCode(map);
    }

    @Override
    public void saveBalanceaClear(BaBalanceaClearDomain baBalanceaClearDomain) throws ApiException {
        BaBalanceaClear baBalanceaClear = this.createBalanceaClear(baBalanceaClearDomain);
        this.saveBalanceaClearModel(baBalanceaClear);
    }

    private BaBalanceaClear createBalanceaClear(BaBalanceaClearDomain baBalanceaClearDomain) {
        String msg = this.checkBalanceaClear(baBalanceaClearDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ba.BaBalanceaServiceImpl.saveBalanceaClear.checkBalanceaClear", msg);
        }
        BaBalanceaClear baBalanceaClear = this.makeBalanceaClear(baBalanceaClearDomain, null);
        this.setBalanceaClearDefault(baBalanceaClear);
        return baBalanceaClear;
    }

    @Override
    public void saveBatchBalanceaClear(List<BaBalanceaClearDomain> vdFaccountDoDomainList) throws ApiException {
        if (null == vdFaccountDoDomainList || vdFaccountDoDomainList.isEmpty()) {
            throw new ApiException("ba.BaBalanceaServiceImpl.sendBalanceaClear.null");
        }
        ArrayList<BaBalanceaClear> baBalanceaClearList = new ArrayList<BaBalanceaClear>();
        for (BaBalanceaClearDomain baBalanceaClearDomain : vdFaccountDoDomainList) {
            BaBalanceaClear baBalanceaClear = this.createBalanceaClear(baBalanceaClearDomain);
            baBalanceaClear.setBalanceaClearType("0");
            baBalanceaClearList.add(baBalanceaClear);
        }
        this.saveBalanceaClearBatchModel(baBalanceaClearList);
    }

    @Override
    public void updateBalanceaClearState(Integer balanceaClearId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateBalanceaClearModel(balanceaClearId, dataState, oldDataState);
    }

    @Override
    public void updateBalanceaClear(BaBalanceaClearDomain baBalanceaClearDomain) throws ApiException {
        String msg = this.checkBalanceaClear(baBalanceaClearDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ba.BaBalanceaServiceImpl.updateBalanceaClear.checkBalanceaClear", msg);
        }
        BaBalanceaClear oldBaBalanceaClear = this.getBalanceaClearModelById(baBalanceaClearDomain.getBalanceaClearId());
        if (null == oldBaBalanceaClear) {
            throw new ApiException("ba.BaBalanceaServiceImpl.updateBalanceaClear.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        BaBalanceaClear baBalanceaClear = this.makeBalanceaClear(baBalanceaClearDomain, oldBaBalanceaClear);
        this.setBalanceaClearUpdataDefault(baBalanceaClear);
        this.updateBalanceaClearModel(baBalanceaClear);
    }

    @Override
    public BaBalanceaClear getBalanceaClear(Integer balanceaClearId) {
        return this.getBalanceaClearModelById(balanceaClearId);
    }

    @Override
    public void deleteBalanceaClear(Integer balanceaClearId) throws ApiException {
        this.deleteBalanceaClearModel(balanceaClearId);
    }

    @Override
    public QueryResult<BaBalanceaClear> queryBalanceaClearPage(Map<String, Object> map) {
        List<BaBalanceaClear> baBalanceaClearList = this.queryBalanceaClearModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countBalanceaClear(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(baBalanceaClearList);
        return queryResult;
    }

    @Override
    public BaBalanceaClear getBalanceaClearByCode(Map<String, Object> map) {
        return this.getBalanceaClearModelByCode(map);
    }

    @Override
    public void delBalanceaClearByCode(Map<String, Object> map) throws ApiException {
        this.delBalanceaClearModelByCode(map);
    }

    @Override
    public void updateBalanceCall(String balanceaClearSeqno, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("balanceaClearSeqno", balanceaClearSeqno);
        map.put("tenantCode", tenantCode);
        BaBalanceaClear baBalanceaClear = this.getBalanceaClearModelByCode(map);
        this.logger.info("ba.baBalancea.updateBalanceCall:" + ((Object)map).toString());
        if (null == baBalanceaClear) {
            throw new ApiException("ba.BaBalanceaServiceImpl.updateBalanceOk.null", ((Object)map).toString());
        }
        if (2 == baBalanceaClear.getBalanceaClearCallstate()) {
            return;
        }
        this.updateCallStateBalanceaClearModel(balanceaClearSeqno, tenantCode, 2, 0);
        SupperRuestDomain ruestDomain = new SupperRuestDomain();
        ruestDomain.setApiCode("pe.payClear.sendClearOrderNext");
        ruestDomain.setOrderCode(baBalanceaClear.getClearOrderSeqno());
        ruestDomain.setTenantCode(baBalanceaClear.getTenantCode());
        ruestDomain.setOrderState("2");
        ruestDomain.setReorderCode(baBalanceaClear.getBalanceaClearSeqno());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ruestDomain", JsonUtil.buildNormalBinder().toJson((Object)ruestDomain));
        try {
            this.internalInvoke(ruestDomain.getApiCode(), paramMap);
        }
        catch (Exception e) {
            this.logger.error("pe.payClear.sendClearOrderNext.error", (Throwable)e);
        }
    }

    @Override
    public void updateBalanceAccount(String billDate) {
        Date billFileDate = this.convertDateStrToBillFileDate(billDate);
        this.reconciliation(0, 10000, billFileDate);
        int onStateNum = this.setBaBalanceaClearOnState(BaBalanceaOnStateEnum.ON_ACCOUNT_1.getCode(), BaBalanceaOnStateEnum.NOT_ON_ACCOUNT_0.getCode(), BaBalanceaStateEnum.FINISH.getCode(), BaBalanceaStateEnum.NOTSTARTED.getCode());
        this.logger.info("ONACCOUNT", (Object)("ba_balancea_clear clearOnState number:" + onStateNum));
        this.summarizingBalancea(this.getOrderDate(billFileDate));
    }

    private void reconciliation(int startRow, int pageSize, Date billDate) {
        this.logger.info("ba.baBalancea.updateBalanceAccount:start", (Object)String.format("startRow:%d,pageSize:%d,billDate:%tF", startRow, pageSize, billDate));
        List<BaBalanceaFilelist> baBalanceaFilelists = this.getBaBalanceaFileListByPage(startRow, pageSize, billDate);
        for (BaBalanceaFilelist balanceaFilelist : baBalanceaFilelists) {
            BaBalanceaClear baBalanceaClear = this.getBalanceaClearByOrderBankSeq(balanceaFilelist.getBalanceaFilelistOpno());
            if (baBalanceaClear == null) {
                this.baBalanceaFileService.updateBalanceaFilelistState(balanceaFilelist.getBalanceaFilelistId(), BaBalanceaOnStateEnum.ON_ACCOUNT_1.getCode(), balanceaFilelist.getDataState());
                if (StringUtils.isNotBlank((String)balanceaFilelist.getBalanceaFilelistOpno())) {
                    this.longBill(balanceaFilelist, this.getOrderDate(billDate));
                    continue;
                }
                this.logger.error("ba.baBalancea.updateBalanceAccount:error", (Object)"balanceaFilelistOpno is null");
                continue;
            }
            if (BaBalanceaOnStateEnum.ON_ACCOUNT_1.getCode().equals(balanceaFilelist.getDataState())) {
                this.baBalanceaFileService.updateBalanceaFilelistState(balanceaFilelist.getBalanceaFilelistId(), BaBalanceaOnStateEnum.NOT_ON_ACCOUNT_0.getCode(), balanceaFilelist.getDataState());
            }
            BigDecimal localAmount = baBalanceaClear.getOrderAmount().setScale(2);
            BigDecimal channelAmount = balanceaFilelist.getBalanceaFilelistAmount().setScale(2);
            baBalanceaClear.setBalanceaClearState(BaBalanceaStateEnum.FINISH.getCode());
            baBalanceaClear.setBalanceaClearOnstate(BaBalanceaOnStateEnum.NOT_ON_ACCOUNT_0.getCode());
            this.logger.info("ba.baBalancea.updateBalanceAccount", (Object)String.format("clearSeqno: %s, orderBankseq: %s;this system amount: %f, outside the system amount: %f", baBalanceaClear.getBalanceaClearSeqno(), baBalanceaClear.getOrderBankseq(), localAmount, channelAmount));
            if (this.checkAmount(localAmount, channelAmount) != 0) {
                baBalanceaClear.setBalanceaClearOnstate(BaBalanceaOnStateEnum.ON_ACCOUNT_1.getCode());
                baBalanceaClear.setMemo(this.getBillDifferenceMemo(localAmount, channelAmount));
                this.logger.info("ba.baBalancea.updateBalanceAccount:onState", (Object)"on account");
            }
            try {
                this.updateSStateBalanceaClearModel(baBalanceaClear);
            }
            catch (ApiException e) {
                this.logger.error((Throwable)e);
                continue;
            }
            if (DateUtils.isSameDay((Date)this.getOrderDate(billDate), (Date)baBalanceaClear.getGmtCreate())) continue;
            this.summarizingBalancea(baBalanceaClear.getGmtCreate());
        }
        if (baBalanceaFilelists.size() == pageSize) {
            this.reconciliation(pageSize * ++startRow, pageSize, billDate);
        }
    }

    private List<BaBalanceaFilelist> getBaBalanceaFileListByPage(int startRow, int pageSize, Date billDate) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("startRow", startRow);
        params.put("rows", pageSize);
        params.put("balanceaFileTime", DateUtil.getDateString((Date)billDate, (String)"yyyy-MM-dd"));
        QueryResult<BaBalanceaFilelist> queryResult = this.baBalanceaFileService.queryBalanceaFilelistPage(params);
        if (queryResult != null && !CollectionUtils.isEmpty((Collection)queryResult.getList())) {
            return queryResult.getList();
        }
        return Collections.emptyList();
    }

    private int setBaBalanceaClearOnState(Integer targetClearOnState, Integer oldClearOnState, Integer targetClearState, Integer oldClearState) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("balanceaClearOnstate", targetClearOnState);
        params.put("oldBalanceaClearOnstate", oldClearOnState);
        params.put("oldBalanceaClearState", oldClearState);
        params.put("balanceaClearState", targetClearState);
        return this.baBalanceaClearMapper.compareAndSwapState(params);
    }

    private void appendOnstateRecord(List<String> onstateRecord, String tenantCode, String fchannelCode) {
        if (null == onstateRecord || null == tenantCode || null == fchannelCode) {
            return;
        }
        assert (StringUtils.isNotBlank((String)tenantCode) || StringUtils.isNotBlank((String)fchannelCode)) : "params can`t be null";
        onstateRecord.add(tenantCode.concat(",").concat(fchannelCode));
    }

    private BaBalanceaClear getBalanceaClearByOrderBankSeq(String orderBankSeq) {
        if (StringUtils.isBlank((String)orderBankSeq)) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderBankseq", orderBankSeq);
        List<BaBalanceaClear> baBalanceaClears = this.queryBalanceaClearModelPage(params);
        if (CollectionUtils.isEmpty(baBalanceaClears)) {
            return null;
        }
        return baBalanceaClears.get(0);
    }

    private Date convertDateStrToBillFileDate(String dateStr) {
        if (StringUtils.isBlank((String)dateStr)) {
            return Calendar.getInstance().getTime();
        }
        try {
            return DateUtils.parseDate((String)dateStr, (String[])new String[]{"yyyy-MM-dd", "yyyyMMdd"});
        }
        catch (ParseException e) {
            throw new ApiException("", "Date Patterns Error eg: yyyy-MM-dd or yyyyMMdd");
        }
    }

    private Date getOrderDate(Date billFileDate) {
        if (null == billFileDate) {
            billFileDate = Calendar.getInstance().getTime();
        }
        return DateUtils.addDays((Date)billFileDate, (int)-1);
    }

    private int checkAmount(BigDecimal localAmount, BigDecimal remoteAmount) {
        if (localAmount == null || remoteAmount == null) {
            return -2;
        }
        return localAmount.compareTo(remoteAmount);
    }

    private String getBillDifferenceMemo(BigDecimal localAmount, BigDecimal remoteAmount) {
        StringBuffer sb = new StringBuffer();
        sb.append(localAmount == null ? "\u672a\u627e\u5230\u4ed8\u6b3e\u8bb0\u5f55" : "");
        sb.append(remoteAmount == null ? "\u6e20\u9053\u6570\u636e\u7f3a\u5931" : "");
        if (this.checkAmount(localAmount, remoteAmount) == 1) {
            sb.append("\u77ed\u6b3e, \u5dee\u5f02\u91d1\u989d:").append(localAmount.subtract(remoteAmount).setScale(2));
        } else if (this.checkAmount(localAmount, remoteAmount) == -1) {
            sb.append("\u957f\u6b3e, \u5dee\u5f02\u91d1\u989d:").append(remoteAmount.subtract(localAmount).setScale(2));
        }
        return sb.toString();
    }

    private void summarizingBalancea(Date orderDate) {
        List<BaBalancea> baBalanceas = this.getSummarizing(orderDate);
        for (BaBalancea balancea : baBalanceas) {
            BaBalancea exist = this.getBalancea(balancea.getTenantCode(), orderDate, balancea.getFchannelCode());
            if (null != exist) {
                balancea.setBalanceaId(exist.getBalanceaId());
                balancea.setGmtModified(Calendar.getInstance().getTime());
                this.updateBalanceaModel(balancea);
                continue;
            }
            this.setBalanceaDefault(balancea);
            balancea.setGmtCreate(Calendar.getInstance().getTime());
            this.insertSelective(balancea);
        }
    }

    private List<BaBalanceaClear> getBalanceaClears(Date orderDate, Integer balanceaClearState, String fchannelClassifyCode, String tenantCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("gmtCreate", DateUtil.getDateString((Date)orderDate, (String)"yyyy-MM-dd"));
        params.put("balanceaClearState", balanceaClearState);
        params.put("fchannelClassifyCode", fchannelClassifyCode);
        params.put("tenantCode", tenantCode);
        return this.baBalanceaClearMapper.query(params);
    }

    private List<BaBalancea> getSummarizing(Date orderDate) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderDate", DateUtil.getDateString((Date)orderDate, (String)"yyyy-MM-dd"));
        List<Map<String, String>> summaryMap = null;
        try {
            summaryMap = this.baBalanceaClearMapper.fileClearSum(params);
        }
        catch (Exception e) {
            this.logger.error("ba.BaBalanceaServiceImpl.getSummarizing", (Throwable)e);
        }
        if (CollectionUtils.isEmpty(summaryMap)) {
            return Collections.emptyList();
        }
        ArrayList<BaBalancea> result = new ArrayList<BaBalancea>();
        for (Map<String, String> balancea : summaryMap) {
            if (!balancea.containsKey("tenantCode") || !balancea.containsKey("fchannelCode")) {
                this.logger.error("BaBalanceaService.getSummarizing", (Object)balancea.toString());
                continue;
            }
            BaBalancea baBalancea = new BaBalancea();
            baBalancea.setBalanceaClearState(BaBalanceaStateEnum.FINISH.getCode());
            baBalancea.setBalanceaClearOnstate(BaBalanceaOnStateEnum.NOT_ON_ACCOUNT_0.getCode());
            baBalancea.setBalanceaTime(DateUtil.getDateString((Date)orderDate, (String)"yyyy-MM-dd"));
            baBalancea.setBalanceaNum(Integer.valueOf(balancea.get("clearNum") == null ? "0" : balancea.get("clearNum")));
            baBalancea.setBalanceaBnum(Integer.valueOf(balancea.get("fileNum") == null ? "0" : balancea.get("fileNum")));
            BigDecimal bAmount = new BigDecimal(balancea.get("fileamount") == null ? "0" : balancea.get("fileamount"));
            BigDecimal amount = new BigDecimal(balancea.get("total"));
            baBalancea.setBalanceaAmount(amount);
            baBalancea.setBalanceaBamount(bAmount);
            baBalancea.setFchannelCode(balancea.get("fchannelCode"));
            baBalancea.setDicPayType("ALL");
            baBalancea.setTenantCode(balancea.get("tenantCode"));
            baBalancea.setDataState(1);
            baBalancea.setBalanceaClearCallstate(1);
            BaBalanceaFile baBalanceaFile = this.baBalanceaFileService.getBalanceaFileByUnique(baBalancea.getTenantCode(), baBalancea.getFchannelCode(), DateUtils.addDays((Date)orderDate, (int)1));
            if (baBalanceaFile != null) {
                baBalancea.setBalanceaBamount(baBalanceaFile.getBalanceaFileAmount());
                baBalancea.setBalanceaBnum(baBalanceaFile.getBalanceaFileNum());
            }
            this.setDiffInfoBetweenBillAndOrder(baBalancea, orderDate);
            result.add(baBalancea);
        }
        return result;
    }

    private void setDiffInfoBetweenBillAndOrder(BaBalancea balancea, Date orderDate) {
        HashMap<String, Object> filelistQuerys = new HashMap<String, Object>();
        filelistQuerys.put("tenantCode", balancea.getTenantCode());
        filelistQuerys.put("fchannelCode", balancea.getFchannelCode());
        filelistQuerys.put("balanceaFileTime", DateUtils.getDayInPast((Date)orderDate, (int)-1, (String)"yyyy-MM-dd"));
        QueryResult<BaBalanceaFilelist> onStateFilelist = this.baBalanceaFileService.queryBalanceaFilelistPage(filelistQuerys);
        List<BaBalanceaClear> onStateClears = this.getBalanceaClears(orderDate, BaBalanceaOnStateEnum.ON_ACCOUNT_1.getCode(), balancea.getFchannelCode(), balancea.getTenantCode());
        if (onStateFilelist != null && !CollectionUtils.isEmpty((Collection)onStateFilelist.getList()) || !CollectionUtils.isEmpty(onStateClears)) {
            balancea.setBalanceaClearOnstate(BaBalanceaOnStateEnum.ON_ACCOUNT_1.getCode());
            balancea.setMemo(this.getBillDifferenceMemo(balancea.getBalanceaAmount(), balancea.getBalanceaBamount()));
        }
    }

    private void longBill(BaBalanceaFilelist fileList, Date orderDate) {
        BaBalanceaClear clear = new BaBalanceaClear();
        clear.setOrderAmount(fileList.getBalanceaFilelistAmount());
        String type = fileList.getDicPayType();
        if (type.equals("PAY,IN")) {
            clear.setDicPayType("IN");
        } else {
            clear.setDicPayType("INO");
        }
        clear.setOrderBankseq(fileList.getBalanceaFilelistOpno());
        clear.setDataState(6);
        clear.setGmtCreate(orderDate);
        this.logger.info("ba.baBalancea.updateBalanceAccount:longBill", (Object)String.format("orderBankseq: %s, orderDate: %tF", fileList.getBalanceaFilelistOpno(), orderDate));
        this.insertSelective(clear);
        HashMap<String, String> billParamsMap = new HashMap<String, String>();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("channelClearSeqno", fileList.getBalanceaFilelistOpno());
        billParamsMap.put("map", JsonUtil.buildNormalBinder().toJson(parameters));
        String json = this.internalInvoke("cm.channelClear.getchannelClearByCode", billParamsMap);
        BaChannelClear baChannelClear = (BaChannelClear)JsonUtil.buildNormalBinder().getJsonToObject(json, BaChannelClear.class);
        if (baChannelClear == null) {
            this.logger.error("ba.baBalancea.updateBalanceAccount:longBill.error", (Object)("cm_channel_clear table no record with params:" + ((Object)billParamsMap).toString()));
            return;
        }
        HashMap<String, String> cmParamsMap = new HashMap<String, String>();
        cmParamsMap.put("cmChannelClear", JsonUtil.buildNormalBinder().toJson((Object)baChannelClear));
        this.internalInvoke("cm.channel.retryNext", cmParamsMap);
    }

    @Override
    public void updateLongBill() {
        List<BaBalanceaClear> balanceaClears = this.getLongBaBalanceaClearList();
        for (BaBalanceaClear baBalanceaClear : balanceaClears) {
            BaBalanceaClear clear2 = this.getBalanceaClearByOrderBankseqAndDataStateNotSix(baBalanceaClear.getOrderBankseq());
            if (null == clear2) continue;
            clear2.setBalanceaClearState(1);
            this.updateSStateBalanceaClearModel(clear2);
        }
    }

    private List<BaBalanceaClear> getLongBaBalanceaClearList() {
        HashMap<String, Object> parMap2 = new HashMap<String, Object>();
        parMap2.put("dataState", 6);
        QueryResult<BaBalanceaClear> queryResult2 = this.queryBalanceaClearPage(parMap2);
        return queryResult2.getList();
    }

    @Override
    public void updateCall() {
        QueryResult<BaBalanceaClear> queryResult;
        int startRow = 0;
        do {
            Integer[] balanceaClearCallstates = new Integer[]{0, 3};
            queryResult = this.querySuccessBalanceaClearByCallsateInAndPage(0, 10000, balanceaClearCallstates);
            for (BaBalanceaClear clear : queryResult.getList()) {
                this.updateBalanceCall(clear.getBalanceaClearSeqno(), clear.getTenantCode());
            }
            ++startRow;
            startRow = queryResult.getRows().size() * startRow;
        } while (!queryResult.getList().isEmpty());
    }

    private QueryResult<BaBalanceaClear> querySuccessBalanceaClearByCallsateInAndPage(int start, int pageSize, Integer[] balanceaClearCallstates) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("startRow", start);
        params.put("rows", pageSize);
        params.put("balanceaClearCallstates", balanceaClearCallstates);
        params.put("balanceaClearOnstate", BaBalanceaOnStateEnum.NOT_ON_ACCOUNT_0.getCode());
        params.put("balanceaClearState", BaBalanceaStateEnum.FINISH.getCode());
        List<BaBalanceaClear> baBalanceaClears = this.baBalanceaClearMapper.getBalanceaClearByClearStateAndCallSateInAndPage(params);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countBalanceaClear(params));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(baBalanceaClears);
        return queryResult;
    }

    private BaBalanceaClear getBalanceaClearByOrderBankseqAndDataStateNotSix(String orderBankseq) {
        try {
            HashMap<String, Object> parMap3 = new HashMap<String, Object>();
            parMap3.put("orderBankseq", orderBankseq);
            return this.baBalanceaClearMapper.getByDateStateNotSixAndOrderBankseq(parMap3);
        }
        catch (Exception e) {
            this.logger.error("ba.BaBalanceaServiceImpl.getBalanceaClearByOrderBankseqAndDataStateNotSix", (Throwable)e);
            return null;
        }
    }

    private void insertSelective(BaBalancea baBalancea) {
        try {
            this.baBalanceaMapper.insertSelective(baBalancea);
        }
        catch (Exception e) {
            this.logger.error("ba.BaBalanceaServiceImpl.insertSelective", (Throwable)e);
        }
    }

    private void insertSelective(BaBalanceaClear clear) {
        try {
            this.baBalanceaClearMapper.insertSelective(clear);
        }
        catch (Exception e) {
            this.logger.error("ba.BaBalanceaServiceImpl.insertSelective", (Throwable)e);
        }
    }
}

