/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.basicsetting.service.impl;

import com.yqbsoft.laser.service.basicsetting.dao.BsCollMapper;
import com.yqbsoft.laser.service.basicsetting.domain.BsCollDomain;
import com.yqbsoft.laser.service.basicsetting.model.BsColl;
import com.yqbsoft.laser.service.basicsetting.service.BsCollService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BsCollServiceImpl
extends BaseServiceImpl
implements BsCollService {
    public static final String SYS_CODE = "bs.BASIC_SETTING.BsCollServiceImpl";
    private BsCollMapper bsCollMapper;

    public void setBsCollMapper(BsCollMapper bsCollMapper) {
        this.bsCollMapper = bsCollMapper;
    }

    private Date getSysDate() {
        try {
            return this.bsCollMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("bs.BASIC_SETTING.BsCollServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkColl(BsCollDomain bsCollDomain) {
        if (null == bsCollDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setCollDefault(BsColl bsColl) {
        if (null == bsColl) {
            return;
        }
        if (null == bsColl.getDataState()) {
            bsColl.setDataState(0);
        }
        if (null == bsColl.getGmtCreate()) {
            bsColl.setGmtCreate(this.getSysDate());
        }
        bsColl.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)bsColl.getCollCode())) {
            bsColl.setCollCode(this.createUUIDString());
        }
    }

    private int getCollMaxCode() {
        int code = 0;
        try {
            return this.bsCollMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("bs.BASIC_SETTING.BsCollServiceImpl.getCollMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCollUpdataDefault(BsColl bsColl) {
        if (null == bsColl) {
            return;
        }
        bsColl.setGmtModified(this.getSysDate());
    }

    private void saveCollModel(BsColl bsColl) throws ApiException {
        if (null == bsColl) {
            return;
        }
        try {
            this.bsCollMapper.insert(bsColl);
        }
        catch (Exception e) {
            throw new ApiException("bs.BASIC_SETTING.BsCollServiceImpl.saveCollModel.ex", (Throwable)e);
        }
    }

    private BsColl getCollModelById(Integer collId) {
        if (null == collId) {
            return null;
        }
        try {
            return this.bsCollMapper.selectByPrimaryKey(collId);
        }
        catch (Exception e) {
            this.logger.error("bs.BASIC_SETTING.BsCollServiceImpl.getCollModelById", (Throwable)e);
            return null;
        }
    }

    public BsColl getCollModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.bsCollMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("bs.BASIC_SETTING.BsCollServiceImpl.getCollModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delCollModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.bsCollMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("bs.BASIC_SETTING.BsCollServiceImpl.delCollModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("bs.BASIC_SETTING.BsCollServiceImpl.delCollModelByCode.num");
        }
    }

    private void deleteCollModel(Integer collId) throws ApiException {
        if (null == collId) {
            return;
        }
        int i = 0;
        try {
            i = this.bsCollMapper.deleteByPrimaryKey(collId);
        }
        catch (Exception e) {
            throw new ApiException("bs.BASIC_SETTING.BsCollServiceImpl.deleteCollModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("bs.BASIC_SETTING.BsCollServiceImpl.deleteCollModel.num");
        }
    }

    private void updateCollModel(BsColl bsColl) throws ApiException {
        if (null == bsColl) {
            return;
        }
        try {
            this.bsCollMapper.updateByPrimaryKeySelective(bsColl);
        }
        catch (Exception e) {
            throw new ApiException("bs.BASIC_SETTING.BsCollServiceImpl.updateCollModel.ex", (Throwable)e);
        }
    }

    private void updateStateCollModel(Integer collId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == collId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("collId", collId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.bsCollMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("bs.BASIC_SETTING.BsCollServiceImpl.updateStateCollModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("bs.BASIC_SETTING.BsCollServiceImpl.updateStateCollModel.null");
        }
    }

    private BsColl makeColl(BsCollDomain bsCollDomain, BsColl bsColl) {
        if (null == bsCollDomain) {
            return null;
        }
        if (null == bsColl) {
            bsColl = new BsColl();
        }
        try {
            BeanUtils.copyAllPropertys((Object)bsColl, (Object)bsCollDomain);
            return bsColl;
        }
        catch (Exception e) {
            this.logger.error("bs.BASIC_SETTING.BsCollServiceImpl.makeColl", (Throwable)e);
            return null;
        }
    }

    private List<BsColl> queryCollModelPage(Map<String, Object> parammap) {
        try {
            return this.bsCollMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("bs.BASIC_SETTING.BsCollServiceImpl.queryCollModel", (Throwable)e);
            return null;
        }
    }

    private int countColl(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.bsCollMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("bs.BASIC_SETTING.BsCollServiceImpl.countColl", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveColl(BsCollDomain bsCollDomain) throws ApiException {
        String msg = this.checkColl(bsCollDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("bs.BASIC_SETTING.BsCollServiceImpl.saveColl.checkColl", msg);
        }
        BsColl bsColl = this.makeColl(bsCollDomain, null);
        this.setCollDefault(bsColl);
        this.saveCollModel(bsColl);
    }

    @Override
    public void updateCollState(Integer collId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateCollModel(collId, dataState, oldDataState);
    }

    @Override
    public void updateColl(BsCollDomain bsCollDomain) throws ApiException {
        String msg = this.checkColl(bsCollDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("bs.BASIC_SETTING.BsCollServiceImpl.updateColl.checkColl", msg);
        }
        BsColl oldBsColl = this.getCollModelById(bsCollDomain.getCollId());
        if (null == oldBsColl) {
            throw new ApiException("bs.BASIC_SETTING.BsCollServiceImpl.updateColl.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        BsColl bsColl = this.makeColl(bsCollDomain, oldBsColl);
        this.setCollUpdataDefault(bsColl);
        this.updateCollModel(bsColl);
    }

    @Override
    public BsColl getColl(Integer collId) {
        return this.getCollModelById(collId);
    }

    @Override
    public void deleteColl(Integer collId) throws ApiException {
        this.deleteCollModel(collId);
    }

    @Override
    public QueryResult<BsColl> queryCollPage(Map<String, Object> map) {
        List<BsColl> bsCollList = this.queryCollModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countColl(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(bsCollList);
        return queryResult;
    }

    @Override
    public BsColl getCollByCode(Map<String, Object> map) {
        return this.getCollModelByCode(map);
    }

    @Override
    public void delCollByCode(Map<String, Object> map) throws ApiException {
        this.delCollModelByCode(map);
    }

    @Override
    public List<BsColl> queryCollListByCodes(Map<String, Object> map) {
        if (map != null && map.size() > 0) {
            List listMap = (List)map.get("listMap");
            ArrayList<BsColl> listColl = new ArrayList<BsColl>();
            for (Map parms : listMap) {
                BsColl coll = this.getCollByCode(parms);
                if (coll == null) continue;
                listColl.add(coll);
            }
            return listColl;
        }
        return null;
    }
}

