/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.basicsetting.service.impl;

import com.yqbsoft.laser.service.basicsetting.dao.BsProvinceMapper;
import com.yqbsoft.laser.service.basicsetting.domain.BsProvinceDomain;
import com.yqbsoft.laser.service.basicsetting.model.BsProvince;
import com.yqbsoft.laser.service.basicsetting.service.BsProvinceService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BsProvinceServiceImpl
extends BaseServiceImpl
implements BsProvinceService {
    public static final String SYS_CODE = "bs.BASIC_SETTING.BsProvinceServiceImpl";
    private BsProvinceMapper bsProvinceMapper;
    final String provinceCache_key = "provinceCache_key";

    public void setBsProvinceMapper(BsProvinceMapper bsProvinceMapper) {
        this.bsProvinceMapper = bsProvinceMapper;
    }

    private Date getSysDate() {
        try {
            return this.bsProvinceMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("bs.BASIC_SETTING.BsProvinceServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkProvince(BsProvinceDomain bsProvinceDomain) {
        if (null == bsProvinceDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setProvinceDefault(BsProvince bsProvince) {
        if (null == bsProvince) {
            return;
        }
        if (null == bsProvince.getDataState()) {
            bsProvince.setDataState(0);
        }
        if (null == bsProvince.getGmtCreate()) {
            bsProvince.setGmtCreate(this.getSysDate());
        }
        bsProvince.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)bsProvince.getProvinceCode())) {
            bsProvince.setProvinceCode(this.createUUIDString());
        }
    }

    private int getProvinceMaxCode() {
        int code = 0;
        try {
            return this.bsProvinceMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("bs.BASIC_SETTING.BsProvinceServiceImpl.getProvinceMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setProvinceUpdataDefault(BsProvince bsProvince) {
        if (null == bsProvince) {
            return;
        }
        bsProvince.setGmtModified(this.getSysDate());
    }

    private void saveProvinceModel(BsProvince bsProvince) throws ApiException {
        if (null == bsProvince) {
            return;
        }
        try {
            this.bsProvinceMapper.insert(bsProvince);
        }
        catch (Exception e) {
            throw new ApiException("bs.BASIC_SETTING.BsProvinceServiceImpl.saveProvinceModel.ex", (Throwable)e);
        }
    }

    private BsProvince getProvinceModelById(Integer provinceId) {
        if (null == provinceId) {
            return null;
        }
        try {
            return this.bsProvinceMapper.selectByPrimaryKey(provinceId);
        }
        catch (Exception e) {
            this.logger.error("bs.BASIC_SETTING.BsProvinceServiceImpl.getProvinceModelById", (Throwable)e);
            return null;
        }
    }

    public BsProvince getProvinceModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.bsProvinceMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("bs.BASIC_SETTING.BsProvinceServiceImpl.getProvinceModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delProvinceModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.bsProvinceMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("bs.BASIC_SETTING.BsProvinceServiceImpl.delProvinceModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("bs.BASIC_SETTING.BsProvinceServiceImpl.delProvinceModelByCode.num");
        }
    }

    private void deleteProvinceModel(Integer provinceId) throws ApiException {
        if (null == provinceId) {
            return;
        }
        int i = 0;
        try {
            i = this.bsProvinceMapper.deleteByPrimaryKey(provinceId);
        }
        catch (Exception e) {
            throw new ApiException("bs.BASIC_SETTING.BsProvinceServiceImpl.deleteProvinceModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("bs.BASIC_SETTING.BsProvinceServiceImpl.deleteProvinceModel.num");
        }
    }

    private void updateProvinceModel(BsProvince bsProvince) throws ApiException {
        if (null == bsProvince) {
            return;
        }
        try {
            this.bsProvinceMapper.updateByPrimaryKeySelective(bsProvince);
        }
        catch (Exception e) {
            throw new ApiException("bs.BASIC_SETTING.BsProvinceServiceImpl.updateProvinceModel.ex", (Throwable)e);
        }
    }

    private void updateStateProvinceModel(Integer provinceId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == provinceId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("provinceId", provinceId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.bsProvinceMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("bs.BASIC_SETTING.BsProvinceServiceImpl.updateStateProvinceModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("bs.BASIC_SETTING.BsProvinceServiceImpl.updateStateProvinceModel.null");
        }
    }

    private BsProvince makeProvince(BsProvinceDomain bsProvinceDomain, BsProvince bsProvince) {
        if (null == bsProvinceDomain) {
            return null;
        }
        if (null == bsProvince) {
            bsProvince = new BsProvince();
        }
        try {
            BeanUtils.copyAllPropertys((Object)bsProvince, (Object)bsProvinceDomain);
            return bsProvince;
        }
        catch (Exception e) {
            this.logger.error("bs.BASIC_SETTING.BsProvinceServiceImpl.makeProvince", (Throwable)e);
            return null;
        }
    }

    private List<BsProvince> queryProvinceModelPage(Map<String, Object> parammap) {
        try {
            this.logger.error("parammap--", parammap);
            return this.bsProvinceMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("bs.BASIC_SETTING.BsProvinceServiceImpl.queryProvinceModel", (Throwable)e);
            return null;
        }
    }

    private int countProvince(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.bsProvinceMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("bs.BASIC_SETTING.BsProvinceServiceImpl.countProvince", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveProvince(BsProvinceDomain bsProvinceDomain) throws ApiException {
        String msg = this.checkProvince(bsProvinceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("bs.BASIC_SETTING.BsProvinceServiceImpl.saveProvince.checkProvince", msg);
        }
        BsProvince bsProvince = this.makeProvince(bsProvinceDomain, null);
        this.setProvinceDefault(bsProvince);
        this.saveProvinceModel(bsProvince);
    }

    @Override
    public void updateProvinceState(Integer provinceId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProvinceModel(provinceId, dataState, oldDataState);
    }

    @Override
    public void updateProvince(BsProvinceDomain bsProvinceDomain) throws ApiException {
        String msg = this.checkProvince(bsProvinceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("bs.BASIC_SETTING.BsProvinceServiceImpl.updateProvince.checkProvince", msg);
        }
        BsProvince oldBsProvince = this.getProvinceModelById(bsProvinceDomain.getProvinceId());
        if (null == oldBsProvince) {
            throw new ApiException("bs.BASIC_SETTING.BsProvinceServiceImpl.updateProvince.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        BsProvince bsProvince = this.makeProvince(bsProvinceDomain, oldBsProvince);
        this.setProvinceUpdataDefault(bsProvince);
        this.updateProvinceModel(bsProvince);
    }

    @Override
    public BsProvince getProvince(Integer provinceId) {
        return this.getProvinceModelById(provinceId);
    }

    @Override
    public void deleteProvince(Integer provinceId) throws ApiException {
        this.deleteProvinceModel(provinceId);
    }

    @Override
    public QueryResult<BsProvince> queryProvincePage(Map<String, Object> map) {
        List<BsProvince> bsProvinceList = this.queryProvinceModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProvince(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(bsProvinceList);
        return queryResult;
    }

    @Override
    public BsProvince getProvinceByCode(Map<String, Object> map) {
        return this.getProvinceModelByCode(map);
    }

    @Override
    public void delProvinceByCode(Map<String, Object> map) throws ApiException {
        this.delProvinceModelByCode(map);
    }

    @Override
    public void queryProvinceCache() {
        List<BsProvince> bsProvinceList = this.queryProvinceModelPage(new HashMap<String, Object>());
        DisUtil.set((String)"provinceCache_key", (String)JsonUtil.buildNormalBinder().jsonObject(bsProvinceList));
    }
}

