/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.basicsetting.service.impl;

import com.yqbsoft.laser.service.basicsetting.dao.BsRoadMapper;
import com.yqbsoft.laser.service.basicsetting.domain.BsRoadDomain;
import com.yqbsoft.laser.service.basicsetting.domain.BsRoadReDomain;
import com.yqbsoft.laser.service.basicsetting.model.BsRoad;
import com.yqbsoft.laser.service.basicsetting.service.BsRoadService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BsRoadServiceImpl
extends BaseServiceImpl
implements BsRoadService {
    private static final String SYS_CODE = "bs.BASIC_SETTING.BsRoadServiceImpl";
    private BsRoadMapper bsRoadMapper;

    public void setBsRoadMapper(BsRoadMapper bsRoadMapper) {
        this.bsRoadMapper = bsRoadMapper;
    }

    private Date getSysDate() {
        try {
            return this.bsRoadMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("bs.BASIC_SETTING.BsRoadServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRoad(BsRoadDomain bsRoadDomain) {
        if (null == bsRoadDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)bsRoadDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRoadDefault(BsRoad bsRoad) {
        if (null == bsRoad) {
            return;
        }
        if (null == bsRoad.getDataState()) {
            bsRoad.setDataState(0);
        }
        if (null == bsRoad.getGmtCreate()) {
            bsRoad.setGmtCreate(this.getSysDate());
        }
        bsRoad.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)bsRoad.getRoadCode())) {
            bsRoad.setRoadCode(this.createUUIDString());
        }
    }

    private int getRoadMaxCode() {
        int code = 0;
        try {
            return this.bsRoadMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("bs.BASIC_SETTING.BsRoadServiceImpl.getRoadMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRoadUpdataDefault(BsRoad bsRoad) {
        if (null == bsRoad) {
            return;
        }
        bsRoad.setGmtModified(this.getSysDate());
    }

    private void saveRoadModel(BsRoad bsRoad) throws ApiException {
        if (null == bsRoad) {
            return;
        }
        try {
            this.bsRoadMapper.insert(bsRoad);
        }
        catch (Exception e) {
            throw new ApiException("bs.BASIC_SETTING.BsRoadServiceImpl.saveRoadModel.ex", (Throwable)e);
        }
    }

    private void saveRoadBatchModel(List<BsRoad> bsRoadList) throws ApiException {
        if (null == bsRoadList || bsRoadList.isEmpty()) {
            return;
        }
        try {
            this.bsRoadMapper.insertBatch(bsRoadList);
        }
        catch (Exception e) {
            throw new ApiException("bs.BASIC_SETTING.BsRoadServiceImpl.saveRoadBatchModel.ex", (Throwable)e);
        }
    }

    private BsRoad getRoadModelById(Integer RoadId) {
        if (null == RoadId) {
            return null;
        }
        try {
            return this.bsRoadMapper.selectByPrimaryKey(RoadId);
        }
        catch (Exception e) {
            this.logger.error("bs.BASIC_SETTING.BsRoadServiceImpl.getRoadModelById", (Throwable)e);
            return null;
        }
    }

    private BsRoad getRoadModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.bsRoadMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("bs.BASIC_SETTING.BsRoadServiceImpl.getRoadModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delRoadModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.bsRoadMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("bs.BASIC_SETTING.BsRoadServiceImpl.delRoadModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("bs.BASIC_SETTING.BsRoadServiceImpl.delRoadModelByCode.num");
        }
    }

    private void deleteRoadModel(Integer RoadId) throws ApiException {
        if (null == RoadId) {
            return;
        }
        int i = 0;
        try {
            i = this.bsRoadMapper.deleteByPrimaryKey(RoadId);
        }
        catch (Exception e) {
            throw new ApiException("bs.BASIC_SETTING.BsRoadServiceImpl.deleteRoadModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("bs.BASIC_SETTING.BsRoadServiceImpl.deleteRoadModel.num");
        }
    }

    private void updateRoadModel(BsRoad bsRoad) throws ApiException {
        if (null == bsRoad) {
            return;
        }
        int i = 0;
        try {
            i = this.bsRoadMapper.updateByPrimaryKeySelective(bsRoad);
        }
        catch (Exception e) {
            throw new ApiException("bs.BASIC_SETTING.BsRoadServiceImpl.updateRoadModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("bs.BASIC_SETTING.BsRoadServiceImpl.updateRoadModel.num");
        }
    }

    private void updateStateRoadModel(Integer RoadId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == RoadId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RoadId", RoadId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.bsRoadMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("bs.BASIC_SETTING.BsRoadServiceImpl.updateStateRoadModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("bs.BASIC_SETTING.BsRoadServiceImpl.updateStateRoadModel.null");
        }
    }

    private void updateStateRoadModelByCode(String tenantCode, String RoadCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)RoadCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("RoadCode", RoadCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.bsRoadMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("bs.BASIC_SETTING.BsRoadServiceImpl.updateStateRoadModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("bs.BASIC_SETTING.BsRoadServiceImpl.updateStateRoadModelByCode.null");
        }
    }

    private BsRoad makeRoad(BsRoadDomain bsRoadDomain, BsRoad bsRoad) {
        if (null == bsRoadDomain) {
            return null;
        }
        if (null == bsRoad) {
            bsRoad = new BsRoad();
        }
        try {
            BeanUtils.copyAllPropertys((Object)bsRoad, (Object)bsRoadDomain);
            return bsRoad;
        }
        catch (Exception e) {
            this.logger.error("bs.BASIC_SETTING.BsRoadServiceImpl.makeRoad", (Throwable)e);
            return null;
        }
    }

    private BsRoadReDomain makeBsRoadReDomain(BsRoad bsRoad) {
        if (null == bsRoad) {
            return null;
        }
        BsRoadReDomain bsRoadReDomain = new BsRoadReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)bsRoadReDomain, (Object)bsRoad);
            return bsRoadReDomain;
        }
        catch (Exception e) {
            this.logger.error("bs.BASIC_SETTING.BsRoadServiceImpl.makeBsRoadReDomain", (Throwable)e);
            return null;
        }
    }

    private List<BsRoad> queryRoadModelPage(Map<String, Object> parammap) {
        try {
            return this.bsRoadMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("bs.BASIC_SETTING.BsRoadServiceImpl.queryRoadModel", (Throwable)e);
            return null;
        }
    }

    private int countRoad(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.bsRoadMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("bs.BASIC_SETTING.BsRoadServiceImpl.countRoad", (Throwable)e);
        }
        return i;
    }

    private BsRoad createBsRoad(BsRoadDomain bsRoadDomain) {
        String msg = this.checkRoad(bsRoadDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("bs.BASIC_SETTING.BsRoadServiceImpl.saveRoad.checkRoad", msg);
        }
        BsRoad bsRoad = this.makeRoad(bsRoadDomain, null);
        this.setRoadDefault(bsRoad);
        return bsRoad;
    }

    @Override
    public String saveRoad(BsRoadDomain bsRoadDomain) throws ApiException {
        BsRoad bsRoad = this.createBsRoad(bsRoadDomain);
        this.saveRoadModel(bsRoad);
        return bsRoad.getRoadCode();
    }

    @Override
    public String saveRoadBatch(List<BsRoadDomain> bsRoadDomainList) throws ApiException {
        if (null == bsRoadDomainList || bsRoadDomainList.isEmpty()) {
            return null;
        }
        ArrayList<BsRoad> bsRoadList = new ArrayList<BsRoad>();
        String code = "";
        for (BsRoadDomain bsRoadDomain : bsRoadDomainList) {
            BsRoad bsRoad = this.createBsRoad(bsRoadDomain);
            code = bsRoad.getRoadCode();
            bsRoadList.add(bsRoad);
        }
        this.saveRoadBatchModel(bsRoadList);
        return code;
    }

    @Override
    public void updateRoadState(Integer RoadId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateRoadModel(RoadId, dataState, oldDataState);
    }

    @Override
    public void updateRoadStateByCode(String tenantCode, String RoadCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateRoadModelByCode(tenantCode, RoadCode, dataState, oldDataState);
    }

    @Override
    public void updateRoad(BsRoadDomain bsRoadDomain) throws ApiException {
        String msg = this.checkRoad(bsRoadDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("bs.BASIC_SETTING.BsRoadServiceImpl.updateRoad.checkRoad", msg);
        }
        BsRoad oldBsRoad = this.getRoadModelById(bsRoadDomain.getRoadId());
        if (null == oldBsRoad) {
            throw new ApiException("bs.BASIC_SETTING.BsRoadServiceImpl.updateRoad.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        BsRoad bsRoad = this.makeRoad(bsRoadDomain, oldBsRoad);
        this.setRoadUpdataDefault(bsRoad);
        this.updateRoadModel(bsRoad);
    }

    @Override
    public BsRoad getRoad(Integer RoadId) {
        return this.getRoadModelById(RoadId);
    }

    @Override
    public void deleteRoad(Integer RoadId) throws ApiException {
        this.deleteRoadModel(RoadId);
    }

    @Override
    public QueryResult<BsRoad> queryRoadPage(Map<String, Object> map) {
        List<BsRoad> bsRoadList = this.queryRoadModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRoad(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(bsRoadList);
        return queryResult;
    }

    @Override
    public BsRoad getRoadByCode(String tenantCode, String RoadCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("RoadCode", RoadCode);
        return this.getRoadModelByCode(map);
    }

    @Override
    public void deleteRoadByCode(String tenantCode, String RoadCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("RoadCode", RoadCode);
        this.delRoadModelByCode(map);
    }
}

