/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.cd.service.impl;

import com.yqbsoft.laser.service.cd.dao.CdCardpUserMapper;
import com.yqbsoft.laser.service.cd.domain.CdCardpUserDomain;
import com.yqbsoft.laser.service.cd.domain.CdCardpUserReDomain;
import com.yqbsoft.laser.service.cd.model.CdCardpUser;
import com.yqbsoft.laser.service.cd.service.CdCardpUserService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CdCardpUserServiceImpl
extends BaseServiceImpl
implements CdCardpUserService {
    private static final String SYS_CODE = "cd.CARDP.CdCardpUserServiceImpl";
    private CdCardpUserMapper cdCardpUserMapper;

    public void setCdCardpUserMapper(CdCardpUserMapper cdCardpUserMapper) {
        this.cdCardpUserMapper = cdCardpUserMapper;
    }

    private Date getSysDate() {
        try {
            return this.cdCardpUserMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpUserServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCardpUser(CdCardpUserDomain cdCardpUserDomain) {
        if (null == cdCardpUserDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)cdCardpUserDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCardpUserDefault(CdCardpUser cdCardpUser) {
        if (null == cdCardpUser) {
            return;
        }
        if (null == cdCardpUser.getDataState()) {
            cdCardpUser.setDataState(0);
        }
        if (null == cdCardpUser.getGmtCreate()) {
            cdCardpUser.setGmtCreate(this.getSysDate());
        }
        cdCardpUser.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)cdCardpUser.getCardpUserCode())) {
            cdCardpUser.setCardpUserCode(this.createUUIDString());
        }
    }

    private int getCardpUserMaxCode() {
        int code = 0;
        try {
            return this.cdCardpUserMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpUserServiceImpl.getCardpUserMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCardpUserUpdataDefault(CdCardpUser cdCardpUser) {
        if (null == cdCardpUser) {
            return;
        }
        cdCardpUser.setGmtModified(this.getSysDate());
    }

    private void saveCardpUserModel(CdCardpUser cdCardpUser) throws ApiException {
        if (null == cdCardpUser) {
            return;
        }
        try {
            this.cdCardpUserMapper.insert(cdCardpUser);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpUserServiceImpl.saveCardpUserModel.ex", (Throwable)e);
        }
    }

    private void saveCardpUserBatchModel(List<CdCardpUser> cdCardpUserList) throws ApiException {
        if (null == cdCardpUserList || cdCardpUserList.isEmpty()) {
            return;
        }
        try {
            this.cdCardpUserMapper.insertBatch(cdCardpUserList);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpUserServiceImpl.saveCardpUserBatchModel.ex", (Throwable)e);
        }
    }

    private CdCardpUser getCardpUserModelById(Integer cardpUserId) {
        if (null == cardpUserId) {
            return null;
        }
        try {
            return this.cdCardpUserMapper.selectByPrimaryKey(cardpUserId);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpUserServiceImpl.getCardpUserModelById", (Throwable)e);
            return null;
        }
    }

    private CdCardpUser getCardpUserModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cdCardpUserMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpUserServiceImpl.getCardpUserModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCardpUserModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cdCardpUserMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpUserServiceImpl.delCardpUserModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cd.CARDP.CdCardpUserServiceImpl.delCardpUserModelByCode.num");
        }
    }

    private void deleteCardpUserModel(Integer cardpUserId) throws ApiException {
        if (null == cardpUserId) {
            return;
        }
        int i = 0;
        try {
            i = this.cdCardpUserMapper.deleteByPrimaryKey(cardpUserId);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpUserServiceImpl.deleteCardpUserModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cd.CARDP.CdCardpUserServiceImpl.deleteCardpUserModel.num");
        }
    }

    private void updateCardpUserModel(CdCardpUser cdCardpUser) throws ApiException {
        if (null == cdCardpUser) {
            return;
        }
        int i = 0;
        try {
            i = this.cdCardpUserMapper.updateByPrimaryKeySelective(cdCardpUser);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpUserServiceImpl.updateCardpUserModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cd.CARDP.CdCardpUserServiceImpl.updateCardpUserModel.num");
        }
    }

    private void updateStateCardpUserModel(Integer cardpUserId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == cardpUserId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cardpUserId", cardpUserId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cdCardpUserMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpUserServiceImpl.updateStateCardpUserModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cd.CARDP.CdCardpUserServiceImpl.updateStateCardpUserModel.null");
        }
    }

    private void updateStateCardpUserModelByCode(String tenantCode, String cardpUserCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)cardpUserCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cardpUserCode", cardpUserCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cdCardpUserMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpUserServiceImpl.updateStateCardpUserModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cd.CARDP.CdCardpUserServiceImpl.updateStateCardpUserModelByCode.null");
        }
    }

    private CdCardpUser makeCardpUser(CdCardpUserDomain cdCardpUserDomain, CdCardpUser cdCardpUser) {
        if (null == cdCardpUserDomain) {
            return null;
        }
        if (null == cdCardpUser) {
            cdCardpUser = new CdCardpUser();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cdCardpUser, (Object)cdCardpUserDomain);
            return cdCardpUser;
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpUserServiceImpl.makeCardpUser", (Throwable)e);
            return null;
        }
    }

    private CdCardpUserReDomain makeCdCardpUserReDomain(CdCardpUser cdCardpUser) {
        if (null == cdCardpUser) {
            return null;
        }
        CdCardpUserReDomain cdCardpUserReDomain = new CdCardpUserReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cdCardpUserReDomain, (Object)cdCardpUser);
            return cdCardpUserReDomain;
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpUserServiceImpl.makeCdCardpUserReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CdCardpUser> queryCardpUserModelPage(Map<String, Object> parammap) {
        try {
            return this.cdCardpUserMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpUserServiceImpl.queryCardpUserModel", (Throwable)e);
            return null;
        }
    }

    private int countCardpUser(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cdCardpUserMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpUserServiceImpl.countCardpUser", (Throwable)e);
        }
        return i;
    }

    private CdCardpUser createCdCardpUser(CdCardpUserDomain cdCardpUserDomain) {
        String msg = this.checkCardpUser(cdCardpUserDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cd.CARDP.CdCardpUserServiceImpl.saveCardpUser.checkCardpUser", msg);
        }
        CdCardpUser cdCardpUser = this.makeCardpUser(cdCardpUserDomain, null);
        this.setCardpUserDefault(cdCardpUser);
        return cdCardpUser;
    }

    @Override
    public String saveCardpUser(CdCardpUserDomain cdCardpUserDomain) throws ApiException {
        CdCardpUser cdCardpUser = this.createCdCardpUser(cdCardpUserDomain);
        this.saveCardpUserModel(cdCardpUser);
        return cdCardpUser.getCardpUserCode();
    }

    @Override
    public String saveCardpUserBatch(List<CdCardpUserDomain> cdCardpUserDomainList) throws ApiException {
        if (null == cdCardpUserDomainList || cdCardpUserDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CdCardpUser> cdCardpUserList = new ArrayList<CdCardpUser>();
        String code = "";
        for (CdCardpUserDomain cdCardpUserDomain : cdCardpUserDomainList) {
            CdCardpUser cdCardpUser = this.createCdCardpUser(cdCardpUserDomain);
            code = cdCardpUser.getCardpUserCode();
            cdCardpUserList.add(cdCardpUser);
        }
        this.saveCardpUserBatchModel(cdCardpUserList);
        return code;
    }

    @Override
    public void updateCardpUserState(Integer cardpUserId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateCardpUserModel(cardpUserId, dataState, oldDataState);
    }

    @Override
    public void updateCardpUserStateByCode(String tenantCode, String cardpUserCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateCardpUserModelByCode(tenantCode, cardpUserCode, dataState, oldDataState);
    }

    @Override
    public void updateCardpUser(CdCardpUserDomain cdCardpUserDomain) throws ApiException {
        String msg = this.checkCardpUser(cdCardpUserDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cd.CARDP.CdCardpUserServiceImpl.updateCardpUser.checkCardpUser", msg);
        }
        CdCardpUser oldCdCardpUser = this.getCardpUserModelById(cdCardpUserDomain.getCardpUserId());
        if (null == oldCdCardpUser) {
            throw new ApiException("cd.CARDP.CdCardpUserServiceImpl.updateCardpUser.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CdCardpUser cdCardpUser = this.makeCardpUser(cdCardpUserDomain, oldCdCardpUser);
        this.setCardpUserUpdataDefault(cdCardpUser);
        this.updateCardpUserModel(cdCardpUser);
    }

    @Override
    public CdCardpUser getCardpUser(Integer cardpUserId) {
        return this.getCardpUserModelById(cardpUserId);
    }

    @Override
    public void deleteCardpUser(Integer cardpUserId) throws ApiException {
        this.deleteCardpUserModel(cardpUserId);
    }

    @Override
    public QueryResult<CdCardpUser> queryCardpUserPage(Map<String, Object> map) {
        List<CdCardpUser> cdCardpUserList = this.queryCardpUserModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCardpUser(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cdCardpUserList);
        return queryResult;
    }

    @Override
    public CdCardpUser getCardpUserByCode(String tenantCode, String cardpUserCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cardpUserCode", cardpUserCode);
        return this.getCardpUserModelByCode(map);
    }

    @Override
    public void deleteCardpUserByCode(String tenantCode, String cardpUserCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cardpUserCode", cardpUserCode);
        this.delCardpUserModelByCode(map);
    }
}

