/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.chargeProvided.withdraw.service.impl;

import com.yqbsoft.laser.service.chargeProvided.CpConstants;
import com.yqbsoft.laser.service.chargeProvided.trade.domain.PtePtradeDomain;
import com.yqbsoft.laser.service.chargeProvided.trade.domain.PtePtradeParticipantDomain;
import com.yqbsoft.laser.service.chargeProvided.trade.domain.PtradeBean;
import com.yqbsoft.laser.service.chargeProvided.trade.domain.UserbankBean;
import com.yqbsoft.laser.service.chargeProvided.trade.domain.VdFaccountOuter;
import com.yqbsoft.laser.service.chargeProvided.trade.enumc.PtradpdeEnum;
import com.yqbsoft.laser.service.chargeProvided.withdraw.dao.CpWithdrawMapper;
import com.yqbsoft.laser.service.chargeProvided.withdraw.domain.CpWithdrawDomain;
import com.yqbsoft.laser.service.chargeProvided.withdraw.model.CpWithdraw;
import com.yqbsoft.laser.service.chargeProvided.withdraw.service.CpWithdrawService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CpWithdrawServiceImpl
extends BaseServiceImpl
implements CpWithdrawService {
    public static final String SYS_CODE = "cp.CpWithdrawServiceImpl";
    private CpWithdrawMapper cpWithdrawMapper;

    public void setCpWithdrawMapper(CpWithdrawMapper cpWithdrawMapper) {
        this.cpWithdrawMapper = cpWithdrawMapper;
    }

    private Date getSysDate() {
        try {
            return this.cpWithdrawMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cp.CpWithdrawServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkWithdraw(CpWithdrawDomain cpWithdrawDomain) {
        if (null == cpWithdrawDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)cpWithdrawDomain.getTenantCode())) {
            msg = msg + "\u79df\u6237\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)cpWithdrawDomain.getFaccountId())) {
            msg = msg + "\u8d26\u6237ID\u4e3a\u7a7a;";
        }
        if (cpWithdrawDomain.getWithdrawMoney() == null) {
            msg = msg + "\u91d1\u989d\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)cpWithdrawDomain.getUserCode())) {
            msg = msg + "\u7528\u6237\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)cpWithdrawDomain.getUserbankNo())) {
            msg = msg + "\u63d0\u73b0\u8d26\u53f7\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)cpWithdrawDomain.getFchannelPmodeCode())) {
            msg = msg + "\u6e20\u9053\u7ec8\u7aef\u7f16\u7801\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setWithdrawDefault(CpWithdraw cpWithdraw) {
        if (null == cpWithdraw) {
            return;
        }
        if (null == cpWithdraw.getDataState()) {
            cpWithdraw.setDataState(CpConstants.WITHDRAW_APPLY_CHARGING);
        }
        if (null == cpWithdraw.getGmtCreate()) {
            cpWithdraw.setGmtCreate(this.getSysDate());
        }
        cpWithdraw.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)cpWithdraw.getWithdrawCode())) {
            cpWithdraw.setWithdrawCode("TX" + this.getNo(null, "CpWithdraw", "cpWithdraw", cpWithdraw.getTenantCode()));
        }
        if (null == cpWithdraw.getServiceChargeState()) {
            cpWithdraw.setServiceChargeState(0);
        }
    }

    private int getWithdrawMaxCode() {
        int code = 0;
        try {
            return this.cpWithdrawMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cp.CpWithdrawServiceImpl.getWithdrawMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setWithdrawUpdataDefault(CpWithdraw cpWithdraw) {
        if (null == cpWithdraw) {
            return;
        }
        cpWithdraw.setGmtModified(this.getSysDate());
    }

    private void saveWithdrawModel(CpWithdraw cpWithdraw) throws ApiException {
        if (null == cpWithdraw) {
            return;
        }
        try {
            this.cpWithdrawMapper.insert(cpWithdraw);
        }
        catch (Exception e) {
            throw new ApiException("cp.CpWithdrawServiceImpl.saveWithdrawModel.ex", (Throwable)e);
        }
    }

    private CpWithdraw getWithdrawModelById(Integer withdrawId) {
        if (null == withdrawId) {
            return null;
        }
        try {
            return this.cpWithdrawMapper.selectByPrimaryKey(withdrawId);
        }
        catch (Exception e) {
            this.logger.error("cp.CpWithdrawServiceImpl.getWithdrawModelById", (Throwable)e);
            return null;
        }
    }

    public CpWithdraw getWithdrawModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cpWithdrawMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cp.CpWithdrawServiceImpl.getWithdrawModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delWithdrawModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cpWithdrawMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cp.CpWithdrawServiceImpl.delWithdrawModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cp.CpWithdrawServiceImpl.delWithdrawModelByCode.num");
        }
    }

    private void deleteWithdrawModel(Integer withdrawId) throws ApiException {
        if (null == withdrawId) {
            return;
        }
        int i = 0;
        try {
            i = this.cpWithdrawMapper.deleteByPrimaryKey(withdrawId);
        }
        catch (Exception e) {
            throw new ApiException("cp.CpWithdrawServiceImpl.deleteWithdrawModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cp.CpWithdrawServiceImpl.deleteWithdrawModel.num");
        }
    }

    private void updateWithdrawModel(CpWithdraw cpWithdraw) throws ApiException {
        if (null == cpWithdraw) {
            return;
        }
        try {
            this.cpWithdrawMapper.updateByPrimaryKeySelective(cpWithdraw);
        }
        catch (Exception e) {
            throw new ApiException("cp.CpWithdrawServiceImpl.updateWithdrawModel.ex", (Throwable)e);
        }
    }

    private void updateStateWithdrawModel(Integer withdrawId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == withdrawId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("withdrawId", withdrawId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cpWithdrawMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cp.CpWithdrawServiceImpl.updateStateWithdrawModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("\u6570\u636e\u672a\u66f4\u6539");
        }
    }

    private CpWithdraw makeWithdraw(CpWithdrawDomain cpWithdrawDomain, CpWithdraw cpWithdraw) {
        if (null == cpWithdrawDomain) {
            return null;
        }
        if (null == cpWithdraw) {
            cpWithdraw = new CpWithdraw();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cpWithdraw, (Object)cpWithdrawDomain);
            return cpWithdraw;
        }
        catch (Exception e) {
            this.logger.error("cp.CpWithdrawServiceImpl.makeWithdraw", (Throwable)e);
            return null;
        }
    }

    private List<CpWithdraw> queryWithdrawModelPage(Map<String, Object> parammap) {
        try {
            return this.cpWithdrawMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cp.CpWithdrawServiceImpl.queryWithdrawModel", (Throwable)e);
            return null;
        }
    }

    private int countWithdraw(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cpWithdrawMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cp.CpWithdrawServiceImpl.countWithdraw", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveWithdraw(CpWithdrawDomain cpWithdrawDomain) throws ApiException {
        CpWithdraw cpWithdraw = this.saveModle(cpWithdrawDomain);
        return cpWithdraw.getWithdrawCode();
    }

    private CpWithdraw saveModle(CpWithdrawDomain cpWithdrawDomain) {
        String msg = this.checkWithdraw(cpWithdrawDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cp.CpWithdrawServiceImpl.saveWithdraw.checkWithdraw", msg);
        }
        CpWithdraw cpWithdraw = this.makeWithdraw(cpWithdrawDomain, null);
        this.setWithdrawDefault(cpWithdraw);
        this.saveWithdrawModel(cpWithdraw);
        return cpWithdraw;
    }

    @Override
    public void updateWithdrawState(Integer withdrawId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateWithdrawModel(withdrawId, dataState, oldDataState);
        if (1 == dataState) {
            CpWithdraw cpWithdraw = this.getWithdraw(withdrawId);
            this.sendPay(cpWithdraw);
        }
    }

    @Override
    public void updateWithdraw(CpWithdrawDomain cpWithdrawDomain) throws ApiException {
        String msg = this.checkWithdraw(cpWithdrawDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cp.CpWithdrawServiceImpl.updateWithdraw.checkWithdraw", msg);
        }
        CpWithdraw oldCpWithdraw = this.getWithdrawModelById(cpWithdrawDomain.getWithdrawId());
        if (null == oldCpWithdraw) {
            throw new ApiException("cp.CpWithdrawServiceImpl.updateWithdraw.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CpWithdraw cpWithdraw = this.makeWithdraw(cpWithdrawDomain, oldCpWithdraw);
        this.setWithdrawUpdataDefault(cpWithdraw);
        this.updateWithdrawModel(cpWithdraw);
    }

    @Override
    public CpWithdraw getWithdraw(Integer withdrawId) {
        return this.getWithdrawModelById(withdrawId);
    }

    @Override
    public void deleteWithdraw(Integer withdrawId) throws ApiException {
        this.deleteWithdrawModel(withdrawId);
    }

    @Override
    public QueryResult<CpWithdraw> queryWithdrawPage(Map<String, Object> map) {
        List<CpWithdraw> cpWithdrawList = this.queryWithdrawModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countWithdraw(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cpWithdrawList);
        return queryResult;
    }

    @Override
    public CpWithdraw getWithdrawByCode(Map<String, Object> map) {
        return this.getWithdrawModelByCode(map);
    }

    @Override
    public void delWithdrawByCode(Map<String, Object> map) throws ApiException {
        this.delWithdrawModelByCode(map);
    }

    @Override
    public String saveWithdrawToPte(CpWithdrawDomain cpWithdrawDomain) throws ApiException {
        CpWithdraw cpWithdraw = this.saveModle(cpWithdrawDomain);
        return this.sendPay(cpWithdraw);
    }

    private String sendPay(CpWithdraw cpWithdraw) {
        if (null == cpWithdraw) {
            return "";
        }
        PtePtradeDomain ptePtradeDomain = new PtePtradeDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ptePtradeDomain, (Object)cpWithdraw);
        }
        catch (Exception e) {
            throw new ApiException("cp.CpWithdrawServiceImpl.copyAllPropertys");
        }
        ptePtradeDomain.setOpuserCode(cpWithdraw.getUserCode());
        ptePtradeDomain.setOpuserName(cpWithdraw.getUserName());
        UserbankBean userBankBean = new UserbankBean();
        userBankBean.setFaccountId(cpWithdraw.getUserbankNo());
        userBankBean.setFaccountName(cpWithdraw.getUserbankName());
        userBankBean.setFaccountBranch(cpWithdraw.getFchannelBankCode());
        ptePtradeDomain.setMerchantCode(cpWithdraw.getUserCode());
        ptePtradeDomain.setAcquireSeqno(cpWithdraw.getWithdrawCode());
        ptePtradeDomain.setBusinessOrderno(cpWithdraw.getWithdrawCode());
        ptePtradeDomain.setBusinessOrder(cpWithdraw.getWithdrawCode());
        ptePtradeDomain.setPaymentMemo(cpWithdraw.getWithdrawCode());
        ptePtradeDomain.setPtradeType(null == cpWithdraw.getWithdrawType() ? "02" : cpWithdraw.getWithdrawType());
        ptePtradeDomain.setOrderAmount(cpWithdraw.getWithdrawMoney());
        ptePtradeDomain.setBusinessType("C02");
        ptePtradeDomain.setFchannelPmodeCode(cpWithdraw.getFchannelPmodeCode());
        HashMap<String, UserbankBean> map = new HashMap<String, UserbankBean>();
        map.put("BANK", userBankBean);
        ptePtradeDomain.setExtension(JsonUtil.buildNormalBinder().toJson(map));
        ptePtradeDomain.setPtradeExtension(JsonUtil.buildNormalBinder().toJson(map));
        ptePtradeDomain.setPtradpdeCode(PtradpdeEnum.WITHDRAW.getCode());
        ptePtradeDomain.setPaymentNotifyurl("cp.withdraw.updateWithdrawToPteBack");
        PtradeBean ptradeBean = this.makeParticipant(cpWithdraw);
        ptePtradeDomain.setPtradeBean(ptradeBean);
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("ptePtradeDomain", JsonUtil.buildNormalBinder().toJson((Object)ptePtradeDomain));
        String result = this.internalInvoke("pte.ptrade.sendSavePtrade", queryMap);
        if (StringUtils.isBlank((String)result)) {
            throw new ApiException("cp.CpWithdrawServiceImpl.saveWithdrawToPte.pte.ptrade.sendSavePtrade", "\u8c03\u7528\u4ea4\u6613\u5f15\u64ce\u5931\u8d25\uff01");
        }
        return result;
    }

    private PtradeBean makeParticipant(CpWithdraw cpWithdraw) {
        if (null == cpWithdraw) {
            return null;
        }
        PtradeBean pb = new PtradeBean();
        pb.setTenantCode(cpWithdraw.getTenantCode());
        pb.setFchannelPmodeCode(cpWithdraw.getFchannelPmodeCode());
        pb.setFchannelMode("0");
        ArrayList<PtePtradeParticipantDomain> partList = new ArrayList<PtePtradeParticipantDomain>();
        String code = cpWithdraw.getUserCode().substring(0, 1);
        PtePtradeParticipantDomain pd1 = new PtePtradeParticipantDomain();
        pd1.setDicActorCode("BUY_B");
        pd1.setFaccountId(cpWithdraw.getFaccountId());
        pd1.setFchannelCode("0" + code);
        pd1.setFchannelClassifyCode(code + "01");
        pd1.setOrderAmount(cpWithdraw.getWithdrawMoney());
        partList.add(pd1);
        pb.setPartList(partList);
        if (StringUtils.isNotBlank((String)cpWithdraw.getFchannelCode())) {
            PtePtradeParticipantDomain pd2 = new PtePtradeParticipantDomain();
            pd2.setDicActorCode("BANK");
            pd2.setFundType(cpWithdraw.getFundType());
            pd2.setFchannelCode(cpWithdraw.getFchannelCode());
            pd2.setFchannelClassifyCode(cpWithdraw.getFchannelClassifyCode());
            pd2.setOrderAmount(cpWithdraw.getWithdrawMoney());
            partList.add(pd2);
        }
        return pb;
    }

    @Override
    public boolean updateWithdrawToPteBack(Map<String, Object> map) throws ApiException {
        if (map == null || map.isEmpty()) {
            return false;
        }
        String rechargeCode = (String)map.get("acquireSeqno");
        String tenantCode = (String)map.get("tenantCode");
        Integer dataState = (Integer)map.get("dataState");
        if (StringUtils.isBlank((String)rechargeCode) || dataState == null) {
            throw new ApiException("cp.CpWithdrawServiceImpl.updateWithdrawToPteBack.null", "\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Object> pmap = new HashMap<String, Object>();
        pmap.put("withdrawCode", rechargeCode);
        pmap.put("tenantCode", tenantCode);
        CpWithdraw cpWithdraw = this.getWithdrawByCode(pmap);
        if (cpWithdraw == null) {
            throw new ApiException("cp.CpWithdrawServiceImpl.updateWithdrawToPteBack.null", "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (dataState == cpWithdraw.getDataState()) {
            return true;
        }
        this.updateStateWithdrawModel(cpWithdraw.getWithdrawId(), dataState, cpWithdraw.getDataState());
        return true;
    }

    @Override
    public void updateWithdrawStateAndUser(Integer withdrawId, Integer dataState, Integer oldDataState, String userName, String userCode) throws ApiException {
        CpWithdraw withdraw = this.getWithdraw(withdrawId);
        withdraw.setMemo(userName);
        this.updateWithdrawModel(withdraw);
        this.updateStateWithdrawModel(withdrawId, dataState, oldDataState);
        if (1 == dataState) {
            withdraw.setUserName(withdraw.getUserbankName());
            this.sendPay(withdraw);
        }
    }

    @Override
    public void updateApproveWithdraw(Integer withdrawId, Integer dataState, Integer oldDataState, String comments) throws ApiException {
        CpWithdraw withdraw = this.getWithdraw(withdrawId);
        if (!withdraw.getDataState().equals(oldDataState)) {
            throw new ApiException("updateTransferState", "\u72b6\u6001\u5df2\u66f4\u6539");
        }
        if (StringUtils.isNotBlank((String)comments)) {
            withdraw.setComments(comments);
            this.updateWithdrawModel(withdraw);
        }
        this.updateStateWithdrawModel(withdrawId, dataState, oldDataState);
        if (dataState.equals(CpConstants.WITHDRAW_APPRROVE_FALSE_CHARGING)) {
            this.sendBackPay(withdraw);
        }
    }

    private void sendBackPay(CpWithdraw withdraw) {
        if (null == withdraw) {
            return;
        }
        PtePtradeDomain ptePtradeDomain = new PtePtradeDomain();
        ptePtradeDomain.setOrderOamount(withdraw.getWithdrawMoney());
        ptePtradeDomain.setOrderAmount(withdraw.getWithdrawMoney());
        ptePtradeDomain.setPtradeType("01");
        ptePtradeDomain.setAcquireSeqno(withdraw.getWithdrawCode());
        ptePtradeDomain.setPartnerCode(withdraw.getUserCode());
        ptePtradeDomain.setBusinessOrderno(withdraw.getWithdrawCode());
        ptePtradeDomain.setBusinessOrder(withdraw.getWithdrawCode());
        ptePtradeDomain.setPaymentMemo(withdraw.getWithdrawCode());
        ptePtradeDomain.setOpuserCode(withdraw.getUserCode());
        ptePtradeDomain.setOpuserName(withdraw.getUserName());
        ptePtradeDomain.setBusinessType("B05");
        ptePtradeDomain.setPtradpdeCode(PtradpdeEnum.RECHARGEULINE.getCode());
        ptePtradeDomain.setTenantCode(withdraw.getTenantCode());
        ptePtradeDomain.setMerchantCode(withdraw.getUserCode());
        ptePtradeDomain.setFchannelPmodeCode(withdraw.getFchannelPmodeCode());
        ptePtradeDomain.setPaymentNotifyurl("cp.withdraw.updateApproveWithdrawbyTrade");
        PtradeBean ptradeBean = this.makeRechargeParticipant(withdraw);
        ptePtradeDomain.setPtradeBean(ptradeBean);
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("ptePtradeDomain", JsonUtil.buildNormalBinder().toJson((Object)ptePtradeDomain));
        String result = this.internalInvoke("pte.ptrade.sendSavePtrade", queryMap);
        if (StringUtils.isBlank((String)result)) {
            throw new ApiException("cp.CpWithdrawServiceImpl.sendPay.send", "\u8c03\u7528\u4ea4\u6613\u5f15\u64ce\u5931\u8d25\uff01");
        }
    }

    private PtradeBean makeRechargeParticipant(CpWithdraw cpWithdraw) {
        if (null == cpWithdraw) {
            return null;
        }
        PtradeBean pb = new PtradeBean();
        String fundType = "01";
        pb.setTenantCode(cpWithdraw.getTenantCode());
        pb.setFchannelPmodeCode(cpWithdraw.getFchannelPmodeCode());
        pb.setFchannelMode("0");
        ArrayList<PtePtradeParticipantDomain> partList = new ArrayList<PtePtradeParticipantDomain>();
        String code = cpWithdraw.getUserCode().substring(0, 1);
        PtePtradeParticipantDomain pd1 = new PtePtradeParticipantDomain();
        pd1.setDicActorCode("BUY_B");
        pd1.setFaccountId(cpWithdraw.getFaccountId());
        pd1.setFchannelCode("0" + code);
        pd1.setFchannelClassifyCode(code + fundType);
        pd1.setOrderAmount(cpWithdraw.getWithdrawMoney());
        pd1.setFundType(fundType);
        partList.add(pd1);
        pb.setPartList(partList);
        if (StringUtils.isNotBlank((String)"ctest")) {
            PtePtradeParticipantDomain pd2 = new PtePtradeParticipantDomain();
            pd2.setDicActorCode("BANK");
            pd2.setFundType(fundType);
            pd2.setFchannelCode("ctest");
            pd2.setOrderAmount(cpWithdraw.getWithdrawMoney());
            partList.add(pd2);
        }
        return pb;
    }

    @Override
    public void updateTransferState(CpWithdrawDomain cpWithdrawDomain, Integer dataState, Integer oldDataState, String memo) throws ApiException {
        CpWithdraw withdraw = this.getWithdraw(cpWithdrawDomain.getWithdrawId());
        if (!withdraw.getDataState().equals(oldDataState)) {
            throw new ApiException("updateTransferState", "\u72b6\u6001\u5df2\u66f4\u6539");
        }
        withdraw.setPaymentVoucher(cpWithdrawDomain.getPaymentVoucher());
        withdraw.setMemo(memo);
        withdraw.setServiceCharge(cpWithdrawDomain.getServiceCharge());
        withdraw.setServiceChargeState(cpWithdrawDomain.getServiceChargeState());
        withdraw.setServiceChargePayer(cpWithdrawDomain.getServiceChargePayer());
        this.updateWithdrawModel(withdraw);
        this.updateStateWithdrawModel(cpWithdrawDomain.getWithdrawId(), dataState, oldDataState);
        if (CpConstants.WITHDRAW_TRANSFER_FALSE_CHARGING.equals(dataState)) {
            this.sendBackPay(withdraw);
        } else if (CpConstants.WITHDRAW_TRANSFER_SUCCESS.equals(dataState)) {
            HashMap<String, String> pmap = new HashMap<String, String>();
            pmap.put("merchantCode", withdraw.getMemberCode());
            pmap.put("faccountType", "201");
            pmap.put("tenantCode", withdraw.getTenantCode());
            String result = this.internalInvoke("vd.faccountOuter.queryOuterFaccount", pmap);
            if (StringUtils.isBlank((String)result)) {
                throw new ApiException("cp.CpWithdrawServiceImpl.savePtrade.setMerchant", "\u672a\u67e5\u8be2\u5230\u8d26\u6237\u4fe1\u606f!" + ((Object)pmap).toString());
            }
            List vdFaccountOuter = (List)JsonUtil.buildNormalBinder().getJsonToList(result, VdFaccountOuter.class);
            if (ListUtil.isEmpty((Collection)vdFaccountOuter)) {
                throw new ApiException("cp.CpWithdrawServiceImpl.savePtrade.setMerchant", "\u672a\u67e5\u8be2\u5230\u8d26\u6237\u4fe1\u606f!" + ((Object)pmap).toString());
            }
            this.logger.error("vdFaccountOuter", (Object)vdFaccountOuter.toString());
        }
    }

    @Override
    public boolean updateApproveWithdrawbyTrade(Map<String, Object> map) throws ApiException {
        if (map == null || map.isEmpty()) {
            return false;
        }
        String withdrawCode = (String)map.get("acquireSeqno");
        String tenantCode = (String)map.get("tenantCode");
        HashMap<String, Object> pmap = new HashMap<String, Object>();
        pmap.put("withdrawCode", withdrawCode);
        pmap.put("tenantCode", tenantCode);
        CpWithdraw cpWithdraw = this.getWithdrawByCode(pmap);
        if (cpWithdraw == null) {
            throw new ApiException("cp.CpWithdrawServiceImpl.updateWithdrawToPteBack.null", "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (cpWithdraw.getDataState().equals(CpConstants.WITHDRAW_APPRROVE_FALSE_CHARGING)) {
            this.updateStateWithdrawModel(cpWithdraw.getWithdrawId(), CpConstants.WITHDRAW_APPRROVE_FALSE, cpWithdraw.getDataState());
        } else if (cpWithdraw.getDataState().equals(CpConstants.WITHDRAW_TRANSFER_FALSE_CHARGING)) {
            this.updateStateWithdrawModel(cpWithdraw.getWithdrawId(), CpConstants.WITHDRAW_TRANSFER_FALSE, cpWithdraw.getDataState());
        }
        return true;
    }
}

