/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contractorder.service.impl;

import com.yqbsoft.laser.service.contractorder.dao.CoCorderGoodsMapper;
import com.yqbsoft.laser.service.contractorder.dao.CoCorderMapper;
import com.yqbsoft.laser.service.contractorder.dao.CoCorderSettlMapper;
import com.yqbsoft.laser.service.contractorder.domain.CoCorderDomain;
import com.yqbsoft.laser.service.contractorder.domain.CoCorderGoodsDomain;
import com.yqbsoft.laser.service.contractorder.domain.CoCorderReDomain;
import com.yqbsoft.laser.service.contractorder.domain.CoCorderSettlDomain;
import com.yqbsoft.laser.service.contractorder.domain.CoCordersendDomain;
import com.yqbsoft.laser.service.contractorder.domain.OcContractDomain;
import com.yqbsoft.laser.service.contractorder.domain.OcContractReDomain;
import com.yqbsoft.laser.service.contractorder.domain.TmProappEnv;
import com.yqbsoft.laser.service.contractorder.model.CoCorder;
import com.yqbsoft.laser.service.contractorder.model.CoCorderGoods;
import com.yqbsoft.laser.service.contractorder.model.CoCorderSettl;
import com.yqbsoft.laser.service.contractorder.model.CtCustrel;
import com.yqbsoft.laser.service.contractorder.service.CoCorderGoodsService;
import com.yqbsoft.laser.service.contractorder.service.CoCorderService;
import com.yqbsoft.laser.service.contractorder.service.CoCordersendService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.ScriptUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CoCorderServiceImpl
extends BaseServiceImpl
implements CoCorderService {
    private static final String SYS_CODE = "co.CONTRACTORDER.CoCorderServiceImpl";
    private CoCorderMapper coCorderMapper;
    private CoCorderSettlMapper coCorderSettlMapper;
    private CoCorderGoodsMapper coCorderGoodsMapper;
    private CoCordersendService coCordersendService;
    private CoCorderGoodsService coCorderGoodsService;

    public CoCordersendService getCoCordersendService() {
        return this.coCordersendService;
    }

    public void setCoCordersendService(CoCordersendService coCordersendService) {
        this.coCordersendService = coCordersendService;
    }

    public CoCorderGoodsMapper getCoCorderGoodsMapper() {
        return this.coCorderGoodsMapper;
    }

    public void setCoCorderGoodsMapper(CoCorderGoodsMapper coCorderGoodsMapper) {
        this.coCorderGoodsMapper = coCorderGoodsMapper;
    }

    public CoCorderSettlMapper getCoCorderSettlMapper() {
        return this.coCorderSettlMapper;
    }

    public void setCoCorderSettlMapper(CoCorderSettlMapper coCorderSettlMapper) {
        this.coCorderSettlMapper = coCorderSettlMapper;
    }

    public void setCoCorderMapper(CoCorderMapper coCorderMapper) {
        this.coCorderMapper = coCorderMapper;
    }

    public CoCorderGoodsService getCoCorderGoodsService() {
        return this.coCorderGoodsService;
    }

    public void setCoCorderGoodsService(CoCorderGoodsService coCorderGoodsService) {
        this.coCorderGoodsService = coCorderGoodsService;
    }

    private Date getSysDate() {
        try {
            return this.coCorderMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCorder(CoCorderDomain coCorderDomain) {
        if (null == coCorderDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)coCorderDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCorderDefault(CoCorder coCorder) {
        if (null == coCorder) {
            return;
        }
        if (null == coCorder.getDataState()) {
            coCorder.setDataState(0);
        }
        if (null == coCorder.getGmtCreate()) {
            coCorder.setGmtCreate(this.getSysDate());
        }
        coCorder.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)coCorder.getCorderCode())) {
            coCorder.setCorderCode(this.createUUIDString());
        }
    }

    private int getCorderMaxCode() {
        int code = 0;
        try {
            return this.coCorderMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.getCorderMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCorderUpdataDefault(CoCorder coCorder) {
        if (null == coCorder) {
            return;
        }
        coCorder.setGmtModified(this.getSysDate());
    }

    private void saveCorderModel(CoCorder coCorder) throws ApiException {
        if (null == coCorder) {
            return;
        }
        try {
            this.coCorderMapper.insert(coCorder);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.saveCorderModel.ex", (Throwable)e);
        }
    }

    private void saveCorderBatchModel(List<CoCorder> coCorderList) throws ApiException {
        if (null == coCorderList || coCorderList.isEmpty()) {
            return;
        }
        try {
            this.coCorderMapper.insertBatch(coCorderList);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.saveCorderBatchModel.ex", (Throwable)e);
        }
    }

    private CoCorder getCorderModelById(Integer corderId) {
        if (null == corderId) {
            return null;
        }
        try {
            return this.coCorderMapper.selectByPrimaryKey(corderId);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.getCorderModelById", (Throwable)e);
            return null;
        }
    }

    private CoCorder getCorderModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.coCorderMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.getCorderModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCorderModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.coCorderMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.delCorderModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.delCorderModelByCode.num");
        }
    }

    private void deleteCorderModel(Integer corderId) throws ApiException {
        if (null == corderId) {
            return;
        }
        int i = 0;
        try {
            i = this.coCorderMapper.deleteByPrimaryKey(corderId);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.deleteCorderModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.deleteCorderModel.num");
        }
    }

    private void updateCorderModel(CoCorder coCorder) throws ApiException {
        if (null == coCorder) {
            return;
        }
        int i = 0;
        try {
            i = this.coCorderMapper.updateByPrimaryKey(coCorder);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.updateCorderModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.updateCorderModel.num");
        }
    }

    private void updateStateCorderModel(Integer corderId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == corderId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("corderId", corderId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.coCorderMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.updateStateCorderModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.updateStateCorderModel.null");
        }
    }

    private void updateStateCorderModelByCode(String tenantCode, String corderCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)corderCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("corderCode", corderCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.coCorderMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.updateStateCorderModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.updateStateCorderModelByCode.null");
        }
    }

    private CoCorder makeCorder(CoCorderDomain coCorderDomain, CoCorder coCorder) {
        if (null == coCorderDomain) {
            return null;
        }
        if (null == coCorder) {
            coCorder = new CoCorder();
        }
        try {
            BeanUtils.copyAllPropertys((Object)coCorder, (Object)coCorderDomain);
            return coCorder;
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.makeCorder", (Throwable)e);
            return null;
        }
    }

    private CoCorderReDomain makeCoCorderReDomain(CoCorder coCorder) {
        if (null == coCorder) {
            return null;
        }
        CoCorderReDomain coCorderReDomain = new CoCorderReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)coCorderReDomain, (Object)coCorder);
            return coCorderReDomain;
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.makeCoCorderReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CoCorder> queryCorderModelPage(Map<String, Object> parammap) {
        try {
            return this.coCorderMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.queryCorderModel", (Throwable)e);
            return null;
        }
    }

    private int countCorder(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.coCorderMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.countCorder", (Throwable)e);
        }
        return i;
    }

    private CoCorder createCoCorder(CoCorderDomain coCorderDomain) {
        String msg = this.checkCorder(coCorderDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.saveCorder.checkCorder", msg);
        }
        CoCorder coCorder = this.makeCorder(coCorderDomain, null);
        this.setCorderDefault(coCorder);
        return coCorder;
    }

    private CoCorder getCoCorder(CoCorderDomain coCorderDomain) {
        CoCorder coCorder = this.createCoCorder(coCorderDomain);
        this.setContractDefault(coCorder);
        coCorder.setDataState(1);
        this.saveCorderModel(coCorder);
        this.saveContractGoodsList(coCorderDomain.getGoodsList(), coCorder);
        coCorderDomain.setContractBillcode(coCorder.getContractBillcode());
        coCorderDomain.setContractBbillcode(coCorder.getContractBbillcode());
        coCorderDomain.setContractTypepro(coCorder.getContractTypepro());
        return coCorder;
    }

    @Override
    public String saveCorder(CoCorderDomain coCorderDomain) throws ApiException {
        CoCorder coCorder = this.getCoCorder(coCorderDomain);
        this.sendCoCordersendService(coCorder);
        return coCorder.getContractBillcode();
    }

    @Override
    public String saveCorderBatch(List<CoCorderDomain> coCorderDomainList) throws ApiException {
        if (null == coCorderDomainList || coCorderDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CoCorder> coCorderList = new ArrayList<CoCorder>();
        String code = "";
        for (CoCorderDomain coCorderDomain : coCorderDomainList) {
            CoCorder coCorder = this.createCoCorder(coCorderDomain);
            code = coCorder.getCorderCode();
            coCorderList.add(coCorder);
        }
        this.saveCorderBatchModel(coCorderList);
        return code;
    }

    @Override
    public void updateCorderState(Integer corderId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        CoCorder coCorder = this.getCorderModelById(corderId);
        if (coCorder == null) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.updateCorderState.ex");
        }
        OcContractReDomain ocContractReDomain = this.getOcContractReDomain(coCorder.getTenantCode(), coCorder);
        if (ocContractReDomain == null) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.updateCorderState.ex1");
        }
        HashMap<String, Integer> mapStr = new HashMap<String, Integer>();
        mapStr.put("contractId", ocContractReDomain.getContractId());
        mapStr.put("dataState", dataState);
        mapStr.put("oldDataState", oldDataState);
        String str = null;
        try {
            str = (String)this.getInternalRouter().inInvoke("oc.contract.updateContractState", mapStr);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.updateCorderState", (Object)str);
        }
        this.updateStateCorderModel(corderId, dataState, oldDataState, map);
    }

    @Override
    public void updateCorderStateByCode(String tenantCode, String corderCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        CoCorder corderByCode = this.getCorderByCode(tenantCode, corderCode);
        if (corderByCode == null) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.updateCorderStateByCode.ex");
        }
        OcContractReDomain ocContractReDomain = this.getOcContractReDomain(tenantCode, corderByCode);
        if (ocContractReDomain == null) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.updateCorderStateByCode.ex1");
        }
        String param = null;
        HashMap<String, Integer> paramStr = new HashMap<String, Integer>();
        paramStr.put("contractId", ocContractReDomain.getContractId());
        paramStr.put("dataState", dataState);
        paramStr.put("oldDataState", oldDataState);
        try {
            param = (String)this.getInternalRouter().inInvoke("oc.contract.updateContractStateExtend", paramStr);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.updateCorderStateUpdateContractStateExtend", (Object)param);
        }
        this.updateStateCorderModelByCode(tenantCode, corderCode, dataState, oldDataState, map);
    }

    private OcContractReDomain getOcContractReDomain(String tenantCode, CoCorder corderByCode) {
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("contractBillcode", corderByCode.getContractBillcode());
        map1.put("tenantCode", tenantCode);
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("map", JsonUtil.buildNonDefaultBinder().toJson(map1));
        String str = null;
        try {
            str = (String)this.getInternalRouter().inInvoke("oc.contract.getContractByCode", mapStr);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.updateCorderState", (Object)str);
        }
        if (StringUtils.isBlank((String)str)) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.updateCorderStateByCodeStr.ex");
        }
        OcContractReDomain ocContractReDomain = null;
        try {
            ocContractReDomain = (OcContractReDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(str, OcContractReDomain.class);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.updateCorderStateByCodeocContractReDomain", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractReDomain), (Throwable)e);
        }
        return ocContractReDomain;
    }

    @Override
    public void updateCorder(CoCorderDomain coCorderDomain) throws ApiException {
        String msg = this.checkCorder(coCorderDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.updateCorder.checkCorder", msg);
        }
        CoCorder oldCoCorder = this.getCorderModelById(coCorderDomain.getCorderId());
        if (null == oldCoCorder) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.updateCorder.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CoCorder coCorder = this.makeCorder(coCorderDomain, oldCoCorder);
        this.setCorderUpdataDefault(coCorder);
        this.updateCorderModel(coCorder);
    }

    @Override
    public CoCorder getCorder(Integer corderId) {
        return this.getCorderModelById(corderId);
    }

    @Override
    public void deleteCorder(Integer corderId) throws ApiException {
        this.deleteCorderModel(corderId);
    }

    @Override
    public QueryResult<CoCorder> queryCorderPage(Map<String, Object> map) {
        List<CoCorder> coCorderList = this.queryCorderModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCorder(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(coCorderList);
        return queryResult;
    }

    @Override
    public CoCorder getCorderByCode(String tenantCode, String corderCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("corderCode", corderCode);
        return this.getCorderModelByCode(map);
    }

    @Override
    public void deleteCorderByCode(String tenantCode, String corderCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("corderCode", corderCode);
        this.delCorderModelByCode(map);
    }

    private void setContractDefault(CoCorder ocContract) {
        if (null == ocContract) {
            return;
        }
        if (null == ocContract.getDataState()) {
            ocContract.setDataState(0);
        }
        Date nowdate = this.getSysDate();
        if (null == ocContract.getGmtCreate()) {
            ocContract.setGmtCreate(nowdate);
        }
        ocContract.setGmtModified(nowdate);
        if (StringUtils.isBlank((String)ocContract.getContractBillcode())) {
            ocContract.setContractBillcode(this.getNo(null, CoCorder.class.getSimpleName(), "contractCode", ocContract.getTenantCode()));
        }
        if (StringUtils.isBlank((String)ocContract.getContractBbillcode())) {
            ocContract.setContractBbillcode(ocContract.getContractBillcode());
        }
        if (StringUtils.isBlank((String)ocContract.getContractTypepro())) {
            ocContract.setContractTypepro("00");
        }
        if (StringUtils.isNotBlank((String)ocContract.getAppmanageIcode())) {
            ocContract.setCashback(this.makeInv(ocContract));
        }
        if (null == ocContract.getContractInvstate() && (null == ocContract.getCashback() || ocContract.getCashback().compareTo(BigDecimal.ZERO) == 0)) {
            ocContract.setContractInvstate(3);
        }
    }

    private BigDecimal makeInv(CoCorder ocContract) {
        if (null == ocContract) {
            return new BigDecimal("0");
        }
        TmProappEnv tmProappEnv = (TmProappEnv)SupDisUtil.getMapJson((String)"TmProappEnv-tenant-ProappCode", (String)(ocContract.getAppmanageIcode() + "-" + ocContract.getTenantCode()), TmProappEnv.class);
        if (null == tmProappEnv) {
            return ocContract.getDataBmoney();
        }
        String confJson = tmProappEnv.getProappEnvOpenconf();
        if (StringUtils.isBlank((String)confJson)) {
            return ocContract.getDataBmoney();
        }
        Map confMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(confJson, String.class, String.class);
        if (null == confMap || confMap.isEmpty()) {
            return ocContract.getDataBmoney();
        }
        String inv = (String)confMap.get("inv");
        if (StringUtils.isBlank((String)inv)) {
            return ocContract.getDataBmoney();
        }
        if ("opay".equals(inv)) {
            return ocContract.getPricesetRefrice();
        }
        if ("mpay".equals(inv)) {
            return ocContract.getContractMoney();
        }
        return ocContract.getDataBmoney();
    }

    private void saveOcContractSettl(List<CoCorderSettlDomain> ocContractSettlDomainList, CoCorder ocContract) {
        if (null == ocContract || null == ocContractSettlDomainList || ocContractSettlDomainList.isEmpty()) {
            return;
        }
        ArrayList<CoCorderSettl> ocContractSettlList = new ArrayList<CoCorderSettl>();
        for (CoCorderSettlDomain ocContractSettlDomain : ocContractSettlDomainList) {
            ocContractSettlDomain.setContractBillcode(ocContract.getContractBillcode());
            if (StringUtils.isBlank((String)ocContractSettlDomain.getMemberBcode())) {
                ocContractSettlDomain.setMemberBcode(ocContract.getMemberBcode());
                ocContractSettlDomain.setMemberBname(ocContract.getMemberBname());
            }
            if (StringUtils.isBlank((String)ocContractSettlDomain.getMemberCcode())) {
                ocContractSettlDomain.setMemberCcode(ocContract.getMemberCcode());
                ocContractSettlDomain.setMemberCname(ocContract.getMemberCname());
            }
            if (StringUtils.isBlank((String)ocContractSettlDomain.getMemberCode())) {
                ocContractSettlDomain.setMemberCode(ocContract.getMemberCode());
                ocContractSettlDomain.setMemberName(ocContract.getMemberName());
            }
            ocContractSettlDomain.setTenantCode(ocContract.getTenantCode());
            CoCorderSettl ocContractSettl = this.createContractsettl(ocContractSettlDomain);
            ocContractSettlList.add(ocContractSettl);
        }
        this.saveContractSettlModelBatch(ocContractSettlList);
    }

    private void saveContractGoodsList(List<CoCorderGoodsDomain> contractGoodsList, CoCorder ocContract) {
        if (contractGoodsList == null || contractGoodsList.isEmpty()) {
            return;
        }
        List coCorderGoodsDomainBean = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNonDefaultBinder().toJson(contractGoodsList), CoCorderGoodsDomain.class);
        if (ListUtil.isNotEmpty((Collection)coCorderGoodsDomainBean)) {
            ArrayList<CoCorderGoods> ocContractGoodsList = new ArrayList<CoCorderGoods>();
            for (CoCorderGoodsDomain ocContractGoodsDomain : coCorderGoodsDomainBean) {
                if (null != ocContract) {
                    if (StringUtils.isBlank((String)ocContractGoodsDomain.getMemberCcode()) && StringUtils.isNotBlank((String)ocContract.getMemberCcode())) {
                        ocContractGoodsDomain.setMemberCcode(ocContract.getMemberCcode());
                        ocContractGoodsDomain.setMemberCname(ocContract.getMemberCname());
                    }
                    ocContractGoodsDomain.setMemberCode(ocContract.getMemberCode());
                    ocContractGoodsDomain.setMemberName(ocContract.getMemberName());
                }
                ocContractGoodsDomain.setCorderCode(ocContract.getCorderCode());
                ocContractGoodsDomain.setContractBillcode(ocContract.getContractBillcode());
                CoCorderGoods ocContractGoods = this.createContractgoods(ocContractGoodsDomain);
                ocContractGoodsList.add(ocContractGoods);
            }
            this.saveContractGoodsBatchModel(ocContractGoodsList);
        }
    }

    private CoCorderGoods createContractgoods(CoCorderGoodsDomain ocContractGoodsDomain) {
        String msg = this.checkCoCorderGoods(ocContractGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.saveContractGoods.checkContractGoods", msg);
        }
        CoCorderGoods ocContractGoods = this.makeContractGoods(ocContractGoodsDomain, null);
        this.setContractGoodsDefault(ocContractGoods);
        return ocContractGoods;
    }

    private CoCorderGoods makeContractGoods(CoCorderGoodsDomain ocContractGoodsDomain, CoCorderGoods ocContractGoods) {
        if (null == ocContractGoodsDomain) {
            return null;
        }
        if (null == ocContractGoods) {
            ocContractGoods = new CoCorderGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocContractGoods, (Object)ocContractGoodsDomain);
            return ocContractGoods;
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.makeContractGoods", (Throwable)e);
            return null;
        }
    }

    private void setContractGoodsDefault(CoCorderGoods ocContractGoods) {
        if (null == ocContractGoods) {
            return;
        }
        if (null == ocContractGoods.getDataState()) {
            ocContractGoods.setDataState(0);
        }
        if (null == ocContractGoods.getGmtCreate()) {
            ocContractGoods.setGmtCreate(this.getSysDate());
        }
        ocContractGoods.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ocContractGoods.getCorderGoodsCode())) {
            ocContractGoods.setCorderGoodsCode(this.createUUIDString());
        }
        if (StringUtils.isBlank((String)ocContractGoods.getContractGoodsCode())) {
            ocContractGoods.setContractGoodsCode(ocContractGoods.getGoodsCode());
        }
    }

    private String checkCoCorderGoods(CoCorderGoodsDomain ocContractGoodsDomain) {
        if (null == ocContractGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocContractGoodsDomain.getTenantCode())) {
            msg = msg + "\u5546\u6237\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocContractGoodsDomain.getGoodsCode())) {
            msg = msg + "\u539f\u59cb\u5355\u636e\u53f7\u4e3a\u7a7a;";
        }
        return msg;
    }

    private CoCorderSettl createContractsettl(CoCorderSettlDomain ocContractSettlDomain) {
        String msg = this.checkContractSettl(ocContractSettlDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.saveContractSettl.checkContractSettl", msg);
        }
        CoCorderSettl ocContractSettl = this.makeContractSettl(ocContractSettlDomain, null);
        this.setContractSettlDefault(ocContractSettl);
        return ocContractSettl;
    }

    private String checkContractSettl(CoCorderSettlDomain ocContractSettlDomain) {
        if (null == ocContractSettlDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocContractSettlDomain.getContractBillcode())) {
            msg = msg + "ContractBillcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocContractSettlDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private CoCorderSettl makeContractSettl(CoCorderSettlDomain ocContractSettlDomain, CoCorderSettl ocContractSettl) {
        if (null == ocContractSettlDomain) {
            return null;
        }
        if (null == ocContractSettl) {
            ocContractSettl = new CoCorderSettl();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocContractSettl, (Object)ocContractSettlDomain);
            return ocContractSettl;
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.makeContractSettl", (Throwable)e);
            return null;
        }
    }

    private void setContractSettlDefault(CoCorderSettl ocContractSettl) {
        if (null == ocContractSettl) {
            return;
        }
        if (null == ocContractSettl.getDataState()) {
            ocContractSettl.setDataState(0);
        }
        if (null == ocContractSettl.getGmtCreate()) {
            ocContractSettl.setGmtCreate(this.getSysDate());
        }
        ocContractSettl.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ocContractSettl.getCorderSettlCode())) {
            ocContractSettl.setCorderSettlCode(this.createUUIDString());
        }
    }

    private void saveContractSettlModelBatch(List<CoCorderSettl> ocContractSettlList) throws ApiException {
        if (null == ocContractSettlList || ocContractSettlList.isEmpty()) {
            return;
        }
        try {
            this.coCorderSettlMapper.insertBatch(ocContractSettlList);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.saveContractSettlModelBatch.ex", (Throwable)e);
        }
    }

    private void saveContractGoodsBatchModel(List<CoCorderGoods> ocContractGoodsList) throws ApiException {
        if (null == ocContractGoodsList || ocContractGoodsList.isEmpty()) {
            return;
        }
        try {
            this.coCorderGoodsMapper.insertBatch(ocContractGoodsList);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.saveContractGoodsBatchModel.ex", (Throwable)e);
        }
    }

    public void sendCoCordersendService(CoCorder coCorderDomain) {
        if (null == coCorderDomain) {
            return;
        }
        CoCordersendDomain coCordersendDomain = new CoCordersendDomain();
        coCordersendDomain.setCorderCode(coCorderDomain.getCorderCode());
        coCordersendDomain.setTenantCode(coCorderDomain.getTenantCode());
        this.coCordersendService.sendCoCordersend(coCordersendDomain);
    }

    @Override
    public String updateCorderStateByContractBillcode(String tenantCode, String contractBillcode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateCorderStateModelByContractBillcode(tenantCode, contractBillcode, dataState, oldDataState, map);
        return "success";
    }

    private void updateCorderStateModelByContractBillcode(String tenantCode, String contractBillcode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)contractBillcode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractBillcode", contractBillcode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.coCorderMapper.updateCorderStateByContractBillcode(map);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.updateCorderStateModelByContractBillcode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.updateCorderStateModelByContractBillcode.null");
        }
    }

    @Override
    public void updateContractSubMoney(Integer corderId, String modifyMoney, String remark) {
        if (StringUtils.isEmpty((String)modifyMoney)) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.updateContractMoneyApply", "\u4ef7\u683c\u4e3a\u7a7a\uff01");
        }
        CoCorder contract = this.getCorderModelById(corderId);
        if (contract == null) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.updateContractMoneyApply", "\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        }
        BigDecimal money1 = contract.getDataBmoney();
        BigDecimal updateMoney = new BigDecimal(modifyMoney);
        contract.setContractMoney(contract.getContractMoney().add(updateMoney));
        contract.setDataBmoney(contract.getDataBmoney().add(updateMoney));
        contract.setGmtModified(this.getSysDate());
        BigDecimal goodsPmoney = contract.getGoodsPmoney();
        if (null == goodsPmoney) {
            goodsPmoney = BigDecimal.ZERO;
        }
        goodsPmoney = goodsPmoney.subtract(updateMoney);
        contract.setGoodsPmoney(goodsPmoney);
        contract.setMemo(remark);
        OcContractReDomain ocContractReDomain = this.getOcContractReDomain(contract.getTenantCode(), contract);
        if (ocContractReDomain == null) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.updateContractSubMoney.ex1");
        }
        HashMap<String, Object> paramStrMap = new HashMap<String, Object>();
        String str = null;
        paramStrMap.put("contractId", ocContractReDomain.getContractId());
        paramStrMap.put("modifyMoney", modifyMoney);
        paramStrMap.put("remark", remark);
        try {
            str = (String)this.getInternalRouter().inInvoke("oc.contract.updateContractSubMoney", paramStrMap);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.updateContractSubMoney", (Object)str);
        }
        this.updateContractMoneyPass(contract, updateMoney, money1);
    }

    private void updateContractMoneyPass(CoCorder contract, BigDecimal updateMoney, BigDecimal money1) {
        if (contract == null) {
            return;
        }
        BigDecimal basePrice = BigDecimal.ZERO;
        BigDecimal amount = null;
        List<CoCorderGoods> contractGoodsList = this.queryCorderGoodsModelPage(this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{contract.getContractBillcode(), contract.getTenantCode()}));
        BigDecimal smoney = updateMoney;
        BigDecimal money = money1.subtract(contract.getGoodsLogmoney());
        BigDecimal nmoney = BigDecimal.ZERO;
        BigDecimal nsmoney = null;
        if (ListUtil.isNotEmpty(contractGoodsList)) {
            for (int i = 0; i < contractGoodsList.size(); ++i) {
                CoCorderGoods ocContractGoods = contractGoodsList.get(i);
                nmoney = ocContractGoods.getContractGoodsPrice();
                nsmoney = nmoney.divide(money, 2).multiply(updateMoney);
                ocContractGoods.setContractGoodsMoney(ocContractGoods.getContractGoodsMoney().add(nsmoney));
                ocContractGoods.setContractGoodsPrice(ocContractGoods.getContractGoodsPrice().add(nsmoney));
                this.updateCorderGoodsModel(ocContractGoods);
                if (ocContractGoods.getPricesetBaseprice() == null) continue;
                basePrice = basePrice.add(ocContractGoods.getPricesetBaseprice());
            }
        }
        if (contract.getCashback() != null) {
            if (basePrice != BigDecimal.ZERO && basePrice.compareTo(contract.getContractMoney()) < 0) {
                amount = this.calBackAmount(this.getQueryMapParam("orderAmount,pricesetBaseprice", new Object[]{contract.getContractMoney(), basePrice}), contract.getTenantCode());
            }
            if (amount != null) {
                contract.setCashback(amount);
            }
        }
        this.updateCorderModel(contract);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("businessOrderno", contract.getContractBillcode());
        paramMap.put("ptradeSeqno", contract.getPtradeSeqno());
        paramMap.put("tenantCode", contract.getTenantCode());
        paramMap.put("money", contract.getContractMoney());
        paramMap.put("transferAmount", amount);
    }

    private BigDecimal calBackAmount(Map<String, Object> paramMap, String tenantCode) {
        String script = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-" + "exchange-backAmountScript"));
        if (StringUtils.isBlank((String)script)) {
            return null;
        }
        Object amount = ScriptUtil.evel((String)script, paramMap);
        if (amount == null) {
            this.logger.error("OrderMngCon.calBackAmount.error", (Object)script);
            return null;
        }
        BigDecimal backAmount = null;
        try {
            backAmount = new BigDecimal(amount.toString());
        }
        catch (Exception e) {
            this.logger.error("OrderMngCon.calBackAmount.error", (Throwable)e);
        }
        return backAmount;
    }

    private void updateCorderGoodsModel(CoCorderGoods coCorderGoods) throws ApiException {
        if (null == coCorderGoods) {
            return;
        }
        int i = 0;
        try {
            i = this.coCorderGoodsMapper.updateByPrimaryKey(coCorderGoods);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.updateCorderGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.updateCorderGoodsModel.num");
        }
    }

    private List<CoCorderGoods> queryCorderGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.coCorderGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.queryCorderGoodsModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public String sendSaveCrmCorder(OcContractDomain ocContractDomain) throws ApiException {
        if (ocContractDomain == null) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.sendSaveCrmCorder", (Object)"\u5546\u57ce\u8ba2\u5355\u540c\u6b65\u5230crm\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
            return null;
        }
        CoCorderDomain coCorderDomain = new CoCorderDomain();
        try {
            BeanUtils.copyAllPropertys((Object)coCorderDomain, (Object)ocContractDomain);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.sendSaveCrmCorder.coCorderDomain", (Throwable)e);
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantCode", coCorderDomain.getTenantCode());
        param.put("userinfoCode", coCorderDomain.getMemberBcode());
        HashMap<String, String> paramStr = new HashMap<String, String>();
        paramStr.put("map", JsonUtil.buildNonDefaultBinder().toJson(param));
        String QueryResultJson = "";
        try {
            QueryResultJson = (String)this.getInternalRouter().inInvoke("ct.custrel.queryCustrelPage", paramStr);
            if (StringUtils.isBlank((String)QueryResultJson)) {
                throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.sendSaveCrmCorder", QueryResultJson);
            }
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.sendSaveCrmCorder", (Throwable)e);
        }
        QueryResult queryResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(QueryResultJson, QueryResult.class);
        List custrelList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)queryResult.getList()), CtCustrel.class);
        if (ListUtil.isEmpty((Collection)custrelList)) {
            coCorderDomain.setDepartCode("0000");
            coCorderDomain.setEmployeeCode("0000");
            coCorderDomain.setCompanyCode("0000");
            this.logger.debug("co.CONTRACTORDER.CoCorderServiceImpl.sendSaveCrmCorderCustrelList", (Object)((Object)param).toString());
        } else {
            CtCustrel ctCustrel = (CtCustrel)custrelList.get(0);
            coCorderDomain.setDepartCode(StringUtils.isNotBlank((String)ctCustrel.getDepartCode()) ? ctCustrel.getDepartCode() : "0000");
            coCorderDomain.setEmployeeCode(StringUtils.isNotBlank((String)ctCustrel.getEmployeeCode()) ? ctCustrel.getEmployeeCode() : "0000");
            coCorderDomain.setCompanyCode(StringUtils.isNotBlank((String)ctCustrel.getCompanyCode()) ? ctCustrel.getCompanyCode() : "0000");
            coCorderDomain.setCompanyShortname(ctCustrel.getCompanyShortname());
            coCorderDomain.setEmployeeName(ctCustrel.getEmployeeName());
            coCorderDomain.setCustrelCode(ctCustrel.getCustrelCode());
            coCorderDomain.setDepartShortname(ctCustrel.getDepartName());
        }
        this.saveCorderCrm(coCorderDomain);
        return "success";
    }

    @Override
    public void sendSaveCrmCorderState(OcContractDomain ocContractDomain) throws ApiException {
        if (ocContractDomain == null) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.sendSaveCrmCorderState", (Object)"\u5546\u57ce\u8ba2\u5355\u4e0b\u5355\u540e\u540c\u6b65\u5230crm\u8ba2\u5355\u72b6\u6001\u4fe1\u606f\u4e3a\u7a7a");
            return;
        }
        this.updateCorderStateByContractBillcode(ocContractDomain.getTenantCode(), ocContractDomain.getContractBillcode(), ocContractDomain.getContractState(), null, null);
    }

    public void saveCorderCrm(CoCorderDomain coCorderDomain) throws ApiException {
        CoCorder coCorder = this.getCoCorder(coCorderDomain);
    }
}

