/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contractorder.service.impl;

import com.yqbsoft.laser.service.contractorder.dao.CoCorderSubMapper;
import com.yqbsoft.laser.service.contractorder.dao.CoCorderSublistMapper;
import com.yqbsoft.laser.service.contractorder.domain.CoCorderSubDomain;
import com.yqbsoft.laser.service.contractorder.domain.CoCorderSubReDomain;
import com.yqbsoft.laser.service.contractorder.domain.CoCorderSublistDomain;
import com.yqbsoft.laser.service.contractorder.domain.CoCorderSublistReDomain;
import com.yqbsoft.laser.service.contractorder.model.CoCorderSub;
import com.yqbsoft.laser.service.contractorder.model.CoCorderSublist;
import com.yqbsoft.laser.service.contractorder.service.CoCorderSubService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CoCorderSubServiceImpl
extends BaseServiceImpl
implements CoCorderSubService {
    private static final String SYS_CODE = "co.CONTRACTORDER.CoCorderSubServiceImpl";
    private CoCorderSubMapper coCorderSubMapper;
    private CoCorderSublistMapper coCorderSublistMapper;

    public void setCoCorderSubMapper(CoCorderSubMapper coCorderSubMapper) {
        this.coCorderSubMapper = coCorderSubMapper;
    }

    public void setCoCorderSublistMapper(CoCorderSublistMapper coCorderSublistMapper) {
        this.coCorderSublistMapper = coCorderSublistMapper;
    }

    private Date getSysDate() {
        try {
            return this.coCorderSubMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderSubServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCorderSub(CoCorderSubDomain coCorderSubDomain) {
        if (null == coCorderSubDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)coCorderSubDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCorderSubDefault(CoCorderSub coCorderSub) {
        if (null == coCorderSub) {
            return;
        }
        if (null == coCorderSub.getDataState()) {
            coCorderSub.setDataState(0);
        }
        if (null == coCorderSub.getGmtCreate()) {
            coCorderSub.setGmtCreate(this.getSysDate());
        }
        coCorderSub.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)coCorderSub.getCorderSubCode())) {
            coCorderSub.setCorderSubCode(this.createUUIDString());
        }
    }

    private int getCorderSubMaxCode() {
        int code = 0;
        try {
            return this.coCorderSubMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderSubServiceImpl.getCorderSubMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCorderSubUpdataDefault(CoCorderSub coCorderSub) {
        if (null == coCorderSub) {
            return;
        }
        coCorderSub.setGmtModified(this.getSysDate());
    }

    private void saveCorderSubModel(CoCorderSub coCorderSub) throws ApiException {
        if (null == coCorderSub) {
            return;
        }
        try {
            this.coCorderSubMapper.insert(coCorderSub);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSubServiceImpl.saveCorderSubModel.ex", (Throwable)e);
        }
    }

    private void saveCorderSubBatchModel(List<CoCorderSub> coCorderSubList) throws ApiException {
        if (null == coCorderSubList || coCorderSubList.isEmpty()) {
            return;
        }
        try {
            this.coCorderSubMapper.insertBatch(coCorderSubList);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSubServiceImpl.saveCorderSubBatchModel.ex", (Throwable)e);
        }
    }

    private CoCorderSub getCorderSubModelById(Integer corderSubId) {
        if (null == corderSubId) {
            return null;
        }
        try {
            return this.coCorderSubMapper.selectByPrimaryKey(corderSubId);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderSubServiceImpl.getCorderSubModelById", (Throwable)e);
            return null;
        }
    }

    private CoCorderSub getCorderSubModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.coCorderSubMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderSubServiceImpl.getCorderSubModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCorderSubModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.coCorderSubMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSubServiceImpl.delCorderSubModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSubServiceImpl.delCorderSubModelByCode.num");
        }
    }

    private void deleteCorderSubModel(Integer corderSubId) throws ApiException {
        if (null == corderSubId) {
            return;
        }
        int i = 0;
        try {
            i = this.coCorderSubMapper.deleteByPrimaryKey(corderSubId);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSubServiceImpl.deleteCorderSubModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSubServiceImpl.deleteCorderSubModel.num");
        }
    }

    private void updateCorderSubModel(CoCorderSub coCorderSub) throws ApiException {
        if (null == coCorderSub) {
            return;
        }
        int i = 0;
        try {
            i = this.coCorderSubMapper.updateByPrimaryKey(coCorderSub);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSubServiceImpl.updateCorderSubModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSubServiceImpl.updateCorderSubModel.num");
        }
    }

    private void updateStateCorderSubModel(Integer corderSubId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == corderSubId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("corderSubId", corderSubId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.coCorderSubMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSubServiceImpl.updateStateCorderSubModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSubServiceImpl.updateStateCorderSubModel.null");
        }
    }

    private void updateStateCorderSubModelByCode(String tenantCode, String corderSubCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)corderSubCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("corderSubCode", corderSubCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.coCorderSubMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSubServiceImpl.updateStateCorderSubModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSubServiceImpl.updateStateCorderSubModelByCode.null");
        }
    }

    private CoCorderSub makeCorderSub(CoCorderSubDomain coCorderSubDomain, CoCorderSub coCorderSub) {
        if (null == coCorderSubDomain) {
            return null;
        }
        if (null == coCorderSub) {
            coCorderSub = new CoCorderSub();
        }
        try {
            BeanUtils.copyAllPropertys((Object)coCorderSub, (Object)coCorderSubDomain);
            return coCorderSub;
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderSubServiceImpl.makeCorderSub", (Throwable)e);
            return null;
        }
    }

    private CoCorderSubReDomain makeCoCorderSubReDomain(CoCorderSub coCorderSub) {
        if (null == coCorderSub) {
            return null;
        }
        CoCorderSubReDomain coCorderSubReDomain = new CoCorderSubReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)coCorderSubReDomain, (Object)coCorderSub);
            return coCorderSubReDomain;
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderSubServiceImpl.makeCoCorderSubReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CoCorderSub> queryCorderSubModelPage(Map<String, Object> parammap) {
        try {
            return this.coCorderSubMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderSubServiceImpl.queryCorderSubModel", (Throwable)e);
            return null;
        }
    }

    private int countCorderSub(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.coCorderSubMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderSubServiceImpl.countCorderSub", (Throwable)e);
        }
        return i;
    }

    private CoCorderSub createCoCorderSub(CoCorderSubDomain coCorderSubDomain) {
        String msg = this.checkCorderSub(coCorderSubDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSubServiceImpl.saveCorderSub.checkCorderSub", msg);
        }
        CoCorderSub coCorderSub = this.makeCorderSub(coCorderSubDomain, null);
        this.setCorderSubDefault(coCorderSub);
        return coCorderSub;
    }

    private String checkCorderSublist(CoCorderSublistDomain coCorderSublistDomain) {
        if (null == coCorderSublistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)coCorderSublistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCorderSublistDefault(CoCorderSublist coCorderSublist) {
        if (null == coCorderSublist) {
            return;
        }
        if (null == coCorderSublist.getDataState()) {
            coCorderSublist.setDataState(0);
        }
        if (null == coCorderSublist.getGmtCreate()) {
            coCorderSublist.setGmtCreate(this.getSysDate());
        }
        coCorderSublist.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)coCorderSublist.getCorderSublistCode())) {
            coCorderSublist.setCorderSublistCode(this.createUUIDString());
        }
    }

    private int getCorderSublistMaxCode() {
        int code = 0;
        try {
            return this.coCorderSublistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderSubServiceImpl.getCorderSublistMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCorderSublistUpdataDefault(CoCorderSublist coCorderSublist) {
        if (null == coCorderSublist) {
            return;
        }
        coCorderSublist.setGmtModified(this.getSysDate());
    }

    private void saveCorderSublistModel(CoCorderSublist coCorderSublist) throws ApiException {
        if (null == coCorderSublist) {
            return;
        }
        try {
            this.coCorderSublistMapper.insert(coCorderSublist);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSubServiceImpl.saveCorderSublistModel.ex", (Throwable)e);
        }
    }

    private void saveCorderSublistBatchModel(List<CoCorderSublist> coCorderSublistList) throws ApiException {
        if (null == coCorderSublistList || coCorderSublistList.isEmpty()) {
            return;
        }
        try {
            this.coCorderSublistMapper.insertBatch(coCorderSublistList);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSubServiceImpl.saveCorderSublistBatchModel.ex", (Throwable)e);
        }
    }

    private CoCorderSublist getCorderSublistModelById(Integer corderSublistId) {
        if (null == corderSublistId) {
            return null;
        }
        try {
            return this.coCorderSublistMapper.selectByPrimaryKey(corderSublistId);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderSubServiceImpl.getCorderSublistModelById", (Throwable)e);
            return null;
        }
    }

    private CoCorderSublist getCorderSublistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.coCorderSublistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderSubServiceImpl.getCorderSublistModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCorderSublistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.coCorderSublistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSubServiceImpl.delCorderSublistModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSubServiceImpl.delCorderSublistModelByCode.num");
        }
    }

    private void deleteCorderSublistModel(Integer corderSublistId) throws ApiException {
        if (null == corderSublistId) {
            return;
        }
        int i = 0;
        try {
            i = this.coCorderSublistMapper.deleteByPrimaryKey(corderSublistId);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSubServiceImpl.deleteCorderSublistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSubServiceImpl.deleteCorderSublistModel.num");
        }
    }

    private void updateCorderSublistModel(CoCorderSublist coCorderSublist) throws ApiException {
        if (null == coCorderSublist) {
            return;
        }
        int i = 0;
        try {
            i = this.coCorderSublistMapper.updateByPrimaryKey(coCorderSublist);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSubServiceImpl.updateCorderSublistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSubServiceImpl.updateCorderSublistModel.num");
        }
    }

    private void updateStateCorderSublistModel(Integer corderSublistId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == corderSublistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("corderSublistId", corderSublistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.coCorderSublistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSubServiceImpl.updateStateCorderSublistModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSubServiceImpl.updateStateCorderSublistModel.null");
        }
    }

    private void updateStateCorderSublistModelByCode(String tenantCode, String corderSublistCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)corderSublistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("corderSublistCode", corderSublistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.coCorderSublistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSubServiceImpl.updateStateCorderSublistModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSubServiceImpl.updateStateCorderSublistModelByCode.null");
        }
    }

    private CoCorderSublist makeCorderSublist(CoCorderSublistDomain coCorderSublistDomain, CoCorderSublist coCorderSublist) {
        if (null == coCorderSublistDomain) {
            return null;
        }
        if (null == coCorderSublist) {
            coCorderSublist = new CoCorderSublist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)coCorderSublist, (Object)coCorderSublistDomain);
            return coCorderSublist;
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderSubServiceImpl.makeCorderSublist", (Throwable)e);
            return null;
        }
    }

    private CoCorderSublistReDomain makeCoCorderSublistReDomain(CoCorderSublist coCorderSublist) {
        if (null == coCorderSublist) {
            return null;
        }
        CoCorderSublistReDomain coCorderSublistReDomain = new CoCorderSublistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)coCorderSublistReDomain, (Object)coCorderSublist);
            return coCorderSublistReDomain;
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderSubServiceImpl.makeCoCorderSublistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CoCorderSublist> queryCorderSublistModelPage(Map<String, Object> parammap) {
        try {
            return this.coCorderSublistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderSubServiceImpl.queryCorderSublistModel", (Throwable)e);
            return null;
        }
    }

    private int countCorderSublist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.coCorderSublistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderSubServiceImpl.countCorderSublist", (Throwable)e);
        }
        return i;
    }

    private CoCorderSublist createCoCorderSublist(CoCorderSublistDomain coCorderSublistDomain) {
        String msg = this.checkCorderSublist(coCorderSublistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSubServiceImpl.saveCorderSublist.checkCorderSublist", msg);
        }
        CoCorderSublist coCorderSublist = this.makeCorderSublist(coCorderSublistDomain, null);
        this.setCorderSublistDefault(coCorderSublist);
        return coCorderSublist;
    }

    @Override
    public String saveCorderSub(CoCorderSubDomain coCorderSubDomain) throws ApiException {
        CoCorderSub coCorderSub = this.createCoCorderSub(coCorderSubDomain);
        this.saveCorderSubModel(coCorderSub);
        return coCorderSub.getCorderSubCode();
    }

    @Override
    public String saveCorderSubBatch(List<CoCorderSubDomain> coCorderSubDomainList) throws ApiException {
        if (null == coCorderSubDomainList || coCorderSubDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CoCorderSub> coCorderSubList = new ArrayList<CoCorderSub>();
        String code = "";
        for (CoCorderSubDomain coCorderSubDomain : coCorderSubDomainList) {
            CoCorderSub coCorderSub = this.createCoCorderSub(coCorderSubDomain);
            code = coCorderSub.getCorderSubCode();
            coCorderSubList.add(coCorderSub);
        }
        this.saveCorderSubBatchModel(coCorderSubList);
        return code;
    }

    @Override
    public void updateCorderSubState(Integer corderSubId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateCorderSubModel(corderSubId, dataState, oldDataState, map);
    }

    @Override
    public void updateCorderSubStateByCode(String tenantCode, String corderSubCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateCorderSubModelByCode(tenantCode, corderSubCode, dataState, oldDataState, map);
    }

    @Override
    public void updateCorderSub(CoCorderSubDomain coCorderSubDomain) throws ApiException {
        String msg = this.checkCorderSub(coCorderSubDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSubServiceImpl.updateCorderSub.checkCorderSub", msg);
        }
        CoCorderSub oldCoCorderSub = this.getCorderSubModelById(coCorderSubDomain.getCorderSubId());
        if (null == oldCoCorderSub) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSubServiceImpl.updateCorderSub.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CoCorderSub coCorderSub = this.makeCorderSub(coCorderSubDomain, oldCoCorderSub);
        this.setCorderSubUpdataDefault(coCorderSub);
        this.updateCorderSubModel(coCorderSub);
    }

    @Override
    public CoCorderSub getCorderSub(Integer corderSubId) {
        return this.getCorderSubModelById(corderSubId);
    }

    @Override
    public void deleteCorderSub(Integer corderSubId) throws ApiException {
        this.deleteCorderSubModel(corderSubId);
    }

    @Override
    public QueryResult<CoCorderSub> queryCorderSubPage(Map<String, Object> map) {
        List<CoCorderSub> coCorderSubList = this.queryCorderSubModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCorderSub(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(coCorderSubList);
        return queryResult;
    }

    @Override
    public CoCorderSub getCorderSubByCode(String tenantCode, String corderSubCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("corderSubCode", corderSubCode);
        return this.getCorderSubModelByCode(map);
    }

    @Override
    public void deleteCorderSubByCode(String tenantCode, String corderSubCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("corderSubCode", corderSubCode);
        this.delCorderSubModelByCode(map);
    }

    @Override
    public String saveCorderSublist(CoCorderSublistDomain coCorderSublistDomain) throws ApiException {
        CoCorderSublist coCorderSublist = this.createCoCorderSublist(coCorderSublistDomain);
        this.saveCorderSublistModel(coCorderSublist);
        return coCorderSublist.getCorderSublistCode();
    }

    @Override
    public String saveCorderSublistBatch(List<CoCorderSublistDomain> coCorderSublistDomainList) throws ApiException {
        if (null == coCorderSublistDomainList || coCorderSublistDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CoCorderSublist> coCorderSublistList = new ArrayList<CoCorderSublist>();
        String code = "";
        for (CoCorderSublistDomain coCorderSublistDomain : coCorderSublistDomainList) {
            CoCorderSublist coCorderSublist = this.createCoCorderSublist(coCorderSublistDomain);
            code = coCorderSublist.getCorderSublistCode();
            coCorderSublistList.add(coCorderSublist);
        }
        this.saveCorderSublistBatchModel(coCorderSublistList);
        return code;
    }

    @Override
    public void updateCorderSublistState(Integer corderSublistId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateCorderSublistModel(corderSublistId, dataState, oldDataState, map);
    }

    @Override
    public void updateCorderSublistStateByCode(String tenantCode, String corderSublistCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateCorderSublistModelByCode(tenantCode, corderSublistCode, dataState, oldDataState, map);
    }

    @Override
    public void updateCorderSublist(CoCorderSublistDomain coCorderSublistDomain) throws ApiException {
        String msg = this.checkCorderSublist(coCorderSublistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSubServiceImpl.updateCorderSublist.checkCorderSublist", msg);
        }
        CoCorderSublist oldCoCorderSublist = this.getCorderSublistModelById(coCorderSublistDomain.getCorderSublistId());
        if (null == oldCoCorderSublist) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSubServiceImpl.updateCorderSublist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CoCorderSublist coCorderSublist = this.makeCorderSublist(coCorderSublistDomain, oldCoCorderSublist);
        this.setCorderSublistUpdataDefault(coCorderSublist);
        this.updateCorderSublistModel(coCorderSublist);
    }

    @Override
    public CoCorderSublist getCorderSublist(Integer corderSublistId) {
        return this.getCorderSublistModelById(corderSublistId);
    }

    @Override
    public void deleteCorderSublist(Integer corderSublistId) throws ApiException {
        this.deleteCorderSublistModel(corderSublistId);
    }

    @Override
    public QueryResult<CoCorderSublist> queryCorderSublistPage(Map<String, Object> map) {
        List<CoCorderSublist> coCorderSublistList = this.queryCorderSublistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCorderSublist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(coCorderSublistList);
        return queryResult;
    }

    @Override
    public CoCorderSublist getCorderSublistByCode(String tenantCode, String corderSublistCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("corderSublistCode", corderSublistCode);
        return this.getCorderSublistModelByCode(map);
    }

    @Override
    public void deleteCorderSublistByCode(String tenantCode, String corderSublistCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("corderSublistCode", corderSublistCode);
        this.delCorderSublistModelByCode(map);
    }
}

