/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.crms.service.impl;

import com.yqbsoft.laser.service.crms.dao.CrmsURechargeMapper;
import com.yqbsoft.laser.service.crms.domain.CrmsChannelSendDomain;
import com.yqbsoft.laser.service.crms.domain.CrmsURechargeDomain;
import com.yqbsoft.laser.service.crms.domain.CrmsURechargeListDomain;
import com.yqbsoft.laser.service.crms.domain.CrmsURechargeReDomain;
import com.yqbsoft.laser.service.crms.model.CrmsChannelSend;
import com.yqbsoft.laser.service.crms.model.CrmsURecharge;
import com.yqbsoft.laser.service.crms.service.CrmsChannelSendService;
import com.yqbsoft.laser.service.crms.service.CrmsURechargeListService;
import com.yqbsoft.laser.service.crms.service.CrmsURechargeService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CrmsURechargeServiceImpl
extends BaseServiceImpl
implements CrmsURechargeService {
    private static final String SYS_CODE = "service.crms.CrmsURechargeServiceImpl";
    private CrmsURechargeMapper crmsURechargeMapper;
    private CrmsChannelSendService crmsChannelSendService;
    private CrmsURechargeListService crmsURechargeListService;

    public CrmsURechargeListService getCrmsURechargeListService() {
        return this.crmsURechargeListService;
    }

    public void setCrmsURechargeListService(CrmsURechargeListService crmsURechargeListService) {
        this.crmsURechargeListService = crmsURechargeListService;
    }

    public CrmsChannelSendService getCrmsChannelSendService() {
        return this.crmsChannelSendService;
    }

    public void setCrmsChannelSendService(CrmsChannelSendService crmsChannelSendService) {
        this.crmsChannelSendService = crmsChannelSendService;
    }

    public void setCrmsURechargeMapper(CrmsURechargeMapper crmsURechargeMapper) {
        this.crmsURechargeMapper = crmsURechargeMapper;
    }

    private Date getSysDate() {
        try {
            return this.crmsURechargeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsURechargeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkURecharge(CrmsURechargeDomain crmsURechargeDomain) {
        if (null == crmsURechargeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)crmsURechargeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setURechargeDefault(CrmsURecharge crmsURecharge) {
        if (null == crmsURecharge) {
            return;
        }
        if (null == crmsURecharge.getDataState()) {
            crmsURecharge.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == crmsURecharge.getGmtCreate()) {
            crmsURecharge.setGmtCreate(date);
        }
        crmsURecharge.setGmtModified(date);
        if (StringUtils.isBlank((String)crmsURecharge.getUrechargeCode())) {
            crmsURecharge.setUrechargeCode(this.getNo(null, "CrmsURecharge", "crmsURecharge", crmsURecharge.getTenantCode()));
        }
    }

    private int getURechargeMaxCode() {
        int code = 0;
        try {
            return this.crmsURechargeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsURechargeServiceImpl.getURechargeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setURechargeUpdataDefault(CrmsURecharge crmsURecharge) {
        if (null == crmsURecharge) {
            return;
        }
        crmsURecharge.setGmtModified(this.getSysDate());
    }

    private void saveURechargeModel(CrmsURecharge crmsURecharge) throws ApiException {
        if (null == crmsURecharge) {
            return;
        }
        try {
            this.crmsURechargeMapper.insert(crmsURecharge);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsURechargeServiceImpl.saveURechargeModel.ex", (Throwable)e);
        }
    }

    private void saveURechargeBatchModel(List<CrmsURecharge> crmsURechargeList) throws ApiException {
        if (null == crmsURechargeList || crmsURechargeList.isEmpty()) {
            return;
        }
        try {
            this.crmsURechargeMapper.insertBatch(crmsURechargeList);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsURechargeServiceImpl.saveURechargeBatchModel.ex", (Throwable)e);
        }
    }

    private CrmsURecharge getURechargeModelById(Integer URechargeId) {
        if (null == URechargeId) {
            return null;
        }
        try {
            return this.crmsURechargeMapper.selectByPrimaryKey(URechargeId);
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsURechargeServiceImpl.getURechargeModelById", (Throwable)e);
            return null;
        }
    }

    private CrmsURecharge getURechargeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.crmsURechargeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsURechargeServiceImpl.getURechargeModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delURechargeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.crmsURechargeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsURechargeServiceImpl.delURechargeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crms.CrmsURechargeServiceImpl.delURechargeModelByCode.num");
        }
    }

    private void deleteURechargeModel(Integer URechargeId) throws ApiException {
        if (null == URechargeId) {
            return;
        }
        int i = 0;
        try {
            i = this.crmsURechargeMapper.deleteByPrimaryKey(URechargeId);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsURechargeServiceImpl.deleteURechargeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crms.CrmsURechargeServiceImpl.deleteURechargeModel.num");
        }
    }

    private void updateURechargeModel(CrmsURecharge crmsURecharge) throws ApiException {
        if (null == crmsURecharge) {
            return;
        }
        int i = 0;
        try {
            i = this.crmsURechargeMapper.updateByPrimaryKeySelective(crmsURecharge);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsURechargeServiceImpl.updateURechargeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crms.CrmsURechargeServiceImpl.updateURechargeModel.num");
        }
    }

    private void updateStateURechargeModel(Integer URechargeId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == URechargeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("URechargeId", URechargeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crmsURechargeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsURechargeServiceImpl.updateStateURechargeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.crms.CrmsURechargeServiceImpl.updateStateURechargeModel.null");
        }
    }

    private void updateStateURechargeModelByCode(String tenantCode, String URechargeCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)URechargeCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("URechargeCode", URechargeCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crmsURechargeMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsURechargeServiceImpl.updateStateURechargeModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.crms.CrmsURechargeServiceImpl.updateStateURechargeModelByCode.null");
        }
    }

    private CrmsURecharge makeURecharge(CrmsURechargeDomain crmsURechargeDomain, CrmsURecharge crmsURecharge) {
        if (null == crmsURechargeDomain) {
            return null;
        }
        if (null == crmsURecharge) {
            crmsURecharge = new CrmsURecharge();
        }
        try {
            BeanUtils.copyAllPropertys((Object)crmsURecharge, (Object)crmsURechargeDomain);
            return crmsURecharge;
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsURechargeServiceImpl.makeURecharge", (Throwable)e);
            return null;
        }
    }

    private CrmsURechargeReDomain makeCrmsURechargeReDomain(CrmsURecharge crmsURecharge) {
        if (null == crmsURecharge) {
            return null;
        }
        CrmsURechargeReDomain crmsURechargeReDomain = new CrmsURechargeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)crmsURechargeReDomain, (Object)crmsURecharge);
            return crmsURechargeReDomain;
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsURechargeServiceImpl.makeCrmsURechargeReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CrmsURecharge> queryURechargeModelPage(Map<String, Object> parammap) {
        try {
            return this.crmsURechargeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsURechargeServiceImpl.queryURechargeModel", (Throwable)e);
            return null;
        }
    }

    private int countURecharge(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.crmsURechargeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsURechargeServiceImpl.countURecharge", (Throwable)e);
        }
        return i;
    }

    private CrmsURecharge createCrmsURecharge(CrmsURechargeDomain crmsURechargeDomain) {
        String msg = this.checkURecharge(crmsURechargeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.crms.CrmsURechargeServiceImpl.saveURecharge.checkURecharge", msg);
        }
        CrmsURecharge crmsURecharge = this.makeURecharge(crmsURechargeDomain, null);
        this.setURechargeDefault(crmsURecharge);
        return crmsURecharge;
    }

    @Override
    public List<CrmsChannelSend> saveURecharge(CrmsURechargeDomain crmsURechargeDomain) throws ApiException {
        CrmsURecharge crmsURecharge = this.createCrmsURecharge(crmsURechargeDomain);
        this.saveURechargeModel(crmsURecharge);
        ArrayList<CrmsURecharge> list = new ArrayList<CrmsURecharge>();
        list.add(crmsURecharge);
        this.handlerCrmsURecharge(crmsURecharge);
        return this.buildChannelSend(list, "insert");
    }

    private void handlerCrmsURecharge(CrmsURecharge crmsURecharge) {
        this.handlerCrmsURecharge(crmsURecharge, null);
    }

    private void handlerCrmsURecharge(CrmsURecharge crmsURecharge, String orderCode) {
        CrmsURechargeListDomain crmsURechargeListDomain = new CrmsURechargeListDomain();
        try {
            BeanUtils.copyAllPropertys((Object)crmsURechargeListDomain, (Object)crmsURecharge);
            crmsURechargeListDomain.setRechargeOpno(orderCode);
            this.crmsURechargeListService.saveURechargeList(crmsURechargeListDomain);
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsURechargeServiceImpl.handlerCrpRecharge", (Throwable)e);
        }
    }

    @Override
    public List<CrmsChannelSend> saveURechargeBatch(List<CrmsURechargeDomain> crmsURechargeDomainList) throws ApiException {
        if (null == crmsURechargeDomainList || crmsURechargeDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CrmsChannelSend> crmsChannelSendList = new ArrayList<CrmsChannelSend>();
        for (CrmsURechargeDomain crmsURechargeDomain : crmsURechargeDomainList) {
            List<CrmsChannelSend> list = this.saveURecharge(crmsURechargeDomain);
            if (!ListUtil.isNotEmpty(list)) continue;
            crmsChannelSendList.addAll(list);
        }
        return crmsChannelSendList;
    }

    @Override
    public List<CrmsChannelSend> updateURechargeState(Integer URechargeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateURechargeModel(URechargeId, dataState, oldDataState, map);
        CrmsURecharge crmsURecharge = this.getURecharge(URechargeId);
        ArrayList<CrmsURecharge> list = new ArrayList<CrmsURecharge>();
        list.add(crmsURecharge);
        return this.buildChannelSend(list, "update");
    }

    @Override
    public List<CrmsChannelSend> updateURechargeStateByCode(String tenantCode, String URechargeCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateURechargeModelByCode(tenantCode, URechargeCode, dataState, oldDataState, map);
        CrmsURecharge crmsURecharge = this.getURechargeByCode(tenantCode, URechargeCode);
        ArrayList<CrmsURecharge> list = new ArrayList<CrmsURecharge>();
        list.add(crmsURecharge);
        return this.buildChannelSend(list, "update");
    }

    @Override
    public List<CrmsChannelSend> updateURecharge(CrmsURechargeDomain crmsURechargeDomain) throws ApiException {
        String msg = this.checkURecharge(crmsURechargeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.crms.CrmsURechargeServiceImpl.updateURecharge.checkURecharge", msg);
        }
        CrmsURecharge oldCrmsURecharge = this.getURechargeModelById(crmsURechargeDomain.getUrechargeId());
        if (null == oldCrmsURecharge) {
            throw new ApiException("service.crms.CrmsURechargeServiceImpl.updateURecharge.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CrmsURecharge crmsURecharge = new CrmsURecharge();
        if (crmsURechargeDomain.getRechargeAllmoney() != null) {
            crmsURecharge.setUrechargeId(crmsURechargeDomain.getUrechargeId());
            crmsURecharge.setRechargeAllmoney(oldCrmsURecharge.getRechargeAllmoney().add(crmsURechargeDomain.getRechargeAllmoney()));
            crmsURecharge.setRechargeSmoney(oldCrmsURecharge.getRechargeSmoney().add(crmsURechargeDomain.getRechargeAllmoney()));
            crmsURecharge.setTenantCode(crmsURechargeDomain.getTenantCode());
        } else if (crmsURechargeDomain.getRechargeSmoney() != null) {
            crmsURecharge.setUrechargeId(crmsURechargeDomain.getUrechargeId());
            crmsURecharge.setRechargeSmoney(oldCrmsURecharge.getRechargeSmoney().add(crmsURechargeDomain.getRechargeSmoney()));
            crmsURecharge.setTenantCode(crmsURechargeDomain.getTenantCode());
        } else {
            crmsURecharge = this.makeURecharge(crmsURechargeDomain, oldCrmsURecharge);
        }
        this.setURechargeUpdataDefault(crmsURecharge);
        this.updateURechargeModel(crmsURecharge);
        if (crmsURechargeDomain.getRechargeAllmoney() != null || crmsURechargeDomain.getRechargeSmoney() != null) {
            this.handlerCrmsURecharge(crmsURecharge, crmsURechargeDomain.getOrderCode());
        }
        ArrayList<CrmsURecharge> list = new ArrayList<CrmsURecharge>();
        list.add(crmsURecharge);
        return this.buildChannelSend(list, "update");
    }

    @Override
    public CrmsURecharge getURecharge(Integer URechargeId) {
        if (null == URechargeId) {
            return null;
        }
        return this.getURechargeModelById(URechargeId);
    }

    @Override
    public List<CrmsChannelSend> deleteURecharge(Integer URechargeId) throws ApiException {
        CrmsURecharge crmsURecharge = this.getURecharge(URechargeId);
        ArrayList<CrmsURecharge> list = new ArrayList<CrmsURecharge>();
        list.add(crmsURecharge);
        this.deleteURechargeModel(URechargeId);
        return this.buildChannelSend(list, "update");
    }

    @Override
    public QueryResult<CrmsURecharge> queryURechargePage(Map<String, Object> map) {
        List<CrmsURecharge> crmsURechargeList = this.queryURechargeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countURecharge(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(crmsURechargeList);
        return queryResult;
    }

    @Override
    public CrmsURecharge getURechargeByUserInfoCode(String tenantCode, String userInfoCode) throws ApiException {
        if (StringUtils.isBlank((String)userInfoCode)) {
            return null;
        }
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tenantCode", tenantCode);
            map.put("userInfoCode", userInfoCode);
            return this.crmsURechargeMapper.getURechargeByUserInfoCode(map);
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsURechargeServiceImpl.getURechargeByUserInfoCode", (Throwable)e);
            return null;
        }
    }

    @Override
    public CrmsURecharge getURechargeByCode(String tenantCode, String URechargeCode) throws ApiException {
        if (StringUtils.isBlank((String)URechargeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("URechargeCode", URechargeCode);
        return this.getURechargeModelByCode(map);
    }

    @Override
    public List<CrmsChannelSend> deleteURechargeByCode(String tenantCode, String URechargeCode) throws ApiException {
        CrmsURecharge crmsURecharge = this.getURechargeByCode(tenantCode, URechargeCode);
        ArrayList<CrmsURecharge> list = new ArrayList<CrmsURecharge>();
        list.add(crmsURecharge);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("urechargeCode", URechargeCode);
        this.delURechargeModelByCode(map);
        return this.buildChannelSend(list, "update");
    }

    private List<CrmsChannelSend> buildChannelSend(List<CrmsURecharge> crmsURechargeList, String dri) {
        if (ListUtil.isEmpty(crmsURechargeList)) {
            return null;
        }
        ArrayList<CrmsChannelSend> crmsChannelSendList = new ArrayList();
        ArrayList<CrmsChannelSendDomain> disChannelsendDomainList = new ArrayList<CrmsChannelSendDomain>();
        for (CrmsURecharge promotion : crmsURechargeList) {
            CrmsChannelSendDomain pmChannelsendDomain = new CrmsChannelSendDomain();
            pmChannelsendDomain.setChannelsendOpcode(promotion.getUrechargeCode());
            pmChannelsendDomain.setChannelsendType("crmsUrecharge");
            pmChannelsendDomain.setChannelsendDir(dri);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)promotion));
            pmChannelsendDomain.setTenantCode(promotion.getTenantCode());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        crmsChannelSendList = this.crmsChannelSendService.saveChannelSendBatch(disChannelsendDomainList);
        return crmsChannelSendList;
    }
}

