/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.service.impl;

import com.yqbsoft.laser.service.data.dao.DaOpsumOrderlistMapper;
import com.yqbsoft.laser.service.data.domain.DaOpsumOrderlistDomain;
import com.yqbsoft.laser.service.data.domain.DaOpsumOrderlistReDomain;
import com.yqbsoft.laser.service.data.domain.DisChannel;
import com.yqbsoft.laser.service.data.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.data.domain.OcContractReDomain;
import com.yqbsoft.laser.service.data.model.DaOpsumOrderlist;
import com.yqbsoft.laser.service.data.service.DaOpsumOrderlistService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DaOpsumOrderlistServiceImpl
extends BaseServiceImpl
implements DaOpsumOrderlistService {
    private static final String SYS_CODE = "da.DaOpsumOrderlistServiceImpl";
    private DaOpsumOrderlistMapper daOpsumOrderlistMapper;

    public void setDaOpsumOrderlistMapper(DaOpsumOrderlistMapper daOpsumOrderlistMapper) {
        this.daOpsumOrderlistMapper = daOpsumOrderlistMapper;
    }

    private Date getSysDate() {
        try {
            return this.daOpsumOrderlistMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumOrderlistServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOpsumOrderList(DaOpsumOrderlistDomain daOpsumOrderlistDomain) {
        if (null == daOpsumOrderlistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)daOpsumOrderlistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOpsumOrderListDefault(DaOpsumOrderlist daOpsumOrderlist) {
        if (null == daOpsumOrderlist) {
            return;
        }
        if (null == daOpsumOrderlist.getDataState()) {
            daOpsumOrderlist.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daOpsumOrderlist.getGmtCreate()) {
            daOpsumOrderlist.setGmtCreate(date);
        }
        daOpsumOrderlist.setGmtModified(date);
        if (StringUtils.isBlank((String)daOpsumOrderlist.getOpsumOrderlistCode())) {
            daOpsumOrderlist.setOpsumOrderlistCode(this.getNo(null, "DaOpsumOrderlist", "daOpsumOrderlist", daOpsumOrderlist.getTenantCode()));
        }
    }

    private int getOpsumOrderListMaxCode() {
        int code = 0;
        try {
            return this.daOpsumOrderlistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumOrderlistServiceImpl.getOpsumOrderListMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOpsumOrderListUpdataDefault(DaOpsumOrderlist daOpsumOrderlist) {
        if (null == daOpsumOrderlist) {
            return;
        }
        daOpsumOrderlist.setGmtModified(this.getSysDate());
    }

    private void saveOpsumOrderListModel(DaOpsumOrderlist daOpsumOrderlist) throws ApiException {
        if (null == daOpsumOrderlist) {
            return;
        }
        try {
            this.daOpsumOrderlistMapper.insert(daOpsumOrderlist);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumOrderlistServiceImpl.saveOpsumOrderListModel.ex", (Throwable)e);
        }
    }

    private void saveOpsumOrderListBatchModel(List<DaOpsumOrderlist> daOpsumOrderlistList) throws ApiException {
        if (null == daOpsumOrderlistList || daOpsumOrderlistList.isEmpty()) {
            return;
        }
        try {
            this.daOpsumOrderlistMapper.insertBatch(daOpsumOrderlistList);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumOrderlistServiceImpl.saveOpsumOrderListBatchModel.ex", (Throwable)e);
        }
    }

    private DaOpsumOrderlist getOpsumOrderListModelById(Integer opsumOrderlistId) {
        if (null == opsumOrderlistId) {
            return null;
        }
        try {
            return this.daOpsumOrderlistMapper.selectByPrimaryKey(opsumOrderlistId);
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumOrderlistServiceImpl.getOpsumOrderListModelById", (Throwable)e);
            return null;
        }
    }

    private DaOpsumOrderlist getOpsumOrderListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.daOpsumOrderlistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumOrderlistServiceImpl.getOpsumOrderListModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delOpsumOrderListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.daOpsumOrderlistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumOrderlistServiceImpl.delOpsumOrderListModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaOpsumOrderlistServiceImpl.delOpsumOrderListModelByCode.num");
        }
    }

    private void deleteOpsumOrderListModel(Integer opsumOrderlistId) throws ApiException {
        if (null == opsumOrderlistId) {
            return;
        }
        int i = 0;
        try {
            i = this.daOpsumOrderlistMapper.deleteByPrimaryKey(opsumOrderlistId);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumOrderlistServiceImpl.deleteOpsumOrderListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaOpsumOrderlistServiceImpl.deleteOpsumOrderListModel.num");
        }
    }

    private void updateOpsumOrderListModel(DaOpsumOrderlist daOpsumOrderlist) throws ApiException {
        if (null == daOpsumOrderlist) {
            return;
        }
        int i = 0;
        try {
            i = this.daOpsumOrderlistMapper.updateByPrimaryKey(daOpsumOrderlist);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumOrderlistServiceImpl.updateOpsumOrderListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaOpsumOrderlistServiceImpl.updateOpsumOrderListModel.num");
        }
    }

    private void updateStateOpsumOrderListModel(Integer opsumOrderlistId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == opsumOrderlistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("opsumOrderlistId", opsumOrderlistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daOpsumOrderlistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumOrderlistServiceImpl.updateStateOpsumOrderListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("da.DaOpsumOrderlistServiceImpl.updateStateOpsumOrderListModel.null");
        }
    }

    private void updateStateOpsumOrderListModelByCode(String tenantCode, String opsumOrderlistCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)opsumOrderlistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opsumOrderlistCode", opsumOrderlistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daOpsumOrderlistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumOrderlistServiceImpl.updateStateOpsumOrderListModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("da.DaOpsumOrderlistServiceImpl.updateStateOpsumOrderListModelByCode.null");
        }
    }

    private DaOpsumOrderlist makeOpsumOrderList(DaOpsumOrderlistDomain daOpsumOrderlistDomain, DaOpsumOrderlist daOpsumOrderlist) {
        if (null == daOpsumOrderlistDomain) {
            return null;
        }
        if (null == daOpsumOrderlist) {
            daOpsumOrderlist = new DaOpsumOrderlist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)daOpsumOrderlist, (Object)daOpsumOrderlistDomain);
            return daOpsumOrderlist;
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumOrderlistServiceImpl.makeOpsumOrderList", (Throwable)e);
            return null;
        }
    }

    private DaOpsumOrderlistReDomain makeDaOpsumOrderlistReDomain(DaOpsumOrderlist daOpsumOrderlist) {
        if (null == daOpsumOrderlist) {
            return null;
        }
        DaOpsumOrderlistReDomain daOpsumOrderlistReDomain = new DaOpsumOrderlistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)daOpsumOrderlistReDomain, (Object)daOpsumOrderlist);
            return daOpsumOrderlistReDomain;
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumOrderlistServiceImpl.makeDaOpsumOrderlistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DaOpsumOrderlist> queryOpsumOrderListModelPage(Map<String, Object> parammap) {
        try {
            return this.daOpsumOrderlistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumOrderlistServiceImpl.queryOpsumOrderListModel", (Throwable)e);
            return null;
        }
    }

    private int countOpsumOrderList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.daOpsumOrderlistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumOrderlistServiceImpl.countOpsumOrderList", (Throwable)e);
        }
        return i;
    }

    private DaOpsumOrderlist createDaOpsumOrderlist(DaOpsumOrderlistDomain daOpsumOrderlistDomain) {
        String msg = this.checkOpsumOrderList(daOpsumOrderlistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("da.DaOpsumOrderlistServiceImpl.saveOpsumOrderList.checkOpsumOrderList", msg);
        }
        DaOpsumOrderlist daOpsumOrderlist = this.makeOpsumOrderList(daOpsumOrderlistDomain, null);
        this.setOpsumOrderListDefault(daOpsumOrderlist);
        return daOpsumOrderlist;
    }

    @Override
    public String saveOpsumOrderList(DaOpsumOrderlistDomain daOpsumOrderlistDomain) throws ApiException {
        DaOpsumOrderlist daOpsumOrderlist = this.createDaOpsumOrderlist(daOpsumOrderlistDomain);
        this.saveOpsumOrderListModel(daOpsumOrderlist);
        return daOpsumOrderlist.getOpsumOrderlistCode();
    }

    @Override
    public String saveOpsumOrderListBatch(List<DaOpsumOrderlistDomain> daOpsumOrderlistDomainList) throws ApiException {
        if (null == daOpsumOrderlistDomainList || daOpsumOrderlistDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DaOpsumOrderlist> daOpsumOrderlistList = new ArrayList<DaOpsumOrderlist>();
        String code = "";
        for (DaOpsumOrderlistDomain daOpsumOrderlistDomain : daOpsumOrderlistDomainList) {
            DaOpsumOrderlist daOpsumOrderlist = this.createDaOpsumOrderlist(daOpsumOrderlistDomain);
            code = daOpsumOrderlist.getOpsumOrderlistCode();
            daOpsumOrderlistList.add(daOpsumOrderlist);
        }
        this.saveOpsumOrderListBatchModel(daOpsumOrderlistList);
        return code;
    }

    @Override
    public void updateOpsumOrderListState(Integer opsumOrderlistId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == opsumOrderlistId) {
            return;
        }
        this.updateStateOpsumOrderListModel(opsumOrderlistId, dataState, oldDataState, map);
    }

    @Override
    public void updateOpsumOrderListStateByCode(String tenantCode, String opsumOrderlistCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)opsumOrderlistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateOpsumOrderListModelByCode(tenantCode, opsumOrderlistCode, dataState, oldDataState, map);
    }

    @Override
    public void updateOpsumOrderList(DaOpsumOrderlistDomain daOpsumOrderlistDomain) throws ApiException {
        String msg = this.checkOpsumOrderList(daOpsumOrderlistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("da.DaOpsumOrderlistServiceImpl.updateOpsumOrderList.checkOpsumOrderList", msg);
        }
        DaOpsumOrderlist oldDaOpsumOrderlist = this.getOpsumOrderListModelById(daOpsumOrderlistDomain.getOpsumOrderlistId());
        if (null == oldDaOpsumOrderlist) {
            throw new ApiException("da.DaOpsumOrderlistServiceImpl.updateOpsumOrderList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DaOpsumOrderlist daOpsumOrderlist = this.makeOpsumOrderList(daOpsumOrderlistDomain, oldDaOpsumOrderlist);
        this.setOpsumOrderListUpdataDefault(daOpsumOrderlist);
        this.updateOpsumOrderListModel(daOpsumOrderlist);
    }

    @Override
    public DaOpsumOrderlist getOpsumOrderList(Integer opsumOrderlistId) {
        if (null == opsumOrderlistId) {
            return null;
        }
        return this.getOpsumOrderListModelById(opsumOrderlistId);
    }

    @Override
    public void deleteOpsumOrderList(Integer opsumOrderlistId) throws ApiException {
        if (null == opsumOrderlistId) {
            return;
        }
        this.deleteOpsumOrderListModel(opsumOrderlistId);
    }

    @Override
    public QueryResult<DaOpsumOrderlist> queryOpsumOrderListPage(Map<String, Object> map) {
        List<DaOpsumOrderlist> daOpsumOrderlistList = this.queryOpsumOrderListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOpsumOrderList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(daOpsumOrderlistList);
        return queryResult;
    }

    @Override
    public DaOpsumOrderlist getOpsumOrderListByCode(String tenantCode, String opsumOrderlistCode) throws ApiException {
        if (StringUtils.isBlank((String)opsumOrderlistCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opsumOrderlistCode", opsumOrderlistCode);
        return this.getOpsumOrderListModelByCode(map);
    }

    @Override
    public void deleteOpsumOrderListByCode(String tenantCode, String opsumOrderlistCode) throws ApiException {
        if (StringUtils.isBlank((String)opsumOrderlistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opsumOrderlistCode", opsumOrderlistCode);
        this.delOpsumOrderListModelByCode(map);
    }

    protected String getBusMember(String channelCode, String tenantCode) {
        DisChannel disChannel;
        String busMember = "";
        if (StringUtils.isNotBlank((String)channelCode) && null != (disChannel = (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-channelCode", (String)(channelCode + "-" + tenantCode), DisChannel.class))) {
            busMember = disChannel.getMemberCode();
        }
        if (StringUtils.isBlank((String)busMember)) {
            busMember = SupDisUtil.getMap((String)"tmtenant-user-code", (String)tenantCode);
        }
        return busMember;
    }

    @Override
    public String saveOrderAll(Map<String, Object> map) throws ApiException {
        return null;
    }

    @Override
    public String orderInfo(OcContractReDomain ocContractDomain) throws ApiException {
        this.logger.error("da.DaOpsumOrderlistServiceImpl.queryOpsumOrderListModel", (Object)("ocContractReDomain is" + ocContractDomain));
        if (ocContractDomain == null) {
            this.logger.error("da.DaOpsumOrderlistServiceImpl.queryOpsumOrderListModel", (Object)("ocContractReDomain is" + ocContractDomain));
            return "error";
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tenantCode", ocContractDomain.getTenantCode());
        paramMap.put("opsetDatacode1", ocContractDomain.getMemberCode());
        if (!ocContractDomain.getMemberCcode().equals("10000210370767")) {
            paramMap.put("opsumCode", "-1");
            this.saveOrUpdateOther(paramMap, ocContractDomain);
            return null;
        }
        paramMap.put("opsumCode", ocContractDomain.getMemberCcode());
        Date gmtCreate = ocContractDomain.getGmtCreate();
        Map<String, Object> dataMap = this.getDataMap(gmtCreate);
        for (String strKey : dataMap.keySet()) {
            paramMap.put("opsetDatacode2", dataMap.get(strKey));
            paramMap.put("opsetDatacode", "NOT_ALL");
            QueryResult<DaOpsumOrderlist> queryResult = this.queryOpsumOrderListPage(paramMap);
            if (ListUtil.isEmpty((Collection)queryResult.getList())) {
                this.saveNewDataInfo(ocContractDomain, strKey);
                continue;
            }
            DaOpsumOrderlist daOpsumOrderlist = (DaOpsumOrderlist)queryResult.getList().get(0);
            DaOpsumOrderlistDomain daOpsumOrderlistDomain = new DaOpsumOrderlistDomain();
            DaOpsumOrderlist daOpsumOrderlist1 = this.buildDa(daOpsumOrderlist, ocContractDomain);
            try {
                BeanUtils.copyAllPropertys((Object)daOpsumOrderlistDomain, (Object)daOpsumOrderlist1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.updateOpsumOrderList(daOpsumOrderlistDomain);
        }
        this.updateOrSaveAllInfo(paramMap, ocContractDomain);
        return null;
    }

    public void updateOrSaveAllInfo(Map paramMap, OcContractReDomain ocContractReDomain) {
        paramMap.put("opsetDatacode", "ALL");
        paramMap.remove("opsetDatacode2");
        paramMap.remove("opsetDatacode2");
        paramMap.remove("opsetDatacode2");
        QueryResult<DaOpsumOrderlist> queryResult = this.queryOpsumOrderListPage(paramMap);
        if (ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.saveNewDataInfo(ocContractReDomain, null);
            return;
        }
        DaOpsumOrderlist daOpsumOrderlist = (DaOpsumOrderlist)queryResult.getList().get(0);
        DaOpsumOrderlistDomain daOpsumOrderlistDomain = new DaOpsumOrderlistDomain();
        DaOpsumOrderlist daOpsumOrderlist1 = this.buildDa(daOpsumOrderlist, ocContractReDomain);
        try {
            BeanUtils.copyAllPropertys((Object)daOpsumOrderlistDomain, (Object)daOpsumOrderlist1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateOpsumOrderList(daOpsumOrderlistDomain);
    }

    public void saveOrUpdateOther(Map paramMap, OcContractReDomain ocContractReDomain) {
        QueryResult<DaOpsumOrderlist> queryResult = this.queryOpsumOrderListPage(paramMap);
        if (ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.saveNewDataInfo(ocContractReDomain, null);
            return;
        }
        DaOpsumOrderlist daOpsumOrderlist = (DaOpsumOrderlist)queryResult.getList().get(0);
        DaOpsumOrderlistDomain daOpsumOrderlistDomain = new DaOpsumOrderlistDomain();
        DaOpsumOrderlist daOpsumOrderlist1 = this.buildDa(daOpsumOrderlist, ocContractReDomain);
        try {
            BeanUtils.copyAllPropertys((Object)daOpsumOrderlistDomain, (Object)daOpsumOrderlist1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateOpsumOrderList(daOpsumOrderlistDomain);
    }

    public DaOpsumOrderlist buildDa(DaOpsumOrderlist daOpsumOrderlist, OcContractReDomain ocContractReDomain) {
        BigDecimal bigDecimal;
        System.out.println(JsonUtil.buildNormalBinder().toJson((Object)daOpsumOrderlist));
        BigDecimal opsumListNum1 = daOpsumOrderlist.getOpsumListNum1();
        BigDecimal opsumListNum = opsumListNum1.add(ocContractReDomain.getContractInmoney());
        daOpsumOrderlist.setOpsumListNum1(opsumListNum);
        BigDecimal opsumListNum2 = daOpsumOrderlist.getOpsumListNum2();
        BigDecimal orderNum = opsumListNum2.add(new BigDecimal(1));
        daOpsumOrderlist.setOpsumListNum2(orderNum);
        BigDecimal opsumListNum3 = daOpsumOrderlist.getOpsumListNum();
        BigDecimal goodsPmoney = opsumListNum3.add(ocContractReDomain.getGoodsPmoney());
        daOpsumOrderlist.setOpsumListNum(goodsPmoney);
        String opsetDatavalue = daOpsumOrderlist.getOpsetDatavalue();
        Map jsonToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(opsetDatavalue, String.class, Object.class);
        if (jsonToMap.containsKey("GIV")) {
            BigDecimal addResult = bigDecimal = new BigDecimal(Double.valueOf(String.valueOf(jsonToMap.get("GIV"))));
            for (OcContractGoodsDomain oc : ocContractReDomain.getGoodsList()) {
                BigDecimal multiply = oc.getGoodsNum().multiply(oc.getContractGoodsMoney());
                addResult = addResult.add(multiply);
            }
            jsonToMap.put("GIV", addResult);
        } else {
            BigDecimal addResult = new BigDecimal(0);
            for (OcContractGoodsDomain oc : ocContractReDomain.getGoodsList()) {
                BigDecimal multiply = oc.getGoodsNum().multiply(oc.getContractGoodsMoney());
                addResult = addResult.add(multiply);
            }
            jsonToMap.put("GIV", addResult);
        }
        if (jsonToMap.containsKey("contractMoney")) {
            bigDecimal = new BigDecimal(Double.valueOf(String.valueOf(jsonToMap.get("contractMoney"))));
            BigDecimal contractMoney = bigDecimal.add(ocContractReDomain.getContractMoney());
            jsonToMap.put("contractMoney", contractMoney);
        } else {
            jsonToMap.put("contractMoney", ocContractReDomain.getContractMoney());
        }
        String memberBcode = ocContractReDomain.getGoodsList().get(0).getMemberBcode();
        HashMap<String, BigDecimal> paramMap = new HashMap<String, BigDecimal>();
        if (jsonToMap.containsKey("contractStore")) {
            BigDecimal contractStore = new BigDecimal(Double.valueOf(String.valueOf(jsonToMap.get("contractStore"))));
            String strValue = SupDisUtil.getRemot((String)("memberBcode" + memberBcode));
            if (!strValue.contains(memberBcode)) {
                BigDecimal addResult = contractStore.add(new BigDecimal(1));
                paramMap.put("contractStore", addResult);
                String str = strValue + "," + memberBcode;
                SupDisUtil.set((String)("memberBcode" + memberBcode), (String)str);
            }
        } else {
            SupDisUtil.set((String)("memberBcode" + memberBcode), (String)memberBcode);
            paramMap.put("contractStore", new BigDecimal(1));
        }
        daOpsumOrderlist.setOpsetDatavalue(JsonUtil.buildNonDefaultBinder().toJson((Object)jsonToMap));
        daOpsumOrderlist.setOpsetDatavalue1(JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        return daOpsumOrderlist;
    }

    public Map<String, Object> getDataMap(Date data) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = sdf.format(data);
        String[] split = dateStr.split("-");
        HashMap<String, Object> dateMap = new HashMap<String, Object>();
        dateMap.put("year", split[0]);
        dateMap.put("month", split[0] + "-" + split[1]);
        dateMap.put("date", dateStr);
        return dateMap;
    }

    public void saveNewDataInfo(OcContractReDomain ocContractReDomain, String strKey) {
        Date gmtCreate = ocContractReDomain.getGmtCreate();
        Map<String, Object> dataMap = this.getDataMap(gmtCreate);
        DaOpsumOrderlistDomain daOpsumOrderlistDomain = new DaOpsumOrderlistDomain();
        daOpsumOrderlistDomain.setOpsetDatacode1(ocContractReDomain.getMemberCode());
        daOpsumOrderlistDomain.setOpsumCode(ocContractReDomain.getMemberCcode());
        if (ocContractReDomain.getMemberCcode().equals("10000210370767")) {
            daOpsumOrderlistDomain.setOpsumCode(ocContractReDomain.getMemberCcode());
            if (StringUtils.isNotBlank((String)strKey)) {
                daOpsumOrderlistDomain.setOpsetDatacode("NOT_ALL");
                daOpsumOrderlistDomain.setOpsetDatacode2(String.valueOf(dataMap.get(strKey)));
            } else {
                daOpsumOrderlistDomain.setOpsetDatacode("ALL");
            }
        } else {
            daOpsumOrderlistDomain.setOpsumCode("-1");
        }
        daOpsumOrderlistDomain.setOpsumListNum1(ocContractReDomain.getContractInmoney());
        daOpsumOrderlistDomain.setOpsumListNum2(new BigDecimal(1));
        daOpsumOrderlistDomain.setOpsumListNum(ocContractReDomain.getGoodsPmoney());
        daOpsumOrderlistDomain.setOpsumListNum2(ocContractReDomain.getContractMoney());
        daOpsumOrderlistDomain.setTenantCode(ocContractReDomain.getTenantCode());
        HashMap<String, BigDecimal> jsonToMap = new HashMap<String, BigDecimal>();
        BigDecimal addResult = new BigDecimal(0);
        for (OcContractGoodsDomain oc : ocContractReDomain.getGoodsList()) {
            BigDecimal multiply = oc.getGoodsNum().multiply(oc.getContractGoodsMoney());
            addResult = addResult.add(multiply);
        }
        jsonToMap.put("GIV", addResult);
        jsonToMap.put("contractMoney", ocContractReDomain.getContractMoney());
        String memberBcode = ocContractReDomain.getGoodsList().get(0).getMemberBcode();
        SupDisUtil.set((String)("memberBcode" + memberBcode), (String)memberBcode);
        HashMap<String, BigDecimal> paramMap = new HashMap<String, BigDecimal>();
        paramMap.put("contractStore", new BigDecimal(1));
        daOpsumOrderlistDomain.setOpsetDatavalue(JsonUtil.buildNonDefaultBinder().toJson(jsonToMap));
        daOpsumOrderlistDomain.setOpsetDatavalue1(JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        this.saveOpsumOrderList(daOpsumOrderlistDomain);
    }
}

